# The following targets are for the maintainer only! do no run if you don't
# know what they do.

.PHONY: printenv updateconfigs printchanges insertchanges startnewrelease diffupstream help

help:
	@echo "These are the targets in addition to the normal debian ones:"
	@echo
	@echo "  printenv        : Print some variables used in the build"
	@echo
	@echo "  updateconfigs   : Update debian/config/*"
	@echo
	@echo "  printchanges    : Print the current changelog entries (from git)"
	@echo
	@echo "  insertchanges   : Insert current changelog entries (from git)"
	@echo
	@echo "  startnewrelease : Start a new changelog set"
	@echo
	@echo "  diffupstream    : Diff stock kernel code against upstream (git)"
	@echo
	@echo "  help            : If you are kernel hacking, you need the professional"
	@echo "                    version of this"
	@echo
	@echo "Environment variables:"
	@echo
	@echo "  NOKERNLOG       : Do not add upstream kernel commits to changelog"
	@echo "  CONCURRENCY_LEVEL=X"
	@echo "                  : Use -jX for kernel compile"
	@echo "  PRINTSHAS       : Include SHAs for commits in changelog"

updateconfigs:
	dh_testdir
	@for arch in i386 amd64 ia64 hppa powerpc sparc lpia; do	\
		$(SHELL) debian/scripts/misc/oldconfig $$arch;		\
	done
	rm -rf build

printenv:
	dh_testdir
	@echo "release           = $(release)"
	@echo "pkgversion        = $(pkgversion)"
	@echo "revisions         = $(revisions)"
	@echo "revision          = $(revision)"
	@echo "prev_revisions    = $(prev_revisions)"
	@echo "prev_revision     = $(prev_revision)"
	@echo "debnum            = $(debnum)"
	@echo "abinum            = $(abinum)"
	@echo "gitver            = $(gitver)"
	@echo "flavours          = $(flavours)"
	@echo "custom_flavours   = $(custom_flavours)"
ifneq ($(SUBLEVEL),)
	@echo "SUBLEVEL          = $(SUBLEVEL)"
endif
	@echo "CONCURRENCY_LEVEL = $(CONCURRENCY_LEVEL)"

printchanges:
	@git-log --pretty=short Ubuntu-$(release)-$(prev_revision)..HEAD | \
		perl -w -f debian/scripts/misc/git-ubuntu-log $(ubuntu_log_opts)

insertchanges:
	@perl -w -f debian/scripts/misc/insert-changes.pl

diffupstream:
	@git-diff-tree -p linux..HEAD $(shell ls | grep -vE '^(ubuntu|debian|\.git.*)')

startnewrelease:
	dh_testdir
	@nextminor=$(shell expr `echo $(revision) | awk -F. '{print $$2}'` + 1); \
	user=$(shell whoami); \
	memyselfandirene="$$(getent passwd $$user | cut -d ":" -f 5 | cut -d "," -f 1)"; \
	now="$(shell date -R)"; \
	echo "Creating new changelog set for $(release)-$(abinum).$$nextminor..."; \
	echo -e "linux-source-$(release) ($(release)-$(abinum).$$nextminor) UNRELEASED; urgency=low\n" > debian/changelog.new; \
	echo "  CHANGELOG: Do not edit directly. Autogenerated at release." >> \
		debian/changelog.new; \
	echo "  CHANGELOG: Use the printchanges target to see the curent changes." \
		>> debian/changelog.new; \
	echo "  CHANGELOG: Use the insertchanges target to create the final log." \
		>> debian/changelog.new; \
	echo -e "\n -- $$memyselfandirene <$$user@ubuntu.com>  $$now\n" >> \
		debian/changelog.new ; \
	cat debian/changelog >> debian/changelog.new; \
	mv debian/changelog.new debian/changelog
