#include "GSEXmlParser.h"

void   Data::Dump()
{
    LOG("Sample iid: " << iid);
    LOG("Source: " << source);
    LOG("Supplementary-Data Type: " << supp_type);
    LOG("Supplementary-Data: " << supp_data);
    LOG("\n-------- Description --------");
    for(int i = 0; i < desc.GetCount(); i++)
        LOG("   " << desc.GetKey(i) << " ..... " << desc[i]);
    LOG("-------- Description --------\n");
}

String   Data::ToXML()
{
    String descs; //descriptions
    for(int i = 0; i < desc.GetCount(); i++)
        descs << XmlTag("Description")("name", desc.GetKey(i)).Text(desc[i]);

    return XmlTag("Sample")("iid", iid)(
                     XmlTag("Source").Text(source) + 
                     XmlTag("Supplementary-Data")("type", supp_type).Text(supp_data) +
                     XmlTag("Descriptions") (descs) 
                 );
}

void   GSEParser::Dump()
{
	LOG("\n======== GSE XML ========\n");
	for (int i=0; i < data.GetCount(); i++) {
		data[i].Dump();
	}
}

void GSEParser::LoadXML(String filename) {
	//Load XML File
    //LOG("\n---- GSE 2109 XML ----");
    String gse;
    gse = LoadFile(GetDataFile(filename));
    XmlNode rnode = ParseXML(gse);
    
    //Clear Data Array
    data.Clear();
    
    //Get Root Node    
    const XmlNode &xnode = rnode["MINiML"];
    
    //Save Data Array, one by one
    Vector<String> lines, des;
    String str, lstr, rstr;
    for (int i=0; i<xnode.GetCount(); i++) {
       if (xnode[i].GetTag()=="Sample") {  
          //LOG("Sample(iid):" << xnode[i].Attr("iid"));
          //LOG("Source:" << xnode[i]["Channel"]["Source"].GatherText());
          //LOG("\n-------- Description --------");
          Data d;
          d.iid = xnode[i].Attr("iid");
          d.source = xnode[i]["Channel"]["Source"].GatherText();
          d.supp_type = xnode[i]["Supplementary-Data"].Attr("type");
          d.supp_data = xnode[i]["Supplementary-Data"].GatherText();
          lines = Split(xnode[i]["Description"].GatherText(),'\n');
          for (int j=0; j<lines.GetCount(); j++) {
              if (lines[j].Find("=") > -1) {
                  des = Split(lines[j], '=');
              } else if (lines[j].Find(":") > -1) {
                  des = Split(lines[j], ':');
              }
              if (des.GetCount()>1) {
                  lstr = TrimSpace(des[0]);
                  rstr = TrimSpace(des[1]);                  
                  //LOG(lstr << ":" << rstr);
                  String& v = d.desc.GetAdd(lstr);
                  v = rstr;
              }
          }
          data.Add(d);
          //LOG("-------- Description --------\n");
       }
    }
    //    
}

String   GSEParser::ToXML()
{
	String datas; // Datas
    for (int i = 0; i < data.GetCount(); i++) {
        datas << data[i].ToXML();
    }
    return XmlHeader() + XmlTag("GSEFAMILY")(datas);
}

String TrimSpace(String str) {
	while (str.StartsWith(" ") && str.GetLength()) {
		str = str.Mid(1);
	}
	while (str.EndsWith(" ") && str.GetLength()) {
		str = str.Left(str.GetLength()-1);
	}
	return str;
}

CONSOLE_APP_MAIN
{
	String in, out, arg_flag;
	in = "GSE2109_family.xml";
	out = "GSEFamily.xml";
	
	const Vector<String>& cmdline = CommandLine();
	for(int i = 0; i < cmdline.GetCount(); i++) {
		if (cmdline[i].StartsWith("-")){
			arg_flag = cmdline[i];			
		} else if (arg_flag.IsEqual("-i")) {
			in = cmdline[i];
			//Cout() << "in: " << in << "\n";
		} else if (arg_flag.IsEqual("-o")) {
			out = cmdline[i];
			//Cout() << "out: " << out << "\n";
		}
	}
	
	GSEParser parser;
	parser.LoadXML(in);
	SaveFile(out,parser.ToXML());
	
}

