#include <stdio.h>
#include <sys/socket.h>
#include <arpa/inet.h>
#include <errno.h>
#include <stdlib.h>
#include <string.h>
#include <fcntl.h>
#include <signal.h>
#include <unistd.h>
#include <netinet/in.h>

void Die(char *mess)
{
    perror(mess);
    exit(1);
}

int main(int argc, char *argv[])
{
    struct  sockaddr_in send_sockopt;
    int	    send_sock;
    int	    send_length = sizeof(send_sockopt);
    FILE    *fd;
    char    BLACK_LIST[1024];
    size_t  len = 0;
    ssize_t read;

    if (argc <= 3)
    {
	fprintf(stderr, "USAGE: %s <RECV_IP> <RECV_PORT> <BLACK LIST FILE PATH>\n", argv[0]);
	fprintf(stderr, "Ex. %s 127.0.0.1 3838 /opt/icas/report/black/blacklist\n", argv[0]);
	exit(1);
    }

    /* open blacklist to read black list data */
    fd = fopen(argv[3],"r");
    if (fd == NULL)
    {
    	fprintf(stderr, "%s: Couldn't open file %s; %s\n", argv[0], "blacklist", strerror (errno));
	exit(1);
    }

    /* Create the UDP socket to send response to icas_recv */
    if ((send_sock = socket(PF_INET, SOCK_DGRAM, IPPROTO_UDP)) < 0)
    {
	Die("Failed to create socket for sending black list.");
    }

    /* Construct the server sockaddr_in structure */
    memset(&send_sockopt,  0, sizeof(send_sockopt));      /* Clear struct */
    memset(&BLACK_LIST,    0, sizeof(BLACK_LIST));	  /* Clear string */
    sprintf(BLACK_LIST,"This is a test!");

    // socket option of icas_send socket
    send_sockopt.sin_family = AF_INET;                   /* Internet/IP */
    send_sockopt.sin_addr.s_addr = inet_addr(argv[1]);   /* IP address */
    send_sockopt.sin_port = htons(atoi(argv[2]));        /* server port */

    while(fgets(BLACK_LIST,sizeof(BLACK_LIST),fd))
    {
	if (sendto(send_sock, BLACK_LIST, sizeof(BLACK_LIST), 0, 
		   (struct sockaddr *) &send_sockopt, 
		   sizeof(send_sockopt)) != sizeof(BLACK_LIST)) 
	{
	    Die("1: Mismatch in number of sent bytes");
	}
    }

    close(send_sock);
    exit(0);
}
