#!/bin/bash
# Program:
#   Patch DRBL evironment to support Xen
# Author: 
#   Jazz, Rock {jazz, rock}@nchc.org.tw
# Version:
#    1.0
# History:                                                                                          
#   2010/07/20  Rock    First release (1.0) 

# [Source]
source /opt/drbl-virt/conf/drbl-virt.conf
source $Work_Path/functions_drbl_virt

# [Main]

# = 1. Patch DRBL xen env for client =
# == Shutdown all drbl client ==
echo -e "\nPlease shutdown all drbl client !!!"
echo "You can use /opt/drbl/sbin/dcs to shutdown."
read -p "Push [Enter] to continue......"

# == Change xen kernel for drbl client ==
check_xen_nu
Xen_Kernel=$(echo $Xen_Kernel | sed 's/^vmlinuz-//g' )
echo $Xen_Kernel > $Work_Home/etc/Xen_Kernel
# == Copy xen image to /tftpboot/nbi_img/ ==
echo "copy Xen image & Kernel to /tftpboot/nbi_img/"
cp /boot/*xen* /tftpboot/nbi_img/
cp /boot/vmlinuz-${Xen_Kernel} /tftpboot/nbi_img/
cp /boot/initrd.img-${Xen_Kernel} /tftpboot/nbi_img/
cp /boot/config-${Xen_Kernel} /tftpboot/nbi_img/
echo ""

# == Modify PXE booting menu ==
# if menu doesn't has drbl-virt, then add it
cat /opt/drbl/sbin/generate-pxe-menu | grep "label drbl-virt" >> /dev/null
if [  $? != 0 ]; then
# backup generate-pxe-menu
cp /tftpboot/nbi_img/pxelinux.cfg/default /tftpboot/nbi_img/pxelinux.cfg/default.drbl-virt_bak
cp /opt/drbl/sbin/generate-pxe-menu /opt/drbl/sbin/generate-pxe-menu.drbl-virt_bak

generate_PXE_menu="/opt/drbl/sbin/generate-pxe-menu"
declare -i modify_line=$(cat -n $generate_PXE_menu | grep 'label drbl' | awk 'NR==1 {print $1}')
# delete default
sed -i 's/^  MENU DEFAULT/  # MENU DEFAULT/g' $generate_PXE_menu
# modify menu
sed -i "${modify_line}i\label drbl-virt" $generate_PXE_menu
modify_line=$modify_line+1
sed -i "${modify_line}i\  MENU DEFAULT" $generate_PXE_menu
modify_line=$modify_line+1
sed -i "${modify_line}i\  # MENU HIDE" $generate_PXE_menu
modify_line=$modify_line+1
sed -i "${modify_line}i\  MENU LABEL DRBL-Virtualization ($Xen, $Xen_Kernel)" $generate_PXE_menu
modify_line=$modify_line+1
sed -i "${modify_line}i\  kernel mboot.c32" $generate_PXE_menu
modify_line=$modify_line+1
sed -i "${modify_line}i\  append $Xen --- vmlinuz-pxe --- initrd-pxe.img devfs=nomount drblthincli=off selinux=0 nomodeset" $generate_PXE_menu
modify_line=$modify_line+1
sed -i "${modify_line}i\  TEXT HELP" $generate_PXE_menu
modify_line=$modify_line+1
sed -i "${modify_line}i\  ENDTEXT" $generate_PXE_menu
modify_line=$modify_line+1
sed -i "${modify_line}i\ " $generate_PXE_menu
fi

# = 2. Patch DRBL initrd to support bridge =
# == Patch /usr/bin/mkpxeinitrd-net (1)Xen network scripts (2)command (3)modules ==
# backup mkpxeinitrd-net. if already has "drbl-virt add", dones't sed
source $Work_Path/drbl_bridge_xen_patch

# = 3. enable xend xendomains daemon in DRBL Client =
if [ -e /opt/drbl/conf/client-extra-service ]; then
    echo 'service_extra_added="xend xendomains"' >> /opt/drbl/conf/client-extra-service
else
    echo 'service_extra_added="xend xendomains"' > /opt/drbl/conf/client-extra-service
fi

# = 4. enable xend xendomains daemon afterr drblpush =
# /opt/drbl/sbin/drbl-client-service xend on

# = 5. cp xen kernel & initrd to /home/domains =
if [ ! -e /home/domains ]; then
    mkdir /home/domains
fi
cp /tftpboot/nbi_img/*xen* /home/domains
cp /tftpboot/nbi_img/vmlinuz-pxe /home/domains
cp /tftpboot/nbi_img/initrd-pxe.img /home/domains

