#!/bin/bash
# Program:
#   Patch DRBL to bridge eth in booting
# Author: 
#   Jazz, Rock {jazz, rock}@nchc.org.tw
# Version:
#    1.0
# History:                                                                                          
#   2010/10/12  Rock    First release (1.0) 

# [Source]
source /opt/drbl-virt/conf/drbl-virt.conf
source $Work_Path/functions_drbl_virt

# [Main]

# = 1. Patch DRBL initrd to support bridge =
# == Patch /usr/bin/mkpxeinitrd-net (1)Xen network scripts (2)command (3)modules ==
# backup mkpxeinitrd-net. if already has "drbl-virt add", dones't sed
cat /usr/bin/mkpxeinitrd-net | grep "# drbl-virt add" >> /dev/null
if [ $? != 0 ]; then
cp /usr/bin/mkpxeinitrd-net /usr/bin/mkpxeinitrd-net.drbl-virt_bak
# copy Xen network scripts
cp /etc/xen/scripts/network-bridge /usr/lib/mkpxeinitrd-net/initrd-skel/bin/
cp /etc/xen/scripts/xen-network-common.sh /usr/lib/mkpxeinitrd-net/initrd-skel/bin/
cp /etc/xen/scripts/xen-script-common.sh /usr/lib/mkpxeinitrd-net/initrd-skel/bin/
# patch it to copy command
declare -i modify_line=$(cat -n /usr/bin/mkpxeinitrd-net | grep 'include_bin_prog_from_server=' | awk '{print $1}')
modify_file="/usr/bin/mkpxeinitrd-net"
sed -i "${modify_line}c\include_bin_prog_from_server='sleep lspci insmod modprobe rmmod lsmod pkill strings brctl ip egrep awk gawk seq fgrep dirname expr bash'" $modify_file
sed -i "${modify_line}i# drbl-virt add" $modify_file
# patch it to copy modules
declare -i modify_line=$(cat -n /usr/bin/mkpxeinitrd-net | grep "# Deal with firmwares" | awk '{print $1}')
sed -i "${modify_line}i# drbl-virt add" $modify_file
modify_line=$modify_line+1
sed -i "${modify_line}icp -a --parents kernel/net/bridge/bridge.ko \$initrd/lib/modules/\$kernel_ver/" $modify_file
modify_line=$modify_line+1
sed -i "${modify_line}icp -a --parents kernel/drivers/xen/netback/netloop.ko \$initrd/lib/modules/\$kernel_ver/" $modify_file

# == Add start_xen_bridge.sh to run Xen network-bridge (/usr/lib/mkpxeinitrd-net/initrd-skel/linuxrc-or-init) ==
cat <<EOF >/usr/lib/mkpxeinitrd-net/initrd-skel/bin/start_xen_bridge.sh
#!/bin/bash
# drbl-virt add
NICs=\$(/sbin/ifconfig | grep eth | awk '{print \$1}')
declare -i NICs_nu=\$(echo \$NICs |wc -l)
NIC=""

if [ \$NICs_nu -lt 1  ]; then
    for (( i=0 ; i<\$NICs_nu ; i++ ))
    do
        NIC_IP=\$(ifconfig eth\${i} | grep "inet addr" | sed 's/inet addr://g' | sed 's/Bcast.*$//g')
        if [ -n \$NIC_IP ]; then
            NIC="eth\${i}"
            break
        fi
    done
else
    NIC=\$NICS
fi

bash /bin/network-bridge start netdev=\$NIC
EOF
fi
# == Run start_xen_bridge.sh when booting  ==
cat /usr/lib/mkpxeinitrd-net/initrd-skel/linuxrc-or-init | grep "bash /bin/start_xen_bridge.sh" >> /dev/null
if [ $? != 0 ]; then
    # backup linuxrc-or-init
    cp /usr/lib/mkpxeinitrd-net/initrd-skel/linuxrc-or-init /usr/lib/mkpxeinitrd-net/initrd-skel/linuxrc-or-init.drbl-virt_bak 
    declare -i modify_line=$(cat -n /usr/lib/mkpxeinitrd-net/initrd-skel/linuxrc-or-init | grep "# clean the tag file" | awk '{print $1}')
    modify_file="/usr/lib/mkpxeinitrd-net/initrd-skel/linuxrc-or-init"

    sed -i "${modify_line}i# drbl-virt add" $modify_file
    modify_line=$modify_line+1
    sed -i "${modify_line}ibash /bin/start_xen_bridge.sh" $modify_file
fi
