#!/bin/bash
# Program:
#   Install DRBL virt module
# Author: 
#   Jazz, Rock {jazz, rock}@nchc.org.tw
# Version:
#    1.0
# History:                                                                                          
#   2010/08/03  Rock    First release (1.0) 


# [Path] 
Work_Home="/opt/drbl-virt"
Work_Path="/opt/drbl-virt/sbin"
Now_Path="$(dirname $0)"
PATH=${PATH}:$Work_Path:${Now_Path}/sbin

# Source]
source $Now_Path/sbin/functions_drbl_virt

# [Main]
check_root

jude="no"
if [ -e $Work_Home ]; then
    echo "This system already has drbl-virt."
    read -p "Do you want to install, again (yes/no): " jude

    if [ $jude == "yes" ]; then
        rm -fr $Work_Home
    else
        echo "Exit"
        exit
    fi
fi


# = 1. Create /opt/drbl-virt and copy file =
mkdir -p $Work_Home
mkdir $Work_Home/etc
mkdir $Work_Home/.tmp
cp -fr $Now_Path/sbin $Work_Home/
cp -fr $Now_Path/conf $Work_Home/
cp  -fr $Now_Path/uninstall.sh $Work_Home/

# = 2. Move war =
mv drbl-virt.war $Work_Home/

# = 4. Install completion =
echo ""
echo "[drbl-virt install completion]"
echo "Please go to /opt/drbl-virt/ to check !!!"
