import  wx
import  wx.wizard as wiz
import	sys
import	os
import	gettext
import	string
import	time
from wx.lib.mixins.listctrl import CheckListCtrlMixin
import  wx.lib.filebrowsebutton as filebrowse

cat = gettext.GNUTranslations(open(sys.argv[1]))
_ = cat.gettext

global FinalArgs
FinalArgs = []
for i in range(0,37):
    FinalArgs.insert(i,'')
#FinalArgs = ['','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','',''] 
#global PXE_CFG
#PXE_CFG = []
global Labels
Labels = []

#----------------------------------------------------------------------
ClonezillaStartSaveArgs = {
1: ("-q", _('msg_ocs_param_q')),
2: ("-c", _('msg_ocs_param_c')),
3: ("-nogui", _('msg_ocs_param_nogui')),
4: ("-a", _('msg_ocs_param_a')),
5: ("-f", _('msg_ocs_param_f')),
6: ("-s", _('msg_ocs_param_s')),
7: ("-ntfs-ok", _('msg_ocs_param_notfs_ok')),
}

#----------------------------------------------------------------------
ClonezillaStartRestoreArgs = {
1: ("-g auto", _('msg_ocs_param_g_auto')),
2: ("-x", _('msg_ocs_param_x')),
3: ("-brdcst", _('msg_ocs_param_broadcast')),
4: ("-v", _('msg_ocs_param_v')),
5: ("-nogui", _('msg_ocs_param_nogui')),
6: ("-c", _('msg_ocs_param_c')),
7: ("-u", _('msg_ocs_param_u')),
8: ("-t", _('msg_ocs_param_t')),
9: ("-j0", _('msg_ocs_param_j0')),
10: ("-ns", _('msg_ocs_param_ns')),
11: ("-k", _('msg_ocs_param_k')),
12: ("-r", _('msg_ocs_param_r')),
13: ("-e", _('msg_ocs_param_e')),
14: ("-f", _('msg_ocs_param_f')),
15: ("-s", _('msg_ocs_param_s')),
16: ("-a", _('msg_ocs_param_a')),
17: ("-o0", _('msg_ocs_param_o0')),
18: ("-o1", _('msg_ocs_param_o1')),
19: ("-hn0", _('msg_ocs_param_hn0')),
20: ("-hn1", _('msg_ocs_param_hn1')),
}

#----------------------------------------------------------------------
class CSSCheckListCtrl(wx.ListCtrl, CheckListCtrlMixin):
    def __init__(self, parent, log):
        wx.ListCtrl.__init__(self, parent, -1, style=wx.LC_REPORT)
        CheckListCtrlMixin.__init__(self)
        self.log = log
        self.Bind(wx.EVT_LIST_ITEM_ACTIVATED, self.OnItemActivated)

    def OnItemActivated(self, evt):
        self.ToggleItem(evt.m_itemIndex)

    # this is called by the base class when an item is checked/unchecked
    def OnCheckItem(self, index, flag):
        data = self.GetItemData(index)
        arg = ClonezillaStartSaveArgs[data][0]
        if flag:
	    FinalArgs[index+3] = arg
        else:
	    FinalArgs[index+3] = ''

#----------------------------------------------------------------------
class CSRCheckListCtrl(wx.ListCtrl, CheckListCtrlMixin):
    def __init__(self, parent, log):
        wx.ListCtrl.__init__(self, parent, -1, style=wx.LC_REPORT)
        CheckListCtrlMixin.__init__(self)
        self.log = log
        self.Bind(wx.EVT_LIST_ITEM_ACTIVATED, self.OnItemActivated)

    def OnItemActivated(self, evt):
        self.ToggleItem(evt.m_itemIndex)

    # this is called by the base class when an item is checked/unchecked
    def OnCheckItem(self, index, flag):
        data = self.GetItemData(index)
        arg = ClonezillaStartRestoreArgs[data][0]
        if flag:
	    if index == 19:
		FinalArgs[index+4] = arg
	    else:
		FinalArgs[index+3] = arg
        else:
	    if index == 19:
		FinalArgs[index+4] = ''
	    else:
		FinalArgs[index+3] = ''

#----------------------------------------------------------------------
def makePageTitle(wizPg, title):
    sizer = wx.BoxSizer(wx.VERTICAL)
    wizPg.SetSizer(sizer)
    title = wx.StaticText(wizPg, -1, title)
    title.SetFont(wx.Font(12, wx.SWISS, wx.NORMAL, wx.BOLD))
    sizer.Add(title, 0, wx.ALIGN_CENTRE|wx.ALL, 5)
    sizer.Add(wx.StaticLine(wizPg, -1), 0, wx.EXPAND|wx.ALL, 5)
    return sizer

#----------------------------------------------------------------------
class WizardBasePage(wiz.PyWizardPage):
    def __init__(self, parent, title):
        wiz.PyWizardPage.__init__(self, parent)
        self.next = self.prev = None
        self.sizer = makePageTitle(self, title)

    def SetNext(self, next):
        self.next = next

    def SetPrev(self, prev):
        self.prev = prev

    def GetNext(self):
        return self.next

    def GetPrev(self):
        return self.prev

#----------------------------------------------------------------------
class SetAllClientsPage(wiz.PyWizardPage):
    def __init__(self, parent, title):
        wiz.PyWizardPage.__init__(self, parent)
        self.next = self.prev = None
        self.sizer = makePageTitle(self, title)

	wx.StaticText(self, -1, _('msg_select_all_clients_or_select_part_them'), pos=(10,60), size=(400,100), style=wx.TE_MULTILINE)
	wx.StaticText(self, -1, _('msg_set_all_clients_des'), pos=(10,80), size=(400,100), style=wx.TE_MULTILINE)
	ox = ['Yes', 'No']
	self.rb = wx.RadioBox(self, -1, _('msg_set_all_clients'), (10,150), (250,75), ox, 1, wx.RA_SPECIFY_COLS|wx.NO_BORDER)
	self.Bind(wx.EVT_RADIOBOX, self.EvtRadioBox, self.rb)
	FinalArgs[1] = '-nl'

    def EvtRadioBox(self, event):
	if event.GetSelection() == 0:
	    FinalArgs[1] = '-nl'
	if event.GetSelection() == 1:
	    FinalArgs[1] = '-h'

    def SetNext(self, next):
        self.next = next

    def GetNext(self):
	next = self.next
	if self.rb.GetSelection()==0:
	    next = next.GetNext()
        return next

#----------------------------------------------------------------------
class SelectOneClientPage(wiz.PyWizardPage):
    def __init__(self, parent, title):
        wiz.PyWizardPage.__init__(self, parent)
        self.next = self.prev = None
        self.sizer = makePageTitle(self, title)
        self.selected_hosts = []
        self.selected_clients = ''
        self.lenghth = 0
        self.filename_temp = []

        file = open("/home/chris/ip_list", "r")
        ip_list = file.read()
        tokens = ("%s" % ip_list).split()
        self.lenghth = len(tokens)
        for i in range(0,len(tokens)):
                self.selected_hosts.insert(len(tokens),"")
                i = i+1
        file.close()

        rb = wx.RadioBox(
                self, -1, _('msg_choose_mode'), (35, 50), (260,590),
                tokens, 1, wx.RA_SPECIFY_COLS
                )

        self.Bind(wx.EVT_RADIOBOX, self.EvtRadioBox, rb)
        FinalArgs[1] = '-h'
	FinalArgs[2] = "\"" + tokens[0] + "\""

    def EvtRadioBox(self, event):
	FinalArgs[2] = ""
	FinalArgs[2] = "\"" + event.GetString() + "\""

    def SetNext(self, next):
        self.next = next

    def SetPrev(self, prev):
        self.prev = prev

    def GetNext(self):
        next = self.next
        return next

    def GetPrev(self):
	FinalArgs[1] = ''
	FinalArgs[2] = ''
        return self.prev

#----------------------------------------------------------------------
class SelectClientsPage(wiz.PyWizardPage):
    def __init__(self, parent, title):
        wiz.PyWizardPage.__init__(self, parent)
        self.next = self.prev = None
        self.sizer = makePageTitle(self, title)

	global PXE_CFG
	PXE_CFG = []
	self.SelectedClientsArray = []
	self.SelectedClientsStr = ''
	self.fuse_next = self.fuse_prev = 0
	
        AllClientsArray = open('/home/chris/ip_list').read().split()
        self.lb = wx.CheckListBox(self, -1, (10,50), (470,250), AllClientsArray)
        self.Bind(wx.EVT_CHECKLISTBOX, self.EvtCheckListBox, self.lb)
        self.lb.SetSelection(0)

    def EvtCheckListBox(self, event):
        index = event.GetSelection()
        label = self.lb.GetString(index)
        if self.lb.IsChecked(index):
	    self.SelectedClientsArray.append(label)
        if not (self.lb.IsChecked(index)):
	    self.SelectedClientsArray.remove(label)
        self.lb.SetSelection(index)    #so that (un)checking also selects (moves the highlight)
	self.SelectedClientsStr = ''
	PXE_CFG = []
	for x in self.SelectedClientsArray:
	    self.SelectedClientsStr = x + ' ' + self.SelectedClientsStr
	    SinglePXECfgFileName = string.upper('%x' % int(x.split('.')[0],10) + '%x' % int(x.split('.')[1],10) + '%x' % int(x.split('.')[2],10) + '%x' % int(x.split('.')[3],10))
	    PXE_CFG.append(SinglePXECfgFileName)
        self.SelectedClientsStr = '\"' + self.SelectedClientsStr + '\"'
	#print self.SelectedClientsStr
	#print PXE_CFG[:]

    def SetNext(self, next):
        self.next = next

    def SetPrev(self, prev):
        self.prev = prev

    def GetNext(self):
	command = ''
	next = self.next
	self.fuse_prev = 0
	self.fuse_next = self.fuse_next + 1
	if self.fuse_next == 2:
            if FinalArgs[1] == '-nl':
                FinalArgs[2] = ''
                clients_pxe_cfg_filename = ''
                PXE_CFG = []
	    elif (self.SelectedClientsStr == '\"\"') or (self.SelectedClientsStr == ''):
	        war = wx.MessageDialog(self, 'YOU MUST CHOOSE AT LEAST ONE!!', 'WARNNING!!', wx.OK|wx.ICON_INFORMATION)
                war.ShowModal()
                war.Destroy()
                return self
	    else:
		FinalArgs[2] = self.SelectedClientsStr
		#print FinalArgs[2]
	    if (FinalArgs[3] == 'remote-linux-gra') or (FinalArgs[3] == 'remote-linux-txt') or (FinalArgs[3] == 'terminal') or (FinalArgs[3] == 'remote-memtest') or (FinalArgs[3] == 'remote-fdos'):
		for i in range(0,4):
		    if FinalArgs[i] != '':
			command = command + FinalArgs[i] + ' '
		FinalCommand.SetLabel('%s' % command)
		CommandLog.WriteText(os.popen('sudo %s' % command).read())
        return next

    def GetPrev(self):
	self.fuse_next = 0
        return self.prev

#----------------------------------------------------------------------
class ClonezillaStartSavePage1(wiz.PyWizardPage):
    def __init__(self, parent, title):
        wiz.PyWizardPage.__init__(self, parent)
        self.next = self.prev = None
        self.sizer = makePageTitle(self, title)
	self.fuse_prev = 0

        ModeList = [_('msg_clonezilla_save_disk'), _('msg_clonezilla_save_parts')]
        rb = wx.RadioBox(
                self, -1, _('msg_choose_mode'), (35, 50), (260,90),
                ModeList, 1, wx.RA_SPECIFY_COLS
                )

        self.Bind(wx.EVT_RADIOBOX, self.EvtRadioBox, rb)
        FinalArgs[0] = '/opt/drbl/sbin/drbl-ocs -b'
	FinalArgs[12] = 'startdisk'
	FinalArgs[13] = 'save'

    def EvtRadioBox(self, event):
        if event.GetInt() == 0:
                FinalArgs[12] = 'startdisk'
		FinalArgs[13] = 'save'
        if event.GetInt() == 1:
                FinalArgs[12] = 'startparts'
		FinalArgs[13] = 'save'

    def SetNext(self, next):
        self.next = next

    def SetPrev(self, prev):
        self.prev = prev

    def GetNext(self):
	self.fuse_prev = 0
        return self.next

    def GetPrev(self):
        self.fuse_prev = self.fuse_prev + 1
        if self.fuse_prev == 1:
	    prev = self.prev
            if FinalArgs[1] == '-nl':
                prev = prev.GetPrev()
        return prev

#----------------------------------------------------------------------
class ClonezillaStartSavePage2(wiz.PyWizardPage):
    def __init__(self, parent, title):
        wiz.PyWizardPage.__init__(self, parent)
        self.next = self.prev = None
        self.sizer = makePageTitle(self, title)
	self.fuse_next = 0
	global CSSP2rb

        choice = [_('msg_now_input_in_server'), _('msg_later_input_in_client')]
        CSSP2rb = wx.RadioBox(self, -1, _('msg_ask_if_input_save_image_name_in_server'), (35,50), (290,150), choice, 1, wx.RA_SPECIFY_COLS)
        CSSP2rb.SetSelection(0)

    def SetNext(self, next):
        self.next = next

    def SetPrev(self, prev):
        self.prev = prev

    def GetNext(self):
	self.fuse_next = self.fuse_next + 1
	next = self.next
	if self.fuse_next == 2:
	    if CSSP2rb.GetSelection() == 1:
		next = next.GetNext()
        return next

    def GetPrev(self):
	self.fuse_next = 0
        return self.prev

#----------------------------------------------------------------------
class ClonezillaStartSavePage3(wiz.PyWizardPage):
    def __init__(self, parent, title):
        wiz.PyWizardPage.__init__(self, parent)
        self.next = self.prev = None
        self.sizer = makePageTitle(self, title)
	self.fuse_next = self.fuse_prev = 0

        self.text_img = wx.TextCtrl(self, -1, '', (10, 180), size=(200, -1))
        wx.StaticText(self, -1,  _('msg_input_image_name'), (10, 160))
        self.text_img = wx.TextCtrl(self, -1, '', (10, 180), size=(200, -1))
        wx.StaticText(self, -1,  _('msg_input_device_name'), (10, 210))
        self.text_dev = wx.TextCtrl(self, -1, '', (10, 230), size=(190, -1))

    def SetNext(self, next):
        self.next = next

    def SetPrev(self, prev):
        self.prev = prev

    def GetNext(self):
	global CSSP2rb
	self.fuse_next = self.fuse_next + 1
	self.fuse_prev = 0
	if self.fuse_next == 2:
	    if CSSP2rb.GetSelection() == 1:
                FinalArgs[14] = ''
                FinalArgs[15] = ''
		#print ('FinalArgs[14] is %s, FinalArgs[15] is %s' % (FinalArgs[14], FinalArgs[15]))
	    elif self.text_img.GetValue() == '' or self.text_dev.GetValue() == '':
		warnning = wx.MessageDialog(self, 'YOU MUST ENTER SOMETHING!!', 'WARNNING', wx.OK|wx.ICON_INFORMATION)
		warnning.ShowModal()
		warnning.Destroy()
		return self
	    else:
	        FinalArgs[14] = self.text_img.GetValue()
	        FinalArgs[15] = self.text_dev.GetValue()
	        #print ('FinalArgs[14] is %s, FinalArgs[15] is %s' % (FinalArgs[14], FinalArgs[15]))
	return self.next

    def GetPrev(self):
	self.fuse_next = 0
        return self.prev

#----------------------------------------------------------------------
class ClonezillaStartSavePage4(wiz.PyWizardPage):
    def __init__(self, parent, title):
        wiz.PyWizardPage.__init__(self, parent)
        self.next = self.prev = None
        self.sizer = makePageTitle(self, title)
	self.fuse_next = self.fuse_prev = 0

        self.list = CSSCheckListCtrl(self, title)
        sizer = wx.BoxSizer()
        sizer.Add(self.list, 1, wx.EXPAND)
        self.SetSizer(sizer)

        self.list.InsertColumn(0, _('argument'))	#not translated
        self.list.InsertColumn(1, _('meannings'), wx.LIST_FORMAT_LEFT)	#not translated

        for key, data in ClonezillaStartSaveArgs.iteritems():
            index = self.list.InsertStringItem(sys.maxint, data[0])
            self.list.SetStringItem(index, 1, data[1])
            self.list.SetItemData(index, key)

        self.list.SetColumnWidth(0, wx.LIST_AUTOSIZE)
        self.list.SetColumnWidth(1, wx.LIST_AUTOSIZE)

        self.list.CheckItem(0)
        self.list.CheckItem(1)

    def SetNext(self, next):
        self.next = next

    def SetPrev(self, prev):
        self.prev = prev

    def GetNext(self):
	self.fuse_prev = 0
        return self.next

    def GetPrev(self):
	self.fuse_prev = self.fuse_prev + 1
	prev = self.prev
	if self.fuse_prev == 1:
	    if FinalArgs[14] == '' and FinalArgs[15] == '':
                prev = prev.GetPrev()
        return prev

#----------------------------------------------------------------------
class ClonezillaStartSavePage5(wiz.PyWizardPage):
    def __init__(self, parent, title):
        wiz.PyWizardPage.__init__(self, parent)
        self.next = self.prev = None
        self.sizer = makePageTitle(self, title)

        ArgList = [_('msg_ocs_param_p_choose'), _('msg_ocs_param_p_true'), _('msg_ocs_param_p_poweroff'), _('msg_ocs_param_p_reboot')]

        rb = wx.RadioBox(self, -1, _('msg_choose_post_mode_after_clone'), (35,50), (290,150), ArgList, 1, wx.RA_SPECIFY_COLS)
        self.Bind(wx.EVT_RADIOBOX, self.EvtRadioBox, rb)
        rb.SetSelection(3)
	FinalArgs[9] = '-p reboot'

    def EvtRadioBox(self, event):
        if event.GetSelection() == 0:
            FinalArgs[9] = '-p choose'
        if event.GetSelection() == 1:
            FinalArgs[9] = '-p true'
        if event.GetSelection() == 2:
            FinalArgs[9] = '-p poweroff'
        if event.GetSelection() == 3:
            FinalArgs[9] = '-p reboot'

    def SetNext(self, next):
        self.next = next

    def SetPrev(self, prev):
        self.prev = prev

    def GetNext(self):
        return self.next

    def GetPrev(self):
        return self.prev

#----------------------------------------------------------------------
class ClonezillaStartSavePage6(wiz.PyWizardPage):
    def __init__(self, parent, title):
        wiz.PyWizardPage.__init__(self, parent)
        self.next = self.prev = None
        self.sizer = makePageTitle(self, title)

        ArgList = [ _('msg_ocs_param_z0'), _('msg_ocs_param_z1'), _('msg_ocs_param_z2'), _('msg_ocs_param_z3')]
        rb = wx.RadioBox(self, -1, _('msg_choose_post_mode_after_clone'), (35,50), (340,150), ArgList, 1, wx.RA_SPECIFY_COLS)
        self.Bind(wx.EVT_RADIOBOX, self.EvtRadioBox, rb)
        rb.SetSelection(3)
	FinalArgs[10] = '-z3'
	self.fuse_next = 0
	self.command = ''

    def EvtRadioBox(self, event):
        if event.GetSelection() == 0:
                FinalArgs[10] = '-z0'
        if event.GetSelection() == 1:
                FinalArgs[10] = '-z1'
        if event.GetSelection() == 2:
                FinalArgs[10] = '-z2'
        if event.GetSelection() == 3:
                FinalArgs[10] = '-z3'

    def SetNext(self, next):
        self.next = next

    def SetPrev(self, prev):
        self.prev = prev

    def GetNext(self):
        global command_log, tc
        self.fuse_next = self.fuse_next + 1
        if self.fuse_next == 2:
	    if FinalArgs[1] == '-nl':
		FinalArgs[1] = ''
            for i in range(0,20):
                if FinalArgs[i] != '':
                    self.command = self.command + FinalArgs[i] + ' '
	    file = open('tmp.log','w')
	    os.system('sudo %s > tmp.log' % self.command)
	    time.sleep(6)
	    file.close()
	    file = open('tmp.log')
	    while True:
		line = file.readline()
		if len(line) == 0: # Zero length indicates EOF
        	    break
		command_log = command_log + line
	    tc.WriteText('%s' % command_log)
	    file.close()
	    os.remove('tmp.log')
	return self.next

    def GetPrev(self):
	self.fuse_next = 0
        return self.prev

#----------------------------------------------------------------------
class ClonezillaStartRestorePage1(wiz.PyWizardPage):
    def __init__(self, parent, title):
        wiz.PyWizardPage.__init__(self, parent)
        self.next = self.prev = None
        self.sizer = makePageTitle(self, title)
	self.fuse_next = self.fuse_prev = 0	

        ModeList = [_('msg_clonezilla_restore_disk'), _('msg_clonezilla_restore_parts')]
        rb = wx.RadioBox(self, -1, _('msg_choose_mode'), (35, 50), (260,90), ModeList, 1, wx.RA_SPECIFY_COLS)
        self.Bind(wx.EVT_RADIOBOX, self.EvtRadioBox, rb)
        FinalArgs[0] = '/opt/drbl/sbin/drbl-ocs -b'
        FinalArgs[33] = 'startdisk'

    def EvtRadioBox(self, event):
        if event.GetInt() == 0:
            FinalArgs[33] = 'startdisk'
        if event.GetInt() == 1:
            FinalArgs[33] = 'startparts'

    def SetNext(self, next):
        self.next = next

    def SetPrev(self, prev):
        self.prev = prev

    def GetNext(self):
	self.fuse_prev = 0
	self.fuse_next = self.fuse_next + 1
	if self.fuse_next == 2:
	    print ('ClonezillaRestorePage1: FinalArgs[33] is %s' % FinalArgs[33])
        return self.next

    def GetPrev(self):
	prev = self.prev
	self.fuse_next = 0
        self.fuse_prev = self.fuse_prev + 1
        if self.fuse_prev == 1:
            if FinalArgs[1] == '-nl':
                prev = prev.GetPrev()
        return prev

#----------------------------------------------------------------------
class ClonezillaStartRestorePage2(wiz.PyWizardPage):
    def __init__(self, parent, title):
        wiz.PyWizardPage.__init__(self, parent)
        self.next = self.prev = None
        self.sizer = makePageTitle(self, title)
	self.fuse_next = 0

        self.list = CSRCheckListCtrl(self, title)
        sizer = wx.BoxSizer()
        sizer.Add(self.list, 1, wx.EXPAND)
        self.SetSizer(sizer)

        self.list.InsertColumn(0, _('argument'))        	       #not translated
        self.list.InsertColumn(1, _('meannings'), wx.LIST_FORMAT_LEFT) #not translated

        for key, data in ClonezillaStartRestoreArgs.iteritems():
            index = self.list.InsertStringItem(sys.maxint, data[0])
            self.list.SetStringItem(index, 1, data[1])
            self.list.SetItemData(index, key)

        self.list.SetColumnWidth(0, wx.LIST_AUTOSIZE)
        self.list.SetColumnWidth(1, wx.LIST_AUTOSIZE)

        self.list.CheckItem(0)
        self.list.CheckItem(1)

    def SetNext(self, next):
        self.next = next

    def SetPrev(self, prev):
        self.prev = prev

    def GetNext(self):
	next = self.next
	self.fuse_next = self.fuse_next + 1
	if self.fuse_next == 2:
	    if not (self.list.IsChecked(18) or self.list.IsChecked(19)):
	        next = next.GetNext()
	        next = next.GetNext()
	    print ('ClonezillaRestorePage2: arguments are : %s' % FinalArgs[3:24])
        return next

    def GetPrev(self):
	self.fuse_next = 0
        return self.prev

#----------------------------------------------------------------------
class ClonezillaStartRestorePage3(wiz.PyWizardPage):
    def __init__(self, parent, title):
        wiz.PyWizardPage.__init__(self, parent)
        self.next = self.prev = None
        self.sizer = makePageTitle(self, title)

        wx.StaticText(self,-1,_('msg_write_MS_WIN_is_necessary'),wx.DLG_PNT(self, 5, 20),wx.DLG_SZE(self, 210, 300),wx.TE_MULTILINE)

    def SetNext(self, next):
        self.next = next

    def SetPrev(self, prev):
        self.prev = prev

    def GetNext(self):
        return self.next

    def GetPrev(self):
        return self.prev

#----------------------------------------------------------------------
class ClonezillaStartRestorePage4(wiz.PyWizardPage):
    def __init__(self, parent, title):
        wiz.PyWizardPage.__init__(self, parent)
        self.next = self.prev = None
        self.sizer = makePageTitle(self, title)
	self.fuse_next = 0

        wx.StaticText(self, -1, _('msg_What_the_win_hostname_prefix'), (5, 80))
        self.text = wx.TextCtrl(self, -1, "PC", (5, 110), size=(200, -1))

    def SetNext(self, next):
        self.next = next

    def SetPrev(self, prev):
        self.prev = prev

    def GetNext(self):
	self.fuse_next = self.fuse_next + 1
	if self.fuse_next == 2:
            if FinalArgs[21] == '-hn0':
                FinalArgs[22] = self.text.GetValue()
            else:
                FinalArgs[22] = ''
            if FinalArgs[23] == '-hn1':
                FinalArgs[24] = self.text.GetValue()
            else:
                FinalArgs[24] = ''
	    print ('ClonezillaRestorePage4 : FinalArgs[21-24] are %s' % FinalArgs[21:25])
	    #print ('FinalArgs[22] is %s, FinalArgs[24] is %s' % (FinalArgs[22], FinalArgs[24]))
        return self.next

    def GetPrev(self):
	self.fuse_next = 0
        return self.prev

#----------------------------------------------------------------------
class ClonezillaStartRestorePage5(wiz.PyWizardPage):
    def __init__(self, parent, title):
        wiz.PyWizardPage.__init__(self, parent)
        self.next = self.prev = None
        self.sizer = makePageTitle(self, title)
	self.fuse_next = self.fuse_prev = 0

        ModeList = [_('msg_ocs_param_y0'), _('msg_ocs_param_y1'), _('msg_ocs_param_y2'), _('msg_ocs_param_skip')]
        wx.StaticText(self,-1,_('msg_if_always_provide_clonezilla_srv'),wx.DLG_PNT(self, 5, 20),wx.DLG_SZE(self, 210, 300),wx.TE_MULTILINE)
        rb = wx.RadioBox(self, -1, '', (5,150), wx.DefaultSize, ModeList, 1, wx.RA_SPECIFY_COLS)
        self.Bind(wx.EVT_RADIOBOX, self.EvtRadioBox, rb)
        rb.SetSelection(3)

    def EvtRadioBox(self, event):
        if event.GetInt() == 0:
            FinalArgs[25] = '-y0'
        elif event.GetInt() == 1:
            FinalArgs[25] = '-y1'
        elif event.GetInt() == 2:
            FinalArgs[25] = '-y2'
        elif event.GetInt() == 3:
            FinalArgs[25] = ''

    def SetNext(self, next):
        self.next = next

    def SetPrev(self, prev):
        self.prev = prev

    def GetNext(self):
	self.fuse_prev = 0
	self.fuse_next = self.fuse_next + 1
	if self.fuse_next == 2:
	    print ('ClonezillaRestorePage5 : FinalArgs[25](-y) is %s' % FinalArgs[25])
        return self.next

    def GetPrev(self):
	prev = self.prev
	self.fuse_next = 0
	self.fuse_prev = self.fuse_prev + 1
	if self.fuse_prev == 1:
	    if FinalArgs[21] == '' and FinalArgs[23] == '':
	        prev = prev.GetPrev()
	        prev = prev.GetPrev()
        return prev

#----------------------------------------------------------------------
class ClonezillaStartRestorePage6(wiz.PyWizardPage):
    def __init__(self, parent, title):
        wiz.PyWizardPage.__init__(self, parent)
        self.next = self.prev = None
        self.sizer = makePageTitle(self, title)
        self.fuse_prev = self.fuse_next = 0
	self.command = ''

        ArgList = [_('msg_ocs_param_p_choose'), _('msg_ocs_param_p_true'), _('msg_ocs_param_p_poweroff'), _('msg_ocs_param_p_reboot')]
        rb = wx.RadioBox(self, -1, _('msg_choose_post_mode_after_clone'), (35,50), (290,150), ArgList, 1, wx.RA_SPECIFY_COLS)
        self.Bind(wx.EVT_RADIOBOX, self.EvtRadioBox, rb)
        rb.SetSelection(3)
        FinalArgs[26] = '-p reboot'

    def EvtRadioBox(self, event):
        if event.GetSelection() == 0:
                FinalArgs[26] = '-p choose'
        if event.GetSelection() == 1:
                FinalArgs[26] = '-p true'
        if event.GetSelection() == 2:
                FinalArgs[26] = '-p poweroff'
        if event.GetSelection() == 3:
                FinalArgs[26] = '-p reboot'

    def SetNext(self, next):
        self.next = next

    def SetPrev(self, prev):
        self.prev = prev

    def GetNext(self):
	global command_log, tc
	next = self.next
	self.fuse_prev = 0
	self.fuse_next = self.fuse_next + 1
	if self.fuse_next == 2:
	    if FinalArgs[9] == '-u':
		if FinalArgs[1] == '-nl':
		    FinalArgs[1] = ''
		FinalArgs[27] = FinalArgs[29] = ''
		FinalArgs[34] = 'restore'
                for i in range(0,37):
                    if FinalArgs[i] != '':
                        self.command = self.command + FinalArgs[i] + ' '
		print ('ClonezillaRestorePage6 : FinalArgs[26] (-z) is %s' % FinalArgs[26])
		print ('FinalCommands : %s' % self.command)
                file = open('tmp.log','w')
                os.system('sudo %s > tmp.log' % self.command)
                time.sleep(6)
                file.close()
                file = open('tmp.log')
                while True:
                    line = file.readline()
                    if len(line) == 0: # Zero length indicates EOF
                        break
                    command_log = command_log + line
                tc.WriteText('%s' % command_log)
                file.close()
                os.remove('tmp.log')
		#tc.WriteText(os.popen('sudo %s' % self.command).read())
		for i in range(0,8):
		    next = next.GetNext()
	    else:
	        print ('ClonezillaRestorePage6 : FinalArgs[26] (-z) is %s' % FinalArgs[26])
        return next

    def GetPrev(self):
	prev = self.prev
	self.fuse_next = 0
	self.fuse_prev = self.fuse_prev + 1
	if self.fuse_prev == 1:
	    FinalArgs[34] = 'multicast_restore'
        return prev

#----------------------------------------------------------------------
class ClonezillaStartRestorePage7(wiz.PyWizardPage):
    def __init__(self, parent, title):
        wiz.PyWizardPage.__init__(self, parent)
        self.next = self.prev = None
        self.sizer = makePageTitle(self, title)
	self.fuse_next = 0

        wx.StaticText(self, -1, _('msg_choose_the_image_to_restore'), (5,80))
        self.fbb = filebrowse.FileBrowseButton(self, -1, pos=(50,150), size=(350, -1), buttonText='browse', 
toolTip='Enter the img name or click browse button to choose img', fileMask='*.img', changeCallback = self.fbbCallback)

    def fbbCallback(self, evt):
        FinalArgs[35] = evt.GetString()

    def SetNext(self, next):
        self.next = next

    def SetPrev(self, prev):
        self.prev = prev

    def GetNext(self):
	next = self.next
	self.fuse_next = self.fuse_next + 1
	if self.fuse_next == 2:
	    if FinalArgs[9] == '-u':
		FinalArgs[35] = ''
		next = next.GetNext()
		print ('ClonezillaRestorePage7 : FinalArgs[9] = -u')
	    elif FinalArgs[35] == '':
                warnning = wx.MessageDialog(self, 'YOU MUST ENTER SOMETHING!!', 'WARNNING', wx.OK|wx.ICON_INFORMATION)
                warnning.ShowModal()
                warnning.Destroy()
		return self			
	    elif FinalArgs[33] == 'startparts':
	        next = next.GetNext()
		print ('ClonezillaRestorePage7 : FinalArgs[33] = startparts')
	    print ('ClonezillaRestorePage7 : FinalArgs[35] is %s' % FinalArgs[35])
        return next

    def GetPrev(self):
	self.fuse_next = 0
        return self.prev

#----------------------------------------------------------------------
class ClonezillaStartRestorePage8a(wiz.PyWizardPage):
    def __init__(self, parent, title):
        wiz.PyWizardPage.__init__(self, parent)
        self.next = self.prev = None
        self.sizer = makePageTitle(self, title)
	self.fuse_next = self.fuse_prev = 0

        wx.StaticText(self, -1, _('msg_choose_the_disks_to_restore'), (5,80))
        self.text = wx.TextCtrl(self, -1, "sda", (5, 110), size=(200, -1))

    def SetNext(self, next):
        self.next = next

    def SetPrev(self, prev):
        self.prev = prev

    def GetNext(self):
	next = self.next
	self.fuse_prev = 0
	self.fuse_next = self.fuse_next + 1
	if self.fuse_next == 2:
	    if FinalArgs[9] == '-u':
		next = next.GetNext()
		FinalArgs[36] = ''
		print ('ClonezillaRestorePage8a : FinalArgs[9] = -u')
	    elif FinalArgs[33] == 'startdisk':
	        if self.text.GetValue() == '':
                    warnning = wx.MessageDialog(self, 'YOU MUST ENTER SOMETHING!!', 'WARNNING', wx.OK|wx.ICON_INFORMATION)
                    warnning.ShowModal()
                    warnning.Destroy()
                    return self
	        else:
	            FinalArgs[36] = self.text.GetValue()
	            next = next.GetNext()
		    print ('ClonezillaRestorePage8a : FinalArgs[33] = startdisk, FinalArgs[36] is %s' % FinalArgs[36])
        return next

    def GetPrev(self):
	prev = self.prev
	self.fuse_next = 0
	self.fuse_prev = self.fuse_prev + 1
	if self.fuse_prev == 1:
	    FinalArgs[36] = ''
        return prev

#----------------------------------------------------------------------
class ClonezillaStartRestorePage8b(wiz.PyWizardPage):
    def __init__(self, parent, title):
        wiz.PyWizardPage.__init__(self, parent)
        self.next = self.prev = None
        self.sizer = makePageTitle(self, title)
	self.fuse_next = self.fuse_prev = 0

        wx.StaticText(self, -1, _('msg_choose_the_parts_to_restore'), (5,80))
        self.text = wx.TextCtrl(self, -1, "sda", (5, 110), size=(200, -1))

    def SetNext(self, next):
        self.next = next

    def SetPrev(self, prev):
        self.prev = prev

    def GetNext(self):
	next = self.next
	self.fuse_prev = 0
	self.fuse_next = self.fuse_next + 1
	if self.fuse_next == 2:
	    if FinalArgs[9] == '-u':
		next = next.GetNext()
		FinalArgs[36] = ''
		print ('ClonezillaRestorePage8b : FinalArgs[9] = -u')
	    elif FinalArgs[33] == 'startparts':
	        if self.text.GetValue() == '':
                    warnning = wx.MessageDialog(self, 'YOU MUST ENTER SOMETHING!!', 'WARNNING', wx.OK|wx.ICON_INFORMATION)
                    warnning.ShowModal()
                    warnning.Destroy()
                    return self
	        else:		
                    FinalArgs[36] = self.text.GetValue()
	            next = next.GetNext()
		    print ('ClonezillaRestorePage8b : FinalArgs[33] = startparts, FinalArgs[36] is %s' % FinalArgs[36])
        return next

    def GetPrev(self):
	prev = self.prev
	self.fuse_next = 0
	self.fuse_prev = self.fuse_prev + 1
	if self.fuse_prev == 1:
	    if FinalArgs[33] == 'startparts':
		FinalArgs[36] = ''
	        prev = prev.GetPrev()
        return prev

#----------------------------------------------------------------------
class ClonezillaStartRestorePage9a(wiz.PyWizardPage):
    def __init__(self, parent, title):
        wiz.PyWizardPage.__init__(self, parent)
        self.next = self.prev = None
        self.sizer = makePageTitle(self, title)
	self.fuse_next = self.fuse_prev = 0
	self.command = ''

        ModeList = [_('msg_multicast_restore'), _('msg_unicast_restore')]
        rb = wx.RadioBox(self, -1, _('msg_choose_the_mode_to_restore_disk'), (35,50), (290,150), ModeList, 1, wx.RA_SPECIFY_COLS)
        self.Bind(wx.EVT_RADIOBOX, self.EvtRadioBox, rb)
	FinalArgs[34] = 'multicast_restore'

    def EvtRadioBox(self, event):
        if event.GetInt() == 0:
            FinalArgs[34] = 'multicast_restore'
        if event.GetInt() == 1:
            FinalArgs[34] = 'restore'

    def SetNext(self, next):
        self.next = next

    def SetPrev(self, prev):
        self.prev = prev

    def GetNext(self):
	global command_log, tc
	next = self.next
	self.fuse_prev = 0
	self.fuse_next = self.fuse_next + 1
	if self.fuse_next == 2:
	    if FinalArgs[33] == 'startdisk':
	        if FinalArgs[9] != '-u' and FinalArgs[34] == 'restore':
		    if FinalArgs[1] == '-nl':
			FinalArgs[1] = ''
		    FinalArgs[27] = FinalArgs[29] = ''
                    for i in range(0,37):
                        if FinalArgs[i] != '':
                            self.command = self.command + FinalArgs[i] + ' '
                    print ('ClonezillaStartRestorePage9a : FinalArgs[9] is empty, FinalArgs[34] is %s' % FinalArgs[34])
		    print ('FinalCommands : %s' % self.command)
            	    file = open('tmp.log','w')
            	    os.system('sudo %s > tmp.log' % self.command)
            	    time.sleep(6)
            	    file.close()
            	    file = open('tmp.log')
            	    while True:
                	line = file.readline()
                	if len(line) == 0: # Zero length indicates EOF
                    	    break
                	command_log = command_log + line
            	    tc.WriteText('%s' % command_log)
            	    file.close()
            	    os.remove('tmp.log')
                    #tc.WriteText(os.popen('sudo %s' % self.command).read())
		    for i in range(0,4):
			next = next.GetNext()
		else:
		    next = next.GetNext()
		    print ('ClonezillaStartRestorePage9a : FinalArgs[34] is %s (should be multicast_restore)' % FinalArgs[34])
        return next

    def GetPrev(self):
	prev = self.prev
	self.fuse_next = 0
	self.fuse_prev = self.fuse_prev + 1
	if self.fuse_prev == 1:
	    if FinalArgs[33] == 'startdisk':
		FinalArgs[27] = '--clients-to-wait'
		FinalArgs[29] = '--max-time-to-wait'
	        prev = prev.GetPrev()
        return prev

#----------------------------------------------------------------------
class ClonezillaStartRestorePage9b(wiz.PyWizardPage):
    def __init__(self, parent, title):
        wiz.PyWizardPage.__init__(self, parent)
        self.next = self.prev = None
        self.sizer = makePageTitle(self, title)
	self.fuse_next = self.fuse_prev = 0
	self.command = ''

        ModeList = [_('msg_multicast_restore'), _('msg_unicast_restore')]
        rb = wx.RadioBox(self, -1, _('msg_choose_the_mode_to_restore_parts'), (35,50), (290,150), ModeList, 1, wx.RA_SPECIFY_COLS)
        self.Bind(wx.EVT_RADIOBOX, self.EvtRadioBox, rb)
        FinalArgs[34] = 'multicast_restore'

    def EvtRadioBox(self, event):
        if event.GetInt() == 0:
            FinalArgs[34] = 'multicast_restore'
        if event.GetInt() == 1:
            FinalArgs[34] = 'restore'

    def SetNext(self, next):
        self.next = next

    def SetPrev(self, prev):
        self.prev = prev

    def GetNext(self):
	global command_log, tc
	next = self.next
	self.fuse_prev = 0
	self.fuse_next = self.fuse_next + 1
	if self.fuse_next == 2:
	    if FinalArgs[33] == 'startparts':
		if FinalArgs[9] != '-u' and FinalArgs[34] == 'restore':
		    if FinalArgs[1] == '-nl':
			FinalArgs[1] = ''
		    FinalArgs[27] = FinalArgs[29] = ''
                    for i in range(0,37):
                        if FinalArgs[i] != '':
                            self.command = self.command + FinalArgs[i] + ' '
                    print ('ClonezillaStartRestorePage9b : FinalArgs[9] is empty, FinalArgs[34] is %s' % FinalArgs[34])
		    print ('FinalCommands : %s' % self.command)
            	    file = open('tmp.log','w')
            	    os.system('sudo %s > tmp.log' % self.command)
            	    time.sleep(6)
            	    file.close()
            	    file = open('tmp.log')
            	    while True:
                	line = file.readline()
                	if len(line) == 0: # Zero length indicates EOF
                    	    break
                	command_log = command_log + line
            	    tc.WriteText('%s' % command_log)
            	    file.close()
            	    os.remove('tmp.log')
                    #tc.WriteText(os.popen('sudo %s' % self.command).read())
		    for i in range(0,3):
			next = next.GetNext()
                else:
                    print ('ClonezillaStartRestorePage9b : FinalArgs[34] is %s (should be multicast_restore)' % FinalArgs[34])
        return next

    def GetPrev(self):
	prev = self.prev
	self.fuse_next = 0
	self.fuse_prev = self.fuse_prev + 1
	if self.fuse_prev == 1:
	    if FinalArgs[33] == 'startparts':
		prev = prev.GetPrev()
        return prev

#----------------------------------------------------------------------
class ClonezillaStartRestorePage10(wiz.PyWizardPage):
    def __init__(self, parent, title):
        wiz.PyWizardPage.__init__(self, parent)
        self.next = self.prev = None
        self.sizer = makePageTitle(self, title)
	self.fuse_next = self.fuse_prev = 0

        ModeList = [_('msg_clients_time_to_wait'), _('msg_time_to_wait'), _('msg_clients_to_wait')]
        rb = wx.RadioBox(self, -1, _('msg_choose_mode'), (35,50), (350, 150), ModeList, 1, wx.RA_SPECIFY_COLS)
        self.Bind(wx.EVT_RADIOBOX, self.EvtRadioBox, rb)
	FinalArgs[27] = '--clients-to-wait'
	FinalArgs[29] = '--max-time-to-wait'

    def EvtRadioBox(self, event):
	if event.GetInt() == 0:
	    FinalArgs[27] = '--clients-to-wait'
	    FinalArgs[29] = '--max-time-to-wait'
	elif event.GetInt() == 1:
	    FinalArgs[27] = ''
	    FinalArgs[29] = '--max-time-to-wait'
	elif event.GetInt() == 2:
	    FinalArgs[27] = '--clients-to-wait'
	    FinalArgs[29] = ''
 
    def SetNext(self, next):
        self.next = next

    def SetPrev(self, prev):
        self.prev = prev

    def GetNext(self):
	next = self.next
	self.fuse_prev = 0
	self.fuse_next = self.fuse_next + 1
	if self.fuse_next == 2:
	    if FinalArgs[27] == '' and FinalArgs[29] != '':
	        next = next.GetNext()
		print ('ClonezillaRestorePage10 : just time-to-wait')
	    elif FinalArgs[27] != '' and FinalArgs[29] == '':
		print ('ClonezillaRestorePage10 : just clients-to-wait')
	    elif FinalArgs[27] != '' and FinalArgs[29] != '':
		print ('ClonezillaRestorePage10 : both time-to-wait and clients-to-wait')
        return next

    def GetPrev(self):
	prev = self.prev
	self.fuse_next = 0
	self.fuse_prev = self.fuse_prev + 1
	if self.fuse_prev == 1:
	    #FinalArgs[27] = '--clients-to-wait'
	    #FinalArgs[29] = '--max-time-to-wait'
	    if FinalArgs[33] == 'startdisk':
	  	prev = prev.GetPrev()
        return prev
#----------------------------------------------------------------------
class ClonezillaStartRestorePage11(wiz.PyWizardPage):
    def __init__(self, parent, title):
        wiz.PyWizardPage.__init__(self, parent)
        self.next = self.prev = None
        self.sizer = makePageTitle(self, title)
	self.fuse_next = self.fuse_prev = 0
	self.command = ''

        wx.StaticText(self, -1, _('msg_how_many_clients_to_restore'), (20, 80))
	self.text = wx.TextCtrl(self, -1, '5', (20, 110), size=(200, -1))

    def SetNext(self, next):
        self.next = next

    def SetPrev(self, prev):
        self.prev = prev

    def GetNext(self):
	global command_log, tc
	next = self.next
	self.fuse_prev = 0
	self.fuse_next = self.fuse_next + 1
	if self.fuse_next == 2:
            if self.text.GetValue() == '':
                warnning = wx.MessageDialog(self, 'YOU MUST ENTER SOMETHING!!', 'WARNNING', wx.OK|wx.ICON_INFORMATION)
                warnning.ShowModal()
                warnning.Destroy()
                return self
	    if FinalArgs[27] != '' and FinalArgs[29] == '':
	        FinalArgs[28] = self.text.GetValue()
                if FinalArgs[1] == '-nl':
                    FinalArgs[1] = ''
                for i in range(0,37):
                    if FinalArgs[i] != '':
                        self.command = self.command + FinalArgs[i] + ' '
                print ('FinalCommands : %s' % self.command)
                #tc.WriteText(os.popen('sudo %s' % self.command).read())
                file = open('tmp.log','w')
                os.system('sudo %s > tmp.log' % self.command)
                time.sleep(6)
                file.close()
                file = open('tmp.log')
                while True:
                    line = file.readline()
                    if len(line) == 0: # Zero length indicates EOF
                        break
                    command_log = command_log + line
                tc.WriteText('%s' % command_log)
                file.close()
                os.remove('tmp.log')
	    elif FinalArgs[27] != '' and FinalArgs[29] != '':
		FinalArgs[28] = self.text.GetValue()	
        return next

    def GetPrev(self):
	prev = self.prev
	self.fuse_next = 0
	self.fuse_prev = self.fuse_prev + 1
	if self.fuse_prev == 1:
	    FinalArgs[28] = ''
        return prev

#----------------------------------------------------------------------
class ClonezillaStartRestorePage12(wiz.PyWizardPage):
    def __init__(self, parent, title):
        wiz.PyWizardPage.__init__(self, parent)
        self.next = self.prev = None
        self.sizer = makePageTitle(self, title)
        self.fuse_next = self.fuse_prev  = 0
        self.command = ''

        wx.StaticText(self, -1, _('msg_max_time_to_wait_sec'), pos=(10, 60), size=(475, 200), style=wx.TE_MULTILINE)
        self.text = wx.TextCtrl(self, -1, "300", (10, 150), size=(100, -1))

    def SetNext(self, next):
        self.next = next

    def SetPrev(self, prev):
        self.prev = prev

    def GetNext(self):
	global command_log, tc
	next = self.next
	self.fuse_prev = 0
	self.fuse_next = self.fuse_next + 1
	if self.fuse_next == 2:
	    if self.text.GetValue() == '':
		warnning = wx.MessageDialog(self, 'YOU MUST ENTER SOMETHING!!', 'WARNNING', wx.OK|wx.ICON_INFORMATION)
		warnning.ShowModal()
		warnning.Destroy()
		return self
	    FinalArgs[30] = self.text.GetValue()
	    if FinalArgs[1] == '-nl':
		FinalArgs[1] = ''
            for i in range(0,37):
                if FinalArgs[i] != '':
                    self.command = self.command + FinalArgs[i] + ' '
            print ('FinalCommands : %s' % self.command)
            #tc.WriteText(os.popen('sudo %s' % self.command).read())
            file = open('tmp.log','w')
            os.system('sudo %s > tmp.log' % self.command)
            time.sleep(6)
            file.close()
            file = open('tmp.log')
            while True:
                line = file.readline()
                if len(line) == 0: # Zero length indicates EOF
                    break
                command_log = command_log + line
	    tc.WriteText('%s' % command_log)
            file.close()
            os.remove('tmp.log')
	return next

    def GetPrev(self):
	prev = self.prev
	self.fuse_next = 0
	self.fuse_prev = self.fuse_prev + 1
	if self.fuse_prev == 1:
	    FinalArgs[30] = ''
	    if FinalArgs[27] == '':
		prev = prev.GetPrev()
        return prev

#----------------------------------------------------------------------
class ClonezillaSelectPage1(wiz.PyWizardPage):
    def __init__(self, parent, title):
        wiz.PyWizardPage.__init__(self, parent)
        self.next = self.prev = None
        self.sizer = makePageTitle(self, title)

        ModeList = [_('msg_ocs_param_y0'), _('msg_ocs_param_y1'), _('msg_ocs_param_y2'), _('msg_ocs_param_skip')]
        wx.StaticText(self,-1,_('msg_if_always_provide_clonezilla_srv'),wx.DLG_PNT(self, 5, 20),wx.DLG_SZE(self, 210, 300),wx.TE_MULTILINE)
        rb = wx.RadioBox(self, -1, '', (5,100), wx.DefaultSize, ModeList, 1, wx.RA_SPECIFY_COLS)
        self.Bind(wx.EVT_RADIOBOX, self.EvtRadioBox, rb)
        rb.SetSelection(1)
	FinalArgs[0] = '/opt/drbl/sbin/drbl-ocs -b'
	FinalArgs[5] = '-y1'

    def EvtRadioBox(self, event):
        if event.GetInt() == 0:
            FinalArgs[5] = '-y0'
        elif event.GetInt() == 1:
            FinalArgs[5] = '-y1'
        elif event.GetInt() == 2:
            FinalArgs[5] = '-y2'
        elif event.GetInt() == 3:
            FinalArgs[5] = ''

    def SetNext(self, next):
        self.next = next

    def SetPrev(self, prev):
        self.prev = prev

    def GetNext(self):
        return self.next

    def GetPrev(self):
        return self.prev

#----------------------------------------------------------------------
class ClonezillaSelectPage2(wiz.PyWizardPage):
    def __init__(self, parent, title):
        wiz.PyWizardPage.__init__(self, parent)
        self.next = self.prev = None
        self.sizer = makePageTitle(self, title)

        ArgList = [_('msg_ocs_param_p_choose'), _('msg_ocs_param_p_true'), _('msg_ocs_param_p_poweroff'), _('msg_ocs_param_p_reboot')]
        rb = wx.RadioBox(self, -1, _('msg_choose_post_mode_after_clone'), (35,50), (290,150), ArgList, 1, wx.RA_SPECIFY_COLS)
        self.Bind(wx.EVT_RADIOBOX, self.EvtRadioBox, rb)
        rb.SetSelection(0)
        self.j = 0
        self.command = ''
        FinalArgs[6] = '-p choose'

    def EvtRadioBox(self, event):
        if event.GetSelection() == 0:
                FinalArgs[6] = '-p choose'
        if event.GetSelection() == 1:
                FinalArgs[6] = '-p true'
        if event.GetSelection() == 2:
                FinalArgs[6] = '-p poweroff'
        if event.GetSelection() == 3:
                FinalArgs[6] = '-p reboot'

    def SetNext(self, next):
        self.next = next

    def SetPrev(self, prev):
        self.prev = prev

    def GetNext(self):
	FinalArgs[7] = 'select_in_client'
        global command_log, tc
        self.j = self.j + 1
        for i in range(0,36):
            if FinalArgs[i] != '' and self.j == 2:
                self.command = self.command + FinalArgs[i] + ' '
        if self.j == 2:
            command_log = os.popen('sudo %s' % self.command).read()
	    tc.WriteText('%s' % command_log)
        return self.next

    def GetPrev(self):
        return self.prev

#----------------------------------------------------------------------
class ClonezillaStopPage(wiz.PyWizardPage):
    def __init__(self, parent, title):
        wiz.PyWizardPage.__init__(self, parent)
        self.next = self.prev = None
        self.sizer = makePageTitle(self, title)

        wx.StaticText(self, -1, _('msg_clonezilla_stop'),(50,100))
	self.j = 0
	self.command = ''
        FinalArgs[0] = '/opt/drbl/sbin/dcs'
        FinalArgs[3] = 'clonezilla-stop'
	
    def SetNext(self, next):
        self.next = next

    def SetPrev(self, prev):
        self.prev = prev

    def GetNext(self):
        global command_log, tc
        self.j = self.j + 1
        for i in range(0,36):
            if FinalArgs[i] != '' and self.j == 2:
                self.command = self.command + FinalArgs[i] + ' '
        if self.j == 2:
            command_log = os.popen('sudo %s' % self.command).read()
	    tc.WriteText('%s' % command_log)
        return self.next

    def GetPrev(self):
        return self.prev

#----------------------------------------------------------------------
class LocalPage(wiz.PyWizardPage):
    def __init__(self, parent, title):
        wiz.PyWizardPage.__init__(self, parent)
        self.next = self.prev = None
        self.sizer = makePageTitle(self, title)

        wx.StaticText(self, -1, _('msg_local'),(50,100))
	self.command = ''
	self.j = 0
        FinalArgs[0] = '/opt/drbl/sbin/dcs'
        FinalArgs[3] = 'local'

    def SetNext(self, next):
        self.next = next

    def SetPrev(self, prev):
        self.prev = prev

    def GetNext(self):
        global command_log, tc
        self.j = self.j + 1
        for i in range(0,36):
            if FinalArgs[i] != '' and self.j == 2:
                self.command = self.command + FinalArgs[i] + ' '
        if self.j == 2:
            command_log = os.popen('sudo %s' % self.command).read()
	    tc.WriteText('%s' % command_log)
        return self.next

    def GetPrev(self):
        return self.prev

#----------------------------------------------------------------------
class RebootPage(wiz.PyWizardPage):
    def __init__(self, parent, title):
        wiz.PyWizardPage.__init__(self, parent)
        self.next = self.prev = None
        self.sizer = makePageTitle(self, title)

        wx.StaticText(self, -1, _('msg_reboot'),(50,100))
	self.command = ''
	self.j = 0
        FinalArgs[0] = '/opt/drbl/sbin/dcs'
        FinalArgs[3] = 'reboot'

    def SetNext(self, next):
        self.next = next

    def SetPrev(self, prev):
        self.prev = prev

    def GetNext(self):
        global command_log, tc
        self.j = self.j + 1
        for i in range(0,36):
            if FinalArgs[i] != '' and self.j == 2:
                self.command = self.command + FinalArgs[i] + ' '
        if self.j == 2:
            command_log = os.popen('sudo %s' % self.command).read()
	    tc.WriteText('%s' % command_log)
        return self.next

    def GetPrev(self):
        return self.prev

#----------------------------------------------------------------------
class ShutdownPage(wiz.PyWizardPage):
    def __init__(self, parent, title):
        wiz.PyWizardPage.__init__(self, parent)
        self.next = self.prev = None
        self.sizer = makePageTitle(self, title)

        wx.StaticText(self, -1, _('msg_shutdown'),(50,100))
	self.command = ''
	self.j = 0
        FinalArgs[0] = '/opt/drbl/sbin/dcs'
        FinalArgs[3] = 'shutdown'

    def SetNext(self, next):
        self.next = next

    def SetPrev(self, prev):
        self.prev = prev

    def GetNext(self):
        global command_log, tc
        self.j = self.j + 1
        for i in range(0,36):
            if FinalArgs[i] != '' and self.j == 2:
                self.command = self.command + FinalArgs[i] + ' '
        if self.j == 2:
            command_log = os.popen('sudo %s' % self.command).read()
	    tc.WriteText('%s' % command_log)
        return self.next

    def GetPrev(self):
        return self.prev

#----------------------------------------------------------------------
class WakeOnLanPage(wiz.PyWizardPage):
    def __init__(self, parent, title):
        wiz.PyWizardPage.__init__(self, parent)
        self.next = self.prev = None
        self.sizer = makePageTitle(self, title)

        wx.StaticText(self, -1, _('msg_Wake_on_LAN'), (50,100))
	self.command = 0
	self.j = 0
        FinalArgs[0] = '/opt/drbl/sbin/dcs'
        FinalArgs[3] = 'Wake-on-LAN'

    def SetNext(self, next):
        self.next = next

    def SetPrev(self, prev):
        self.prev = prev

    def GetNext(self):
        global command_log, tc
        self.j = self.j + 1
        for i in range(0,36):
            if FinalArgs[i] != '' and self.j == 2:
                self.command = self.command + FinalArgs[i] + ' '
        if self.j == 2:
            command_log = os.popen('sudo %s' % self.command).read()
	    tc.WriteText('%s' % command_log)
        return self.next

    def GetPrev(self):
        return self.prev

#----------------------------------------------------------------------
class SwitchPXEMenuPage1(wiz.PyWizardPage):
    def __init__(self, parent, title):
        wiz.PyWizardPage.__init__(self, parent)
        self.next = self.prev = None
        self.sizer = makePageTitle(self, title)

	ModeList = [_('msg_hide_pxe_menus'), _('msg_reveal_pxe_menus'), _('msg_setdefault_pxe_menu')]
        rb = wx.RadioBox(self, -1, _('msg_choose_the_action'), (35, 50), (260,90), ModeList, 1, wx.RA_SPECIFY_COLS)

        self.Bind(wx.EVT_RADIOBOX, self.EvtRadioBox, rb)
        FinalArgs[0] = '/opt/drbl/bin/hide_reveal_pxe_img'
        FinalArgs[3] = 'hide'

    def EvtRadioBox(self, event):
        if event.GetInt() == 0:
	    FinalArgs[0] = '/opt/drbl/bin/hide_reveal_pxe_img'
	    FinalArgs[3] = 'hide'
        if event.GetInt() == 1:
            FinalArgs[0] = '/opt/drbl/bin/hide_reveal_pxe_img'
            FinalArgs[3] = 'reveal'
        elif event.GetInt() == 2:
	    FinalArgs[0] = '/opt/drbl/bin/set-default-pxe-img'
	    FinalArgs[3] = '-i'

    def SetNext(self, next):
        self.next = next

    def SetPrev(self, prev):
        self.prev = prev

    def GetNext(self):
	next = self.next
        if FinalArgs[3] == '-i':
	    next = next.GetNext()
        return next

    def GetPrev(self):
        return self.prev

#----------------------------------------------------------------------
class SwitchPXEMenuPage2(wiz.PyWizardPage):
    def __init__(self, parent, title):
        wiz.PyWizardPage.__init__(self, parent)
        self.next = self.prev = None
        self.sizer = makePageTitle(self, title)
	self.j = 0

        b = wx.Button(self, -1, "Choose The Labels You Want To Reveal (MultiChoices)", (50,50))
        self.Bind(wx.EVT_BUTTON, self.OnButton, b)

    def OnButton(self, evt):
	global Labels
	Labels = []
	index = 0

        file = open('/tftpboot/nbi_img/pxelinux.cfg/default')
        content = file.read()
        for word in content.split():
	    if word == 'label':
		Labels.append(content.split()[index + 1])
	    index = index + 1
	file.close()

        dlg = wx.MultiChoiceDialog(self, _('msg_hide_reveal'), 'Lables:', Labels)

        if (dlg.ShowModal() == wx.ID_OK):
            selections = dlg.GetSelections()
            self.selected_labels = [Labels[x] for x in selections]
	    #print self.selected_labels[:]
        dlg.Destroy()

    def SetNext(self, next):
        self.next = next

    def SetPrev(self, prev):
        self.prev = prev

    def GetNext(self):
	global command_log, tc
	global PXE_CFG_Files
	next = self.next
	self.j = self.j + 1
	if self.j == 2:
	    if FinalArgs[3] == 'hide' or 'reveal':
	        if FinalArgs[1] == '-nl':
		    for k in range(0,len(self.selected_labels[:])):
		        os.system('sudo %s %s %s /tftpboot/nbi_img/pxelinux.cfg/default' % (FinalArgs[0], self.selected_labels[k], FinalArgs[3]))
		        command_log = command_log + 'command : %s %s %s /tftpboot/nbi_img/pxelinux.cfg/default\n' % (FinalArgs[0], self.selected_labels[k], FinalArgs[3])
		    os.system('sudo rm -f /tftpboot/nbi_img/pxelinux.cfg/1* 2* 3* 4* 5* 6* 7* 8* 9* 0* A* B* C* D* E* F*')
		    command_log = command_log + 'command : rm -f /tftpboot/nbi_img/pxelinux.cfg/1* 2* 3* 4* 5* 6* 7* 8* 9* 0* A* B* C* D* E* F*\n'
		    tc.WriteText('%s' % command_log)
	        else:
		    print 'pass FinalArgs[1] == -h and FinalArgs[3] == hide or reveal'
		    for i in range(0, len(PXE_CFG_Files[:])):
		        os.system('cp /tftpboot/nbi_img/pxelinux.cfg/default /tftpboot/nbi_img/pxelinux.cfg/%s' % PXE_CFG_Files[i])
		        command_log = command_log + 'copy /tftpboot/nbi_img/pxelinux.cfg/default to %s\n' % PXE_CFG_Files[i]
		        for k in range(0, len(self.selected_labels[:])):
			    os.system('%s %s %s /tftpboot/nbi_img/pxelinux.cfg/%s' % (FinalArgs[0], self.selected_labels[k], FinalArgs[3], PXE_CFG_Files[i]))
			    command_log = command_log + 'command : %s %s %s /tftpboot/nbi_img/pxelinux.cfg/%s\n' % (FinalArgs[0], self.selected_labels, FinalArgs[3], PXE_CFG_Files[i])
		    tc.WriteText('%s' % command_log)
	    next = next.GetNext()
        return next

    def GetPrev(self):
        return self.prev

#----------------------------------------------------------------------
class SwitchPXEMenuPage3(wiz.PyWizardPage):
    def __init__(self, parent, title):
        wiz.PyWizardPage.__init__(self, parent)
        self.next = self.prev = None
        self.sizer = makePageTitle(self, title)
	self.j = 0

        b = wx.Button(self, -1, "Choose The Labels You Want To Set as Default (Single Choice)", (50,50))
        self.Bind(wx.EVT_BUTTON, self.OnButton, b)

    def OnButton(self, evt):
        global Labels
	Labels = []
	index = 0

        file = open('/tftpboot/nbi_img/pxelinux.cfg/default')
        content = file.read()
        for word in content.split():
            if word == 'label':
                Labels.append(content.split()[index + 1])
            index = index + 1
        file.close()

        dlg = wx.SingleChoiceDialog(self, _('msg_setdefault_title'), "Lables:", Labels, wx.CHOICEDLG_STYLE)

        if dlg.ShowModal() == wx.ID_OK:
	    self.selected_label = dlg.GetStringSelection()
        dlg.Destroy()

    def SetNext(self, next):
        self.next = next

    def SetPrev(self, prev):
        self.prev = prev

    def GetNext(self):
	global command_log, tc
	self.j = self.j + 1
	if self.j == 2:
	    if FinalArgs[1] == '-nl' and FinalArgs[3] == '-i':
                    os.system('sudo %s %s %s /tftpboot/nbi_img/pxelinux.cfg/default' % (FinalArgs[0], self.selected_label, FinalArgs[3]))
		    command_log = command_log + 'command : %s %s %s /tftpboot/nbi_img/pxelinux.cfg/default' % (FinalArgs[0], self.selected_label, FinalArgs[3])
                    os.system('sudo rm -f /tftpboot/nbi_img/pxelinux.cfg/1* 2* 3* 4* 5* 6* 7* 8* 9* 0* A* B* C* D* E* F*')
		    command_log = command_log + 'command : rm -f /tftpboot/nbi_img/pxelinux.cfg/1* 2* 3* 4* 5* 6* 7* 8* 9* 0* A* B* C* D* E* F*'
		    tc.WriteText('%s' % command_log)
            elif FinalArgs[1] == '-h' and FinalArgs[3] == '-i':
                for i in range(0, len(PXE_CFG_Files[:])):
                    os.system('cp /tftpboot/nbi_img/pxelinux.cfg/default /tftpboot/nbi_img/pxelinux.cfg/%s' % PXE_CFG_Files[i])
                    command_log = command_log + 'copy /tftpboot/nbi_img/pxelinux.cfg/default to %s\n' % PXE_CFG_Files[i]
                    os.system('%s %s %s /tftpboot/nbi_img/pxelinux.cfg/%s' % (FinalArgs[0], self.selected_label, FinalArgs[3], PXE_CFG_Files[i]))
                    command_log = command_log + 'command : %s %s %s /tftpboot/nbi_img/pxelinux.cfg/%s\n' % (FinalArgs[0], self.selected_label, FinalArgs[3], PXE_CFG_Files[i])
		    tc.WriteText('%s' % command_log)
        return self.next

    def GetPrev(self):
        return self.prev

#----------------------------------------------------------------------
class SwitchPXEMenuPage4(wiz.PyWizardPage):
    def __init__(self, parent, title):
        wiz.PyWizardPage.__init__(self, parent)
        self.next = self.prev = None
        self.sizer = makePageTitle(self, title)
	global tc
        tc = wx.TextCtrl(self, -1,'', pos=(35,50), size=(350, 250), style=wx.TE_MULTILINE|wx.TE_READONLY)

        #self.b1 = wx.Button(self, -1, 'detail', pos=(400,250))
        self.b2 = wx.Button(self, -1, 'command..', pos=(400,200))
        #self.Bind(wx.EVT_BUTTON, self.OnButtonDetail, self.b1)
        self.Bind(wx.EVT_BUTTON, self.OnButtonCommand, self.b2)

    #def OnButtonDetail(self, evt):
        #self.tc.WriteText('%s' % command_log)
        #self.b1.Enable(False)

    def OnButtonCommand(self, evt):
	global tc
        final_command = ''
        for i in range(0,36):
            if FinalArgs[i] != '':
                final_command = final_command + FinalArgs[i] + ' '
        tc.WriteText('%s' % final_command)
        self.b2.Enable(False)

    def SetNext(self, next):
        self.next = next

    def SetPrev(self, prev):
        self.prev = prev

#----------------------------------------------------------------------
class DRBLModePage(wiz.PyWizardPage):
    def __init__(self, parent, title):
        wiz.PyWizardPage.__init__(self, parent)
        self.next = self.prev = None
        self.sizer = makePageTitle(self, title)

        ModeList = [_('msg_drbl_mode_0'), _('msg_drbl_mode_1'), _('msg_drbl_mode_2')]
	wx.StaticText(self,-1,_('msg_drbl_mode_switch_long'),wx.DLG_PNT(self, 5, 20),wx.DLG_SZE(self, 320, 300),wx.TE_MULTILINE)
	rb = wx.RadioBox(self, -1, '', (5,220), wx.DefaultSize, ModeList, 1, wx.RA_SPECIFY_COLS)	
	self.j = 0
	self.command = ''

        self.Bind(wx.EVT_RADIOBOX, self.EvtRadioBox, rb)
        FinalArgs[0] = '/opt/drbl/sbin/tune-clientdir-opt'
	FinalArgs[1] = '-d'
	FinalArgs[2] = '0'

    def EvtRadioBox(self, event):
        if event.GetInt() == 0:
	    FinalArgs[2] = '0'
	elif event.GetInt() == 1:
	    FinalArgs[2] = '1'
	elif event.GetInt() == 2:
	    FinalArgs[2] = '2'

    def SetNext(self, next):
        self.next = next

    def SetPrev(self, prev):
        self.prev = prev

    def GetNext(self):
        global command_log, tc
        self.j = self.j + 1
        for i in range(0,36):
            if FinalArgs[i] != '' and self.j == 2:
                self.command = self.command + FinalArgs[i] + ' '
        if self.j == 2:
            command_log = os.popen('sudo %s' % self.command).read()
            tc.WriteText('%s' % command_log)
        return self.next

    def GetPrev(self):
        return self.prev

#----------------------------------------------------------------------
class ClonezillaModePage(wiz.PyWizardPage):
    def __init__(self, parent, title):
        wiz.PyWizardPage.__init__(self, parent)
        self.next = self.prev = None
        self.sizer = makePageTitle(self, title)

        ModeList = [_('msg_clonezilla_mode_0'), _('msg_clonezilla_mode_1'), _('msg_clonezilla_mode_2')]
	wx.StaticText(self,-1,_('msg_clonezilla_mode_switch_long'),wx.DLG_PNT(self, 5, 20),wx.DLG_SZE(self, 210, 200),wx.TE_MULTILINE)
	rb = wx.RadioBox(self, -1, '', (5,205), wx.DefaultSize, ModeList, 1, wx.RA_SPECIFY_COLS)
	self.command = ''
	self.j = 0

        self.Bind(wx.EVT_RADIOBOX, self.EvtRadioBox, rb)
        FinalArgs[0] = '/opt/drbl/sbin/tune-clientdir-opt'
        FinalArgs[1] = '-z'
        FinalArgs[2] = '0'

    def EvtRadioBox(self, event):
        if event.GetInt() == 0:
            FinalArgs[2] = '0'
        elif event.GetInt() == 1:
            FinalArgs[2] = '1'
        elif event.GetInt() == 2:
            FinalArgs[2] = '2'

    def SetNext(self, next):
        self.next = next

    def SetPrev(self, prev):
        self.prev = prev

    def GetNext(self):
        global command_log, tc
        self.j = self.j + 1
        for i in range(0,36):
            if FinalArgs[i] != '' and self.j == 2:
                self.command = self.command + FinalArgs[i] + ' '
        if self.j == 2:
            command_log = os.popen('sudo %s' % self.command).read()
            tc.WriteText('%s' % command_log)
        return self.next

    def GetPrev(self):
        return self.prev

#----------------------------------------------------------------------
class GenTemplateFilePage(wiz.PyWizardPage):
    def __init__(self, parent, title):
        wiz.PyWizardPage.__init__(self, parent)
        self.next = self.prev = None
        self.sizer = makePageTitle(self, title)
	self.command = ''
	self.j = 0

        wx.StaticText(self, -1, _('msg_gen_template_files'),(50,100))
        FinalArgs[0] = '/opt/drbl/sbin/gen_ssi_files'

    def SetNext(self, next):
        self.next = next

    def SetPrev(self, prev):
        self.prev = prev

    def GetNext(self):
        global command_log, tc
        self.j = self.j + 1
        for i in range(0,36):
            if FinalArgs[i] != '' and self.j == 2:
                self.command = self.command + FinalArgs[i] + ' '
        if self.j == 2:
            command_log = os.popen('sudo %s' % self.command).read()
            tc.WriteText('%s' % command_log)
        return self.next

    def GetPrev(self):
        return self.prev

#----------------------------------------------------------------------
class LoginSwitchPage(wiz.PyWizardPage):
    def __init__(self, parent, title):
        wiz.PyWizardPage.__init__(self, parent)
        self.next = self.prev = None
        self.sizer = makePageTitle(self, title)
	self.j = 0

	ModeList = [_('msg_normal_login'), _('msg_auto_login'), _('msg_timed_login')]
        wx.StaticText(self, -1, _('msg_login_switch'),(50,35))
	rb = wx.RadioBox(self, -1, _('msg_choose_action'), (35, 50), (280,200), ModeList, 1, wx.RA_SPECIFY_COLS)
	self.Bind(wx.EVT_RADIOBOX, self.EvtRadioBox, rb)
        FinalArgs[0] = '/opt/drbl/sbin/drbl-login-switch'
	FinalArgs[3] = '-n'

    def EvtRadioBox(self, event):
        if event.GetInt() == 0:
	    FinalArgs[0] = '/opt/drbl/sbin/drbl-login-switch'
	    FinalArgs[3] = '-n'
            FinalArgs[4] = ''
	    FinalArgs[5] = ''
        elif event.GetInt() == 1:
	    FinalArgs[0] = '/opt/drbl/sbin/drbl-client-switch'
	    FinalArgs[3] = 'remote-linux-gra'
	    FinalArgs[4] = '/opt/drbl/sbin/drbl-login-switch'
            FinalArgs[5] = '-a'
        elif event.GetInt() == 2:
            FinalArgs[0] = '/opt/drbl/sbin/drbl-client-switch'
	    FinalArgs[3] = 'remote-linux-gra'
            FinalArgs[4] = '/opt/drbl/sbin/drbl-login-switch'
            FinalArgs[5] = '-t'

    def SetNext(self, next):
        self.next = next

    def SetPrev(self, prev):
        self.prev = prev

    def GetNext(self):
	next = self.next
        global command_log, tc
        self.j = self.j + 1
	if self.j == 2:
	    if FinalArgs[3] == '-n':
		FinalArgs[1] = FinalArgs[2] = ''
		command_log = os.popen('sudo %s %s' % (FinalArgs[0], FinalArgs[3])).read()
		tc.WriteText('%s' % command_log)
	    else:
            	command_log = os.popen('sudo %s %s %s %s' % (FinalArgs[0], FinalArgs[1],FinalArgs[2],FinalArgs[3])).read()
		tc.WriteText('%s' % command_log)
                command_log = os.popen('sudo %s %s' % (FinalArgs[4], FinalArgs[5])).read()
            	tc.WriteText('%s' % command_log)
        return next

    def GetPrev(self):
        prev = self.prev
        prev = prev.GetPrev()
        return prev

#----------------------------------------------------------------------
class ClientReAutoLoginPage(wiz.PyWizardPage):
    def __init__(self, parent, title):
        wiz.PyWizardPage.__init__(self, parent)
        self.next = self.prev = None
        self.sizer = makePageTitle(self, title)
	self.j = 0
	self.command = ''

        wx.StaticText(self, -1, _('msg_client_reautologin'),(50,100))
        FinalArgs[0] = '/opt/drbl/sbin/drbl-client-reautologin'

    def SetNext(self, next):
        self.next = next

    def SetPrev(self, prev):
        self.prev = prev

    def GetNext(self):
        global command_log, tc
        self.j = self.j + 1
        if self.j == 2:
            for i in range(0,3):
                if FinalArgs[i] != '' and self.j == 2:
                    self.command = self.command + FinalArgs[i] + ' '
            command_log = os.popen('sudo %s' % self.command).read()
            tc.WriteText('%s' % command_log)
        return self.next

    def GetPrev(self):
        prev = self.prev
        prev = prev.GetPrev()
        return prev

#----------------------------------------------------------------------
class CleanAutoLoginAccountPage(wiz.PyWizardPage):
    def __init__(self, parent, title):
        wiz.PyWizardPage.__init__(self, parent)
        self.next = self.prev = None
        self.sizer = makePageTitle(self, title)

	wx.StaticText(self, -1, _('msg_clean_autologin_account'),(50,100))
	FinalArgs[0] = '/opt/drbl/sbin/drbl-clean-autologin-account'

    def SetNext(self, next):
        self.next = next

    def SetPrev(self, prev):
        self.prev = prev

    def GetNext(self):
        return self.next

    def GetPrev(self):
        prev = self.prev
        prev = prev.GetPrev()
        return prev


#----------------------------------------------------------------------
class ResetAutoLoginAccountPage(wiz.PyWizardPage):
    def __init__(self, parent, title):
        wiz.PyWizardPage.__init__(self, parent)
        self.next = self.prev = None
        self.sizer = makePageTitle(self, title)

        wx.StaticText(self, -1, _('msg_reset_autologin_account'))
        FinalArgs[0] = '/opt/drbl/sbin/drbl-user-env-reset'
	FinalArgs[1] = '--auto-login'

    def SetNext(self, next):
        self.next = next

    def SetPrev(self, prev):
        self.prev = prev

    def GetNext(self):
        return self.next


#----------------------------------------------------------------------
class SwitchDRBLServPage(wiz.PyWizardPage):
    def __init__(self, parent, title):
        wiz.PyWizardPage.__init__(self, parent)
        self.next = self.prev = None
        self.sizer = makePageTitle(self, title)

        ModeList = [_('msg_start_drbl_all_services'), _('msg_stop_drbl_all_services'), _('msg_restart_drbl_all_services'), _('msg_add_drbl_all_services'), _('msg_del_drbl_all_services')]
        wx.StaticText(self, -1, _('msg_switch_drbl_service'),(50,35))
        rb = wx.RadioBox(self, -1, _('msg_choose_action'), (35, 50), (250,200), ModeList, 1, wx.RA_SPECIFY_COLS)
        self.Bind(wx.EVT_RADIOBOX, self.EvtRadioBox, rb)
        FinalArgs[0] = '/opt/drbl/sbin/drbl-all-service'
        FinalArgs[1] = 'start'

    def EvtRadioBox(self, event):
        if event.GetInt() == 0:
            FinalArgs[1] = 'start'
        elif event.GetInt() == 1:
            FinalArgs[1] = 'stop'
        elif event.GetInt() == 2:
            FinalArgs[1] = 'restart'
        elif event.GetInt() == 3:
            FinalArgs[1] = 'add'
        elif event.GetInt() == 4:
            FinalArgs[1] = 'del'

    def SetNext(self, next):
        self.next = next

    def SetPrev(self, prev):
        self.prev = prev

    def GetNext(self):
        return self.next

#----------------------------------------------------------------------
class ReDeployPage(wiz.PyWizardPage):
    def __init__(self, parent, title):
        wiz.PyWizardPage.__init__(self, parent)
        self.next = self.prev = None
        self.sizer = makePageTitle(self, title)

        wx.StaticText(self, -1, _('msg_re_deploy'),(50,100))
        FinalArgs[0] = '/opt/drbl/sbin/drblpush -c /etc/drbl/drblpush.conf'	

    def SetNext(self, next):
        self.next = next

    def SetPrev(self, prev):
        self.prev = prev

    def GetNext(self):
        return self.next

    def GetPrev(self):
	return self.prev

#----------------------------------------------------------------------
class FinalPage(wiz.PyWizardPage):
    def __init__(self, parent, title):
        wiz.PyWizardPage.__init__(self, parent)
        self.next = self.prev = None
        self.sizer = makePageTitle(self, title)
	global FinalCommand, CommandLog

	FinalCommand = wx.StaticText(self, -1, '', pos=(10,60), size=(400,100))
        CommandLog = wx.TextCtrl(self, -1, '', pos=(10,100), size=(470,200), style=wx.TE_MULTILINE|wx.TE_READONLY)
	
    def SetNext(self, next):
        self.next = next

    def GetNext(self):
        return self.next


#----------------------------------------------------------------------
class MainFrame(wx.Frame):
    def __init__(self, parent, id):
        wx.Frame.__init__(self, parent, id, _('msg_nchc_title'), (250,100), (700,400), style=wx.CAPTION)
	#wx.NO_FULL_REPAINT_ON_RESIZE
        self.scroll = wx.ScrolledWindow(self, -1)
	self.scroll.SetScrollbars(1, 1, 550, 400)

        FunctionList = [_('msg_remote_linux_graphic'), _('msg_remote_linux_text'), _('msg_thin_client')
		        , _('msg_remote_memtest'), _('msg_remote_fdos'), _('msg_clonezilla_start_save')
			, _('msg_clonezilla_start_restore'), _('msg_clonezilla_selec_in_client'), _('msg_clonezilla_stop')
			, _('msg_local'), _('msg_reboot'), _('msg_shutdown'), _('msg_Wake_on_LAN')
			, _('msg_switch_pxe_menu'), _('msg_switch_pxe_bg_mode'), _('msg_drbl_mode_switch')
			, _('msg_clonezilla_mode_switch'), _('msg_gen_template_files'), _('msg_login_switch')
			, _('msg_client_reautologin'), _('msg_clean_autologin_account'), _('msg_reset_autologin_account')
			, _('msg_switch_drbl_service'), _('msg_re_deploy'), _('msg_clean_dhcpd_lease')
			, _('msg_regenerate_nfs_nis_nat_config')]
        rb = wx.RadioBox(self.scroll, -1, '', (35,20), (0,0), FunctionList, 2, wx.RA_SPECIFY_COLS|wx.NO_BORDER)
        self.scroll.Bind(wx.EVT_RADIOBOX, self.EvtRadioBox, rb)
        rb.SetSelection(0)
	self.b1 = wx.Button(self.scroll, wx.ID_OK, pos=(600, 360))      # not translated
	self.b2 = wx.Button(self.scroll, wx.ID_EXIT, pos=(500, 360))
	self.scroll.Bind(wx.EVT_BUTTON, self.RemoteLinuxGraWizard, self.b1)
	self.scroll.Bind(wx.EVT_BUTTON, self.OnCloseMe, self.b2)
	self.scroll.Bind(wx.EVT_CLOSE, self.OnCloseWindow)

    def EvtRadioBox(self, event):
        if event.GetSelection() == 0:
	    self.scroll.Bind(wx.EVT_BUTTON, self.RemoteLinuxGraWizard, self.b1)
            FinalArgs[0] = '/opt/drbl/sbin/dcs'
            FinalArgs[3] = 'remote-linux-gra'
        if event.GetSelection() == 1:
            self.scroll.Bind(wx.EVT_BUTTON, self.RemoteLinuxTxtWizard, self.b1)
        if event.GetSelection() == 2:
	    self.scroll.Bind(wx.EVT_BUTTON, self.TerminalWizard, self.b1)
        if event.GetSelection() == 3:
            self.scroll.Bind(wx.EVT_BUTTON, self.RemoteMemTestWizard, self.b1)
        if event.GetSelection() == 4:
            self.scroll.Bind(wx.EVT_BUTTON, self.RemotefdosWizard, self.b1)
        if event.GetSelection() == 5:
            self.scroll.Bind(wx.EVT_BUTTON, self.ClonezillaStartSaveWizard, self.b1)
        if event.GetSelection() == 6:
            self.scroll.Bind(wx.EVT_BUTTON, self.ClonezillaStartRestoreWizard, self.b1)
        if event.GetSelection() == 7:
            self.scroll.Bind(wx.EVT_BUTTON, self.ClonezillaSelectWizard, self.b1)
        if event.GetSelection() == 8:
            self.scroll.Bind(wx.EVT_BUTTON, self.ClonezillaStopWizard, self.b1)
        if event.GetSelection() == 9:
            self.scroll.Bind(wx.EVT_BUTTON, self.LocalWizard, self.b1)
        if event.GetSelection() == 10:
            self.scroll.Bind(wx.EVT_BUTTON, self.RebootWizard, self.b1)
        if event.GetSelection() == 11:
            self.scroll.Bind(wx.EVT_BUTTON, self.ShutdownWizard, self.b1)
        if event.GetSelection() == 12:
            self.scroll.Bind(wx.EVT_BUTTON, self.WakeOnLANWizard, self.b1)
        if event.GetSelection() == 13:
            self.scroll.Bind(wx.EVT_BUTTON, self.SwitchPXEMenuWizard, self.b1)
        if event.GetSelection() == 14:
            self.scroll.Bind(wx.EVT_BUTTON, self.SwitchPXEModeWizard, self.b1)
        if event.GetSelection() == 15:
            self.scroll.Bind(wx.EVT_BUTTON, self.DRBLModeWizard, self.b1)
        if event.GetSelection() == 16:
            self.scroll.Bind(wx.EVT_BUTTON, self.ClonezillaModeWizard, self.b1)
        if event.GetSelection() == 17:
            self.scroll.Bind(wx.EVT_BUTTON, self.GenTemplateFileWizard, self.b1)
        if event.GetSelection() == 18:
            self.scroll.Bind(wx.EVT_BUTTON, self.LoginSwitchWizard, self.b1)
        if event.GetSelection() == 19:
            self.scroll.Bind(wx.EVT_BUTTON, self.ClientReAutoLoginWizard, self.b1)
        if event.GetSelection() == 20:
            self.scroll.Bind(wx.EVT_BUTTON, self.CleanAutoLoginAccountWizard, self.b1)
        if event.GetSelection() == 21:
            self.scroll.Bind(wx.EVT_BUTTON, self.ResetAutoLoginAccountWizard, self.b1)
        if event.GetSelection() == 22:
            self.scroll.Bind(wx.EVT_BUTTON, self.SwitchDRBLServWizard, self.b1)
        if event.GetSelection() == 23:
            self.scroll.Bind(wx.EVT_BUTTON, self.ReDeployWizard, self.b1)
        if event.GetSelection() == 24:
            self.scroll.Bind(wx.EVT_BUTTON, self.CleanDHCPLeaseWizard, self.b1)
        if event.GetSelection() == 25:
            self.scroll.Bind(wx.EVT_BUTTON, self.Regenerate3NWizard, self.b1)

#----------------------------------------------------------------------
    def OnCloseWindow(self, event):
	self.Destroy()
#----------------------------------------------------------------------
    def OnCloseMe(self, event):
	self.Close(True)

#------------------------------Wizard Modules--------------------------
    def RemoteLinuxGraWizard(self,evt):
        wizard = wiz.Wizard(self, -1, _('msg_remote_linux_graphic'), pos = (350,200))

	page1 = SetAllClientsPage(wizard, _('msg_title_set_all_clients'))
	page2 = SelectClientsPage(wizard, _('msg_select_clients'))
	page3 = FinalPage(wizard, _('msg_done'))
	FinalArgs[0] = '/opt/drbl/sbin/dcs'
	FinalArgs[3] = 'remote-linux-gra'

	self.page1 = page1
	wizard.SetPageSize((500,300))

	page1.SetNext(page2)
	page2.SetPrev(page1)
	page2.SetNext(page3)

        if wizard.RunWizard(page1):
	    for i in range(0,36):
		FinalArgs[i] = ''
        else:
            for i in range(0,36):
                FinalArgs[i] = ''
	    
#------------------------------Wizard Modules--------------------------
    def RemoteLinuxTxtWizard(self,evt):
        wizard = wiz.Wizard(self, -1, _('msg_remote_linux_text'), pos = (350,200))

        page1 = SetAllClientsPage(wizard, _('msg_title_set_all_clients'))
        page2 = SelectClientsPage(wizard, _('msg_select_clients'))
        page3 = FinalPage(wizard, _('msg_done'))
        FinalArgs[0] = '/opt/drbl/sbin/dcs'
        FinalArgs[3] = 'remote-linux-txt'

        self.page1 = page1
        wizard.SetPageSize((500,300))

        page1.SetNext(page2)
        page2.SetPrev(page1)
        page2.SetNext(page3)

        if wizard.RunWizard(page1):
            for i in range(0,36):
                FinalArgs[i] = ''
        else:
            for i in range(0,36):
                FinalArgs[i] = ''

#------------------------------Wizard Modules--------------------------
    def TerminalWizard(self,evt):
        wizard = wiz.Wizard(self, -1, _('msg_thin_client'), pos = (350,200))

        page1 = SetAllClientsPage(wizard, _('msg_title_set_all_clients'))
        page2 = SelectClientsPage(wizard, _('msg_select_clients'))
        page3 = FinalPage(wizard, _('msg_done'))
        FinalArgs[0] = '/opt/drbl/sbin/dcs'
        FinalArgs[3] = 'terminal'

        self.page1 = page1
        wizard.SetPageSize((500,300))

        page1.SetNext(page2)
        page2.SetPrev(page1)
        page2.SetNext(page3)

        if wizard.RunWizard(page1):
            for i in range(0,36):
                FinalArgs[i] = ''
        else:
            for i in range(0,36):
                FinalArgs[i] = ''

#------------------------------Wizard Modules--------------------------
    def RemoteMemTestWizard(self,evt):
        wizard = wiz.Wizard(self, -1, _('msg_remote_memtest'), pos = (500,200))

        page1 = SetAllClientsPage(wizard, _('msg_title_set_all_clients'))
        page2 = SelectClientsPage(wizard, _('msg_select_clients'))
        page3 = FinalPage(wizard, _('msg_done'))
        FinalArgs[0] = '/opt/drbl/sbin/dcs'
        FinalArgs[3] = 'remote-memtest'

        self.page1 = page1
        wizard.SetPageSize((500,300))

        page1.SetNext(page2)
        page2.SetPrev(page1)
        page2.SetNext(page3)

        if wizard.RunWizard(page1):
            for i in range(0,36):
                FinalArgs[i] = ''
        else:
            for i in range(0,36):
                FinalArgs[i] = ''

#------------------------------Wizard Modules--------------------------
    def RemotefdosWizard(self,evt):
        wizard = wiz.Wizard(self, -1, _('msg_remote_fdos'), pos = (500,200))

        page1 = SetAllClientsPage(wizard, _('msg_title_set_all_clients'))
        page2 = SelectClientsPage(wizard, _('msg_select_clients'))
        page3 = FinalPage(wizard,_('msg_done'))
        FinalArgs[0] = '/opt/drbl/sbin/dcs'
        FinalArgs[3] = 'remote-fdos'

        self.page1 = page1
        wizard.SetPageSize((500,300))

        page1.SetNext(page2)
        page2.SetPrev(page1)
        page2.SetNext(page3)

        if wizard.RunWizard(page1):
            for i in range(0,36):
                FinalArgs[i] = ''
        else:
            for i in range(0,36):
                FinalArgs[i] = ''

#------------------------------Wizard Modules--------------------------
    def ClonezillaStartSaveWizard(self,evt):
        wizard = wiz.Wizard(self, -1, 'ClonezillaStartSaveWizard', pos = (500,200))

        page1 = SetAllClientsPage(wizard, '')
        page2 = SelectClientsPage(wizard, '')
	page3 = ClonezillaStartSavePage1(wizard, '')
	page4 = ClonezillaStartSavePage2(wizard, '')
	page5 = ClonezillaStartSavePage3(wizard, '')
	page6 = ClonezillaStartSavePage4(wizard, '')
	page7 = ClonezillaStartSavePage5(wizard, '')
	page8 = ClonezillaStartSavePage6(wizard, '')
        page9 = FinalPage(wizard,'')

        self.page1 = page1
        wizard.SetPageSize((500,300))

        page1.SetNext(page2)
        page2.SetPrev(page1)
        page2.SetNext(page3)
        page3.SetPrev(page2)
        page3.SetNext(page4)
	page4.SetPrev(page3)
	page4.SetNext(page5)
	page5.SetPrev(page4)
	page5.SetNext(page6)
	page6.SetPrev(page5)
	page6.SetNext(page7)
	page7.SetPrev(page6)
	page7.SetNext(page8)
	page8.SetPrev(page7)
	page8.SetNext(page9)

        if wizard.RunWizard(page1):
            for i in range(0,36):
                FinalArgs[i] = ''
        else:
            for i in range(0,36):
                FinalArgs[i] = ''

#------------------------------Wizard Modules--------------------------
    def ClonezillaStartRestoreWizard(self,evt):
        wizard = wiz.Wizard(self, -1, 'ClonezillaStartRestoreWizard', pos = (500,200))

        page1 = SetAllClientsPage(wizard, '')
        page2 = SelectClientsPage(wizard, '')
        page3 = ClonezillaStartRestorePage1(wizard, 'ClonezillaStartRestorePage1')
        page4 = ClonezillaStartRestorePage2(wizard, 'ClonezillaStartRestorePage2')
        page5 = ClonezillaStartRestorePage3(wizard, 'ClonezillaStartRestorePage3')
        page6 = ClonezillaStartRestorePage4(wizard, 'ClonezillaStartRestorePage4')
        page7 = ClonezillaStartRestorePage5(wizard, 'ClonezillaStartRestorePage5')
	page8 = ClonezillaStartRestorePage6(wizard, 'ClonezillaStartRestorePage6')
        page9 = ClonezillaStartRestorePage7(wizard, 'ClonezillaStartRestorePage7')
	page10 = ClonezillaStartRestorePage8a(wizard, 'ClonezillaStartRestorePage8a')
	page11 = ClonezillaStartRestorePage8b(wizard, 'ClonezillaStartRestorePage8b')
	page12 = ClonezillaStartRestorePage9a(wizard, 'ClonezillaStartRestorePage9a')
	page13 = ClonezillaStartRestorePage9b(wizard, 'ClonezillaStartRestorePage9b')
	page14 = ClonezillaStartRestorePage10(wizard, 'ClonezillaStartRestorePage10')
	page15 = ClonezillaStartRestorePage11(wizard, 'ClonezillaStartRestorePage11')
	page16 = ClonezillaStartRestorePage12(wizard, 'ClonezillaStartRestorePage12')
        page17 = FinalPage(wizard,'FinalPage')

        self.page1 = page1
        wizard.SetPageSize((500,300))

        page1.SetNext(page2)
        page2.SetPrev(page1)
        page2.SetNext(page3)
        page3.SetPrev(page2)
        page3.SetNext(page4)
        page4.SetPrev(page3)
        page4.SetNext(page5)
        page5.SetPrev(page4)
        page5.SetNext(page6)
        page6.SetPrev(page5)
        page6.SetNext(page7)
        page7.SetPrev(page6)
        page7.SetNext(page8)
	page8.SetPrev(page7)
	page8.SetNext(page9)
	page9.SetPrev(page8)
	page9.SetNext(page10)
	page10.SetPrev(page9)
	page10.SetNext(page11)
	page11.SetPrev(page10)
	page11.SetNext(page12)
	page12.SetPrev(page11)
	page12.SetNext(page13)
	page13.SetPrev(page12)
	page13.SetNext(page14)
	page14.SetPrev(page13)
	page14.SetNext(page15)
	page15.SetPrev(page14)
	page15.SetNext(page16)
	page16.SetPrev(page15)
	page16.SetNext(page17)

        if wizard.RunWizard(page1):
            #wx.MessageBox(_('success'), "That's all folks!", wx.CENTRE | wx.NO_DEFAULT, self)
            for i in range(0,36):
                FinalArgs[i] = ''
        else:
            #wx.MessageBox(_('cancel'), "That's all folks!", wx.CENTRE | wx.NO_DEFAULT, self)
            for i in range(0,36):
                FinalArgs[i] = ''

#------------------------------Wizard Modules--------------------------
    def ClonezillaSelectWizard(self,evt):
        wizard = wiz.Wizard(self, -1, _('msg_clonezilla_selec_in_client'), pos = (500,200))

        page1 = SetAllClientsPage(wizard, _('msg_title_set_all_clients'))
        page2 = SelectClientsPage(wizard, _('msg_select_clients'))
        page3 = ClonezillaSelectPage1(wizard, '')
	page4 = ClonezillaSelectPage2(wizard, '')
        page5 = FinalPage(wizard, '')

        self.page1 = page1
        wizard.SetPageSize((500,300))

        page1.SetNext(page2)
        page2.SetPrev(page1)
        page2.SetNext(page3)
        page3.SetPrev(page2)
        page3.SetNext(page4)
	page4.SetPrev(page3)
	page4.SetNext(page5)

        if wizard.RunWizard(page1):
            wx.MessageBox(_('success'), "That's all folks!", wx.CENTRE | wx.NO_DEFAULT, self)
            for i in range(0,36):
                FinalArgs[i] = ''
        else:
            wx.MessageBox(_('cancel'), "That's all folks!", wx.CENTRE | wx.NO_DEFAULT, self)
            for i in range(0,36):
                FinalArgs[i] = ''

#------------------------------Wizard Modules--------------------------
    def ClonezillaStopWizard(self,evt):
        wizard = wiz.Wizard(self, -1, _('msg_clonezilla_stop'), pos = (500,200))

        page1 = SetAllClientsPage(wizard, _('msg_title_set_all_clients'))
        page2 = SelectClientsPage(wizard, _('msg_select_clients'))
        page3 = FinalPage(wizard, _('msg_done'))
        FinalArgs[0] = '/opt/drbl/sbin/dcs'
        FinalArgs[3] = 'clonezilla-stop'

        self.page1 = page1
        wizard.SetPageSize((500,300))

        page1.SetNext(page2)
        page2.SetPrev(page1)
        page2.SetNext(page3)

        if wizard.RunWizard(page1):
            wx.MessageBox(_('success'), "That's all folks!", wx.CENTRE | wx.NO_DEFAULT, self)
            for i in range(0,36):
                FinalArgs[i] = ''
        else:
            wx.MessageBox(_('cancel'), "That's all folks!", wx.CENTRE | wx.NO_DEFAULT, self)
            for i in range(0,36):
                FinalArgs[i] = ''

#------------------------------Wizard Modules--------------------------
    def LocalWizard(self,evt):
        wizard = wiz.Wizard(self, -1, _('msg_local'), pos = (500,200))

        page1 = SetAllClientsPage(wizard, _('msg_title_set_all_clients'))
        page2 = SelectClientsPage(wizard, _('msg_select_clients'))
        page3 = FinalPage(wizard, _('msg_done'))
        FinalArgs[0] = '/opt/drbl/sbin/dcs'
        FinalArgs[3] = 'local'

        self.page1 = page1
        wizard.SetPageSize((500,300))

        page1.SetNext(page2)
        page2.SetPrev(page1)
        page2.SetNext(page3)

        if wizard.RunWizard(page1):
            wx.MessageBox(_('success'), "That's all folks!", wx.CENTRE | wx.NO_DEFAULT, self)
            for i in range(0,36):
                FinalArgs[i] = ''
        else:
            wx.MessageBox(_('cancel'), "That's all folks!", wx.CENTRE | wx.NO_DEFAULT, self)
            for i in range(0,36):
                FinalArgs[i] = ''

#------------------------------Wizard Modules--------------------------
    def RebootWizard(self,evt):
        wizard = wiz.Wizard(self, -1, _('msg_reboot'), pos = (500,200))

        page1 = SetAllClientsPage(wizard, _('msg_title_set_all_clients'))
        page2 = SelectClientsPage(wizard, _('msg_select_clients'))
        page3 = FinalPage(wizard, _('msg_done'))
        FinalArgs[0] = '/opt/drbl/sbin/dcs'
        FinalArgs[3] = 'reboot'

        self.page1 = page1
        wizard.SetPageSize((500,300))

        page1.SetNext(page2)
        page2.SetPrev(page1)
        page2.SetNext(page3)

        if wizard.RunWizard(page1):
            wx.MessageBox(_('success'), "That's all folks!", wx.CENTRE | wx.NO_DEFAULT, self)
            for i in range(0,36):
                FinalArgs[i] = ''
        else:
            wx.MessageBox(_('cancel'), "That's all folks!", wx.CENTRE | wx.NO_DEFAULT, self)
            for i in range(0,36):
                FinalArgs[i] = ''

#------------------------------Wizard Modules--------------------------
    def ShutdownWizard(self,evt):
        wizard = wiz.Wizard(self, -1, _('msg_shutdown'), pos = (500,200))

        page1 = SetAllClientsPage(wizard, _('msg_title_set_all_clients'))
        page2 = SelectClientsPage(wizard, _('msg_select_clients'))
        page3 = FinalPage(wizard, _('msg_done'))
        FinalArgs[0] = '/opt/drbl/sbin/dcs'
        FinalArgs[3] = 'shutdown'

        self.page1 = page1
        wizard.SetPageSize((500,300))

        page1.SetNext(page2)
        page2.SetPrev(page1)
        page2.SetNext(page3)

        if wizard.RunWizard(page1):
            wx.MessageBox(_('success'), "That's all folks!", wx.CENTRE | wx.NO_DEFAULT, self)
            for i in range(0,36):
                FinalArgs[i] = ''
        else:
            wx.MessageBox(_('cancel'), "That's all folks!", wx.CENTRE | wx.NO_DEFAULT, self)
            for i in range(0,36):
                FinalArgs[i] = ''

#------------------------------Wizard Modules-----------------------------
    def WakeOnLANWizard(self,evt):
        wizard = wiz.Wizard(self, -1, _('msg_Wake_on_LAN'), pos = (500,200))

        page1 = SetAllClientsPage(wizard, _('msg_title_set_all_clients'))
        page2 = SelectClientsPage(wizard, _('msg_select_clients'))
        page3 = FinalPage(wizard, _('msg_done'))
        FinalArgs[0] = '/opt/drbl/sbin/dcs'
        FinalArgs[3] = 'Wake-on-LAN'

        self.page1 = page1
        wizard.SetPageSize((500,300))

        page1.SetNext(page2)
        page2.SetPrev(page1)
        page2.SetNext(page3)

        if wizard.RunWizard(page1):
            wx.MessageBox(_('success'), "That's all folks!", wx.CENTRE | wx.NO_DEFAULT, self)
            for i in range(0,36):
                FinalArgs[i] = ''
        else:
            wx.MessageBox(_('cancel'), "That's all folks!", wx.CENTRE | wx.NO_DEFAULT, self)
            for i in range(0,36):
                FinalArgs[i] = ''

#------------------------------Wizard Modules-----------------------------
    def SwitchPXEMenuWizard(self,evt):
        wizard = wiz.Wizard(self, -1, _('msg_switch_pxe_menu'), pos = (500,200))

        page1 = SetAllClientsPage(wizard, _('msg_title_set_all_clients'))
        page2 = SelectClientsPage(wizard, _('msg_select_clients'))
        page3 = SwitchPXEMenuPage1(wizard, '')
        page4 = SwitchPXEMenuPage2(wizard, '')
	page5 = SwitchPXEMenuPage3(wizard, '')
        page6 = SwitchPXEMenuPage4(wizard, '')

        self.page1 = page1
        wizard.SetPageSize((500,300))

        page1.SetNext(page2)
        page2.SetPrev(page1)
        page2.SetNext(page3)
        page3.SetPrev(page2)
        page3.SetNext(page4)
	page4.SetPrev(page3)
	page4.SetNext(page5)
	page5.SetPrev(page4)
	page5.SetNext(page6)

        if wizard.RunWizard(page1):
            wx.MessageBox(_('success'), "That's all folks!", wx.CENTRE | wx.NO_DEFAULT, self)
            for i in range(0,36):
                FinalArgs[i] = ''
        else:
            wx.MessageBox(_('cancel'), "That's all folks!", wx.CENTRE | wx.NO_DEFAULT, self)
            for i in range(0,36):
                FinalArgs[i] = ''

#------------------------------Wizard Modules-----------------------------
    def SwitchPXEModeWizard(self,evt):
        wizard = wiz.Wizard(self, -1, 'SwitchPXEModeWizard', pos = (500,200))

        page1 = SetAllClientsPage(wizard, '')
        page2 = SelectOnePage(wizard, '')
        page3 = SwitchPXEModePage(wizard, '')
        page4 = FinalPage(wizard, '')

        self.page1 = page1
        wizard.SetPageSize((500,300))

        page1.SetNext(page2)
        page2.SetPrev(page1)
        page2.SetNext(page3)
        page3.SetPrev(page2)
        page3.SetNext(page4)

        if wizard.RunWizard(page1):
            wx.MessageBox(_('success'), "That's all folks!", wx.CENTRE | wx.NO_DEFAULT, self)
            for i in range(0,36):
                FinalArgs[i] = ''
        else:
            wx.MessageBox(_('cancel'), "That's all folks!", wx.CENTRE | wx.NO_DEFAULT, self)
            for i in range(0,36):
                FinalArgs[i] = ''

#------------------------------Wizard Modules-----------------------------
    def DRBLModeWizard(self,evt):
        wizard = wiz.Wizard(self, -1, 'DRBLModeWizard', pos = (500,200))

        page1 = DRBLModePage(wizard, '')
        page2 = FinalPage(wizard, '')

        self.page1 = page1
        wizard.SetPageSize((500,330))

        page1.SetNext(page2)
        #page2.SetPrev(page1)

        if wizard.RunWizard(page1):
            wx.MessageBox(_('success'), "That's all folks!", wx.CENTRE | wx.NO_DEFAULT, self)
            for i in range(0,36):
                FinalArgs[i] = ''
        else:
            wx.MessageBox(_('cancel'), "That's all folks!", wx.CENTRE | wx.NO_DEFAULT, self)
            for i in range(0,36):
                FinalArgs[i] = ''

#------------------------------Wizard Modules-----------------------------
    def ClonezillaModeWizard(self,evt):
        wizard = wiz.Wizard(self, -1, 'ClonezillaModeWizard', pos = (500,200))

        page1 = ClonezillaModePage(wizard, '')
        page2 = FinalPage(wizard, '')

        self.page1 = page1
        wizard.SetPageSize((500,300))

        page1.SetNext(page2)
        page2.SetPrev(page1)

        if wizard.RunWizard(page1):
            wx.MessageBox(_('success'), "That's all folks!", wx.CENTRE | wx.NO_DEFAULT, self)
            for i in range(0,36):
                FinalArgs[i] = ''
        else:
            wx.MessageBox(_('cancel'), "That's all folks!", wx.CENTRE | wx.NO_DEFAULT, self)
            for i in range(0,36):
                FinalArgs[i] = ''

#------------------------------Wizard Modules-----------------------------
    def GenTemplateFileWizard(self,evt):
        wizard = wiz.Wizard(self, -1, 'GenTemplateFileWizard', pos = (500,200))

        page1 = GenTemplateFilePage(wizard, '')
        page2 = FinalPage(wizard, '')

        self.page1 = page1
        wizard.SetPageSize((500,300))

        page1.SetNext(page2)
        page2.SetPrev(page1)

        if wizard.RunWizard(page1):
            wx.MessageBox(_('success'), "That's all folks!", wx.CENTRE | wx.NO_DEFAULT, self)
            for i in range(0,36):
                FinalArgs[i] = ''
        else:
            wx.MessageBox(_('cancel'), "That's all folks!", wx.CENTRE | wx.NO_DEFAULT, self)
            for i in range(0,36):
                FinalArgs[i] = ''

#------------------------------Wizard Modules-----------------------------
    def LoginSwitchWizard(self,evt):
        wizard = wiz.Wizard(self, -1, 'LoginSwitchWizard', pos = (500,200))

        page1 = SetAllClientsPage(wizard, '')
        page2 = SelectClientsPage(wizard, '')
	page3 = LoginSwitchPage(wizard, '')
        page4 = FinalPage(wizard, '')

        self.page1 = page1
        wizard.SetPageSize((500,300))

        page1.SetNext(page2)
        page2.SetPrev(page1)
        page2.SetNext(page3)
        page3.SetPrev(page2)
        page3.SetNext(page4)

        if wizard.RunWizard(page1):
            wx.MessageBox(_('success'), "That's all folks!", wx.CENTRE | wx.NO_DEFAULT, self)
            for i in range(0,36):
                FinalArgs[i] = ''
        else:
            wx.MessageBox(_('cancel'), "That's all folks!", wx.CENTRE | wx.NO_DEFAULT, self)
            for i in range(0,36):
                FinalArgs[i] = ''

#------------------------------Wizard Modules-----------------------------
    def ClientReAutoLoginWizard(self,evt):
        wizard = wiz.Wizard(self, -1, ' ClientReAutoLogin', pos = (500,200))

        page1 = SetAllClientsPage(wizard, '')
        page2 = SelectClientsPage(wizard, '')
        page3 = ClientReAutoLoginPage(wizard, '')
        page4 = FinalPage(wizard, '')

        self.page1 = page1
        wizard.SetPageSize((500,300))

        page1.SetNext(page2)
        page2.SetPrev(page1)
        page2.SetNext(page3)
        page3.SetPrev(page2)
        page3.SetNext(page4)

        if wizard.RunWizard(page1):
            wx.MessageBox(_('success'), "That's all folks!", wx.CENTRE | wx.NO_DEFAULT, self)
            for i in range(0,36):
                FinalArgs[i] = ''
        else:
            wx.MessageBox(_('cancel'), "That's all folks!", wx.CENTRE | wx.NO_DEFAULT, self)
            for i in range(0,36):
                FinalArgs[i] = ''

#------------------------------Wizard Modules-----------------------------
    def CleanAutoLoginAccountWizard(self,evt):
        wizard = wiz.Wizard(self, -1, 'CleanAutoLoginAccount', pos = (500,200))

        page1 = SetAllClientsPage(wizard, '')
        page2 = SelectOneClientPage(wizard, '')
        page3 = CleanAutoLoginAccountPage(wizard, '')
        page4 = FinalPage(wizard, '')

        self.page1 = page1
        wizard.SetPageSize((500,300))

        page1.SetNext(page2)
        page2.SetPrev(page1)
        page2.SetNext(page3)
        page3.SetPrev(page2)
        page3.SetNext(page4)

        if wizard.RunWizard(page1):
            wx.MessageBox(_('success'), "That's all folks!", wx.CENTRE | wx.NO_DEFAULT, self)
            for i in range(0,36):
                FinalArgs[i] = ''
        else:
            wx.MessageBox(_('cancel'), "That's all folks!", wx.CENTRE | wx.NO_DEFAULT, self)
            for i in range(0,36):
                FinalArgs[i] = ''

#------------------------------Wizard Modules-----------------------------
    def ResetAutoLoginAccountWizard(self,evt):
        wizard = wiz.Wizard(self, -1, 'ResetAutoLoginAccount', pos = (500,200))

        #page1 = SetAllClientsPage(wizard, '')
        #page2 = SelectOneClientPage(wizard, '')
        page1 = ResetAutoLoginAccountPage(wizard, '')
        page2 = FinalPage(wizard, '')

        self.page1 = page1
        wizard.SetPageSize((500,300))

        page1.SetNext(page2)
        #page2.SetPrev(page1)
        #page2.SetNext(page3)
        #page3.SetPrev(page2)
        #page3.SetNext(page4)

        if wizard.RunWizard(page1):
            wx.MessageBox(_('success'), "That's all folks!", wx.CENTRE | wx.NO_DEFAULT, self)
            for i in range(0,36):
                FinalArgs[i] = ''
        else:
            wx.MessageBox(_('cancel'), "That's all folks!", wx.CENTRE | wx.NO_DEFAULT, self)
            for i in range(0,36):
                FinalArgs[i] = ''

#------------------------------Wizard Modules-----------------------------
    def SwitchDRBLServWizard(self,evt):
        wizard = wiz.Wizard(self, -1, 'SwitchDRBLServWizard', pos = (500,200))

        page1 = SwitchDRBLServPage(wizard, '')
        page2 = FinalPage(wizard, '')

        self.page1 = page1
        wizard.SetPageSize((500,300))

        page1.SetNext(page2)

        if wizard.RunWizard(page1):
            wx.MessageBox(_('success'), "That's all folks!", wx.CENTRE | wx.NO_DEFAULT, self)
            for i in range(0,36):
                FinalArgs[i] = ''
        else:
            wx.MessageBox(_('cancel'), "That's all folks!", wx.CENTRE | wx.NO_DEFAULT, self)
            for i in range(0,36):
                FinalArgs[i] = ''

#------------------------------Wizard Modules-----------------------------
    def ReDeployWizard(self,evt):
        wizard = wiz.Wizard(self, -1, 'ReDeployWizard', pos = (500,200))

        page1 = SetAllClientsPage(wizard, '')
        page2 = SelectClientsPage(wizard, '')
        page3 = ReDeployPage(wizard, '')
        page4 = FinalPage(wizard, '')

        self.page1 = page1
        wizard.SetPageSize((500,300))

        page1.SetNext(page2)
        page2.SetPrev(page1)
        page2.SetNext(page3)
        page3.SetPrev(page2)
        page3.SetNext(page4)

        if wizard.RunWizard(page1):
            wx.MessageBox(_('success'), "That's all folks!", wx.CENTRE | wx.NO_DEFAULT, self)
            for i in range(0,36):
                FinalArgs[i] = ''
        else:
            wx.MessageBox(_('cancel'), "That's all folks!", wx.CENTRE | wx.NO_DEFAULT, self)
            for i in range(0,36):
                FinalArgs[i] = ''

#------------------------------Wizard Modules-----------------------------
    def CleanDHCPLeaseWizard(self,evt):
        wizard = wiz.Wizard(self, -1, 'CleanDHCPLeaseWizard', pos = (500,200))

        page1 = SetAllClientsPage(wizard, '')
        page2 = SelectClientsPage(wizard, '')
        page3 = CleanDHCPLeasePage(wizard, '')
        page4 = FinalPage(wizard, '')

        self.page1 = page1
        wizard.SetPageSize((500,300))

        page1.SetNext(page2)
        page2.SetPrev(page1)
        page2.SetNext(page3)
        page3.SetPrev(page2)
        page3.SetNext(page4)

        if wizard.RunWizard(page1):
            wx.MessageBox(_('success'), "That's all folks!", wx.CENTRE | wx.NO_DEFAULT, self)
            for i in range(0,36):
                FinalArgs[i] = ''
        else:
            wx.MessageBox(_('cancel'), "That's all folks!", wx.CENTRE | wx.NO_DEFAULT, self)
            for i in range(0,36):
                FinalArgs[i] = ''

#------------------------------Wizard Modules-----------------------------
    def Regenerate3NWizard(self,evt):
        wizard = wiz.Wizard(self, -1, 'Regenerate3NWizard', pos = (500,200))

        page1 = SetAllClientsPage(wizard, '')
        page2 = SelectClientsPage(wizard, '')
        page3 = Regenerate3NPage(wizard, '')
        page4 = FinalPage(wizard, '')

        self.page1 = page1
        wizard.SetPageSize((500,300))

        page1.SetNext(page2)
        page2.SetPrev(page1)
        page2.SetNext(page3)
        page3.SetPrev(page2)
        page3.SetNext(page4)

        if wizard.RunWizard(page1):
            wx.MessageBox(_('success'), "That's all folks!", wx.CENTRE | wx.NO_DEFAULT, self)
            for i in range(0,36):
                FinalArgs[i] = ''
        else:
            wx.MessageBox(_('cancel'), "That's all folks!", wx.CENTRE | wx.NO_DEFAULT, self)
            for i in range(0,36):
                FinalArgs[i] = ''

#------------------------------------------------------------------------
if __name__ == '__main__':
    app = wx.PySimpleApp()
    frame = MainFrame(parent=None, id=-1)
    frame.Show()
    app.MainLoop()

