import  wx
import  wx.wizard as wiz
import	sys
import	gettext
from wx.lib.mixins.listctrl import CheckListCtrlMixin
import  wx.lib.filebrowsebutton as filebrowse

cat = gettext.GNUTranslations(open(sys.argv[1]))
_ = cat.gettext

global FinalArgs 
FinalArgs = ['','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','',''] 
#global selected_hosts, selected_clients, lenghth
#lenghth = 0

#----------------------------------------------------------------------
ClonezillaStartSaveArgs = {
1: ("-q", _('msg_ocs_param_q')),
2: ("-c", _('msg_ocs_param_c')),
3: ("-nogui", _('msg_ocs_param_nogui')),
4: ("-a", _('msg_ocs_param_a')),
5: ("-f", _('msg_ocs_param_f')),
6: ("-s", _('msg_ocs_param_s')),
}

#----------------------------------------------------------------------
ClonezillaStartRestoreArgs = {
1: ("-g auto", _('msg_ocs_param_g_auto')),
2: ("-x", _('msg_ocs_param_x')),
3: ("-brdcst", _('msg_ocs_param_broadcast')),
4: ("-v", _('msg_ocs_param_v')),
5: ("-nogui", _('msg_ocs_param_nogui')),
6: ("-c", _('msg_ocs_param_c')),
7: ("-u", _('msg_ocs_param_u')),
8: ("-t", _('msg_ocs_param_t')),
9: ("-j0", _('msg_ocs_param_j0')),
10: ("-ns", _('msg_ocs_param_ns')),
11: ("-k", _('msg_ocs_param_k')),
12: ("-r", _('msg_ocs_param_r')),
13: ("-e", _('msg_ocs_param_e')),
14: ("-f", _('msg_ocs_param_f')),
15: ("-s", _('msg_ocs_param_s')),
16: ("-a", _('msg_ocs_param_a')),
17: ("-o", _('msg_ocs_param_o')),
18: ("-hn0", _('msg_ocs_param_hn0')),
19: ("-hn1", _('msg_ocs_param_hn1')),
}

#----------------------------------------------------------------------
class CSSCheckListCtrl(wx.ListCtrl, CheckListCtrlMixin):
    def __init__(self, parent, log):
        wx.ListCtrl.__init__(self, parent, -1, style=wx.LC_REPORT)
        CheckListCtrlMixin.__init__(self)
        self.log = log
        self.Bind(wx.EVT_LIST_ITEM_ACTIVATED, self.OnItemActivated)

    def OnItemActivated(self, evt):
        self.ToggleItem(evt.m_itemIndex)

    # this is called by the base class when an item is checked/unchecked
    def OnCheckItem(self, index, flag):
        data = self.GetItemData(index)
        arg = ClonezillaStartSaveArgs[data][0]
        if flag:
	    FinalArgs[index+3] = arg
        else:
	    FinalArgs[index+3] = ''

#----------------------------------------------------------------------
class CSRCheckListCtrl(wx.ListCtrl, CheckListCtrlMixin):
    def __init__(self, parent, log):
        wx.ListCtrl.__init__(self, parent, -1, style=wx.LC_REPORT)
        CheckListCtrlMixin.__init__(self)
        self.log = log
        self.Bind(wx.EVT_LIST_ITEM_ACTIVATED, self.OnItemActivated)

    def OnItemActivated(self, evt):
        self.ToggleItem(evt.m_itemIndex)

    # this is called by the base class when an item is checked/unchecked
    def OnCheckItem(self, index, flag):
        data = self.GetItemData(index)
        arg = ClonezillaStartRestoreArgs[data][0]
        if flag:
	    if index == 18:
		FinalArgs[index+4] = arg
	    else:
		FinalArgs[index+3] = arg
        else:
	    if index == 18:
		FinalArgs[index+4] = ''
	    else:
		FinalArgs[index+3] = ''

#----------------------------------------------------------------------
def makePageTitle(wizPg, title):
    sizer = wx.BoxSizer(wx.VERTICAL)
    wizPg.SetSizer(sizer)
    title = wx.StaticText(wizPg, -1, title)
    title.SetFont(wx.Font(12, wx.SWISS, wx.NORMAL, wx.BOLD))
    sizer.Add(title, 0, wx.ALIGN_CENTRE|wx.ALL, 5)
    sizer.Add(wx.StaticLine(wizPg, -1), 0, wx.EXPAND|wx.ALL, 5)
    return sizer

#----------------------------------------------------------------------
class WizardBasePage(wiz.PyWizardPage):
    def __init__(self, parent, title):
        wiz.PyWizardPage.__init__(self, parent)
        self.next = self.prev = None
        self.sizer = makePageTitle(self, title)

    def SetNext(self, next):
        self.next = next

    def SetPrev(self, prev):
        self.prev = prev

    def GetNext(self):
        return self.next

    def GetPrev(self):
        return self.prev

#----------------------------------------------------------------------
class SetAllClientsPage(wiz.PyWizardPage):
    def __init__(self, parent, title):
        wiz.PyWizardPage.__init__(self, parent)
        self.next = self.prev = None
        self.sizer = makePageTitle(self, title)

        self.cb = wx.CheckBox(self, -1, _('msg_title_set_all_clients'))
        self.cb.SetValue(True)
        self.sizer.Add(self.cb, 0, wx.ALL, 5)

    def SetNext(self, next):
        self.next = next

    def SetPrev(self, prev):
        self.prev = prev

    def GetNext(self):
	next = self.next
	if self.cb.GetValue():
	    FinalArgs[1] = ''
	    next = next.GetNext()
	else:
	    #FinalArgs[1] = ''
	    FinalArgs[1] = '-h'
        return next

    def GetPrev(self):
        return self.prev

#----------------------------------------------------------------------
class SelectClientsPage(wiz.PyWizardPage):
    def __init__(self, parent, title):
        wiz.PyWizardPage.__init__(self, parent)
        self.next = self.prev = None
        self.sizer = makePageTitle(self, title)
	self.selected_hosts = []
	self.selected_clients = ''
	self.lenghth = 0

        g = open("/tmp/ip_list", "r")
        ip_list = g.read()
        tokens = ("%s" % ip_list).split()
        self.lenghth = len(tokens)
        for i in range(0,len(tokens)):
                self.selected_hosts.insert(len(tokens),"")
                i = i+1
        g.close()

        lb = wx.CheckListBox(self, -1, (35,50), (290,250), tokens)
        self.Bind(wx.EVT_CHECKLISTBOX, self.EvtCheckListBox, lb)
        lb.SetSelection(0)
        counts = lb.GetCount()
        self.lb = lb
        pos = lb.GetPosition().x + lb.GetSize().width + 25

    def EvtCheckListBox(self, event):
	j = 0
        index = event.GetSelection()
        label = self.lb.GetString(index)
        if self.lb.IsChecked(index):
            del self.selected_hosts[index]
            self.selected_hosts.insert(index,label)
        if not (self.lb.IsChecked(index)):
            self.selected_hosts.remove(label)
            self.selected_hosts.insert(index,"")
        self.lb.SetSelection(index)    #so that (un)checking also selects (moves the highlight)
	self.selected_clients = ''
	while j < self.lenghth:
	    if self.selected_hosts[j] != "":
	        self.selected_clients = self.selected_clients + self.selected_hosts[j] + ' '
	    j = j+1
        self.selected_clients = '\"' + self.selected_clients + '\"'
        FinalArgs[2] = self.selected_clients

    def SetNext(self, next):
        self.next = next

    def SetPrev(self, prev):
        self.prev = prev

    def GetNext(self):
	#print self.selected_clients
        return self.next

    def GetPrev(self):
        return self.prev

#----------------------------------------------------------------------
class RemoteLinuxGraPage(wiz.PyWizardPage):
    def __init__(self, parent, title):
        wiz.PyWizardPage.__init__(self, parent)
        self.next = self.prev = None
        self.sizer = makePageTitle(self, title)

	wx.StaticText(self, -1, _('msg_remote_linux_graphic'),(50,100))
	FinalArgs[0] = '/opt/drbl/sbin/dcs'
	FinalArgs[3] = 'remote-linux-gra'

    def SetNext(self, next):
        self.next = next

    def SetPrev(self, prev):
        self.prev = prev

    def GetNext(self):
        return self.next

    def GetPrev(self):
	prev = self.prev
	prev = prev.GetPrev()
        return prev

#----------------------------------------------------------------------
class RemoteLinuxTxtPage(wiz.PyWizardPage):
    def __init__(self, parent, title):
        wiz.PyWizardPage.__init__(self, parent)
        self.next = self.prev = None
        self.sizer = makePageTitle(self, title)

        wx.StaticText(self, -1, _('msg_remote_linux_text'),(50,100))
        FinalArgs[0] = '/opt/drbl/sbin/dcs'
        FinalArgs[3] = 'remote-linux-text'

    def SetNext(self, next):
        self.next = next

    def SetPrev(self, prev):
        self.prev = prev

    def GetNext(self):
        return self.next

    def GetPrev(self):
        prev = self.prev
        prev = prev.GetPrev()
        return prev

#----------------------------------------------------------------------
class TerminalPage(wiz.PyWizardPage):
    def __init__(self, parent, title):
        wiz.PyWizardPage.__init__(self, parent)
        self.next = self.prev = None
        self.sizer = makePageTitle(self, title)

        wx.StaticText(self, -1, _('msg_thin_client'),(50,100))
        FinalArgs[0] = '/opt/drbl/sbin/dcs'
        FinalArgs[3] = 'remote-thin-client'

    def SetNext(self, next):
        self.next = next

    def SetPrev(self, prev):
        self.prev = prev

    def GetNext(self):
        return self.next

    def GetPrev(self):
        prev = self.prev
        prev = prev.GetPrev()
        return prev

#----------------------------------------------------------------------
class RemoteMemTestPage(wiz.PyWizardPage):
    def __init__(self, parent, title):
        wiz.PyWizardPage.__init__(self, parent)
        self.next = self.prev = None
        self.sizer = makePageTitle(self, title)

        wx.StaticText(self, -1, _('msg_remote_memtest'),(50,100))
        FinalArgs[0] = '/opt/drbl/sbin/dcs'
        FinalArgs[3] = 'remote-memtest'

    def SetNext(self, next):
        self.next = next

    def SetPrev(self, prev):
        self.prev = prev

    def GetNext(self):
        return self.next

    def GetPrev(self):
        prev = self.prev
        prev = prev.GetPrev()
        return prev

#----------------------------------------------------------------------
class RemotefdosPage(wiz.PyWizardPage):
    def __init__(self, parent, title):
        wiz.PyWizardPage.__init__(self, parent)
        self.next = self.prev = None
        self.sizer = makePageTitle(self, title)

        wx.StaticText(self, -1, _('msg_remote_fdos'),(50,100))
        FinalArgs[0] = '/opt/drbl/sbin/dcs'
        FinalArgs[3] = 'remote-fdos'

    def SetNext(self, next):
        self.next = next

    def SetPrev(self, prev):
        self.prev = prev

    def GetNext(self):
        return self.next

    def GetPrev(self):
        prev = self.prev
        prev = prev.GetPrev()
        return prev

#----------------------------------------------------------------------
class ClonezillaStartSavePage1(wiz.PyWizardPage):
    def __init__(self, parent, title):
        wiz.PyWizardPage.__init__(self, parent)
        self.next = self.prev = None
        self.sizer = makePageTitle(self, title)
        ModeList = [_('msg_clonezilla_save_disk'), _('msg_clonezilla_save_parts')]

        rb = wx.RadioBox(
                self, -1, _('msg_choose_mode'), (35, 50), (260,90),
                ModeList, 1, wx.RA_SPECIFY_COLS
                )

        self.Bind(wx.EVT_RADIOBOX, self.EvtRadioBox, rb)
        FinalArgs[0] = '/opt/drbl/sbin/drbl-ocs -b'
	FinalArgs[12] = 'startdisk save'

    def EvtRadioBox(self, event):
        if event.GetInt() == 0:
                FinalArgs[12] = 'startdisk save'
        if event.GetInt() == 1:
                FinalArgs[12] = 'startpart save'

    def SetNext(self, next):
        self.next = next

    def SetPrev(self, prev):
        self.prev = prev

    def GetNext(self):
        return self.next

    def GetPrev(self):
        return self.prev

#----------------------------------------------------------------------
class ClonezillaStartSavePage2(wiz.PyWizardPage):
    def __init__(self, parent, title):
        wiz.PyWizardPage.__init__(self, parent)
        self.next = self.prev = None
        self.sizer = makePageTitle(self, title)

	wx.StaticText(self,-1,_('msg_ask_if_input_save_image_name_in_server'),wx.DLG_PNT(self, 10, 20),wx.DLG_SZE(self, 200, 100),wx.TE_MULTILINE)

        self.cb = wx.CheckBox(self, -1, 'YES',(20,130)) # not translated
        self.cb.SetValue(True)
        #self.sizer.Add(self.cb, 0, wx.TOP|wx.LEFT, 80)
	
    def SetNext(self, next):
        self.next = next

    def SetPrev(self, prev):
        self.prev = prev

    def GetNext(self):
	next = self.next
	if not self.cb.GetValue():
	    next = next.GetNext()
        return next

    def GetPrev(self):
        return self.prev

#----------------------------------------------------------------------
class ClonezillaStartSavePage3(wiz.PyWizardPage):
    def __init__(self, parent, title):
        wiz.PyWizardPage.__init__(self, parent)
        self.next = self.prev = None
        self.sizer = makePageTitle(self, title)

        wx.StaticText(self, -1,  _('msg_input_image_name'), (10, 160))
        self.text_img = wx.TextCtrl(self, -1, '', (10, 180), size=(200, -1))

        wx.StaticText(self, -1,  _('msg_input_device_name'), (10, 210))
        self.text_dev = wx.TextCtrl(self, -1, '', (10, 230), size=(190, -1))

    def SetNext(self, next):
        self.next = next

    def SetPrev(self, prev):
        self.prev = prev

    def GetNext(self):
	FinalArgs[13] = self.text_img.GetValue()
	FinalArgs[14] = self.text_dev.GetValue()
        return self.next

    def GetPrev(self):
        return self.prev

#----------------------------------------------------------------------
class ClonezillaStartSavePage4(wiz.PyWizardPage):
    def __init__(self, parent, title):
        wiz.PyWizardPage.__init__(self, parent)
        self.next = self.prev = None
        self.sizer = makePageTitle(self, title)

        self.list = CSSCheckListCtrl(self, title)
        sizer = wx.BoxSizer()
        sizer.Add(self.list, 1, wx.EXPAND)
        self.SetSizer(sizer)

        self.list.InsertColumn(0, _('argument'))	#not translated
        self.list.InsertColumn(1, _('meannings'), wx.LIST_FORMAT_LEFT)	#not translated

        for key, data in ClonezillaStartSaveArgs.iteritems():
            index = self.list.InsertStringItem(sys.maxint, data[0])
            self.list.SetStringItem(index, 1, data[1])
            self.list.SetItemData(index, key)

        self.list.SetColumnWidth(0, wx.LIST_AUTOSIZE)
        self.list.SetColumnWidth(1, wx.LIST_AUTOSIZE)

        self.list.CheckItem(0)
        self.list.CheckItem(1)

    def SetNext(self, next):
        self.next = next

    def SetPrev(self, prev):
        self.prev = prev

    def GetNext(self):
        next = self.next
        if self.list.IsChecked(0) == self.list.IsChecked(1) == self.list.IsChecked(2) == self.list.IsChecked(3) == self.list.IsChecked(4) == self.list.IsChecked(5) == 0:
            next = 0
        return next

    def GetPrev(self):
        prev = self.prev
        prev = prev.GetPrev()
        return prev

#----------------------------------------------------------------------
class ClonezillaStartSavePage5(wiz.PyWizardPage):
    def __init__(self, parent, title):
        wiz.PyWizardPage.__init__(self, parent)
        self.next = self.prev = None
        self.sizer = makePageTitle(self, title)

        ArgList = [_('msg_ocs_param_p_choose'), _('msg_ocs_param_p_true'),
                      _('msg_ocs_param_p_poweroff'), _('msg_ocs_param_p_reboot')]

        rb = wx.RadioBox(
                self, -1, _('msg_choose_post_mode_after_clone'), (35,50), (290,150),
                ArgList, 1, wx.RA_SPECIFY_COLS
                )
        self.Bind(wx.EVT_RADIOBOX, self.EvtRadioBox, rb)
        rb.SetSelection(3)
	FinalArgs[9] = '-p reboot'

    def EvtRadioBox(self, event):
        if event.GetSelection() == 0:
                FinalArgs[9] = '-p choose'
        if event.GetSelection() == 1:
                FinalArgs[9] = '-p true'
        if event.GetSelection() == 2:
                FinalArgs[9] = '-p poweroff'
        if event.GetSelection() == 3:
                FinalArgs[9] = '-p reboot'

    def SetNext(self, next):
        self.next = next

    def SetPrev(self, prev):
        self.prev = prev

    def GetNext(self):
        return self.next

    def GetPrev(self):
        return self.prev

#----------------------------------------------------------------------
class ClonezillaStartSavePage6(wiz.PyWizardPage):
    def __init__(self, parent, title):
        wiz.PyWizardPage.__init__(self, parent)
        self.next = self.prev = None
        self.sizer = makePageTitle(self, title)

        ArgList = [ _('msg_ocs_param_z0'), _('msg_ocs_param_z1'), _('msg_ocs_param_z2'), _('msg_ocs_param_z3')]
        rb = wx.RadioBox(self, -1, _('msg_choose_post_mode_after_clone'), (35,50), (340,150), ArgList, 1, wx.RA_SPECIFY_COLS)
        self.Bind(wx.EVT_RADIOBOX, self.EvtRadioBox, rb)
        rb.SetSelection(3)
	FinalArgs[10] = '-z3'

    def EvtRadioBox(self, event):
        if event.GetSelection() == 0:
                FinalArgs[10] = '-z0'
        if event.GetSelection() == 1:
                FinalArgs[10] = '-z1'
        if event.GetSelection() == 2:
                FinalArgs[10] = '-z2'
        if event.GetSelection() == 3:
                FinalArgs[10] = '-z3'

    def SetNext(self, next):
        self.next = next

    def SetPrev(self, prev):
        self.prev = prev

    def GetNext(self):
        return self.next

    def GetPrev(self):
        return self.prev

#----------------------------------------------------------------------
class ClonezillaStartRestorePage1(wiz.PyWizardPage):
    def __init__(self, parent, title):
        wiz.PyWizardPage.__init__(self, parent)
        self.next = self.prev = None
        self.sizer = makePageTitle(self, title)
        ModeList = [_('msg_clonezilla_restore_disk'), _('msg_clonezilla_restore_parts')]

        rb = wx.RadioBox(self, -1, _('msg_choose_mode'), (35, 50), (260,90), ModeList, 1, wx.RA_SPECIFY_COLS)

        self.Bind(wx.EVT_RADIOBOX, self.EvtRadioBox, rb)
        FinalArgs[0] = '/opt/drbl/sbin/drbl-ocs -b'
        FinalArgs[32] = 'startdisk'

    def EvtRadioBox(self, event):
        if event.GetInt() == 0:
                FinalArgs[32] = 'startdisk'
        if event.GetInt() == 1:
                FinalArgs[32] = 'startpart'

    def SetNext(self, next):
        self.next = next

    def SetPrev(self, prev):
        self.prev = prev

    def GetNext(self):
        return self.next

    def GetPrev(self):
        return self.prev

#----------------------------------------------------------------------
class ClonezillaStartRestorePage2(wiz.PyWizardPage):
    def __init__(self, parent, title):
        wiz.PyWizardPage.__init__(self, parent)
        self.next = self.prev = None
        self.sizer = makePageTitle(self, title)

        self.list = CSRCheckListCtrl(self, title)
        sizer = wx.BoxSizer()
        sizer.Add(self.list, 1, wx.EXPAND)
        self.SetSizer(sizer)

        self.list.InsertColumn(0, _('argument'))        #not translated
        self.list.InsertColumn(1, _('meannings'), wx.LIST_FORMAT_LEFT) #not translated

        for key, data in ClonezillaStartRestoreArgs.iteritems():
            index = self.list.InsertStringItem(sys.maxint, data[0])
            self.list.SetStringItem(index, 1, data[1])
            self.list.SetItemData(index, key)

        self.list.SetColumnWidth(0, wx.LIST_AUTOSIZE)
        self.list.SetColumnWidth(1, wx.LIST_AUTOSIZE)

        self.list.CheckItem(0)
        self.list.CheckItem(1)

    def SetNext(self, next):
        self.next = next

    def SetPrev(self, prev):
        self.prev = prev

    def GetNext(self):
	j = 0
	check_sum = 0
        next = self.next
	for j in range(0,18):
	    check_sum = check_sum + self.list.IsChecked(j)
	if check_sum == 0: # if user didn't check any box, then return NULL.
            next = 0
	if (self.list.IsChecked(17) or self.list.IsChecked(18)):
	    next = self.next
	else:
	    next = next.GetNext()
	    next = next.GetNext()
        return next

    def GetPrev(self):
        return self.prev

#----------------------------------------------------------------------
class ClonezillaStartRestorePage3(wiz.PyWizardPage):
    def __init__(self, parent, title):
        wiz.PyWizardPage.__init__(self, parent)
        self.next = self.prev = None
        self.sizer = makePageTitle(self, title)

	wx.StaticText(self,-1,_('msg_write_MS_WIN_is_necessary'),wx.DLG_PNT(self, 10, 20),wx.DLG_SZE(self, 200, 100),wx.TE_MULTILINE)
	#if len(_('msg_write_MS_WIN_is_necessary')) <= 517:
	    #wx.StaticText(self, -1, _('msg_write_MS_WIN_is_necessary')[:60], (10,60))
	    #wx.StaticText(self, -1, _('msg_write_MS_WIN_is_necessary')[60:122], (10,80))
	    #wx.StaticText(self, -1, _('msg_write_MS_WIN_is_necessary')[122:184], (10,100))
	    #wx.StaticText(self, -1, _('msg_write_MS_WIN_is_necessary')[184:253], (10,120))
	    #wx.StaticText(self, -1, _('msg_write_MS_WIN_is_necessary')[253:314], (10,140))
	    #wx.StaticText(self, -1, _('msg_write_MS_WIN_is_necessary')[314:380], (10,160))
	    #wx.StaticText(self, -1, _('msg_write_MS_WIN_is_necessary')[380:440], (10,180))
	    #wx.StaticText(self, -1, _('msg_write_MS_WIN_is_necessary')[440:495], (10,220))
	    #wx.StaticText(self, -1, _('msg_write_MS_WIN_is_necessary')[495:], (10,240))
	#else:
            #wx.StaticText(self, -1, _('msg_write_MS_WIN_is_necessary')[:79], (10,60))
	    #wx.StaticText(self, -1, _('msg_write_MS_WIN_is_necessary')[79:156], (10,80))
            #wx.StaticText(self, -1, _('msg_write_MS_WIN_is_necessary')[156:248], (10,100))
            #wx.StaticText(self, -1, _('msg_write_MS_WIN_is_necessary')[248:331], (10,120))
            #wx.StaticText(self, -1, _('msg_write_MS_WIN_is_necessary')[331:413], (10,140))
            #wx.StaticText(self, -1, _('msg_write_MS_WIN_is_necessary')[413:449], (10,160))
	    #wx.StaticText(self, -1, _('msg_write_MS_WIN_is_necessary')[449:], (10,200))

    def SetNext(self, next):
        self.next = next

    def SetPrev(self, prev):
        self.prev = prev

    def GetNext(self):
        return self.next

    def GetPrev(self):
        return self.prev

#----------------------------------------------------------------------
class ClonezillaStartRestorePage4(wiz.PyWizardPage):
    def __init__(self, parent, title):
        wiz.PyWizardPage.__init__(self, parent)
        self.next = self.prev = None
        self.sizer = makePageTitle(self, title)

	wx.StaticText(self, -1, _('msg_What_the_win_hostname_prefix'), (5, 80))
        self.text = wx.TextCtrl(self, -1, "PC", (5, 110), size=(200, -1))

    def SetNext(self, next):
        self.next = next

    def SetPrev(self, prev):
        self.prev = prev

    def GetNext(self):
	#print FinalArgs
	if FinalArgs[20] == '-hn0' and FinalArgs[22] == '-hn1':
	    FinalArgs[21] = FinalArgs[23] = self.text.GetValue()
	elif FinalArgs[20] == '-hn0'and FinalArgs[22] != '-hn1':
	    FinalArgs[21] =  self.text.GetValue()
	elif FinalArgs[22] == '-hn1' and FinalArgs[20] != '-hn0':
	    FinalArgs[23] = self.text.GetValue()
        elif FinalArgs[20] != '-hn0' and FinalArgs[22] != '-hn1':
            FinalArgs[21] = FinalArgs[23] = ''
	return self.next

    def GetPrev(self):
        prev = self.prev
        prev = prev.GetPrev()
        return prev

#----------------------------------------------------------------------
class ClonezillaStartRestorePage5(wiz.PyWizardPage):
    def __init__(self, parent, title):
        wiz.PyWizardPage.__init__(self, parent)
        self.next = self.prev = None
        self.sizer = makePageTitle(self, title)

        ModeList = [_('msg_ocs_param_y0'), _('msg_ocs_param_y1'), _('msg_ocs_param_y2'), _('msg_ocs_param_skip')]
	wx.StaticText(self,-1,_('msg_if_always_provide_clonezilla_srv'),wx.DLG_PNT(self, 10, 20),wx.DLG_SZE(self, 200, 100),wx.TE_MULTILINE)
        rb = wx.RadioBox(self, -1, '', (5,150), wx.DefaultSize, ModeList, 1, wx.RA_SPECIFY_COLS)
        self.Bind(wx.EVT_RADIOBOX, self.EvtRadioBox, rb)
        rb.SetSelection(3)

    def EvtRadioBox(self, event):
        if event.GetInt() == 0:
            FinalArgs[24] = '-y0'
        elif event.GetInt() == 1:
            FinalArgs[24] = '-y1'
        elif event.GetInt() == 2:
            FinalArgs[24] = '-y2'
        elif event.GetInt() == 3:
            FinalArgs[24] = ''

    def SetNext(self, next):
        self.next = next

    def SetPrev(self, prev):
        self.prev = prev

    def GetNext(self):
        return self.next

    def GetPrev(self):
        return self.prev

#----------------------------------------------------------------------
class ClonezillaStartRestorePage6(wiz.PyWizardPage):
    def __init__(self, parent, title):
        wiz.PyWizardPage.__init__(self, parent)
        self.next = self.prev = None
        self.sizer = makePageTitle(self, title)

        ArgList = [_('msg_ocs_param_p_choose'), _('msg_ocs_param_p_true'), _('msg_ocs_param_p_poweroff'), _('msg_ocs_param_p_reboot')]
        rb = wx.RadioBox(self, -1, _('msg_choose_post_mode_after_clone'), (35,50), (290,150), ArgList, 1, wx.RA_SPECIFY_COLS)
        self.Bind(wx.EVT_RADIOBOX, self.EvtRadioBox, rb)
        rb.SetSelection(3)
        FinalArgs[25] = '-p reboot'

    def EvtRadioBox(self, event):
        if event.GetSelection() == 0:
                FinalArgs[25] = '-p choose'
        if event.GetSelection() == 1:
                FinalArgs[25] = '-p true'
        if event.GetSelection() == 2:
                FinalArgs[25] = '-p poweroff'
        if event.GetSelection() == 3:
                FinalArgs[25] = '-p reboot'

    def SetNext(self, next):
        self.next = next

    def SetPrev(self, prev):
        self.prev = prev

    def GetNext(self):
	next = self.next
	if FinalArgs[9] == '-u':
	    next = next.GetNext()
	    next = next.GetNext()
	    next = next.GetNext()
        return next

    def GetPrev(self):
        return self.prev

#----------------------------------------------------------------------
class ClonezillaStartRestorePage7(wiz.PyWizardPage):
    def __init__(self, parent, title):
        wiz.PyWizardPage.__init__(self, parent)
        self.next = self.prev = None
        self.sizer = makePageTitle(self, title)

        wx.StaticText(self, -1, _('msg_choose_the_image_to_restore'), (5,80))
        self.fbb = filebrowse.FileBrowseButton(self, -1, pos=(50,150), size=(350, -1), buttonText='browse', toolTip='Type filename or click browse to choose file', fileMask='*.img', changeCallback = self.fbbCallback)

    def fbbCallback(self, evt):
        FinalArgs[34] = evt.GetString()

    def SetNext(self, next):
        self.next = next

    def SetPrev(self, prev):
        self.prev = prev

    def GetNext(self):
        return self.next

    def GetPrev(self):
        return self.prev

#----------------------------------------------------------------------
class ClonezillaStartRestorePage8(wiz.PyWizardPage):
    def __init__(self, parent, title):
        wiz.PyWizardPage.__init__(self, parent)
        self.next = self.prev = None
        self.sizer = makePageTitle(self, title)

        if FinalArgs[32] == 'startdisk':
            wx.StaticText(self, -1, _('msg_choose_the_disks_to_restore'), (5,80))
        elif FinalArgs[32] == 'startpart':
            wx.StaticText(self, -1, _(msg_choose_the_parts_to_restore), (5,80))
        self.text = wx.TextCtrl(self, -1, "hda", (5, 110), size=(200, -1))

    def SetNext(self, next):
        self.next = next

    def SetPrev(self, prev):
        self.prev = prev

    def GetNext(self):
	if FinalArgs[9] == '-u':
	    FinalArgs[35] = ''
	elif FinalArgs[9] == '':
	    FinalArgs[35] = self.text.GetValue()
        return self.next

    def GetPrev(self):
        return self.prev

#----------------------------------------------------------------------
class ClonezillaStartRestorePage9(wiz.PyWizardPage):
    def __init__(self, parent, title):
        wiz.PyWizardPage.__init__(self, parent)
        self.next = self.prev = None
        self.sizer = makePageTitle(self, title)

        ModeList = [_('msg_multicast_restore'), _('msg_unicast_restore')]
	if FinalArgs[32] == 'startdisk':
            rb = wx.RadioBox(self, -1, _('msg_choose_the_mode_to_restore_disk'), (35,50), (290,150), ModeList, 1, wx.RA_SPECIFY_COLS)
	elif FinalArgs[32] == 'startpart':
	    rb = wx.RadioBox(self, -1, _('msg_choose_the_mode_to_restore_parts'), (35,50), (290,150), ModeList, 1, wx.RA_SPECIFY_COLS)
        self.Bind(wx.EVT_RADIOBOX, self.EvtRadioBox, rb)
	if FinalArgs[9] == '-u':
	    FinalArgs[33] = 'restore'
	else:
	    FinalArgs[33] = 'multicast_restore'

    def EvtRadioBox(self, event):
        if event.GetInt() == 0:
            FinalArgs[33] = 'multicast_restore'
        if event.GetInt() == 1:
            FinalArgs[33] = 'restore'

    def SetNext(self, next):
        self.next = next

    def SetPrev(self, prev):
        self.prev = prev

    def GetNext(self):
	next = self.next
        if FinalArgs[9] == '-u':
            FinalArgs[33] = 'restore'
	if FinalArgs[33] == 'restore':
	    next = next.GetNext()
	    next = next.GetNext()
	    next = next.GetNext()
        return next

    def GetPrev(self):
        return self.prev

#----------------------------------------------------------------------
class ClonezillaStartRestorePage10(wiz.PyWizardPage):
    def __init__(self, parent, title):
        wiz.PyWizardPage.__init__(self, parent)
        self.next = self.prev = None
        self.sizer = makePageTitle(self, title)

        ModeList = [_('msg_clients_time_to_wait'), _('msg_time_to_wait'), _('msg_clients_to_wait')]
        rb = wx.RadioBox(self, -1, _('msg_choose_mode'), (35,50), (350, 150), ModeList, 1, wx.RA_SPECIFY_COLS)
        self.Bind(wx.EVT_RADIOBOX, self.EvtRadioBox, rb)
	FinalArgs[26] = '--clients-to-wait'
	FinalArgs[28] = '--max-time-to-wait'

    def EvtRadioBox(self, event):
	if event.GetInt() == 0:
	    FinalArgs[26] = '--clients-to-wait'
	    FinalArgs[28] = '--max-time-to-wait'
	elif event.GetInt() == 1:
	    FinalArgs[26] = ''
	    FinalArgs[28] = '--max-time-to-wait'
	elif event.GetInt() == 2:
	    FinalArgs[26] = '--clients-to-wait'
	    FinalArgs[28] = ''
 
    def SetNext(self, next):
        self.next = next

    def SetPrev(self, prev):
        self.prev = prev

    def GetNext(self):
	next = self.next
	if FinalArgs[33] == 'restore':
            FinalArgs[26] = ''
            FinalArgs[28] = ''
	    next = self.next
	if FinalArgs[26] == '' and FinalArgs[28] != '':
	    next = next.GetNext()
        return next

    def GetPrev(self):
        return self.prev
#----------------------------------------------------------------------
class ClonezillaStartRestorePage11(wiz.PyWizardPage):
    def __init__(self, parent, title):
        wiz.PyWizardPage.__init__(self, parent)
        self.next = self.prev = None
        self.sizer = makePageTitle(self, title)

        wx.StaticText(self, -1, _('msg_how_many_clients_to_restore'), (20, 80))
	self.text = wx.TextCtrl(self, -1, '5', (20, 110), size=(200, -1))

    def SetNext(self, next):
        self.next = next

    def SetPrev(self, prev):
        self.prev = prev

    def GetNext(self):
	next = self.next
	if FinalArgs[26] != '':
	    FinalArgs[27] = self.text.GetValue()
	    next = self.next
	if FinalArgs[28] == '': 
	    next = next.GetNext()
        return next

    def GetPrev(self):
        return self.prev

#----------------------------------------------------------------------
class ClonezillaStartRestorePage12(wiz.PyWizardPage):
    def __init__(self, parent, title):
        wiz.PyWizardPage.__init__(self, parent)
        self.next = self.prev = None
        self.sizer = makePageTitle(self, title)

        wx.StaticText(self, -1, _('msg_max_time_to_wait_sec'), (20, 80))
        self.text = wx.TextCtrl(self, -1, "300", (20, 110), size=(200, -1))

    def SetNext(self, next):
        self.next = next

    def SetPrev(self, prev):
        self.prev = prev

    def GetNext(self):
	if FinalArgs[28] != '':
	    FinalArgs[29] = self.text.GetValue()
	return self.next

    def GetPrev(self):
        return self.prev

#----------------------------------------------------------------------
class ClonezillaStartRestorePage13(wiz.PyWizardPage):
    def __init__(self, parent, title):
        wiz.PyWizardPage.__init__(self, parent)
        self.next = self.prev = None
        self.sizer = makePageTitle(self, title)

    def SetNext(self, next):
        self.next = next

    def SetPrev(self, prev):
        self.prev = prev

    def GetNext(self):
        return self.next

    def GetPrev(self):
        return self.prev

#----------------------------------------------------------------------
class ClonezillaSelectPage1(wiz.PyWizardPage):
    def __init__(self, parent, title):
        wiz.PyWizardPage.__init__(self, parent)
        self.next = self.prev = None
        self.sizer = makePageTitle(self, title)

        ModeList = [_('msg_ocs_param_y0'), _('msg_ocs_param_y1'), _('msg_ocs_param_y2'), _('msg_ocs_param_skip')]
        wx.StaticText(self,-1,_('msg_if_always_provide_clonezilla_srv'),wx.DLG_PNT(self, 10, 20),wx.DLG_SZE(self, 200, 100),wx.TE_MULTILINE)
        rb = wx.RadioBox(self, -1, '', (5,150), wx.DefaultSize, ModeList, 1, wx.RA_SPECIFY_COLS)
        self.Bind(wx.EVT_RADIOBOX, self.EvtRadioBox, rb)
        rb.SetSelection(1)
	FinalArgs[5] = '-y1'

    def EvtRadioBox(self, event):
        if event.GetInt() == 0:
            FinalArgs[5] = '-y0'
        elif event.GetInt() == 1:
            FinalArgs[5] = '-y1'
        elif event.GetInt() == 2:
            FinalArgs[5] = '-y2'
        elif event.GetInt() == 3:
            FinalArgs[5] = ''

    def SetNext(self, next):
        self.next = next

    def SetPrev(self, prev):
        self.prev = prev

    def GetNext(self):
        return self.next

    def GetPrev(self):
        return self.prev

#----------------------------------------------------------------------
class ClonezillaSelectPage2(wiz.PyWizardPage):
    def __init__(self, parent, title):
        wiz.PyWizardPage.__init__(self, parent)
        self.next = self.prev = None
        self.sizer = makePageTitle(self, title)

        ArgList = [_('msg_ocs_param_p_choose'), _('msg_ocs_param_p_true'), _('msg_ocs_param_p_poweroff'), _('msg_ocs_param_p_reboot')]
        rb = wx.RadioBox(self, -1, _('msg_choose_post_mode_after_clone'), (35,50), (290,150), ArgList, 1, wx.RA_SPECIFY_COLS)
        self.Bind(wx.EVT_RADIOBOX, self.EvtRadioBox, rb)
        rb.SetSelection(0)
        FinalArgs[6] = '-p choose'

    def EvtRadioBox(self, event):
        if event.GetSelection() == 0:
                FinalArgs[6] = '-p choose'
        if event.GetSelection() == 1:
                FinalArgs[6] = '-p true'
        if event.GetSelection() == 2:
                FinalArgs[6] = '-p poweroff'
        if event.GetSelection() == 3:
                FinalArgs[6] = '-p reboot'

    def SetNext(self, next):
        self.next = next

    def SetPrev(self, prev):
        self.prev = prev

    def GetNext(self):
	FinalArgs[7] = 'select_in_client'
        return self.next

    def GetPrev(self):
        return self.prev

#----------------------------------------------------------------------
class ClonezillaStopPage(wiz.PyWizardPage):
    def __init__(self, parent, title):
        wiz.PyWizardPage.__init__(self, parent)
        self.next = self.prev = None
        self.sizer = makePageTitle(self, title)

        wx.StaticText(self, -1, _('msg_clonezilla_stop'),(50,100))
        FinalArgs[0] = '/opt/drbl/sbin/dcs'
        FinalArgs[3] = 'clonezilla-stop'
	
    def SetNext(self, next):
        self.next = next

    def SetPrev(self, prev):
        self.prev = prev

    def GetNext(self):
        return self.next

    def GetPrev(self):
        return self.prev

#----------------------------------------------------------------------
class LocalPage(wiz.PyWizardPage):
    def __init__(self, parent, title):
        wiz.PyWizardPage.__init__(self, parent)
        self.next = self.prev = None
        self.sizer = makePageTitle(self, title)

        wx.StaticText(self, -1, _('msg_local'),(50,100))
        FinalArgs[0] = '/opt/drbl/sbin/dcs'
        FinalArgs[3] = 'local'

    def SetNext(self, next):
        self.next = next

    def SetPrev(self, prev):
        self.prev = prev

    def GetNext(self):
        return self.next

    def GetPrev(self):
        return self.prev

#----------------------------------------------------------------------
class RebootPage(wiz.PyWizardPage):
    def __init__(self, parent, title):
        wiz.PyWizardPage.__init__(self, parent)
        self.next = self.prev = None
        self.sizer = makePageTitle(self, title)

        wx.StaticText(self, -1, _('msg_reboot'),(50,100))
        FinalArgs[0] = '/opt/drbl/sbin/dcs'
        FinalArgs[3] = 'reboot'

    def SetNext(self, next):
        self.next = next

    def SetPrev(self, prev):
        self.prev = prev

    def GetNext(self):
        return self.next

    def GetPrev(self):
        return self.prev

#----------------------------------------------------------------------
class ShutdownPage(wiz.PyWizardPage):
    def __init__(self, parent, title):
        wiz.PyWizardPage.__init__(self, parent)
        self.next = self.prev = None
        self.sizer = makePageTitle(self, title)

        wx.StaticText(self, -1, _('msg_shutdown'),(50,100))
        FinalArgs[0] = '/opt/drbl/sbin/dcs'
        FinalArgs[3] = 'shutdown'

    def SetNext(self, next):
        self.next = next

    def SetPrev(self, prev):
        self.prev = prev

    def GetNext(self):
        return self.next

    def GetPrev(self):
        return self.prev

#----------------------------------------------------------------------
class WakeOnLanPage(wiz.PyWizardPage):
    def __init__(self, parent, title):
        wiz.PyWizardPage.__init__(self, parent)
        self.next = self.prev = None
        self.sizer = makePageTitle(self, title)

        wx.StaticText(self, -1, _('msg_Wake_on_LAN'), (50,100))
        FinalArgs[0] = '/opt/drbl/sbin/dcs'
        FinalArgs[3] = 'Wake-on-LAN'

    def SetNext(self, next):
        self.next = next

    def SetPrev(self, prev):
        self.prev = prev

    def GetNext(self):
        return self.next

    def GetPrev(self):
        return self.prev

#----------------------------------------------------------------------
class FinalPage(wiz.PyWizardPage):
    def __init__(self, parent, title):
        wiz.PyWizardPage.__init__(self, parent)
        self.next = self.prev = None
        self.sizer = makePageTitle(self, title)

        self.tc = wx.TextCtrl(self, -1,'', pos=(35,50), size=(350, 350), style=wx.TE_MULTILINE|wx.TE_READONLY)
	b = wx.Button(self, -1, 'see log', pos=(400,250))
	self.Bind(wx.EVT_BUTTON, self.OnWriteLog, b)
	
    def OnWriteLog(self, evt):
	i = 0
	for i in range(0,36):
	    if FinalArgs[i] != '':
	        self.tc.WriteText('%s ' % FinalArgs[i])	
	    FinalArgs[i] = ''

    def SetNext(self, next):
        self.next = next

    def SetPrev(self, prev):
        self.prev = prev

    def GetNext(self):
        return self.next

    def GetPrev(self):
        return self.prev

#----------------------------------------------------------------------
class MainFrame(wx.Frame):
    def __init__(self, parent, id):
        wx.Frame.__init__(self, parent, id, 'TEST WIZARD', (300,200), (600,400), style=wx.CAPTION)
	#wx.NO_FULL_REPAINT_ON_RESIZE
        self.scroll = wx.ScrolledWindow(self, -1)
	self.scroll.SetScrollbars(1, 1, 550, 500)

        FunctionList = [_('msg_remote_linux_graphic'), _('msg_remote_linux_text'), _('msg_thin_client')
		        , _('msg_remote_memtest'), _('msg_remote_fdos'), _('msg_clonezilla_start_save')
			, _('msg_clonezilla_start_restore'), _('msg_clonezilla_selec_in_client'), _('msg_clonezilla_stop')
			, _('msg_local'), _('msg_reboot'), _('msg_shutdown'), _('msg_Wake_on_LAN')]
        rb = wx.RadioBox(self.scroll, -1, '', (35,20), (0,0), FunctionList, 1, wx.RA_SPECIFY_COLS|wx.NO_BORDER)
        self.scroll.Bind(wx.EVT_RADIOBOX, self.EvtRadioBox, rb)
        rb.SetSelection(0)
	self.b = wx.Button(self.scroll, wx.ID_FORWARD, pos=(450, 350))      # not translated
	self.scroll.Bind(wx.EVT_BUTTON, self.RemoteLinuxGraWizard, self.b)

    def EvtRadioBox(self, event):
        if event.GetSelection() == 0:
	    #b = wx.Button(self.scroll, wx.ID_FORWARD,(pos,220))
	    self.scroll.Bind(wx.EVT_BUTTON, self.RemoteLinuxGraWizard, self.b)
        if event.GetSelection() == 1:
	    #b = wx.Button(self.scroll, wx.ID_FORWARD)
            self.scroll.Bind(wx.EVT_BUTTON, self.RemoteLinuxTxtWizard, self.b)
        if event.GetSelection() == 2:
	    #b = wx.Button(self.scroll, wx.ID_FORWARD)
	    self.scroll.Bind(wx.EVT_BUTTON, self.TerminalWizard, self.b)
        if event.GetSelection() == 3:
            #b = wx.Button(self.scroll, wx.ID_FORWARD, pos=(450, 350))
            self.scroll.Bind(wx.EVT_BUTTON, self.RemoteMemTestWizard, self.b)
        if event.GetSelection() == 4:
            #b = wx.Button(self.scroll, wx.ID_FORWARD, pos=(450, 350))
            self.scroll.Bind(wx.EVT_BUTTON, self.RemotefdosWizard, self.b)
        if event.GetSelection() == 5:
            #b = wx.Button(self.scroll, wx.ID_FORWARD, pos=(450, 350))
            self.scroll.Bind(wx.EVT_BUTTON, self.ClonezillaStartSaveWizard, self.b)
        if event.GetSelection() == 6:
            #b = wx.Button(self.scroll, wx.ID_FORWARD, pos=(450, 350))
            self.scroll.Bind(wx.EVT_BUTTON, self.ClonezillaStartRestoreWizard, self.b)
        if event.GetSelection() == 7:
            #b = wx.Button(self.scroll, wx.ID_FORWARD, pos=(450, 350))
            self.scroll.Bind(wx.EVT_BUTTON, self.ClonezillaSelectWizard, self.b)
        if event.GetSelection() == 8:
            #b = wx.Button(self.scroll, wx.ID_FORWARD, pos=(450, 350))
            self.scroll.Bind(wx.EVT_BUTTON, self.ClonezillaStopWizard, self.b)
        if event.GetSelection() == 9:
            #b = wx.Button(self.scroll, wx.ID_FORWARD, pos=(450, 350))
            self.scroll.Bind(wx.EVT_BUTTON, self.LocalWizard, self.b)
        if event.GetSelection() == 10:
            #b = wx.Button(self.scroll, wx.ID_FORWARD, pos=(450, 350))
            self.scroll.Bind(wx.EVT_BUTTON, self.RebootWizard, self.b)
        if event.GetSelection() == 11:
            #b = wx.Button(self.scroll, wx.ID_FORWARD, pos=(450, 350))
            self.scroll.Bind(wx.EVT_BUTTON, self.ShutdownWizard, self.b)
        if event.GetSelection() == 12:
            #b = wx.Button(self.scroll, wx.ID_FORWARD, pos=(450, 350))
            self.scroll.Bind(wx.EVT_BUTTON, self.WakeOnLanWizard, self.b)

	
#------------------------------Wizard Modules--------------------------
    def RemoteLinuxGraWizard(self,evt):
        wizard = wiz.Wizard(self, -1, 'RemoteLinuxGraWizard', pos = (500,200))

	page1 = SetAllClientsPage(wizard, '')
	page2 = SelectClientsPage(wizard, '')
	page3 = RemoteLinuxGraPage(wizard, '')
	page4 = FinalPage(wizard, '')

	self.page1 = page1
	wizard.SetPageSize((500,300))

	page1.SetNext(page2)
	page2.SetPrev(page1)
	page2.SetNext(page3)
	page3.SetPrev(page2)
	page3.SetNext(page4)

        if wizard.RunWizard(page1):
            wx.MessageBox(_('success'), "That's all folks!")
        else:
            wx.MessageBox(_('cancel'), "That's all folks!")
	    
#------------------------------Wizard Modules--------------------------
    def RemoteLinuxTxtWizard(self,evt):
        wizard = wiz.Wizard(self, -1, 'RemoteLinuxTextWizard', pos = (500,200))

        page1 = SetAllClientsPage(wizard, '')
        page2 = SelectClientsPage(wizard, '')
        page3 = RemoteLinuxTxtPage(wizard, '')
        page4 = FinalPage(wizard, '')

        self.page1 = page1
        wizard.SetPageSize((500,300))

        page1.SetNext(page2)
        page2.SetPrev(page1)
        page2.SetNext(page3)
        page3.SetPrev(page2)
        page3.SetNext(page4)

        if wizard.RunWizard(page1):
            wx.MessageBox(_('success'), "That's all folks!")
        else:
            wx.MessageBox(_('cancel'), "That's all folks!")

#------------------------------Wizard Modules--------------------------
    def TerminalWizard(self,evt):
        wizard = wiz.Wizard(self, -1, 'TerminalWizard', pos = (500,200))

        page1 = SetAllClientsPage(wizard, '')
        page2 = SelectClientsPage(wizard, '')
        page3 = TerminalPage(wizard, '')
        page4 = FinalPage(wizard, '')

        self.page1 = page1
        wizard.SetPageSize((500,300))

        page1.SetNext(page2)
        page2.SetPrev(page1)
        page2.SetNext(page3)
        page3.SetPrev(page2)
        page3.SetNext(page4)

        if wizard.RunWizard(page1):
            wx.MessageBox(_('success'), "That's all folks!")
        else:
            wx.MessageBox(_('cancel'), "That's all folks!")

#------------------------------Wizard Modules--------------------------
    def RemoteMemTestWizard(self,evt):
        wizard = wiz.Wizard(self, -1, 'RemoteMemTestWizard', pos = (500,200))

        page1 = SetAllClientsPage(wizard, '')
        page2 = SelectClientsPage(wizard, '')
        page3 = RemoteMemTestPage(wizard, '')
        page4 = FinalPage(wizard, '')

        self.page1 = page1
        wizard.SetPageSize((500,300))

        page1.SetNext(page2)
        page2.SetPrev(page1)
        page2.SetNext(page3)
        page3.SetPrev(page2)
        page3.SetNext(page4)

        if wizard.RunWizard(page1):
            wx.MessageBox(_('success'), "That's all folks!")
        else:
            wx.MessageBox(_('cancel'), "That's all folks!")

#------------------------------Wizard Modules--------------------------
    def RemotefdosWizard(self,evt):
        wizard = wiz.Wizard(self, -1, 'RemotefdosWizard', pos = (500,200))

        page1 = SetAllClientsPage(wizard, '')
        page2 = SelectClientsPage(wizard, '')
        page3 = RemotefdosPage(wizard,'')
        page4 = FinalPage(wizard,'')

        self.page1 = page1
        wizard.SetPageSize((500,300))

        page1.SetNext(page2)
        page2.SetPrev(page1)
        page2.SetNext(page3)
        page3.SetPrev(page2)
        page3.SetNext(page4)

        if wizard.RunWizard(page1):
            wx.MessageBox(_('success'), "That's all folks!")
        else:
            wx.MessageBox(_('cancel'), "That's all folks!")

#------------------------------Wizard Modules--------------------------
    def ClonezillaStartSaveWizard(self,evt):
        wizard = wiz.Wizard(self, -1, 'ClonezillaStartSaveWizard', pos = (500,200))

        page1 = SetAllClientsPage(wizard, '')
        page2 = SelectClientsPage(wizard, '')
	page3 = ClonezillaStartSavePage1(wizard, '')
	page4 = ClonezillaStartSavePage2(wizard, '')
	page5 = ClonezillaStartSavePage3(wizard, '')
	page6 = ClonezillaStartSavePage4(wizard, '')
	page7 = ClonezillaStartSavePage5(wizard, '')
	page8 = ClonezillaStartSavePage6(wizard, '')
        page9 = FinalPage(wizard,'')

        self.page1 = page1
        wizard.SetPageSize((500,300))

        page1.SetNext(page2)
        page2.SetPrev(page1)
        page2.SetNext(page3)
        page3.SetPrev(page2)
        page3.SetNext(page4)
	page4.SetPrev(page3)
	page4.SetNext(page5)
	page5.SetPrev(page4)
	page5.SetNext(page6)
	page6.SetPrev(page5)
	page6.SetNext(page7)
	page7.SetPrev(page6)
	page7.SetNext(page8)
	page8.SetPrev(page7)
	page8.SetNext(page9)

        if wizard.RunWizard(page1):
            wx.MessageBox(_('success'), "That's all folks!")
        else:
            wx.MessageBox(_('cancel'), "That's all folks!")

#------------------------------Wizard Modules--------------------------
    def ClonezillaStartRestoreWizard(self,evt):
        wizard = wiz.Wizard(self, -1, 'ClonezillaStartRestoreWizard', pos = (500,200))

        page1 = SetAllClientsPage(wizard, '')
        page2 = SelectClientsPage(wizard, '')
        page3 = ClonezillaStartRestorePage1(wizard, '')
        page4 = ClonezillaStartRestorePage2(wizard, '')
        page5 = ClonezillaStartRestorePage3(wizard, '')
        page6 = ClonezillaStartRestorePage4(wizard, '')
        page7 = ClonezillaStartRestorePage5(wizard, '')
	page8 = ClonezillaStartRestorePage6(wizard, '')
        page9 = ClonezillaStartRestorePage7(wizard, '')
	page10 = ClonezillaStartRestorePage8(wizard, '')
	page11 = ClonezillaStartRestorePage9(wizard, '')
	page12 = ClonezillaStartRestorePage10(wizard, '')
	page13 = ClonezillaStartRestorePage11(wizard, '')
	page14 = ClonezillaStartRestorePage12(wizard, '')
	page15 = ClonezillaStartRestorePage13(wizard, '')
        page16 = FinalPage(wizard,'')

        self.page1 = page1
        wizard.SetPageSize((500,300))

        page1.SetNext(page2)
        page2.SetPrev(page1)
        page2.SetNext(page3)
        page3.SetPrev(page2)
        page3.SetNext(page4)
        page4.SetPrev(page3)
        page4.SetNext(page5)
        page5.SetPrev(page4)
        page5.SetNext(page6)
        page6.SetPrev(page5)
        page6.SetNext(page7)
        page7.SetPrev(page6)
        page7.SetNext(page8)
	page8.SetPrev(page7)
	page8.SetNext(page9)
	page9.SetPrev(page8)
	page9.SetNext(page10)
	page10.SetPrev(page9)
	page10.SetNext(page11)
	page11.SetPrev(page9)
	page11.SetNext(page12)
	page12.SetPrev(page9)
	page12.SetNext(page13)
	page13.SetPrev(page9)
	page13.SetNext(page14)
	page14.SetPrev(page9)
	page14.SetNext(page15)
	page15.SetPrev(page14)
	page15.SetNext(page16)

        if wizard.RunWizard(page1):
            wx.MessageBox(_('success'), "That's all folks!")
        else:
            wx.MessageBox(_('cancel'), "That's all folks!")

#------------------------------Wizard Modules--------------------------
    def ClonezillaSelectWizard(self,evt):
        wizard = wiz.Wizard(self, -1, 'ClonezillaSelectWizard', pos = (500,200))

        page1 = SetAllClientsPage(wizard, '')
        page2 = SelectClientsPage(wizard, '')
        page3 = ClonezillaSelectPage1(wizard, '')
	page4 = ClonezillaSelectPage2(wizard, '')
        page5 = FinalPage(wizard, '')

        self.page1 = page1
        wizard.SetPageSize((500,300))

        page1.SetNext(page2)
        page2.SetPrev(page1)
        page2.SetNext(page3)
        page3.SetPrev(page2)
        page3.SetNext(page4)
	page4.SetPrev(page3)
	page4.SetNext(page5)

        if wizard.RunWizard(page1):
            wx.MessageBox(_('success'), "That's all folks!")
        else:
            wx.MessageBox(_('cancel'), "That's all folks!")

#------------------------------Wizard Modules--------------------------
    def ClonezillaStopWizard(self,evt):
        wizard = wiz.Wizard(self, -1, 'ClonezillaStopWizard', pos = (500,200))

        page1 = SetAllClientsPage(wizard, '')
        page2 = SelectClientsPage(wizard, '')
        page3 = ClonezillaStopPage(wizard, '')
        page4 = FinalPage(wizard, '')

        self.page1 = page1
        wizard.SetPageSize((500,300))

        page1.SetNext(page2)
        page2.SetPrev(page1)
        page2.SetNext(page3)
        page3.SetPrev(page2)
        page3.SetNext(page4)

        if wizard.RunWizard(page1):
            wx.MessageBox(_('success'), "That's all folks!")
        else:
            wx.MessageBox(_('cancel'), "That's all folks!")

#------------------------------Wizard Modules--------------------------
    def LocalWizard(self,evt):
        wizard = wiz.Wizard(self, -1, 'LocalWizard', pos = (500,200))

        page1 = SetAllClientsPage(wizard, '')
        page2 = SelectClientsPage(wizard, '')
        page3 = LocalPage(wizard, '')
        page4 = FinalPage(wizard, '')

        self.page1 = page1
        wizard.SetPageSize((500,300))

        page1.SetNext(page2)
        page2.SetPrev(page1)
        page2.SetNext(page3)
        page3.SetPrev(page2)
        page3.SetNext(page4)

        if wizard.RunWizard(page1):
            wx.MessageBox(_('success'), "That's all folks!")
        else:
            wx.MessageBox(_('cancel'), "That's all folks!")

#------------------------------Wizard Modules--------------------------
    def RebootWizard(self,evt):
        wizard = wiz.Wizard(self, -1, 'RebootWizard', pos = (500,200))

        page1 = SetAllClientsPage(wizard, '')
        page2 = SelectClientsPage(wizard, '')
        page3 = RebootPage(wizard, '')
        page4 = FinalPage(wizard, '')

        self.page1 = page1
        wizard.SetPageSize((500,300))

        page1.SetNext(page2)
        page2.SetPrev(page1)
        page2.SetNext(page3)
        page3.SetPrev(page2)
        page3.SetNext(page4)

        if wizard.RunWizard(page1):
            wx.MessageBox(_('success'), "That's all folks!")
        else:
            wx.MessageBox(_('cancel'), "That's all folks!")

#------------------------------Wizard Modules--------------------------
    def ShutdownWizard(self,evt):
        wizard = wiz.Wizard(self, -1, 'ShutdownWizard', pos = (500,200))

        page1 = SetAllClientsPage(wizard, '')
        page2 = SelectClientsPage(wizard, '')
        page3 = ShutdownPage(wizard, '')
        page4 = FinalPage(wizard, '')

        self.page1 = page1
        wizard.SetPageSize((500,300))

        page1.SetNext(page2)
        page2.SetPrev(page1)
        page2.SetNext(page3)
        page3.SetPrev(page2)
        page3.SetNext(page4)

        if wizard.RunWizard(page1):
            wx.MessageBox(_('success'), "That's all folks!")
        else:
            wx.MessageBox(_('cancel'), "That's all folks!")

#------------------------------Wizard Modules-----------------------------
    def WakeOnLanWizard(self,evt):
        wizard = wiz.Wizard(self, -1, 'WakeOnLanWizard', pos = (500,200))

        page1 = SetAllClientsPage(wizard, '')
        page2 = SelectClientsPage(wizard, '')
        page3 = WakeOnLanPage(wizard, '')
        page4 = FinalPage(wizard, '')

        self.page1 = page1
        wizard.SetPageSize((500,300))

        page1.SetNext(page2)
        page2.SetPrev(page1)
        page2.SetNext(page3)
        page3.SetPrev(page2)
        page3.SetNext(page4)

        if wizard.RunWizard(page1):
            wx.MessageBox(_('success'), "That's all folks!")
        else:
            wx.MessageBox(_('cancel'), "That's all folks!")

#------------------------------------------------------------------------
if __name__ == '__main__':
    app = wx.PySimpleApp()
    frame = MainFrame(parent=None, id=-1)
    frame.Show()
    app.MainLoop()

