import  wx, sys, os, gettext, string, time
import  wx.wizard as wiz
from config import generate_ip_list, drbl_dcs, remote_functions

cat = gettext.GNUTranslations(open('../langs/%s.mo' % os.getenv('LANG')))
_ = cat.gettext

global selected_clients, selected_func
selected_clients = ['-nl','']
selected_func = ['']

#----------------------------------------------------------------------
def makePageTitle(wizPg, title):
    sizer = wx.BoxSizer(wx.VERTICAL)
    wizPg.SetSizer(sizer)
    title = wx.StaticText(wizPg, -1, title)
    title.SetFont(wx.Font(12, wx.SWISS, wx.NORMAL, wx.BOLD))
    sizer.Add(title, 0, wx.ALIGN_CENTRE|wx.ALL, 5)
    sizer.Add(wx.StaticLine(wizPg, -1), 0, wx.EXPAND|wx.ALL, 5)
    return sizer

#----------------------------------------------------------------------
class remoteLinuxPage(wiz.PyWizardPage):
    def __init__(self, parent, title):
        wiz.PyWizardPage.__init__(self, parent)
        self.next = self.prev = None
        self.sizer = makePageTitle(self, title)

	list = []
	for i in range(0, len(remote_functions)):
	    list.append(remote_functions[i][0] + '   ' + remote_functions[i][1])

        self.rb = wx.RadioBox(self, -1, '', wx.DefaultPosition, wx.DefaultSize, list, 1, wx.RA_SPECIFY_COLS|wx.NO_BORDER)
        self.sizer.Add(self.rb, 0, wx.ALIGN_CENTER|wx.ALL, 50)
        self.Bind(wx.EVT_RADIOBOX, self.EvtRadioBox, self.rb)
        self.rb.SetSelection(0)
	selected_func[0] = remote_functions[0][2]

    def EvtRadioBox(self, event):
        selected_func[0] = remote_functions[event.GetSelection()][2]

    def SetNext(self, next):
        self.next = next

    def SetPrev(self, prev):
        self.prev = prev

    def GetNext(self):
        return self.next

    def GetPrev(self):
        return self.prev

#----------------------------------------------------------------------
class setAllClientsPage(wiz.PyWizardPage):
    def __init__(self, parent, title):
        wiz.PyWizardPage.__init__(self, parent)
        self.next = self.prev = None
        self.sizer = makePageTitle(self, title)
	self.fuse_next = 0

        wx.StaticText(self, -1, _('msg_select_all_clients_or_select_part_them'), pos=(10,60), size=(500,100), style=wx.TE_MULTILINE)
        wx.StaticText(self, -1, _('msg_set_all_clients_des'), pos=(10,80), size=(500,100), style=wx.TE_MULTILINE)
        ox = ['Yes', 'No']
        self.rb = wx.RadioBox(self, -1, _('msg_set_all_clients'), (10,150), (250,75), ox, 1, wx.RA_SPECIFY_COLS|wx.NO_BORDER)
        self.Bind(wx.EVT_RADIOBOX, self.EvtRadioBox, self.rb)

    def EvtRadioBox(self, event):
        if event.GetSelection() == 0:
            selected_clients[0] = '-nl'
        if event.GetSelection() == 1:
            selected_clients[0] = '-h'

    def SetNext(self, next):
        self.next = next

    def SetPrev(self, prev):
	self.prev = prev

    def GetNext(self):
        next = self.next
	self.fuse_next = self.fuse_next + 1
	if self.fuse_next == 2:
            if self.rb.GetSelection() == 0:
                Command.SetLabel('%s %s %s' % (drbl_dcs, selected_clients[0], selected_func[0]))
                #CommandLog.WriteText(os.popen('%s %s %s' % (drbl_dcs, selected_clients[0], selected_func[0])).read())
                next = next.GetNext()
        return next

    def GetPrev(self):
	self.fuse_next = 0
	prev = self.prev
	return prev

#----------------------------------------------------------------------
class selectClientsPage(wiz.PyWizardPage):
    def __init__(self, parent, title):
        wiz.PyWizardPage.__init__(self, parent)
        self.next = self.prev = None
        self.sizer = makePageTitle(self, title)

        self.SelectedClientsArray = []
        self.SelectedClientsStr = ''
        self.fuse_next = self.fuse_prev = 0

        AllClientsArray = os.popen(generate_ip_list).read().split('\n')
        AllClientsArray.remove('')
        self.lb = wx.CheckListBox(self, -1, (10,50), (470,250), AllClientsArray)
        self.Bind(wx.EVT_CHECKLISTBOX, self.EvtCheckListBox, self.lb)
        self.lb.SetSelection(0)

    def EvtCheckListBox(self, event):
        index = event.GetSelection()
        label = self.lb.GetString(index)
        if self.lb.IsChecked(index):
            self.SelectedClientsArray.append(label)
        if not (self.lb.IsChecked(index)):
            self.SelectedClientsArray.remove(label)
        self.lb.SetSelection(index)	#so that (un)checking also selects (moves the highlight)

    def SetNext(self, next):
        self.next = next

    def SetPrev(self, prev):
        self.prev = prev

    def GetNext(self):
        next = self.next
        self.fuse_prev = 0
        self.fuse_next = self.fuse_next + 1
        if self.fuse_next == 2:
	    if (selected_clients[0] == '-h'):
	        if len(self.SelectedClientsArray) == 0:
                    war = wx.MessageDialog(self, 'YOU MUST CHOOSE ONE!!', 'WARNNING!!', wx.OK|wx.ICON_INFORMATION)
                    war.ShowModal()
                    war.Destroy()
                    return self
                else:
                    for x in self.SelectedClientsArray:
                        self.SelectedClientsStr = x + ' ' + self.SelectedClientsStr
                    self.SelectedClientsStr = '\"' + self.SelectedClientsStr + '\"'
                    selected_clients[1] = self.SelectedClientsStr
		    CommandLog.WriteText('The commands are : %s %s %s %s' % (drbl_dcs, selected_clients[0], selected_clients[1], selected_func[0]))
                    #CommandLog.WriteText(os.popen('%s %s %s %s' % (drbl_dcs, selected_clients[0], selected_clients[1], selected_func[0])).read())
	return next

    def GetPrev(self):
	prev = self.prev
	self.fuse_next = 0
	return prev

#------------------------------------------------------------------------
class remoteLinuxFinalPage(wiz.PyWizardPage):
    def __init__(self, parent, title):
        wiz.PyWizardPage.__init__(self, parent)
        self.next = self.prev = None
        self.sizer = makePageTitle(self, title)
        global Command, CommandLog

        Command = wx.StaticText(self, -1, '', pos=(10,60), size=(150,100), style=wx.TE_MULTILINE)
        CommandLog = wx.TextCtrl(self, -1, '', pos=(10,100), size=(480,200), style=wx.TE_MULTILINE|wx.TE_READONLY)

