#!/bin/bash
# Program:
#   Path DRBL evironment to support Xen/KVM
# Author: 
#   Jazz, Rock {jazz, rock}@nchc.org.tw
# Version:
#    1.0
# History:                                                                                          
#   2010/07/20  Rock    First release (1.0) 

# [Source]
source /opt/drbl-virt/conf/drbl-virt.conf
source $Work_Path/functions_drbl_virt

# [Main]

# = 0. Variables setup =
# == Get DRBL eth ==
eths=""
declare -i eth_nu=""
get_DRBL_eth                                                                                                                                                                           
     
if [ $eth_nu -gt "1" ]; then
    echo ""
    echo "DRBL environment has muiltpule netwrok card(NIC)."
fi   
     
for eth in $eths
do   
     
    # == Get Host IP range/number  ==
    Host_first_IP=""
    Host_last_IP=""
    # get eth network
    eth_address=$(/opt/drbl/bin/drbl-get-ipadd $eth)
    eth_netmask=$(/opt/drbl/bin/drbl-get-netmask $eth)
    eth_network=$(/opt/drbl/bin/drbl-get-network $eth_address $eth_netmask)
    get_Host_IP_range
     
    # == Get VM number, IP range & prefix name ==
    declare -i VM_IP_range=""
    declare -i Host_last_IP_4=""
    declare -i VM_Host_totoal_nu=""
    VM_first_IP=""
    VM_last_IP=""
    VM_prefix_name=""
    get_VM_IP_range_and_prefix_name
    create_VM_IP_table
     
    # == Generate MAC address  ==
    # MAC address [00:16:3e:xx:xx:xx] is for Xen use
    generate_Xen_MAC_address
     
    # == Add VM IP to dhcpd.conf  ==
    VM_IPs=$(cat /opt/drbl-virt/etc/IP_VM_$eth | awk '{print $1}')
    VM_hosts=$(cat /opt/drbl-virt/etc/IP_VM_$eth | awk '{print $2}')
    VM_MACs=$(cat /opt/drbl-virt/etc/macadr-VM-$eth.txt)
    add_VM_dhcpd_conf
     
    # == Add VM IP to exports  ==
    #add_VM_nfs_exportd
     
    # == Add VM IP to ypserv.securenets  ==
    #add_VM_ypserv_securenets
     
     
done 
     
# = 1. Copy VM fs =
# Kernel & initrd -> /home/domains
     
     
# = 2. Add NFS config =
     
# = 3. Add DHCP config =
     
# = 4. Add hosts and cp it to all drbl client =
     
# = 5. generate guest config file =     
