#!/bin/bash
# Program:
#  Remove DRBL virt module
# Author: 
#   Jazz, Rock {jazz, rock}@nchc.org.tw
# Version:
#    1.0
# History:                                                                                          
#   2010/07/20  Rock    First release (1.0) 

# [Source]
source /opt/drbl-virt/conf/drbl-virt.conf
source $Work_Path/functions_drbl_virt

# [Main]
check_systemInfo

case $Linux_Distribution in
    # for Ubuntu
    "Ubuntu")
        echo "Only support Debain"
    ;; 
    # for Debian
    "Debian")
        # check xen package
        check_debian_xen_pkg=""
        check_debian_xen
        echo $check_debian_xen_pkg

        if [ $check_debian_xen_pkg == "no" ]; then
        echo -e "Don'f find Xen package, please check APT sources.list"
        exit 0
        fi
        
        # check bit 
        echo $Linux_bit | grep 64 > /dev/null 
        if [ $? == 0 ]; then
            Linux_bit="amd64"
        else
            Linux_bit="686"
        fi  
                 
        # check version
        echo $Linux_Version | grep "^5" > /dev/null
        if [ $? == 0 ]; then
            hypervisior=""
            check_hypervisior
            echo $hyprtvisior

            if [ $hypervisior == "Xen" ]; then
                echo ""
                echo "Install Xen Hypervisior"
                aptitude install xen-linux-system-2.6.26-2-xen-${Linux_bit} xen-tools bridge-utils python-xml
                cp $Work_Home/conf/debian-lenny_xend-config.sxp /etc/xen/xend-config.sxp
                if [ $1 == "stop" ]; then
                    echo ""
                    echo "DRBL server default will not enabled xend."
                    echo "DRBL client default will enabled xend."
                    update-rc.d xend remove
                    update-rc.d xendomains remove
                elif [ $1 == "start" ]; then
                    update-rc.d xend defaults
                    update-rc.d xendomains defaults
                fi
            
            else
                aptitude install kvm
            fi

        fi  
    ;; 
    # for Fedora
    "Fedora")            
        echo "Only support Debain"
    ;; 
    *) 
        echo "Only support Debain"
    ;; 
esac

