#!/bin/bash
# Program:
#   Path DRBL evironment to support Xen/KVM
# Author: 
#   Jazz, Rock {jazz, rock}@nchc.org.tw
# Version:
#    1.0
# History:                                                                                          
#   2010/07/20  Rock    First release (1.0) 

# [Source]
source /opt/drbl-virt/conf/drbl-virt.conf
source $Work_Path/functions_drbl_virt

# [Main]

# = 1. Patch DRBL xen env for client =
# == Shutdown all drbl client ==
echo "Please check all client are shutdown !!!"
read -p "Push 'Enter' to continue......"

# == Change xen kernel for drbl client ==
check_xen_nu
Xen_Kernel=$(echo $Xen_Kernel | sed 's/^vmlinuz-//g' )

# == Copy xen image to /tftpboot/nbi_img/ ==
echo "copy Xen image & Kernel to /tftpboot/nbi_img/"
cp /boot/*xen* /tftpboot/nbi_img/
cp /boot/vmlinuz-${Xen_Kernel} /tftpboot/nbi_img/
cp /boot/initrd.img-${Xen_Kernel} /tftpboot/nbi_img/
cp /boot/config-${Xen_Kernel} /tftpboot/nbi_img/
echo ""

# == Modify PXE booting menu ==
# backup generate-pxe-menu
cp /tftpboot/nbi_img/pxelinux.cfg/default /tftpboot/nbi_img/pxelinux.cfg/default.drbl-virt_bak
cp /opt/drbl/sbin/generate-pxe-menu /opt/drbl/sbin/generate-pxe-menu.drbl-virt_bak
generate_PXE_menu="/opt/drbl/sbin/generate-pxe-menu"
declare -i modify_line=$(cat -n $generate_PXE_menu | grep 'label drbl' | awk 'NR==1 {print $1}')
# modify menu
sed -i "${modify_line}i\label drbl-virt" $generate_PXE_menu
modify_line=$modify_line+1
sed -i "${modify_line}i\  MENU DEFAULT" $generate_PXE_menu
modify_line=$modify_line+1
sed -i "${modify_line}i\  MENU LABEL DRBL-Virtualization ($Xen, $Xen_Kernel)" $generate_PXE_menu
modify_line=$modify_line+1
sed -i "${modify_line}i\  kernel mboot.c32" $generate_PXE_menu
modify_line=$modify_line+1
sed -i "${modify_line}i\  append $Xen --- vmlinuz-pxe --- initrd-pxe.img devfs=nomount drblthincli=off selinux=0 nomodeset" $generate_PXE_menu
modify_line=$modify_line+1
sed -i "${modify_line}i\  TEXT HELP" $generate_PXE_menu
modify_line=$modify_line+1
sed -i "${modify_line}i\  ENDTEXT" $generate_PXE_menu
modify_line=$modify_line+1
sed -i "${modify_line}i\ " $generate_PXE_menu


# = 2. Patch DRBL initrd to support bridge =
# == Patch /usr/bin/mkpxeinitrd-net (1)Xen network scripts (2)command (3)modules ==
# backup
cp /usr/bin/mkpxeinitrd-net /usr/bin/mkpxeinitrd-net.drbl-virt_bak
# copy Xen network scripts
cp /etc/xen/scripts/network-bridge /usr/lib/mkpxeinitrd-net/initrd-skel/bin/
cp /etc/xen/scripts/xen-network-common.sh /usr/lib/mkpxeinitrd-net/initrd-skel/bin/
cp /etc/xen/scripts/xen-script-common.sh /usr/lib/mkpxeinitrd-net/initrd-skel/bin/
# patch it to copy command
declare -i modify_line=$(cat -n /usr/bin/mkpxeinitrd-net | grep 'include_bin_prog_from_server=' | awk '{print $1}')
modify_file="/usr/bin/mkpxeinitrd-net"
sed -i "${modify_line}c\include_bin_prog_from_server='sleep lspci insmod modprobe rmmod lsmod pkill strings brctl ip egrep awk gawk seq fgrep dirname expr'" $modify_file
sed -i "${modify_line}i# drbl-virt add" $modify_file
# patch it to copy modules
declare -i modify_line=$(cat -n /usr/bin/mkpxeinitrd-net | grep "# Deal with firmwares" | awk '{print $1}')
sed -i "${modify_line}i# drbl-virt add" $modify_file
modify_line=$modify_line+1
sed -i "${modify_line}icp -a --parents kernel/net/bridge/bridge.ko \$initrd/lib/modules/\$kernel_ver/" $modify_file
modify_line=$modify_line+1
sed -i "${modify_line}icp -a --parents kernel/drivers/xen/netback/netloop.ko \$initrd/lib/modules/\$kernel_ver/" $modify_file

# == Run Xen network-bridge in booting (/usr/lib/mkpxeinitrd-net/initrd-skel/linuxrc-or-init) ==
cat <<EOF >/usr/lib/mkpxeinitrd-net/initrd-skel/bin/start_xen_bridge.sh
# drbl-virt add
NICs=\$(/sbin/ifconfig | grep eth | awk '{print \$1}')
declare -i NICs_nu=\$(echo \$NICs |wc -l)
NIC=""

if [ \$NICs_nu -lt 1  ];
    for (( i=0 ; i<\$NICs_nu ; i++ ))
    do
        NIC_IP=\$(ifconfig eth\${i} | grep "inet addr" | sed 's/inet addr://g' | sed 's/Bcast.*$//g')
        if [ -n \$NIC_IP ]; then
            NIC="eth\${i}"
            break
        fi
    done
else
    NIC=\$NICS
fi

sh /bin/network-bridge start netdev=\$NIC
EOF
# backup
cp /usr/lib/mkpxeinitrd-net/initrd-skel/linuxrc-or-init /usr/lib/mkpxeinitrd-net/initrd-skel/linuxrc-or-init.drbl-virt_bak 
declare -i modify_line=$(cat -n /usr/lib/mkpxeinitrd-net/initrd-skel/linuxrc-or-init | grep "# clean the tag file" | awk '{print $1}')
modify_file="/usr/lib/mkpxeinitrd-net/initrd-skel/linuxrc-or-init"

sed -i "${modify_line}i# drbl-virt add" $modify_file
modify_line=$modify_line+1
sed -i "${modify_line}ish /bin/start_xen_bridge.sh" $modify_file


# = 3. Re-deploy drbl client =
# == Cheange Xen Kernel ==
echo "/opt/drbl/sbin/drblsrv-offline -s $Xen_Kernel"
/opt/drbl/sbin/drblsrv-offline -s $Xen_Kernel                                                                                                                        
echo ""
# == Re-delpoy drbl client ==
echo "Re-delpoy drbl client"
echo "/opt/drbl/sbin/drblpush -c /etc/drbl/drblpush.conf"
/opt/drbl/sbin/drblpush -c /etc/drbl/drblpush.conf
echo ""

