#!/bin/bash
# Program:
#  Remove DRBL virt module
# Author: 
#   Jazz, Rock {jazz, rock}@nchc.org.tw
# Version:
#    1.0
# History:                                                                                          
#   2010/07/20  Rock    First release (1.0) 

# [PATH]
Work_Path=$(dirname "$0")
PATH=${PATH}:$Work_Path

# [Source]
source funs_drbl_virt

# [Main]
check_systemInfo

case $Linux_Distribution in
    # for Ubuntu
    "Ubuntu")
        echo "Only support Debain"
    ;; 
    # for Debian
    "Debian")
        # check bit 
        echo $Linux_bit | grep 64                                                                                  
        if [ $? == 0 ]; then
            Linux_bit="amd64"
        else
            Linux_bit="686"
        fi  
                 
        # check version
        echo $Linux_Version | grep "^5"
        if [ $? == 0 ]; then
            hypervisior=check_hypervisior
            if [ $hypervisior == "Xen" ]; then
                aptitude remove xen-linux-system-2.6.26-2-xen-${Linux_bit} xen-tools
            else
                aptitude remove kvm
            fi
        fi  
    ;; 
    # for Fedora
    "Fedora")            
        echo "Only support Debain"
    ;; 
    *) 
        echo "Only support Debain"
    ;; 
esac

