#!/bin/bash
# Program:
#   DRBL virt module
# Author: 
#   Jazz, Rock {jazz, rock}@nchc.org.tw
# Version:
#    1.0
# History:
#   2010/07/20  Rock    First release (1.0)

# [Variable Declation]
cpu_flag="no"
Linux_bit=""
Linux_Distribution=""
Linux_Version=""
VMM_select=""

# [Check Root]
function check_root(){      
  if [ $USER != "root" ]; then
    echo "Please change user to root !!!"
    exit                   
  fi
} 

# [Check CPU support]
function cpu_check(){
egrep '(vmx|svm)' --color=always /proc/cpuinfo > /dev/null
if [ $? == 0 ]; then
    cpu_flag="yes"
fi
}

# [Check System Version]
function check_systemInfo(){
Linux_bit=$(uname -m)
Linux_Distribution=$(lsb_release -i | awk '{print $3}')
Linux_Version=$(lsb_release -r | awk '{print $2}')
}


function VMM_select(){
if [ $cpu_flag == "yes" ]; then
    while [ "$VMM_select" != "1" -a "$VMM_select" != "2"  ]
    do
       read -p "Which VMM/Hypervisior will be used in DRBL (1)Xen (2)KVM: " VMM_select
    done
else
    echo "Xen will be the only Hypervisior in your DRBL"
    echo -e "Because CPU don't support virtualization, \nit can't choose KVM to be the Hypervisior"
    VMM_select=2
fi  
}   

# [DRBL Check]

