; Script generated by the HM NIS Edit Script Wizard.

; HM NIS Edit Wizard helper defines
!define PRODUCT_NAME "DRBLLiveHelper"
!define PRODUCT_VERSION "0.0.2"
!define PRODUCT_PUBLISHER "NCHC"
!define PRODUCT_WEB_SITE "http://drbl.nchc.org.tw"
!define PRODUCT_DIR_REGKEY "Software\Microsoft\Windows\CurrentVersion\App Paths\DRBLLiveHelper.exe"
!define PRODUCT_UNINST_KEY "Software\Microsoft\Windows\CurrentVersion\Uninstall\${PRODUCT_NAME}"
!define PRODUCT_UNINST_ROOT_KEY "HKLM"
!define PRODUCT_STARTMENU_REGVAL "NSIS:StartMenuDir"

; MUI 1.67 compatible ------
!include "MUI.nsh"

; MUI Settings
!define MUI_ABORTWARNING
!define MUI_ICON "clonezilla_logo_transparent.ico"
!define MUI_UNICON "clonezilla_logo_transparent.ico"

; Language Selection Dialog Settings
!define MUI_LANGDLL_REGISTRY_ROOT "${PRODUCT_UNINST_ROOT_KEY}"
!define MUI_LANGDLL_REGISTRY_KEY "${PRODUCT_UNINST_KEY}"
!define MUI_LANGDLL_REGISTRY_VALUENAME "NSIS:Language"

; Welcome page
!insertmacro MUI_PAGE_WELCOME
; License page
!define MUI_LICENSEPAGE_CHECKBOX
!insertmacro MUI_PAGE_LICENSE "COPYING.txt"
; Components page
!insertmacro MUI_PAGE_COMPONENTS
; Directory page
!insertmacro MUI_PAGE_DIRECTORY
; Start menu page
var ICONS_GROUP
!define MUI_STARTMENUPAGE_NODISABLE
!define MUI_STARTMENUPAGE_DEFAULTFOLDER "DRBLLiveHelper"
!define MUI_STARTMENUPAGE_REGISTRY_ROOT "${PRODUCT_UNINST_ROOT_KEY}"
!define MUI_STARTMENUPAGE_REGISTRY_KEY "${PRODUCT_UNINST_KEY}"
!define MUI_STARTMENUPAGE_REGISTRY_VALUENAME "${PRODUCT_STARTMENU_REGVAL}"
!insertmacro MUI_PAGE_STARTMENU Application $ICONS_GROUP
; Instfiles page
!insertmacro MUI_PAGE_INSTFILES
; Finish page
!define MUI_FINISHPAGE_RUN "$INSTDIR\DRBLLiveHelper.exe"
!define MUI_FINISHPAGE_SHOWREADME "$INSTDIR\COPYING.txt"
!insertmacro MUI_PAGE_FINISH

; Uninstaller pages
!insertmacro MUI_UNPAGE_INSTFILES

; Language files
!insertmacro MUI_LANGUAGE "English"
;!insertmacro MUI_LANGUAGE "TradChinese"

; MUI end ------

Name "${PRODUCT_NAME} ${PRODUCT_VERSION}"
OutFile "DRBLLiveHelperSetup.exe"
InstallDir "$PROGRAMFILES\DRBLLiveHelper"
InstallDirRegKey HKLM "${PRODUCT_DIR_REGKEY}" ""
ShowInstDetails show
ShowUnInstDetails show

Function .onInit
  ;!insertmacro MUI_LANGDLL_DISPLAY
FunctionEnd

Section -Library ;-SEC01
  CreateDirectory "$INSTDIR\lib"
  SetOutPath "$INSTDIR\lib"
  SetOverwrite ifnewer
  File "lib\syslinux.exe"
  File "lib\7za.exe"

  CreateDirectory "$INSTDIR\languages"
  SetOutPath "$INSTDIR\languages"
  SetOverwrite ifnewer
  File "languages\Language.txt"
  File "languages\Language-en.txt"
  File "languages\Language-fr.txt"
  File "languages\Language-ja.txt"
  File "languages\Language-nl.txt"
  File "languages\Language-zh_tw.txt"
  
  SetOutPath "$INSTDIR"
  File "DRBLLiveHelper.exe"
  File "COPYING.txt"
  File "AUTHORS.txt"
  
  ;Exec 'RegSvr32 /s "$INSTDIR\Language404.dll"'
  ;RegDLL "$INSTDIR\Language404.dll"
; Shortcuts
  !insertmacro MUI_STARTMENU_WRITE_BEGIN Application
  CreateDirectory "$SMPROGRAMS\$ICONS_GROUP"
  CreateShortCut "$SMPROGRAMS\$ICONS_GROUP\DRBLLiveHelper.lnk" "$INSTDIR\DRBLLiveHelper.exe"
  CreateShortCut "$DESKTOP\DRBLLiveHelper.lnk" "$INSTDIR\DRBLLiveHelper.exe"
  !insertmacro MUI_STARTMENU_WRITE_END
SectionEnd

Section /o "Source" SEC02
  CreateDirectory "$INSTDIR\src"
  SetOutPath "$INSTDIR\src"
  File "RegkeyModule.bas"
  File "ReadyDialog.frx"
  File "ReadyDialog.frm"
  File "Project.vbw"
  File "Project.vbp"
  File "FormatPage.frm"
  File "FormatPage.frx"
  File "BootPage.frm"
  File "BootPage.frx"
  File "InstallPage.frm"
  File "InstallPage.frx"
  File "InstallHPDialog.frx"
  File "InstallHPDialog.frm"
  File "FTPModule.bas"
  File "FormatDialog.frx"
  File "FormatDialog.frm"
  File "CommonModule.bas"
  File "clonezilla_logo_transparent.ico"
  File "clonezilla_logo_transparent.gif"
  File "Internationalization.bas"
  File "COPYING.txt"
  File "AUTHORS.txt"
  File "FormatDialog.frm"
  File "FormatDialog.frx"
  File "LanguagePage.frm"
  File "LanguagePage.frx"
  File "MainModule.bas"
  File "InstallFM20.frm"
  File "InstallFM20.frx"
  
; Shortcuts
  !insertmacro MUI_STARTMENU_WRITE_BEGIN Application
  !insertmacro MUI_STARTMENU_WRITE_END
SectionEnd

Section -AdditionalIcons
  SetOutPath $INSTDIR
  !insertmacro MUI_STARTMENU_WRITE_BEGIN Application
  WriteIniStr "$INSTDIR\${PRODUCT_NAME}.url" "InternetShortcut" "URL" "${PRODUCT_WEB_SITE}"
  ;CreateShortCut "$SMPROGRAMS\$ICONS_GROUP\Website.lnk" "$INSTDIR\${PRODUCT_NAME}.url"
  CopyFiles "$INSTDIR\${PRODUCT_NAME}.url" "$SMPROGRAMS\$ICONS_GROUP\"
  CreateShortCut "$SMPROGRAMS\$ICONS_GROUP\Uninstall.lnk" "$INSTDIR\uninst.exe"
  
  !insertmacro MUI_STARTMENU_WRITE_END
SectionEnd

Section -Post
  WriteUninstaller "$INSTDIR\uninst.exe"
  WriteRegStr HKLM "${PRODUCT_DIR_REGKEY}" "" "$INSTDIR\DRBLLiveHelper.exe"
  WriteRegStr ${PRODUCT_UNINST_ROOT_KEY} "${PRODUCT_UNINST_KEY}" "DisplayName" "$(^Name)"
  WriteRegStr ${PRODUCT_UNINST_ROOT_KEY} "${PRODUCT_UNINST_KEY}" "UninstallString" "$INSTDIR\uninst.exe"
  WriteRegStr ${PRODUCT_UNINST_ROOT_KEY} "${PRODUCT_UNINST_KEY}" "DisplayIcon" "$INSTDIR\DRBLLiveHelper.exe"
  WriteRegStr ${PRODUCT_UNINST_ROOT_KEY} "${PRODUCT_UNINST_KEY}" "DisplayVersion" "${PRODUCT_VERSION}"
  WriteRegStr ${PRODUCT_UNINST_ROOT_KEY} "${PRODUCT_UNINST_KEY}" "URLInfoAbout" "${PRODUCT_WEB_SITE}"
  WriteRegStr ${PRODUCT_UNINST_ROOT_KEY} "${PRODUCT_UNINST_KEY}" "Publisher" "${PRODUCT_PUBLISHER}"
SectionEnd

; Section descriptions
!insertmacro MUI_FUNCTION_DESCRIPTION_BEGIN
  !insertmacro MUI_DESCRIPTION_TEXT ${SEC02} "Source Code"
!insertmacro MUI_FUNCTION_DESCRIPTION_END


Function un.onUninstSuccess
  HideWindow
  MessageBox MB_ICONINFORMATION|MB_OK "DRBLLiveHelper installer has been removed."
FunctionEnd

Function un.onInit
!insertmacro MUI_UNGETLANGUAGE
  MessageBox MB_ICONQUESTION|MB_YESNO|MB_DEFBUTTON2 "Do you really want to remove DRBLLiveHelper installer from your computerH" IDYES +2
  Abort
FunctionEnd

Section Uninstall
  !insertmacro MUI_STARTMENU_GETFOLDER "Application" $ICONS_GROUP
  UnRegDLL $INSTDIR\Language404.dll"
  Delete "$INSTDIR\${PRODUCT_NAME}.url"
  Delete "$INSTDIR\uninst.exe"
  Delete "$INSTDIR\src\COPYING.txt"
  Delete "$INSTDIR\src\AUTHORS.txt"
  Delete "$INSTDIR\src\clonezilla_logo_transparent.gif"
  Delete "$INSTDIR\src\clonezilla_logo_transparent.ico"
  Delete "$INSTDIR\src\CommonModule.bas"
  Delete "$INSTDIR\src\FormatPage.frm"
  Delete "$INSTDIR\src\FormatPage.frx"
  Delete "$INSTDIR\src\BootPage.frm"
  Delete "$INSTDIR\src\BootPage.frx"
  Delete "$INSTDIR\src\InstallPage.frm"
  Delete "$INSTDIR\src\InstallPage.frx"
  Delete "$INSTDIR\src\FormatDialog.frm"
  Delete "$INSTDIR\src\FormatDialog.frx"
  Delete "$INSTDIR\src\FTPModule.bas"
  Delete "$INSTDIR\src\InstallHPDialog.frm"
  Delete "$INSTDIR\src\InstallHPDialog.frx"
  Delete "$INSTDIR\src\Project.vbp"
  Delete "$INSTDIR\src\Project.vbw"
  Delete "$INSTDIR\src\ReadyDialog.frm"
  Delete "$INSTDIR\src\ReadyDialog.frx"
  Delete "$INSTDIR\src\RegkeyModule.bas"
  Delete "$INSTDIR\src\Internationalization.bas"
  Delete "$INSTDIR\src\MainModule.bas"
  Delete "$INSTDIR\src\InstallFM20.frm"
  Delete "$INSTDIR\src\InstallFM20.frx"
  Delete "$INSTDIR\COPYING.txt"
  Delete "$INSTDIR\AUTHORS.txt"
  Delete "$INSTDIR\DRBLLiveHelper.exe"
  Delete "$INSTDIR\lib\7za.exe"
  Delete "$INSTDIR\lib\syslinux.exe"
  Delete "$SMPROGRAMS\$ICONS_GROUP\Uninstall.lnk"
  Delete "$SMPROGRAMS\$ICONS_GROUP\${PRODUCT_NAME}.url"
  Delete "$DESKTOP\DRBLLiveHelper.lnk"
  Delete "$SMPROGRAMS\$ICONS_GROUP\DRBLLiveHelper.lnk"
  Delete "$INSTDIR\src\FormatDialog.frm"
  Delete "$INSTDIR\src\FormatDialog.frx"
  Delete "$INSTDIR\src\LanguagePage.frm"
  Delete "$INSTDIR\src\LanguagePage.frx"
  Delete "$INSTDIR\languages\Language.txt"
  Delete "$INSTDIR\languages\Language-en.txt"
  Delete "$INSTDIR\languages\Language-fr.txt"
  Delete "$INSTDIR\languages\Language-ja.txt"
  Delete "$INSTDIR\languages\Language-nl.txt"
  Delete "$INSTDIR\languages\Language-zh_tw.txt"

  RMDir "$SMPROGRAMS\$ICONS_GROUP"
  RMDir "$INSTDIR\src"
  RMDir "$INSTDIR\lib"
  RMDir "$INSTDIR\languages"
  RMDir "$INSTDIR"

  DeleteRegKey ${PRODUCT_UNINST_ROOT_KEY} "${PRODUCT_UNINST_KEY}"
  DeleteRegKey HKLM "${PRODUCT_DIR_REGKEY}"
  SetAutoClose true
SectionEnd