#!/bin/bash

biocluster_install()
{
#####################################################################
# 以下為基本程式設計與生資相關自由軟體
#####################################################################
########
# 安裝基本程式語言編譯環境
########
sudo apt-get -y install gcc g++ make autoconf build-essential
########
# 安裝 JDK 6 編譯環境
########
sudo apt-get -y install sun-java6-jdk
########
# 安裝 GNU R 相關套件
# (去除 rjava 與 rmpi 套件, 因為 rmpi 必須特別設定成使用 mpich2 )
########
sudo apt-get -y install r-base
sudo apt-get -y install `apt-cache search --names-only "^r-cran" | awk '{ print $1 }' | grep -v "r-cran-rjava" | grep -v "r-cran-rmpi" `
########
# 安裝 GNU R BioConductor 套件
########
if [ ! -e biocLite.R ]; then
  sudo wget http://www.bioconductor.org/biocLite.R
fi
if [ ! -e BioConductor.R ]; then
  cat > BioConductor.R << EOF
source(file="$(pwd)/biocLite.R")
biocLite()
EOF
  sudo R --no-save < BioConductor.R
fi
########
# 安裝 GNU R ape 套件
########
sudo apt-get -f install libc6-dev g77 gfortran liblapack-dev
if [ ! -e gee_4.13-14.tar.gz ]; then
  wget http://cran.r-project.org/src/contrib/gee_4.13-14.tar.gz
  sudo R CMD INSTALL gee_4.13-14.tar.gz
fi
if [ ! -e nlme_3.1-94.tar.gz ]; then
  wget http://cran.r-project.org/src/contrib/nlme_3.1-94.tar.gz
  sudo R CMD INSTALL nlme_3.1-94.tar.gz
fi
if [ ! -e lattice_0.17-25.tar.gz ]; then
  wget http://cran.r-project.org/src/contrib/lattice_0.17-25.tar.gz
  sudo R CMD INSTALL lattice_0.17-25.tar.gz
fi
if [ ! -e ape_2.3-2.tar.gz ]; then
  wget http://cran.r-project.org/src/contrib/ape_2.3-2.tar.gz
  sudo R CMD INSTALL ape_2.3-2.tar.gz
fi
#####################################################################
# 以下為叢集環境的需求
#####################################################################
########
# 安裝 MPICH2
########
if [ ! -e mpich2-1.0.8p1.tar.gz ]; then
  wget http://www.mcs.anl.gov/research/projects/mpich2/downloads/tarballs/1.0.8p1/mpich2-1.0.8p1.tar.gz
  tar zxvf mpich2-1.0.8p1.tar.gz
  cd mpich2-1.0.8p1
  ./configure CFLAGS="-fPIC" CXXFLAGS="-fPIC" FFLAGS="-fPIC" prefix=/opt/mpich2
  sudo make
  sudo make install
  cd ..
fi
########
# 安裝 openPBS / torque
########
if [ ! -e torque-2.3.6.tar.gz ]; then
  wget wget http://www.clusterresources.com/downloads/torque/torque-2.3.6.tar.gz
  tar zxvf torque-2.3.6.tar.gz
  cd torque-2.3.6/
  ./configure --prefix=/opt/torque
  sudo make
  sudo make install
  sudo /opt/torque/sbin/pbs_server -t create
  echo "$(hostname)" > nodes
  sudo mv nodes /var/spool/torque/server_priv/nodes
  echo "$(hostname)" > server_name
  sudo mv server_name /var/spool/torque/server_name
  cat > torque_conf << EOF
create queue batch
set queue batch queue_type = Execution
set queue batch started = True
set queue batch enabled = True
set server default_queue = batch
set server resources_default.nodes = 1
set server scheduling = True
set server acl_host_enable = True
set server acl_hosts = *
EOF
  sudo /opt/torque/bin/qmgr < torque_conf
  cat >> config << EOF
\$pbsserver    $(hostname)
\$logevent     255
EOF
  sudo mv config /var/spool/torque/mom_priv/jobs/config
  sudo /opt/torque/bin/qterm -t quick
  sudo /opt/torque/sbin/pbs_server
  sudo /opt/torque/sbin/pbs_sched
  sudo /opt/torque/sbin/pbs_mom
  sudo /opt/torque/bin/pbsnodes -a
  sudo cp contrib/init.d/debian.pbs_mom /etc/init.d/pbs_mom
  sudo cp contrib/init.d/debian.pbs_sched /etc/init.d/pbs_sched
  sudo cp contrib/init.d/debian.pbs_server /etc/init.d/pbs_server
  cd ..
fi

########
# 安裝 Lustre
########
if [ ! -e /etc/apt/sources.list.d/lustre.list ]; then
  sudo echo "deb http://www.pdsi-scidac.org/repository/debian testing main" > lustre.list
  sudo mv lustre.list /etc/apt/sources.list.d/lustre.list
  sudo apt-get update
  sudo apt-get -y --force-yes install pdsi-scidac-keyring
  sudo apt-get -y install linux-image-2.6.22.19-lustre-686 lustre-modules-2.6.22.19-lustre-686 lustre-utils 
fi
########
# 安裝 Ganglia 叢集監控系統
########
if [ ! -f /usr/sbin/gmond ] || [ ! -f /usr/sbin/gmetad ]; then
  echo "Installing Ganglia ...."
  sudo apt-get install gmetad ganglia-monitor
  sudo apt-get install rrdtool librrds-perl librrd2-dev apache2 libapache2-mod-php5 php5-gd apache2-mpm-prefork apache2-utils apache2.2-common libapr1 libaprutil1 libmysqlclient15off libpq5 mysql-common openssl-blacklist ssl-cert
  echo "deb http://free.nchc.org.tw/debian testing main" > testing.list
  sudo mv testing.list /etc/apt/sources.list.d/
  sudo apt-get update
  sudo apt-get install ganglia-webfrontend
  sudo rm /etc/apt/sources.list.d/testing.list
  sudo apt-get update
fi
#####################################################################
# 以下為叢集版本的生資相關軟體
#####################################################################
########
# 安裝 Rmpi
########
if [ ! -e Rmpi_0.5-7.tar.gz ]; then
  wget http://www.stats.uwo.ca/faculty/yu/Rmpi/download/linux/Rmpi_0.5-7.tar.gz
  sudo R CMD INSTALL Rmpi_0.5-7.tar.gz --configure-args=--with-mpi=/opt/mpich2
fi
########
# 安裝 mpiBLAST
# 參考 http://debianclusters.cs.uni.edu/index.php/Installing_mpiBLAST
########
sudo apt-get install csh
if [ ! -e mpiBLAST-1.5.0-pio.tgz ]; then
  wget http://www.mpiblast.org/downloads/files/mpiBLAST-1.5.0-pio.tgz
  tar zxvf mpiBLAST-1.5.0-pio.tgz
  cd mpiblast-1.5.0-pio
  ./ncbi/make/makedis.csh 2>&1|tee out.makedis.txt
  ./ncbi/make/makedis.csh 2>&1|tee out.makedis.txt
  ./ncbi/make/makedis.csh 2>&1|tee out.makedis.txt
  ./configure --prefix=/opt/mpiblast --with-mpi=/opt/mpich2 --with-ncbi=`pwd`/ncbi --enable-MPI_Alloc_mem
  sudo make
  sudo make install
  cd ..
fi

if [ ! -e mito.nt.gz ]; then
  wget ftp://ftp.ncbi.nlm.nih.gov/blast/db/FASTA/mito.nt.gz
fi

if [ ! -e add_path ]; then
  cat > add_path << EOF
echo "export PATH=\\\$PATH:/opt/torque/bin:/opt/mpich2/bin:/opt/mpiblast/bin" >> /etc/profile
EOF
  sudo sh add_path
fi
#####################################################################
# 電腦叢集的網頁監控機制
#####################################################################
########
# 安裝 wwwBLAST
########
if [ ! -e wwwblast-2.2.21-ia32-linux.tar.gz ]; then
  wget ftp://ftp.ncbi.nlm.nih.gov/blast/executables/LATEST/wwwblast-2.2.21-ia32-linux.tar.gz
  tar zxvf wwwblast-2.2.21-ia32-linux.tar.gz
fi
#####################################################################
# 安裝 DRBL
#####################################################################
if [ ! -e GPG-KEY-DRBL ]; then
  wget http://drbl.nchc.org.tw/GPG-KEY-DRBL
  sudo apt-key add GPG-KEY-DRBL
  echo "deb http://free.nchc.org.tw/drbl-core drbl stable" > drbl.list
  sudo mv drbl.list /etc/apt/sources.list.d/
  sudo apt-get update
  sudo apt-get install drbl
  sudo /opt/drbl/sbin/drblsrv -i
  sudo /opt/drbl/sbin/drblpush -i
fi
}

function biocluster_config()
{
########
# 設定 Torque
########
if [ -d /var/spool/torque/ ]; then
  for i in `sudo ls /tftpboot/nodes/`
  do 
    sudo cp -r /var/spool/torque /tftpboot/nodes/$i/var/spool/
  done
fi
}

if [ ! -e /etc/debian_version ]; then
  echo "本批次安裝檔目前僅適用 Debian 或 Ubuntu 系列，敬請見諒!!"
  exit 1
fi

case "$1" in
  clean)
    sudo rm -rf add_path ape_2.3-2.tar.gz biocLite.R BioConductor.R blast gee_4.13-14.tar.gz GPG-KEY-DRBL lattice_0.17-25.tar.gz mito.nt.gz mpiblast-1.5.0-pio mpiBLAST-1.5.0-pio.tgz mpich2-1.0.8p1 mpich2-1.0.8p1.tar.gz nlme_3.1-94.tar.gz Rmpi_0.5-7.tar.gz torque-2.3.6 torque-2.3.6.tar.gz wwwblast-2.2.21-ia32-linux.tar.gz
    exit 0;
    ;;
  install)
    biocluster_install
    ;;
  config)
    biocluster_config
    ;;
  *)
    echo "Usage: $0 [ install | config | clean ]"
    ;;
esac
