package edu.ntu.parallel.wc;

import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.IntWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapred.FileInputFormat;
import org.apache.hadoop.mapred.FileOutputFormat;
import org.apache.hadoop.mapred.JobClient;
import org.apache.hadoop.mapred.JobConf;

public class WordCounter {

	/**
	 * @param args
	 */
	public static void main(String[] args) {
		// TODO Auto-generated method stub
		JobClient job = new JobClient();
		JobConf conf = new JobConf(WordCounter.class);
		
		conf.setJobName("TK's Word Count");
		
		conf.setOutputKeyClass(Text.class);
		conf.setOutputValueClass(IntWritable.class);
		
		conf.setMapperClass(WordCountMapper.class);
		conf.setReducerClass(WordCountReducer.class);
		conf.setCombinerClass(WordCountReducer.class);
		
		FileInputFormat.setInputPaths(conf, "/data/test/input");
		FileOutputFormat.setOutputPath(conf, new Path("1/wc"));
		
		long start = System.nanoTime();
		job.setConf(conf);
		try{
			job.runJob(conf);
		}catch(Exception e){
			e.printStackTrace();
		}
		long duration = System.nanoTime() - start;
		System.err.println(duration/1E+9+" secs");
	}

}
