/*
 * Decompiled with CFR 0.152.
 */
package nchc.grep;

import nchc.grep.nchcgrepM;
import nchc.grep.nchcgrepR;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapred.FileInputFormat;
import org.apache.hadoop.mapred.FileOutputFormat;
import org.apache.hadoop.mapred.JobClient;
import org.apache.hadoop.mapred.JobConf;

public class nchcgrep {
    public static void main(String[] args) {
        if (args.length < 4) {
            System.out.println("nchcgrep <inDir> <outDir> <m> <r>");
            return;
        }
        JobConf conf = new JobConf(nchcgrep.class);
        conf.setJobName("NCHC grep");
        conf.setOutputKeyClass(Text.class);
        conf.setOutputValueClass(Text.class);
        conf.setMapperClass(nchcgrepM.class);
        conf.setReducerClass(nchcgrepR.class);
        conf.setCombinerClass(nchcgrepR.class);
        FileInputFormat.setInputPaths((JobConf)conf, (String)args[0]);
        FileOutputFormat.setOutputPath((JobConf)conf, (Path)new Path(args[1]));
        conf.setNumMapTasks(Integer.parseInt(args[2]));
        conf.setNumReduceTasks(Integer.parseInt(args[3]));
        long start = System.nanoTime();
        try {
            JobClient.runJob((JobConf)conf);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        long time = System.nanoTime() - start;
        System.err.println(String.valueOf((double)time / 1.0E9) + " sec");
    }
}

