﻿import java.io.IOException;

import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;


public class CheckAndDelete {
	// checkAndDelete函式，檢查是否存在該資料夾，若有則刪除之
	static boolean checkAndDelete(final String path, Configuration conf) {
		Path dst_path = new Path(path);
		try {
			// 產生操作hdfs的物件
			FileSystem hdfs = dst_path.getFileSystem(conf);
			// 檢查是否存在
			if (hdfs.exists(dst_path)) {
				// 有則刪除
				hdfs.delete(dst_path, true);
				
			}

		} catch (IOException e) {
			e.printStackTrace();
			return false;
		}
		return true;
	}
	static public void main(String args[]){
		Configuration conf = new Configuration();
		String path = "/user/waue/input";

		boolean status = checkAndDelete( path, conf);
		System.err.println("create? :" + status);
		
	}
}
