﻿import java.io.IOException;

import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;


public class PutToHdfs {
	// 將檔案從local上傳到 hdfs , src 為 local 的來源, dst 為 hdfs 的目的端
	static boolean putToHdfs(String src, String dst, Configuration conf) {
		Path dstPath = new Path(dst);
		try {
			// 產生操作hdfs的物件
			FileSystem hdfs = dstPath.getFileSystem(conf);
			// 上傳
			hdfs.copyFromLocalFile(false, new Path(src),new Path(dst));

		} catch (IOException e) {
			e.printStackTrace();
			return false;
		}
		return true;
	}
	static public void main(String args[]){
		Configuration conf = new Configuration();
		String src = "/home/waue/input";
		String dst = "/user/waue/program_put_input";
		boolean status = putToHdfs(src, dst, conf);
		System.err.println("create? :" + status);
		
	}
}
