﻿import java.io.IOException;

import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;


public class GetFromHdfs {
	// 將檔案從hdfs下載回local, src 為 hdfs的來源, dst 為 local 的目的端
	static boolean getFromHdfs(String src,String dst, Configuration conf) {
		Path dstPath = new Path(src);
		try {
			// 產生操作hdfs的物件
			FileSystem hdfs = dstPath.getFileSystem(conf);
			// 下載
			hdfs.copyToLocalFile(false, new Path(src),new Path(dst));
			
		} catch (IOException e) {
			e.printStackTrace();
			return false;
		}
		return true;
	}
	static public void main(String args[]){
		Configuration conf = new Configuration();
		String src = "/user/waue/input";
		String dst = "/home/waue/input";
		boolean status = getFromHdfs(src, dst, conf);
		System.err.println("create? :" + status);
		
	}
}
