/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * Autogenerated by Thrift
 *
 * DO NOT EDIT UNLESS YOU ARE SURE THAT YOU KNOW WHAT YOU ARE DOING
 */
package org.apache.hadoop.hbase.thrift.generated;

import java.util.List;
import java.util.ArrayList;
import java.util.Map;
import java.util.HashMap;
import java.util.Set;
import java.util.HashSet;
import com.facebook.thrift.*;

import com.facebook.thrift.protocol.*;
import com.facebook.thrift.transport.*;

public class Hbase {

  public interface Iface {

    /**
     * Brings a table on-line (enables it)
     * @param tableName name of the table
     */
    public void enableTable(byte[] tableName) throws IOError, TException;

    /**
     * Disables a table (takes it off-line) If it is being served, the master
     * will tell the servers to stop serving it.
     * @param tableName name of the table
     */
    public void disableTable(byte[] tableName) throws IOError, TException;

    /**
     * @param tableName name of table to check
     * @return true if table is on-line
     */
    public boolean isTableEnabled(byte[] tableName) throws IOError, TException;

    /**
     * List all the userspace tables.
     * @return - returns a list of names
     */
    public List<byte[]> getTableNames() throws IOError, TException;

    /**
     * List all the column families assoicated with a table.
     * @param tableName table name
     * @return list of column family descriptors
     */
    public Map<byte[],ColumnDescriptor> getColumnDescriptors(byte[] tableName) throws IOError, TException;

    /**
     * List the regions associated with a table.
     * @param tableName table name
     * @return list of region descriptors
     */
    public List<TRegionInfo> getTableRegions(byte[] tableName) throws IOError, TException;

    /**
     * Create a table with the specified column families.  The name
     * field for each ColumnDescriptor must be set and must end in a
     * colon (:).  All other fields are optional and will get default
     * values if not explicitly specified.
     * 
     * @param tableName name of table to create
     * @param columnFamilies list of column family descriptors
     * 
     * @throws IllegalArgument if an input parameter is invalid
     * @throws AlreadyExists if the table name already exists
     */
    public void createTable(byte[] tableName, List<ColumnDescriptor> columnFamilies) throws IOError, IllegalArgument, AlreadyExists, TException;

    /**
     * Deletes a table
     * @param tableName name of table to delete
     * @throws NotFound if table doesn't exist on server
     */
    public void deleteTable(byte[] tableName) throws IOError, NotFound, TException;

    /**
     * Get a single TCell for the specified table, row, and column at the
     * latest timestamp.
     * 
     * @param tableName name of table
     * @param row row key
     * @param column column name
     * @return value for specified row/column
     */
    public TCell get(byte[] tableName, byte[] row, byte[] column) throws IOError, NotFound, TException;

    /**
     * Get the specified number of versions for the specified table,
     * row, and column.
     * 
     * @param tableName name of table
     * @param row row key
     * @param column column name
     * @param numVersions number of versions to retrieve
     * @return list of cells for specified row/column
     */
    public List<TCell> getVer(byte[] tableName, byte[] row, byte[] column, int numVersions) throws IOError, NotFound, TException;

    /**
     * Get the specified number of versions for the specified table,
     * row, and column.  Only versions less than or equal to the specified
     * timestamp will be returned.
     * 
     * @param tableName name of table
     * @param row row key
     * @param column column name
     * @param timestamp timestamp
     * @param numVersions number of versions to retrieve
     * @return list of cells for specified row/column
     */
    public List<TCell> getVerTs(byte[] tableName, byte[] row, byte[] column, long timestamp, int numVersions) throws IOError, NotFound, TException;

    /**
     * Get all the data for the specified table and row at the latest
     * timestamp.
     * 
     * @param tableName name of table
     * @param row row key
     * @return TRowResult containing the row and map of columns to TCells. Map is empty if row does not exist.
     */
    public TRowResult getRow(byte[] tableName, byte[] row) throws IOError, TException;

    /**
     * Get all the data for the specified table and row at the specified
     * timestamp.
     * 
     * @param tableName of table
     * @param row row key
     * @param timestamp timestamp
     * @return TRowResult containing the row and map of columns to TCells. Map is empty if row does not exist.
     */
    public TRowResult getRowTs(byte[] tableName, byte[] row, long timestamp) throws IOError, TException;

    /**
     * Apply a series of mutations (updates/deletes) to a row in a
     * single transaction.  If an exception is thrown, then the
     * transaction is aborted.  Default current timestamp is used, and
     * all entries will have an identical timestamp.
     * 
     * @param tableName name of table
     * @param row row key
     * @param mutations list of mutation commands
     */
    public void mutateRow(byte[] tableName, byte[] row, List<Mutation> mutations) throws IOError, IllegalArgument, TException;

    /**
     * Apply a series of mutations (updates/deletes) to a row in a
     * single transaction.  If an exception is thrown, then the
     * transaction is aborted.  The specified timestamp is used, and
     * all entries will have an identical timestamp.
     * 
     * @param tableName name of table
     * @param row row key
     * @param mutations list of mutation commands
     * @param timestamp timestamp
     */
    public void mutateRowTs(byte[] tableName, byte[] row, List<Mutation> mutations, long timestamp) throws IOError, IllegalArgument, TException;

    /**
     * Apply a series of batches (each a series of mutations on a single row)
     * in a single transaction.  If an exception is thrown, then the
     * transaction is aborted.  Default current timestamp is used, and
     * all entries will have an identical timestamp.
     * 
     * @param tableName name of table
     * @param rowBatches list of row batches
     */
    public void mutateRows(byte[] tableName, List<BatchMutation> rowBatches) throws IOError, IllegalArgument, TException;

    /**
     * Apply a series of batches (each a series of mutations on a single row)
     * in a single transaction.  If an exception is thrown, then the
     * transaction is aborted.  The specified timestamp is used, and
     * all entries will have an identical timestamp.
     * 
     * @param tableName name of table
     * @param rowBatches list of row batches
     * @param timestamp timestamp
     */
    public void mutateRowsTs(byte[] tableName, List<BatchMutation> rowBatches, long timestamp) throws IOError, IllegalArgument, TException;

    /**
     * Delete all cells that match the passed row and column.
     * 
     * @param tableName name of table
     * @param row Row to update
     * @param column name of column whose value is to be deleted
     */
    public void deleteAll(byte[] tableName, byte[] row, byte[] column) throws IOError, TException;

    /**
     * Delete all cells that match the passed row and column and whose
     * timestamp is equal-to or older than the passed timestamp.
     * 
     * @param tableName name of table
     * @param row Row to update
     * @param column name of column whose value is to be deleted
     * @param timestamp timestamp
     */
    public void deleteAllTs(byte[] tableName, byte[] row, byte[] column, long timestamp) throws IOError, TException;

    /**
     * Completely delete the row's cells.
     * 
     * @param tableName name of table
     * @param row key of the row to be completely deleted.
     */
    public void deleteAllRow(byte[] tableName, byte[] row) throws IOError, TException;

    /**
     * Completely delete the row's cells marked with a timestamp
     * equal-to or older than the passed timestamp.
     * 
     * @param tableName name of table
     * @param row key of the row to be completely deleted.
     * @param timestamp timestamp
     */
    public void deleteAllRowTs(byte[] tableName, byte[] row, long timestamp) throws IOError, TException;

    /**
     * Get a scanner on the current table starting at the specified row and
     * ending at the last row in the table.  Return the specified columns.
     * 
     * @param columns columns to scan. If column name is a column family, all
     * columns of the specified column family are returned.  Its also possible
     * to pass a regex in the column qualifier.
     * @param tableName name of table
     * @param startRow starting row in table to scan.  send "" (empty string) to
     *                 start at the first row.
     * 
     * @return scanner id to be used with other scanner procedures
     */
    public int scannerOpen(byte[] tableName, byte[] startRow, List<byte[]> columns) throws IOError, TException;

    /**
     * Get a scanner on the current table starting and stopping at the
     * specified rows.  ending at the last row in the table.  Return the
     * specified columns.
     * 
     * @param columns columns to scan. If column name is a column family, all
     * columns of the specified column family are returned.  Its also possible
     * to pass a regex in the column qualifier.
     * @param tableName name of table
     * @param startRow starting row in table to scan.  send "" (empty string) to
     *                 start at the first row.
     * @param stopRow row to stop scanning on.  This row is *not* included in the
     *                scanner's results
     * 
     * @return scanner id to be used with other scanner procedures
     */
    public int scannerOpenWithStop(byte[] tableName, byte[] startRow, byte[] stopRow, List<byte[]> columns) throws IOError, TException;

    /**
     * Get a scanner on the current table starting at the specified row and
     * ending at the last row in the table.  Return the specified columns.
     * Only values with the specified timestamp are returned.
     * 
     * @param columns columns to scan. If column name is a column family, all
     * columns of the specified column family are returned.  Its also possible
     * to pass a regex in the column qualifier.
     * @param tableName name of table
     * @param startRow starting row in table to scan.  send "" (empty string) to
     *                 start at the first row.
     * @param timestamp timestamp
     * 
     * @return scanner id to be used with other scanner procedures
     */
    public int scannerOpenTs(byte[] tableName, byte[] startRow, List<byte[]> columns, long timestamp) throws IOError, TException;

    /**
     * Get a scanner on the current table starting and stopping at the
     * specified rows.  ending at the last row in the table.  Return the
     * specified columns.  Only values with the specified timestamp are
     * returned.
     * 
     * @param columns columns to scan. If column name is a column family, all
     * columns of the specified column family are returned.  Its also possible
     * to pass a regex in the column qualifier.
     * @param tableName name of table
     * @param startRow starting row in table to scan.  send "" (empty string) to
     *                 start at the first row.
     * @param stopRow row to stop scanning on.  This row is *not* included
     *                in the scanner's results
     * @param timestamp timestamp
     * 
     * @return scanner id to be used with other scanner procedures
     */
    public int scannerOpenWithStopTs(byte[] tableName, byte[] startRow, byte[] stopRow, List<byte[]> columns, long timestamp) throws IOError, TException;

    /**
     * Returns the scanner's current row value and advances to the next
     * row in the table.  When there are no more rows in the table, or a key
     * greater-than-or-equal-to the scanner's specified stopRow is reached,
     * a NotFound exception is returned.
     * 
     * @param id id of a scanner returned by scannerOpen
     * @return a TRowResult containing the current row and a map of the columns to TCells.
     * @throws IllegalArgument if ScannerID is invalid
     * @throws NotFound when the scanner reaches the end
     */
    public TRowResult scannerGet(int id) throws IOError, IllegalArgument, NotFound, TException;

    /**
     * Closes the server-state associated with an open scanner.
     * 
     * @param id id of a scanner returned by scannerOpen
     * @throws IllegalArgument if ScannerID is invalid
     */
    public void scannerClose(int id) throws IOError, IllegalArgument, TException;

  }

  public static class Client implements Iface {
    public Client(TProtocol prot)
    {
      this(prot, prot);
    }

    public Client(TProtocol iprot, TProtocol oprot)
    {
      iprot_ = iprot;
      oprot_ = oprot;
    }

    protected TProtocol iprot_;
    protected TProtocol oprot_;

    protected int seqid_;

    public TProtocol getInputProtocol()
    {
      return this.iprot_;
    }

    public TProtocol getOutputProtocol()
    {
      return this.oprot_;
    }

    public void enableTable(byte[] tableName) throws IOError, TException
    {
      send_enableTable(tableName);
      recv_enableTable();
    }

    public void send_enableTable(byte[] tableName) throws TException
    {
      oprot_.writeMessageBegin(new TMessage("enableTable", TMessageType.CALL, seqid_));
      enableTable_args args = new enableTable_args();
      args.tableName = tableName;
      args.write(oprot_);
      oprot_.writeMessageEnd();
      oprot_.getTransport().flush();
    }

    public void recv_enableTable() throws IOError, TException
    {
      TMessage msg = iprot_.readMessageBegin();
      if (msg.type == TMessageType.EXCEPTION) {
        TApplicationException x = TApplicationException.read(iprot_);
        iprot_.readMessageEnd();
        throw x;
      }
      enableTable_result result = new enableTable_result();
      result.read(iprot_);
      iprot_.readMessageEnd();
      if (result.__isset.io) {
        throw result.io;
      }
      return;
    }

    public void disableTable(byte[] tableName) throws IOError, TException
    {
      send_disableTable(tableName);
      recv_disableTable();
    }

    public void send_disableTable(byte[] tableName) throws TException
    {
      oprot_.writeMessageBegin(new TMessage("disableTable", TMessageType.CALL, seqid_));
      disableTable_args args = new disableTable_args();
      args.tableName = tableName;
      args.write(oprot_);
      oprot_.writeMessageEnd();
      oprot_.getTransport().flush();
    }

    public void recv_disableTable() throws IOError, TException
    {
      TMessage msg = iprot_.readMessageBegin();
      if (msg.type == TMessageType.EXCEPTION) {
        TApplicationException x = TApplicationException.read(iprot_);
        iprot_.readMessageEnd();
        throw x;
      }
      disableTable_result result = new disableTable_result();
      result.read(iprot_);
      iprot_.readMessageEnd();
      if (result.__isset.io) {
        throw result.io;
      }
      return;
    }

    public boolean isTableEnabled(byte[] tableName) throws IOError, TException
    {
      send_isTableEnabled(tableName);
      return recv_isTableEnabled();
    }

    public void send_isTableEnabled(byte[] tableName) throws TException
    {
      oprot_.writeMessageBegin(new TMessage("isTableEnabled", TMessageType.CALL, seqid_));
      isTableEnabled_args args = new isTableEnabled_args();
      args.tableName = tableName;
      args.write(oprot_);
      oprot_.writeMessageEnd();
      oprot_.getTransport().flush();
    }

    public boolean recv_isTableEnabled() throws IOError, TException
    {
      TMessage msg = iprot_.readMessageBegin();
      if (msg.type == TMessageType.EXCEPTION) {
        TApplicationException x = TApplicationException.read(iprot_);
        iprot_.readMessageEnd();
        throw x;
      }
      isTableEnabled_result result = new isTableEnabled_result();
      result.read(iprot_);
      iprot_.readMessageEnd();
      if (result.__isset.success) {
        return result.success;
      }
      if (result.__isset.io) {
        throw result.io;
      }
      throw new TApplicationException(TApplicationException.MISSING_RESULT, "isTableEnabled failed: unknown result");
    }

    public List<byte[]> getTableNames() throws IOError, TException
    {
      send_getTableNames();
      return recv_getTableNames();
    }

    public void send_getTableNames() throws TException
    {
      oprot_.writeMessageBegin(new TMessage("getTableNames", TMessageType.CALL, seqid_));
      getTableNames_args args = new getTableNames_args();
      args.write(oprot_);
      oprot_.writeMessageEnd();
      oprot_.getTransport().flush();
    }

    public List<byte[]> recv_getTableNames() throws IOError, TException
    {
      TMessage msg = iprot_.readMessageBegin();
      if (msg.type == TMessageType.EXCEPTION) {
        TApplicationException x = TApplicationException.read(iprot_);
        iprot_.readMessageEnd();
        throw x;
      }
      getTableNames_result result = new getTableNames_result();
      result.read(iprot_);
      iprot_.readMessageEnd();
      if (result.__isset.success) {
        return result.success;
      }
      if (result.__isset.io) {
        throw result.io;
      }
      throw new TApplicationException(TApplicationException.MISSING_RESULT, "getTableNames failed: unknown result");
    }

    public Map<byte[],ColumnDescriptor> getColumnDescriptors(byte[] tableName) throws IOError, TException
    {
      send_getColumnDescriptors(tableName);
      return recv_getColumnDescriptors();
    }

    public void send_getColumnDescriptors(byte[] tableName) throws TException
    {
      oprot_.writeMessageBegin(new TMessage("getColumnDescriptors", TMessageType.CALL, seqid_));
      getColumnDescriptors_args args = new getColumnDescriptors_args();
      args.tableName = tableName;
      args.write(oprot_);
      oprot_.writeMessageEnd();
      oprot_.getTransport().flush();
    }

    public Map<byte[],ColumnDescriptor> recv_getColumnDescriptors() throws IOError, TException
    {
      TMessage msg = iprot_.readMessageBegin();
      if (msg.type == TMessageType.EXCEPTION) {
        TApplicationException x = TApplicationException.read(iprot_);
        iprot_.readMessageEnd();
        throw x;
      }
      getColumnDescriptors_result result = new getColumnDescriptors_result();
      result.read(iprot_);
      iprot_.readMessageEnd();
      if (result.__isset.success) {
        return result.success;
      }
      if (result.__isset.io) {
        throw result.io;
      }
      throw new TApplicationException(TApplicationException.MISSING_RESULT, "getColumnDescriptors failed: unknown result");
    }

    public List<TRegionInfo> getTableRegions(byte[] tableName) throws IOError, TException
    {
      send_getTableRegions(tableName);
      return recv_getTableRegions();
    }

    public void send_getTableRegions(byte[] tableName) throws TException
    {
      oprot_.writeMessageBegin(new TMessage("getTableRegions", TMessageType.CALL, seqid_));
      getTableRegions_args args = new getTableRegions_args();
      args.tableName = tableName;
      args.write(oprot_);
      oprot_.writeMessageEnd();
      oprot_.getTransport().flush();
    }

    public List<TRegionInfo> recv_getTableRegions() throws IOError, TException
    {
      TMessage msg = iprot_.readMessageBegin();
      if (msg.type == TMessageType.EXCEPTION) {
        TApplicationException x = TApplicationException.read(iprot_);
        iprot_.readMessageEnd();
        throw x;
      }
      getTableRegions_result result = new getTableRegions_result();
      result.read(iprot_);
      iprot_.readMessageEnd();
      if (result.__isset.success) {
        return result.success;
      }
      if (result.__isset.io) {
        throw result.io;
      }
      throw new TApplicationException(TApplicationException.MISSING_RESULT, "getTableRegions failed: unknown result");
    }

    public void createTable(byte[] tableName, List<ColumnDescriptor> columnFamilies) throws IOError, IllegalArgument, AlreadyExists, TException
    {
      send_createTable(tableName, columnFamilies);
      recv_createTable();
    }

    public void send_createTable(byte[] tableName, List<ColumnDescriptor> columnFamilies) throws TException
    {
      oprot_.writeMessageBegin(new TMessage("createTable", TMessageType.CALL, seqid_));
      createTable_args args = new createTable_args();
      args.tableName = tableName;
      args.columnFamilies = columnFamilies;
      args.write(oprot_);
      oprot_.writeMessageEnd();
      oprot_.getTransport().flush();
    }

    public void recv_createTable() throws IOError, IllegalArgument, AlreadyExists, TException
    {
      TMessage msg = iprot_.readMessageBegin();
      if (msg.type == TMessageType.EXCEPTION) {
        TApplicationException x = TApplicationException.read(iprot_);
        iprot_.readMessageEnd();
        throw x;
      }
      createTable_result result = new createTable_result();
      result.read(iprot_);
      iprot_.readMessageEnd();
      if (result.__isset.io) {
        throw result.io;
      }
      if (result.__isset.ia) {
        throw result.ia;
      }
      if (result.__isset.exist) {
        throw result.exist;
      }
      return;
    }

    public void deleteTable(byte[] tableName) throws IOError, NotFound, TException
    {
      send_deleteTable(tableName);
      recv_deleteTable();
    }

    public void send_deleteTable(byte[] tableName) throws TException
    {
      oprot_.writeMessageBegin(new TMessage("deleteTable", TMessageType.CALL, seqid_));
      deleteTable_args args = new deleteTable_args();
      args.tableName = tableName;
      args.write(oprot_);
      oprot_.writeMessageEnd();
      oprot_.getTransport().flush();
    }

    public void recv_deleteTable() throws IOError, NotFound, TException
    {
      TMessage msg = iprot_.readMessageBegin();
      if (msg.type == TMessageType.EXCEPTION) {
        TApplicationException x = TApplicationException.read(iprot_);
        iprot_.readMessageEnd();
        throw x;
      }
      deleteTable_result result = new deleteTable_result();
      result.read(iprot_);
      iprot_.readMessageEnd();
      if (result.__isset.io) {
        throw result.io;
      }
      if (result.__isset.nf) {
        throw result.nf;
      }
      return;
    }

    public TCell get(byte[] tableName, byte[] row, byte[] column) throws IOError, NotFound, TException
    {
      send_get(tableName, row, column);
      return recv_get();
    }

    public void send_get(byte[] tableName, byte[] row, byte[] column) throws TException
    {
      oprot_.writeMessageBegin(new TMessage("get", TMessageType.CALL, seqid_));
      get_args args = new get_args();
      args.tableName = tableName;
      args.row = row;
      args.column = column;
      args.write(oprot_);
      oprot_.writeMessageEnd();
      oprot_.getTransport().flush();
    }

    public TCell recv_get() throws IOError, NotFound, TException
    {
      TMessage msg = iprot_.readMessageBegin();
      if (msg.type == TMessageType.EXCEPTION) {
        TApplicationException x = TApplicationException.read(iprot_);
        iprot_.readMessageEnd();
        throw x;
      }
      get_result result = new get_result();
      result.read(iprot_);
      iprot_.readMessageEnd();
      if (result.__isset.success) {
        return result.success;
      }
      if (result.__isset.io) {
        throw result.io;
      }
      if (result.__isset.nf) {
        throw result.nf;
      }
      throw new TApplicationException(TApplicationException.MISSING_RESULT, "get failed: unknown result");
    }

    public List<TCell> getVer(byte[] tableName, byte[] row, byte[] column, int numVersions) throws IOError, NotFound, TException
    {
      send_getVer(tableName, row, column, numVersions);
      return recv_getVer();
    }

    public void send_getVer(byte[] tableName, byte[] row, byte[] column, int numVersions) throws TException
    {
      oprot_.writeMessageBegin(new TMessage("getVer", TMessageType.CALL, seqid_));
      getVer_args args = new getVer_args();
      args.tableName = tableName;
      args.row = row;
      args.column = column;
      args.numVersions = numVersions;
      args.write(oprot_);
      oprot_.writeMessageEnd();
      oprot_.getTransport().flush();
    }

    public List<TCell> recv_getVer() throws IOError, NotFound, TException
    {
      TMessage msg = iprot_.readMessageBegin();
      if (msg.type == TMessageType.EXCEPTION) {
        TApplicationException x = TApplicationException.read(iprot_);
        iprot_.readMessageEnd();
        throw x;
      }
      getVer_result result = new getVer_result();
      result.read(iprot_);
      iprot_.readMessageEnd();
      if (result.__isset.success) {
        return result.success;
      }
      if (result.__isset.io) {
        throw result.io;
      }
      if (result.__isset.nf) {
        throw result.nf;
      }
      throw new TApplicationException(TApplicationException.MISSING_RESULT, "getVer failed: unknown result");
    }

    public List<TCell> getVerTs(byte[] tableName, byte[] row, byte[] column, long timestamp, int numVersions) throws IOError, NotFound, TException
    {
      send_getVerTs(tableName, row, column, timestamp, numVersions);
      return recv_getVerTs();
    }

    public void send_getVerTs(byte[] tableName, byte[] row, byte[] column, long timestamp, int numVersions) throws TException
    {
      oprot_.writeMessageBegin(new TMessage("getVerTs", TMessageType.CALL, seqid_));
      getVerTs_args args = new getVerTs_args();
      args.tableName = tableName;
      args.row = row;
      args.column = column;
      args.timestamp = timestamp;
      args.numVersions = numVersions;
      args.write(oprot_);
      oprot_.writeMessageEnd();
      oprot_.getTransport().flush();
    }

    public List<TCell> recv_getVerTs() throws IOError, NotFound, TException
    {
      TMessage msg = iprot_.readMessageBegin();
      if (msg.type == TMessageType.EXCEPTION) {
        TApplicationException x = TApplicationException.read(iprot_);
        iprot_.readMessageEnd();
        throw x;
      }
      getVerTs_result result = new getVerTs_result();
      result.read(iprot_);
      iprot_.readMessageEnd();
      if (result.__isset.success) {
        return result.success;
      }
      if (result.__isset.io) {
        throw result.io;
      }
      if (result.__isset.nf) {
        throw result.nf;
      }
      throw new TApplicationException(TApplicationException.MISSING_RESULT, "getVerTs failed: unknown result");
    }

    public TRowResult getRow(byte[] tableName, byte[] row) throws IOError, TException
    {
      send_getRow(tableName, row);
      return recv_getRow();
    }

    public void send_getRow(byte[] tableName, byte[] row) throws TException
    {
      oprot_.writeMessageBegin(new TMessage("getRow", TMessageType.CALL, seqid_));
      getRow_args args = new getRow_args();
      args.tableName = tableName;
      args.row = row;
      args.write(oprot_);
      oprot_.writeMessageEnd();
      oprot_.getTransport().flush();
    }

    public TRowResult recv_getRow() throws IOError, TException
    {
      TMessage msg = iprot_.readMessageBegin();
      if (msg.type == TMessageType.EXCEPTION) {
        TApplicationException x = TApplicationException.read(iprot_);
        iprot_.readMessageEnd();
        throw x;
      }
      getRow_result result = new getRow_result();
      result.read(iprot_);
      iprot_.readMessageEnd();
      if (result.__isset.success) {
        return result.success;
      }
      if (result.__isset.io) {
        throw result.io;
      }
      throw new TApplicationException(TApplicationException.MISSING_RESULT, "getRow failed: unknown result");
    }

    public TRowResult getRowTs(byte[] tableName, byte[] row, long timestamp) throws IOError, TException
    {
      send_getRowTs(tableName, row, timestamp);
      return recv_getRowTs();
    }

    public void send_getRowTs(byte[] tableName, byte[] row, long timestamp) throws TException
    {
      oprot_.writeMessageBegin(new TMessage("getRowTs", TMessageType.CALL, seqid_));
      getRowTs_args args = new getRowTs_args();
      args.tableName = tableName;
      args.row = row;
      args.timestamp = timestamp;
      args.write(oprot_);
      oprot_.writeMessageEnd();
      oprot_.getTransport().flush();
    }

    public TRowResult recv_getRowTs() throws IOError, TException
    {
      TMessage msg = iprot_.readMessageBegin();
      if (msg.type == TMessageType.EXCEPTION) {
        TApplicationException x = TApplicationException.read(iprot_);
        iprot_.readMessageEnd();
        throw x;
      }
      getRowTs_result result = new getRowTs_result();
      result.read(iprot_);
      iprot_.readMessageEnd();
      if (result.__isset.success) {
        return result.success;
      }
      if (result.__isset.io) {
        throw result.io;
      }
      throw new TApplicationException(TApplicationException.MISSING_RESULT, "getRowTs failed: unknown result");
    }

    public void mutateRow(byte[] tableName, byte[] row, List<Mutation> mutations) throws IOError, IllegalArgument, TException
    {
      send_mutateRow(tableName, row, mutations);
      recv_mutateRow();
    }

    public void send_mutateRow(byte[] tableName, byte[] row, List<Mutation> mutations) throws TException
    {
      oprot_.writeMessageBegin(new TMessage("mutateRow", TMessageType.CALL, seqid_));
      mutateRow_args args = new mutateRow_args();
      args.tableName = tableName;
      args.row = row;
      args.mutations = mutations;
      args.write(oprot_);
      oprot_.writeMessageEnd();
      oprot_.getTransport().flush();
    }

    public void recv_mutateRow() throws IOError, IllegalArgument, TException
    {
      TMessage msg = iprot_.readMessageBegin();
      if (msg.type == TMessageType.EXCEPTION) {
        TApplicationException x = TApplicationException.read(iprot_);
        iprot_.readMessageEnd();
        throw x;
      }
      mutateRow_result result = new mutateRow_result();
      result.read(iprot_);
      iprot_.readMessageEnd();
      if (result.__isset.io) {
        throw result.io;
      }
      if (result.__isset.ia) {
        throw result.ia;
      }
      return;
    }

    public void mutateRowTs(byte[] tableName, byte[] row, List<Mutation> mutations, long timestamp) throws IOError, IllegalArgument, TException
    {
      send_mutateRowTs(tableName, row, mutations, timestamp);
      recv_mutateRowTs();
    }

    public void send_mutateRowTs(byte[] tableName, byte[] row, List<Mutation> mutations, long timestamp) throws TException
    {
      oprot_.writeMessageBegin(new TMessage("mutateRowTs", TMessageType.CALL, seqid_));
      mutateRowTs_args args = new mutateRowTs_args();
      args.tableName = tableName;
      args.row = row;
      args.mutations = mutations;
      args.timestamp = timestamp;
      args.write(oprot_);
      oprot_.writeMessageEnd();
      oprot_.getTransport().flush();
    }

    public void recv_mutateRowTs() throws IOError, IllegalArgument, TException
    {
      TMessage msg = iprot_.readMessageBegin();
      if (msg.type == TMessageType.EXCEPTION) {
        TApplicationException x = TApplicationException.read(iprot_);
        iprot_.readMessageEnd();
        throw x;
      }
      mutateRowTs_result result = new mutateRowTs_result();
      result.read(iprot_);
      iprot_.readMessageEnd();
      if (result.__isset.io) {
        throw result.io;
      }
      if (result.__isset.ia) {
        throw result.ia;
      }
      return;
    }

    public void mutateRows(byte[] tableName, List<BatchMutation> rowBatches) throws IOError, IllegalArgument, TException
    {
      send_mutateRows(tableName, rowBatches);
      recv_mutateRows();
    }

    public void send_mutateRows(byte[] tableName, List<BatchMutation> rowBatches) throws TException
    {
      oprot_.writeMessageBegin(new TMessage("mutateRows", TMessageType.CALL, seqid_));
      mutateRows_args args = new mutateRows_args();
      args.tableName = tableName;
      args.rowBatches = rowBatches;
      args.write(oprot_);
      oprot_.writeMessageEnd();
      oprot_.getTransport().flush();
    }

    public void recv_mutateRows() throws IOError, IllegalArgument, TException
    {
      TMessage msg = iprot_.readMessageBegin();
      if (msg.type == TMessageType.EXCEPTION) {
        TApplicationException x = TApplicationException.read(iprot_);
        iprot_.readMessageEnd();
        throw x;
      }
      mutateRows_result result = new mutateRows_result();
      result.read(iprot_);
      iprot_.readMessageEnd();
      if (result.__isset.io) {
        throw result.io;
      }
      if (result.__isset.ia) {
        throw result.ia;
      }
      return;
    }

    public void mutateRowsTs(byte[] tableName, List<BatchMutation> rowBatches, long timestamp) throws IOError, IllegalArgument, TException
    {
      send_mutateRowsTs(tableName, rowBatches, timestamp);
      recv_mutateRowsTs();
    }

    public void send_mutateRowsTs(byte[] tableName, List<BatchMutation> rowBatches, long timestamp) throws TException
    {
      oprot_.writeMessageBegin(new TMessage("mutateRowsTs", TMessageType.CALL, seqid_));
      mutateRowsTs_args args = new mutateRowsTs_args();
      args.tableName = tableName;
      args.rowBatches = rowBatches;
      args.timestamp = timestamp;
      args.write(oprot_);
      oprot_.writeMessageEnd();
      oprot_.getTransport().flush();
    }

    public void recv_mutateRowsTs() throws IOError, IllegalArgument, TException
    {
      TMessage msg = iprot_.readMessageBegin();
      if (msg.type == TMessageType.EXCEPTION) {
        TApplicationException x = TApplicationException.read(iprot_);
        iprot_.readMessageEnd();
        throw x;
      }
      mutateRowsTs_result result = new mutateRowsTs_result();
      result.read(iprot_);
      iprot_.readMessageEnd();
      if (result.__isset.io) {
        throw result.io;
      }
      if (result.__isset.ia) {
        throw result.ia;
      }
      return;
    }

    public void deleteAll(byte[] tableName, byte[] row, byte[] column) throws IOError, TException
    {
      send_deleteAll(tableName, row, column);
      recv_deleteAll();
    }

    public void send_deleteAll(byte[] tableName, byte[] row, byte[] column) throws TException
    {
      oprot_.writeMessageBegin(new TMessage("deleteAll", TMessageType.CALL, seqid_));
      deleteAll_args args = new deleteAll_args();
      args.tableName = tableName;
      args.row = row;
      args.column = column;
      args.write(oprot_);
      oprot_.writeMessageEnd();
      oprot_.getTransport().flush();
    }

    public void recv_deleteAll() throws IOError, TException
    {
      TMessage msg = iprot_.readMessageBegin();
      if (msg.type == TMessageType.EXCEPTION) {
        TApplicationException x = TApplicationException.read(iprot_);
        iprot_.readMessageEnd();
        throw x;
      }
      deleteAll_result result = new deleteAll_result();
      result.read(iprot_);
      iprot_.readMessageEnd();
      if (result.__isset.io) {
        throw result.io;
      }
      return;
    }

    public void deleteAllTs(byte[] tableName, byte[] row, byte[] column, long timestamp) throws IOError, TException
    {
      send_deleteAllTs(tableName, row, column, timestamp);
      recv_deleteAllTs();
    }

    public void send_deleteAllTs(byte[] tableName, byte[] row, byte[] column, long timestamp) throws TException
    {
      oprot_.writeMessageBegin(new TMessage("deleteAllTs", TMessageType.CALL, seqid_));
      deleteAllTs_args args = new deleteAllTs_args();
      args.tableName = tableName;
      args.row = row;
      args.column = column;
      args.timestamp = timestamp;
      args.write(oprot_);
      oprot_.writeMessageEnd();
      oprot_.getTransport().flush();
    }

    public void recv_deleteAllTs() throws IOError, TException
    {
      TMessage msg = iprot_.readMessageBegin();
      if (msg.type == TMessageType.EXCEPTION) {
        TApplicationException x = TApplicationException.read(iprot_);
        iprot_.readMessageEnd();
        throw x;
      }
      deleteAllTs_result result = new deleteAllTs_result();
      result.read(iprot_);
      iprot_.readMessageEnd();
      if (result.__isset.io) {
        throw result.io;
      }
      return;
    }

    public void deleteAllRow(byte[] tableName, byte[] row) throws IOError, TException
    {
      send_deleteAllRow(tableName, row);
      recv_deleteAllRow();
    }

    public void send_deleteAllRow(byte[] tableName, byte[] row) throws TException
    {
      oprot_.writeMessageBegin(new TMessage("deleteAllRow", TMessageType.CALL, seqid_));
      deleteAllRow_args args = new deleteAllRow_args();
      args.tableName = tableName;
      args.row = row;
      args.write(oprot_);
      oprot_.writeMessageEnd();
      oprot_.getTransport().flush();
    }

    public void recv_deleteAllRow() throws IOError, TException
    {
      TMessage msg = iprot_.readMessageBegin();
      if (msg.type == TMessageType.EXCEPTION) {
        TApplicationException x = TApplicationException.read(iprot_);
        iprot_.readMessageEnd();
        throw x;
      }
      deleteAllRow_result result = new deleteAllRow_result();
      result.read(iprot_);
      iprot_.readMessageEnd();
      if (result.__isset.io) {
        throw result.io;
      }
      return;
    }

    public void deleteAllRowTs(byte[] tableName, byte[] row, long timestamp) throws IOError, TException
    {
      send_deleteAllRowTs(tableName, row, timestamp);
      recv_deleteAllRowTs();
    }

    public void send_deleteAllRowTs(byte[] tableName, byte[] row, long timestamp) throws TException
    {
      oprot_.writeMessageBegin(new TMessage("deleteAllRowTs", TMessageType.CALL, seqid_));
      deleteAllRowTs_args args = new deleteAllRowTs_args();
      args.tableName = tableName;
      args.row = row;
      args.timestamp = timestamp;
      args.write(oprot_);
      oprot_.writeMessageEnd();
      oprot_.getTransport().flush();
    }

    public void recv_deleteAllRowTs() throws IOError, TException
    {
      TMessage msg = iprot_.readMessageBegin();
      if (msg.type == TMessageType.EXCEPTION) {
        TApplicationException x = TApplicationException.read(iprot_);
        iprot_.readMessageEnd();
        throw x;
      }
      deleteAllRowTs_result result = new deleteAllRowTs_result();
      result.read(iprot_);
      iprot_.readMessageEnd();
      if (result.__isset.io) {
        throw result.io;
      }
      return;
    }

    public int scannerOpen(byte[] tableName, byte[] startRow, List<byte[]> columns) throws IOError, TException
    {
      send_scannerOpen(tableName, startRow, columns);
      return recv_scannerOpen();
    }

    public void send_scannerOpen(byte[] tableName, byte[] startRow, List<byte[]> columns) throws TException
    {
      oprot_.writeMessageBegin(new TMessage("scannerOpen", TMessageType.CALL, seqid_));
      scannerOpen_args args = new scannerOpen_args();
      args.tableName = tableName;
      args.startRow = startRow;
      args.columns = columns;
      args.write(oprot_);
      oprot_.writeMessageEnd();
      oprot_.getTransport().flush();
    }

    public int recv_scannerOpen() throws IOError, TException
    {
      TMessage msg = iprot_.readMessageBegin();
      if (msg.type == TMessageType.EXCEPTION) {
        TApplicationException x = TApplicationException.read(iprot_);
        iprot_.readMessageEnd();
        throw x;
      }
      scannerOpen_result result = new scannerOpen_result();
      result.read(iprot_);
      iprot_.readMessageEnd();
      if (result.__isset.success) {
        return result.success;
      }
      if (result.__isset.io) {
        throw result.io;
      }
      throw new TApplicationException(TApplicationException.MISSING_RESULT, "scannerOpen failed: unknown result");
    }

    public int scannerOpenWithStop(byte[] tableName, byte[] startRow, byte[] stopRow, List<byte[]> columns) throws IOError, TException
    {
      send_scannerOpenWithStop(tableName, startRow, stopRow, columns);
      return recv_scannerOpenWithStop();
    }

    public void send_scannerOpenWithStop(byte[] tableName, byte[] startRow, byte[] stopRow, List<byte[]> columns) throws TException
    {
      oprot_.writeMessageBegin(new TMessage("scannerOpenWithStop", TMessageType.CALL, seqid_));
      scannerOpenWithStop_args args = new scannerOpenWithStop_args();
      args.tableName = tableName;
      args.startRow = startRow;
      args.stopRow = stopRow;
      args.columns = columns;
      args.write(oprot_);
      oprot_.writeMessageEnd();
      oprot_.getTransport().flush();
    }

    public int recv_scannerOpenWithStop() throws IOError, TException
    {
      TMessage msg = iprot_.readMessageBegin();
      if (msg.type == TMessageType.EXCEPTION) {
        TApplicationException x = TApplicationException.read(iprot_);
        iprot_.readMessageEnd();
        throw x;
      }
      scannerOpenWithStop_result result = new scannerOpenWithStop_result();
      result.read(iprot_);
      iprot_.readMessageEnd();
      if (result.__isset.success) {
        return result.success;
      }
      if (result.__isset.io) {
        throw result.io;
      }
      throw new TApplicationException(TApplicationException.MISSING_RESULT, "scannerOpenWithStop failed: unknown result");
    }

    public int scannerOpenTs(byte[] tableName, byte[] startRow, List<byte[]> columns, long timestamp) throws IOError, TException
    {
      send_scannerOpenTs(tableName, startRow, columns, timestamp);
      return recv_scannerOpenTs();
    }

    public void send_scannerOpenTs(byte[] tableName, byte[] startRow, List<byte[]> columns, long timestamp) throws TException
    {
      oprot_.writeMessageBegin(new TMessage("scannerOpenTs", TMessageType.CALL, seqid_));
      scannerOpenTs_args args = new scannerOpenTs_args();
      args.tableName = tableName;
      args.startRow = startRow;
      args.columns = columns;
      args.timestamp = timestamp;
      args.write(oprot_);
      oprot_.writeMessageEnd();
      oprot_.getTransport().flush();
    }

    public int recv_scannerOpenTs() throws IOError, TException
    {
      TMessage msg = iprot_.readMessageBegin();
      if (msg.type == TMessageType.EXCEPTION) {
        TApplicationException x = TApplicationException.read(iprot_);
        iprot_.readMessageEnd();
        throw x;
      }
      scannerOpenTs_result result = new scannerOpenTs_result();
      result.read(iprot_);
      iprot_.readMessageEnd();
      if (result.__isset.success) {
        return result.success;
      }
      if (result.__isset.io) {
        throw result.io;
      }
      throw new TApplicationException(TApplicationException.MISSING_RESULT, "scannerOpenTs failed: unknown result");
    }

    public int scannerOpenWithStopTs(byte[] tableName, byte[] startRow, byte[] stopRow, List<byte[]> columns, long timestamp) throws IOError, TException
    {
      send_scannerOpenWithStopTs(tableName, startRow, stopRow, columns, timestamp);
      return recv_scannerOpenWithStopTs();
    }

    public void send_scannerOpenWithStopTs(byte[] tableName, byte[] startRow, byte[] stopRow, List<byte[]> columns, long timestamp) throws TException
    {
      oprot_.writeMessageBegin(new TMessage("scannerOpenWithStopTs", TMessageType.CALL, seqid_));
      scannerOpenWithStopTs_args args = new scannerOpenWithStopTs_args();
      args.tableName = tableName;
      args.startRow = startRow;
      args.stopRow = stopRow;
      args.columns = columns;
      args.timestamp = timestamp;
      args.write(oprot_);
      oprot_.writeMessageEnd();
      oprot_.getTransport().flush();
    }

    public int recv_scannerOpenWithStopTs() throws IOError, TException
    {
      TMessage msg = iprot_.readMessageBegin();
      if (msg.type == TMessageType.EXCEPTION) {
        TApplicationException x = TApplicationException.read(iprot_);
        iprot_.readMessageEnd();
        throw x;
      }
      scannerOpenWithStopTs_result result = new scannerOpenWithStopTs_result();
      result.read(iprot_);
      iprot_.readMessageEnd();
      if (result.__isset.success) {
        return result.success;
      }
      if (result.__isset.io) {
        throw result.io;
      }
      throw new TApplicationException(TApplicationException.MISSING_RESULT, "scannerOpenWithStopTs failed: unknown result");
    }

    public TRowResult scannerGet(int id) throws IOError, IllegalArgument, NotFound, TException
    {
      send_scannerGet(id);
      return recv_scannerGet();
    }

    public void send_scannerGet(int id) throws TException
    {
      oprot_.writeMessageBegin(new TMessage("scannerGet", TMessageType.CALL, seqid_));
      scannerGet_args args = new scannerGet_args();
      args.id = id;
      args.write(oprot_);
      oprot_.writeMessageEnd();
      oprot_.getTransport().flush();
    }

    public TRowResult recv_scannerGet() throws IOError, IllegalArgument, NotFound, TException
    {
      TMessage msg = iprot_.readMessageBegin();
      if (msg.type == TMessageType.EXCEPTION) {
        TApplicationException x = TApplicationException.read(iprot_);
        iprot_.readMessageEnd();
        throw x;
      }
      scannerGet_result result = new scannerGet_result();
      result.read(iprot_);
      iprot_.readMessageEnd();
      if (result.__isset.success) {
        return result.success;
      }
      if (result.__isset.io) {
        throw result.io;
      }
      if (result.__isset.ia) {
        throw result.ia;
      }
      if (result.__isset.nf) {
        throw result.nf;
      }
      throw new TApplicationException(TApplicationException.MISSING_RESULT, "scannerGet failed: unknown result");
    }

    public void scannerClose(int id) throws IOError, IllegalArgument, TException
    {
      send_scannerClose(id);
      recv_scannerClose();
    }

    public void send_scannerClose(int id) throws TException
    {
      oprot_.writeMessageBegin(new TMessage("scannerClose", TMessageType.CALL, seqid_));
      scannerClose_args args = new scannerClose_args();
      args.id = id;
      args.write(oprot_);
      oprot_.writeMessageEnd();
      oprot_.getTransport().flush();
    }

    public void recv_scannerClose() throws IOError, IllegalArgument, TException
    {
      TMessage msg = iprot_.readMessageBegin();
      if (msg.type == TMessageType.EXCEPTION) {
        TApplicationException x = TApplicationException.read(iprot_);
        iprot_.readMessageEnd();
        throw x;
      }
      scannerClose_result result = new scannerClose_result();
      result.read(iprot_);
      iprot_.readMessageEnd();
      if (result.__isset.io) {
        throw result.io;
      }
      if (result.__isset.ia) {
        throw result.ia;
      }
      return;
    }

  }
  public static class Processor implements TProcessor {
    public Processor(Iface iface)
    {
      iface_ = iface;
      processMap_.put("enableTable", new enableTable());
      processMap_.put("disableTable", new disableTable());
      processMap_.put("isTableEnabled", new isTableEnabled());
      processMap_.put("getTableNames", new getTableNames());
      processMap_.put("getColumnDescriptors", new getColumnDescriptors());
      processMap_.put("getTableRegions", new getTableRegions());
      processMap_.put("createTable", new createTable());
      processMap_.put("deleteTable", new deleteTable());
      processMap_.put("get", new get());
      processMap_.put("getVer", new getVer());
      processMap_.put("getVerTs", new getVerTs());
      processMap_.put("getRow", new getRow());
      processMap_.put("getRowTs", new getRowTs());
      processMap_.put("mutateRow", new mutateRow());
      processMap_.put("mutateRowTs", new mutateRowTs());
      processMap_.put("mutateRows", new mutateRows());
      processMap_.put("mutateRowsTs", new mutateRowsTs());
      processMap_.put("deleteAll", new deleteAll());
      processMap_.put("deleteAllTs", new deleteAllTs());
      processMap_.put("deleteAllRow", new deleteAllRow());
      processMap_.put("deleteAllRowTs", new deleteAllRowTs());
      processMap_.put("scannerOpen", new scannerOpen());
      processMap_.put("scannerOpenWithStop", new scannerOpenWithStop());
      processMap_.put("scannerOpenTs", new scannerOpenTs());
      processMap_.put("scannerOpenWithStopTs", new scannerOpenWithStopTs());
      processMap_.put("scannerGet", new scannerGet());
      processMap_.put("scannerClose", new scannerClose());
    }

    protected static interface ProcessFunction {
      public void process(int seqid, TProtocol iprot, TProtocol oprot) throws TException;
    }

    private Iface iface_;
    protected final HashMap<String,ProcessFunction> processMap_ = new HashMap<String,ProcessFunction>();

    public boolean process(TProtocol iprot, TProtocol oprot) throws TException
    {
      TMessage msg = iprot.readMessageBegin();
      ProcessFunction fn = processMap_.get(msg.name);
      if (fn == null) {
        TProtocolUtil.skip(iprot, TType.STRUCT);
        iprot.readMessageEnd();
        TApplicationException x = new TApplicationException(TApplicationException.UNKNOWN_METHOD, "Invalid method name: '"+msg.name+"'");
        oprot.writeMessageBegin(new TMessage(msg.name, TMessageType.EXCEPTION, msg.seqid));
        x.write(oprot);
        oprot.writeMessageEnd();
        oprot.getTransport().flush();
        return true;
      }
      fn.process(msg.seqid, iprot, oprot);
      return true;
    }

    private class enableTable implements ProcessFunction {
      public void process(int seqid, TProtocol iprot, TProtocol oprot) throws TException
      {
        enableTable_args args = new enableTable_args();
        args.read(iprot);
        iprot.readMessageEnd();
        enableTable_result result = new enableTable_result();
        try {
          iface_.enableTable(args.tableName);
        } catch (IOError io) {
          result.io = io;
          result.__isset.io = true;
        }
        oprot.writeMessageBegin(new TMessage("enableTable", TMessageType.REPLY, seqid));
        result.write(oprot);
        oprot.writeMessageEnd();
        oprot.getTransport().flush();
      }

    }

    private class disableTable implements ProcessFunction {
      public void process(int seqid, TProtocol iprot, TProtocol oprot) throws TException
      {
        disableTable_args args = new disableTable_args();
        args.read(iprot);
        iprot.readMessageEnd();
        disableTable_result result = new disableTable_result();
        try {
          iface_.disableTable(args.tableName);
        } catch (IOError io) {
          result.io = io;
          result.__isset.io = true;
        }
        oprot.writeMessageBegin(new TMessage("disableTable", TMessageType.REPLY, seqid));
        result.write(oprot);
        oprot.writeMessageEnd();
        oprot.getTransport().flush();
      }

    }

    private class isTableEnabled implements ProcessFunction {
      public void process(int seqid, TProtocol iprot, TProtocol oprot) throws TException
      {
        isTableEnabled_args args = new isTableEnabled_args();
        args.read(iprot);
        iprot.readMessageEnd();
        isTableEnabled_result result = new isTableEnabled_result();
        try {
          result.success = iface_.isTableEnabled(args.tableName);
          result.__isset.success = true;
        } catch (IOError io) {
          result.io = io;
          result.__isset.io = true;
        }
        oprot.writeMessageBegin(new TMessage("isTableEnabled", TMessageType.REPLY, seqid));
        result.write(oprot);
        oprot.writeMessageEnd();
        oprot.getTransport().flush();
      }

    }

    private class getTableNames implements ProcessFunction {
      public void process(int seqid, TProtocol iprot, TProtocol oprot) throws TException
      {
        getTableNames_args args = new getTableNames_args();
        args.read(iprot);
        iprot.readMessageEnd();
        getTableNames_result result = new getTableNames_result();
        try {
          result.success = iface_.getTableNames();
          result.__isset.success = true;
        } catch (IOError io) {
          result.io = io;
          result.__isset.io = true;
        }
        oprot.writeMessageBegin(new TMessage("getTableNames", TMessageType.REPLY, seqid));
        result.write(oprot);
        oprot.writeMessageEnd();
        oprot.getTransport().flush();
      }

    }

    private class getColumnDescriptors implements ProcessFunction {
      public void process(int seqid, TProtocol iprot, TProtocol oprot) throws TException
      {
        getColumnDescriptors_args args = new getColumnDescriptors_args();
        args.read(iprot);
        iprot.readMessageEnd();
        getColumnDescriptors_result result = new getColumnDescriptors_result();
        try {
          result.success = iface_.getColumnDescriptors(args.tableName);
          result.__isset.success = true;
        } catch (IOError io) {
          result.io = io;
          result.__isset.io = true;
        }
        oprot.writeMessageBegin(new TMessage("getColumnDescriptors", TMessageType.REPLY, seqid));
        result.write(oprot);
        oprot.writeMessageEnd();
        oprot.getTransport().flush();
      }

    }

    private class getTableRegions implements ProcessFunction {
      public void process(int seqid, TProtocol iprot, TProtocol oprot) throws TException
      {
        getTableRegions_args args = new getTableRegions_args();
        args.read(iprot);
        iprot.readMessageEnd();
        getTableRegions_result result = new getTableRegions_result();
        try {
          result.success = iface_.getTableRegions(args.tableName);
          result.__isset.success = true;
        } catch (IOError io) {
          result.io = io;
          result.__isset.io = true;
        }
        oprot.writeMessageBegin(new TMessage("getTableRegions", TMessageType.REPLY, seqid));
        result.write(oprot);
        oprot.writeMessageEnd();
        oprot.getTransport().flush();
      }

    }

    private class createTable implements ProcessFunction {
      public void process(int seqid, TProtocol iprot, TProtocol oprot) throws TException
      {
        createTable_args args = new createTable_args();
        args.read(iprot);
        iprot.readMessageEnd();
        createTable_result result = new createTable_result();
        try {
          iface_.createTable(args.tableName, args.columnFamilies);
        } catch (IOError io) {
          result.io = io;
          result.__isset.io = true;
        } catch (IllegalArgument ia) {
          result.ia = ia;
          result.__isset.ia = true;
        } catch (AlreadyExists exist) {
          result.exist = exist;
          result.__isset.exist = true;
        }
        oprot.writeMessageBegin(new TMessage("createTable", TMessageType.REPLY, seqid));
        result.write(oprot);
        oprot.writeMessageEnd();
        oprot.getTransport().flush();
      }

    }

    private class deleteTable implements ProcessFunction {
      public void process(int seqid, TProtocol iprot, TProtocol oprot) throws TException
      {
        deleteTable_args args = new deleteTable_args();
        args.read(iprot);
        iprot.readMessageEnd();
        deleteTable_result result = new deleteTable_result();
        try {
          iface_.deleteTable(args.tableName);
        } catch (IOError io) {
          result.io = io;
          result.__isset.io = true;
        } catch (NotFound nf) {
          result.nf = nf;
          result.__isset.nf = true;
        }
        oprot.writeMessageBegin(new TMessage("deleteTable", TMessageType.REPLY, seqid));
        result.write(oprot);
        oprot.writeMessageEnd();
        oprot.getTransport().flush();
      }

    }

    private class get implements ProcessFunction {
      public void process(int seqid, TProtocol iprot, TProtocol oprot) throws TException
      {
        get_args args = new get_args();
        args.read(iprot);
        iprot.readMessageEnd();
        get_result result = new get_result();
        try {
          result.success = iface_.get(args.tableName, args.row, args.column);
          result.__isset.success = true;
        } catch (IOError io) {
          result.io = io;
          result.__isset.io = true;
        } catch (NotFound nf) {
          result.nf = nf;
          result.__isset.nf = true;
        }
        oprot.writeMessageBegin(new TMessage("get", TMessageType.REPLY, seqid));
        result.write(oprot);
        oprot.writeMessageEnd();
        oprot.getTransport().flush();
      }

    }

    private class getVer implements ProcessFunction {
      public void process(int seqid, TProtocol iprot, TProtocol oprot) throws TException
      {
        getVer_args args = new getVer_args();
        args.read(iprot);
        iprot.readMessageEnd();
        getVer_result result = new getVer_result();
        try {
          result.success = iface_.getVer(args.tableName, args.row, args.column, args.numVersions);
          result.__isset.success = true;
        } catch (IOError io) {
          result.io = io;
          result.__isset.io = true;
        } catch (NotFound nf) {
          result.nf = nf;
          result.__isset.nf = true;
        }
        oprot.writeMessageBegin(new TMessage("getVer", TMessageType.REPLY, seqid));
        result.write(oprot);
        oprot.writeMessageEnd();
        oprot.getTransport().flush();
      }

    }

    private class getVerTs implements ProcessFunction {
      public void process(int seqid, TProtocol iprot, TProtocol oprot) throws TException
      {
        getVerTs_args args = new getVerTs_args();
        args.read(iprot);
        iprot.readMessageEnd();
        getVerTs_result result = new getVerTs_result();
        try {
          result.success = iface_.getVerTs(args.tableName, args.row, args.column, args.timestamp, args.numVersions);
          result.__isset.success = true;
        } catch (IOError io) {
          result.io = io;
          result.__isset.io = true;
        } catch (NotFound nf) {
          result.nf = nf;
          result.__isset.nf = true;
        }
        oprot.writeMessageBegin(new TMessage("getVerTs", TMessageType.REPLY, seqid));
        result.write(oprot);
        oprot.writeMessageEnd();
        oprot.getTransport().flush();
      }

    }

    private class getRow implements ProcessFunction {
      public void process(int seqid, TProtocol iprot, TProtocol oprot) throws TException
      {
        getRow_args args = new getRow_args();
        args.read(iprot);
        iprot.readMessageEnd();
        getRow_result result = new getRow_result();
        try {
          result.success = iface_.getRow(args.tableName, args.row);
          result.__isset.success = true;
        } catch (IOError io) {
          result.io = io;
          result.__isset.io = true;
        }
        oprot.writeMessageBegin(new TMessage("getRow", TMessageType.REPLY, seqid));
        result.write(oprot);
        oprot.writeMessageEnd();
        oprot.getTransport().flush();
      }

    }

    private class getRowTs implements ProcessFunction {
      public void process(int seqid, TProtocol iprot, TProtocol oprot) throws TException
      {
        getRowTs_args args = new getRowTs_args();
        args.read(iprot);
        iprot.readMessageEnd();
        getRowTs_result result = new getRowTs_result();
        try {
          result.success = iface_.getRowTs(args.tableName, args.row, args.timestamp);
          result.__isset.success = true;
        } catch (IOError io) {
          result.io = io;
          result.__isset.io = true;
        }
        oprot.writeMessageBegin(new TMessage("getRowTs", TMessageType.REPLY, seqid));
        result.write(oprot);
        oprot.writeMessageEnd();
        oprot.getTransport().flush();
      }

    }

    private class mutateRow implements ProcessFunction {
      public void process(int seqid, TProtocol iprot, TProtocol oprot) throws TException
      {
        mutateRow_args args = new mutateRow_args();
        args.read(iprot);
        iprot.readMessageEnd();
        mutateRow_result result = new mutateRow_result();
        try {
          iface_.mutateRow(args.tableName, args.row, args.mutations);
        } catch (IOError io) {
          result.io = io;
          result.__isset.io = true;
        } catch (IllegalArgument ia) {
          result.ia = ia;
          result.__isset.ia = true;
        }
        oprot.writeMessageBegin(new TMessage("mutateRow", TMessageType.REPLY, seqid));
        result.write(oprot);
        oprot.writeMessageEnd();
        oprot.getTransport().flush();
      }

    }

    private class mutateRowTs implements ProcessFunction {
      public void process(int seqid, TProtocol iprot, TProtocol oprot) throws TException
      {
        mutateRowTs_args args = new mutateRowTs_args();
        args.read(iprot);
        iprot.readMessageEnd();
        mutateRowTs_result result = new mutateRowTs_result();
        try {
          iface_.mutateRowTs(args.tableName, args.row, args.mutations, args.timestamp);
        } catch (IOError io) {
          result.io = io;
          result.__isset.io = true;
        } catch (IllegalArgument ia) {
          result.ia = ia;
          result.__isset.ia = true;
        }
        oprot.writeMessageBegin(new TMessage("mutateRowTs", TMessageType.REPLY, seqid));
        result.write(oprot);
        oprot.writeMessageEnd();
        oprot.getTransport().flush();
      }

    }

    private class mutateRows implements ProcessFunction {
      public void process(int seqid, TProtocol iprot, TProtocol oprot) throws TException
      {
        mutateRows_args args = new mutateRows_args();
        args.read(iprot);
        iprot.readMessageEnd();
        mutateRows_result result = new mutateRows_result();
        try {
          iface_.mutateRows(args.tableName, args.rowBatches);
        } catch (IOError io) {
          result.io = io;
          result.__isset.io = true;
        } catch (IllegalArgument ia) {
          result.ia = ia;
          result.__isset.ia = true;
        }
        oprot.writeMessageBegin(new TMessage("mutateRows", TMessageType.REPLY, seqid));
        result.write(oprot);
        oprot.writeMessageEnd();
        oprot.getTransport().flush();
      }

    }

    private class mutateRowsTs implements ProcessFunction {
      public void process(int seqid, TProtocol iprot, TProtocol oprot) throws TException
      {
        mutateRowsTs_args args = new mutateRowsTs_args();
        args.read(iprot);
        iprot.readMessageEnd();
        mutateRowsTs_result result = new mutateRowsTs_result();
        try {
          iface_.mutateRowsTs(args.tableName, args.rowBatches, args.timestamp);
        } catch (IOError io) {
          result.io = io;
          result.__isset.io = true;
        } catch (IllegalArgument ia) {
          result.ia = ia;
          result.__isset.ia = true;
        }
        oprot.writeMessageBegin(new TMessage("mutateRowsTs", TMessageType.REPLY, seqid));
        result.write(oprot);
        oprot.writeMessageEnd();
        oprot.getTransport().flush();
      }

    }

    private class deleteAll implements ProcessFunction {
      public void process(int seqid, TProtocol iprot, TProtocol oprot) throws TException
      {
        deleteAll_args args = new deleteAll_args();
        args.read(iprot);
        iprot.readMessageEnd();
        deleteAll_result result = new deleteAll_result();
        try {
          iface_.deleteAll(args.tableName, args.row, args.column);
        } catch (IOError io) {
          result.io = io;
          result.__isset.io = true;
        }
        oprot.writeMessageBegin(new TMessage("deleteAll", TMessageType.REPLY, seqid));
        result.write(oprot);
        oprot.writeMessageEnd();
        oprot.getTransport().flush();
      }

    }

    private class deleteAllTs implements ProcessFunction {
      public void process(int seqid, TProtocol iprot, TProtocol oprot) throws TException
      {
        deleteAllTs_args args = new deleteAllTs_args();
        args.read(iprot);
        iprot.readMessageEnd();
        deleteAllTs_result result = new deleteAllTs_result();
        try {
          iface_.deleteAllTs(args.tableName, args.row, args.column, args.timestamp);
        } catch (IOError io) {
          result.io = io;
          result.__isset.io = true;
        }
        oprot.writeMessageBegin(new TMessage("deleteAllTs", TMessageType.REPLY, seqid));
        result.write(oprot);
        oprot.writeMessageEnd();
        oprot.getTransport().flush();
      }

    }

    private class deleteAllRow implements ProcessFunction {
      public void process(int seqid, TProtocol iprot, TProtocol oprot) throws TException
      {
        deleteAllRow_args args = new deleteAllRow_args();
        args.read(iprot);
        iprot.readMessageEnd();
        deleteAllRow_result result = new deleteAllRow_result();
        try {
          iface_.deleteAllRow(args.tableName, args.row);
        } catch (IOError io) {
          result.io = io;
          result.__isset.io = true;
        }
        oprot.writeMessageBegin(new TMessage("deleteAllRow", TMessageType.REPLY, seqid));
        result.write(oprot);
        oprot.writeMessageEnd();
        oprot.getTransport().flush();
      }

    }

    private class deleteAllRowTs implements ProcessFunction {
      public void process(int seqid, TProtocol iprot, TProtocol oprot) throws TException
      {
        deleteAllRowTs_args args = new deleteAllRowTs_args();
        args.read(iprot);
        iprot.readMessageEnd();
        deleteAllRowTs_result result = new deleteAllRowTs_result();
        try {
          iface_.deleteAllRowTs(args.tableName, args.row, args.timestamp);
        } catch (IOError io) {
          result.io = io;
          result.__isset.io = true;
        }
        oprot.writeMessageBegin(new TMessage("deleteAllRowTs", TMessageType.REPLY, seqid));
        result.write(oprot);
        oprot.writeMessageEnd();
        oprot.getTransport().flush();
      }

    }

    private class scannerOpen implements ProcessFunction {
      public void process(int seqid, TProtocol iprot, TProtocol oprot) throws TException
      {
        scannerOpen_args args = new scannerOpen_args();
        args.read(iprot);
        iprot.readMessageEnd();
        scannerOpen_result result = new scannerOpen_result();
        try {
          result.success = iface_.scannerOpen(args.tableName, args.startRow, args.columns);
          result.__isset.success = true;
        } catch (IOError io) {
          result.io = io;
          result.__isset.io = true;
        }
        oprot.writeMessageBegin(new TMessage("scannerOpen", TMessageType.REPLY, seqid));
        result.write(oprot);
        oprot.writeMessageEnd();
        oprot.getTransport().flush();
      }

    }

    private class scannerOpenWithStop implements ProcessFunction {
      public void process(int seqid, TProtocol iprot, TProtocol oprot) throws TException
      {
        scannerOpenWithStop_args args = new scannerOpenWithStop_args();
        args.read(iprot);
        iprot.readMessageEnd();
        scannerOpenWithStop_result result = new scannerOpenWithStop_result();
        try {
          result.success = iface_.scannerOpenWithStop(args.tableName, args.startRow, args.stopRow, args.columns);
          result.__isset.success = true;
        } catch (IOError io) {
          result.io = io;
          result.__isset.io = true;
        }
        oprot.writeMessageBegin(new TMessage("scannerOpenWithStop", TMessageType.REPLY, seqid));
        result.write(oprot);
        oprot.writeMessageEnd();
        oprot.getTransport().flush();
      }

    }

    private class scannerOpenTs implements ProcessFunction {
      public void process(int seqid, TProtocol iprot, TProtocol oprot) throws TException
      {
        scannerOpenTs_args args = new scannerOpenTs_args();
        args.read(iprot);
        iprot.readMessageEnd();
        scannerOpenTs_result result = new scannerOpenTs_result();
        try {
          result.success = iface_.scannerOpenTs(args.tableName, args.startRow, args.columns, args.timestamp);
          result.__isset.success = true;
        } catch (IOError io) {
          result.io = io;
          result.__isset.io = true;
        }
        oprot.writeMessageBegin(new TMessage("scannerOpenTs", TMessageType.REPLY, seqid));
        result.write(oprot);
        oprot.writeMessageEnd();
        oprot.getTransport().flush();
      }

    }

    private class scannerOpenWithStopTs implements ProcessFunction {
      public void process(int seqid, TProtocol iprot, TProtocol oprot) throws TException
      {
        scannerOpenWithStopTs_args args = new scannerOpenWithStopTs_args();
        args.read(iprot);
        iprot.readMessageEnd();
        scannerOpenWithStopTs_result result = new scannerOpenWithStopTs_result();
        try {
          result.success = iface_.scannerOpenWithStopTs(args.tableName, args.startRow, args.stopRow, args.columns, args.timestamp);
          result.__isset.success = true;
        } catch (IOError io) {
          result.io = io;
          result.__isset.io = true;
        }
        oprot.writeMessageBegin(new TMessage("scannerOpenWithStopTs", TMessageType.REPLY, seqid));
        result.write(oprot);
        oprot.writeMessageEnd();
        oprot.getTransport().flush();
      }

    }

    private class scannerGet implements ProcessFunction {
      public void process(int seqid, TProtocol iprot, TProtocol oprot) throws TException
      {
        scannerGet_args args = new scannerGet_args();
        args.read(iprot);
        iprot.readMessageEnd();
        scannerGet_result result = new scannerGet_result();
        try {
          result.success = iface_.scannerGet(args.id);
          result.__isset.success = true;
        } catch (IOError io) {
          result.io = io;
          result.__isset.io = true;
        } catch (IllegalArgument ia) {
          result.ia = ia;
          result.__isset.ia = true;
        } catch (NotFound nf) {
          result.nf = nf;
          result.__isset.nf = true;
        }
        oprot.writeMessageBegin(new TMessage("scannerGet", TMessageType.REPLY, seqid));
        result.write(oprot);
        oprot.writeMessageEnd();
        oprot.getTransport().flush();
      }

    }

    private class scannerClose implements ProcessFunction {
      public void process(int seqid, TProtocol iprot, TProtocol oprot) throws TException
      {
        scannerClose_args args = new scannerClose_args();
        args.read(iprot);
        iprot.readMessageEnd();
        scannerClose_result result = new scannerClose_result();
        try {
          iface_.scannerClose(args.id);
        } catch (IOError io) {
          result.io = io;
          result.__isset.io = true;
        } catch (IllegalArgument ia) {
          result.ia = ia;
          result.__isset.ia = true;
        }
        oprot.writeMessageBegin(new TMessage("scannerClose", TMessageType.REPLY, seqid));
        result.write(oprot);
        oprot.writeMessageEnd();
        oprot.getTransport().flush();
      }

    }

  }

  public static class enableTable_args implements TBase, java.io.Serializable   {
    public byte[] tableName;

    public final Isset __isset = new Isset();
    public static final class Isset implements java.io.Serializable {
      public boolean tableName = false;
    }

    public enableTable_args() {
    }

    public enableTable_args(
      byte[] tableName)
    {
      this();
      this.tableName = tableName;
      this.__isset.tableName = true;
    }

    public boolean equals(Object that) {
      if (that == null)
        return false;
      if (that instanceof enableTable_args)
        return this.equals((enableTable_args)that);
      return false;
    }

    public boolean equals(enableTable_args that) {
      if (that == null)
        return false;

      boolean this_present_tableName = true && (this.tableName != null);
      boolean that_present_tableName = true && (that.tableName != null);
      if (this_present_tableName || that_present_tableName) {
        if (!(this_present_tableName && that_present_tableName))
          return false;
        if (!java.util.Arrays.equals(this.tableName, that.tableName))
          return false;
      }

      return true;
    }

    public int hashCode() {
      return 0;
    }

    public void read(TProtocol iprot) throws TException {
      TField field;
      iprot.readStructBegin();
      while (true)
      {
        field = iprot.readFieldBegin();
        if (field.type == TType.STOP) { 
          break;
        }
        switch (field.id)
        {
          case 1:
            if (field.type == TType.STRING) {
              this.tableName = iprot.readBinary();
              this.__isset.tableName = true;
            } else { 
              TProtocolUtil.skip(iprot, field.type);
            }
            break;
          default:
            TProtocolUtil.skip(iprot, field.type);
            break;
        }
        iprot.readFieldEnd();
      }
      iprot.readStructEnd();
    }

    public void write(TProtocol oprot) throws TException {
      TStruct struct = new TStruct("enableTable_args");
      oprot.writeStructBegin(struct);
      TField field = new TField();
      if (this.tableName != null) {
        field.name = "tableName";
        field.type = TType.STRING;
        field.id = 1;
        oprot.writeFieldBegin(field);
        oprot.writeBinary(this.tableName);
        oprot.writeFieldEnd();
      }
      oprot.writeFieldStop();
      oprot.writeStructEnd();
    }

    public String toString() {
      StringBuilder sb = new StringBuilder("enableTable_args(");
      sb.append("tableName:");
      sb.append(this.tableName);
      sb.append(")");
      return sb.toString();
    }

  }

  public static class enableTable_result implements TBase, java.io.Serializable   {
    public IOError io;

    public final Isset __isset = new Isset();
    public static final class Isset implements java.io.Serializable {
      public boolean io = false;
    }

    public enableTable_result() {
    }

    public enableTable_result(
      IOError io)
    {
      this();
      this.io = io;
      this.__isset.io = true;
    }

    public boolean equals(Object that) {
      if (that == null)
        return false;
      if (that instanceof enableTable_result)
        return this.equals((enableTable_result)that);
      return false;
    }

    public boolean equals(enableTable_result that) {
      if (that == null)
        return false;

      boolean this_present_io = true && (this.io != null);
      boolean that_present_io = true && (that.io != null);
      if (this_present_io || that_present_io) {
        if (!(this_present_io && that_present_io))
          return false;
        if (!this.io.equals(that.io))
          return false;
      }

      return true;
    }

    public int hashCode() {
      return 0;
    }

    public void read(TProtocol iprot) throws TException {
      TField field;
      iprot.readStructBegin();
      while (true)
      {
        field = iprot.readFieldBegin();
        if (field.type == TType.STOP) { 
          break;
        }
        switch (field.id)
        {
          case 1:
            if (field.type == TType.STRUCT) {
              this.io = new IOError();
              this.io.read(iprot);
              this.__isset.io = true;
            } else { 
              TProtocolUtil.skip(iprot, field.type);
            }
            break;
          default:
            TProtocolUtil.skip(iprot, field.type);
            break;
        }
        iprot.readFieldEnd();
      }
      iprot.readStructEnd();
    }

    public void write(TProtocol oprot) throws TException {
      TStruct struct = new TStruct("enableTable_result");
      oprot.writeStructBegin(struct);
      TField field = new TField();

      if (this.__isset.io) {
        if (this.io != null) {
          field.name = "io";
          field.type = TType.STRUCT;
          field.id = 1;
          oprot.writeFieldBegin(field);
          this.io.write(oprot);
          oprot.writeFieldEnd();
        }
      }
      oprot.writeFieldStop();
      oprot.writeStructEnd();
    }

    public String toString() {
      StringBuilder sb = new StringBuilder("enableTable_result(");
      sb.append("io:");
      sb.append(this.io.toString());
      sb.append(")");
      return sb.toString();
    }

  }

  public static class disableTable_args implements TBase, java.io.Serializable   {
    public byte[] tableName;

    public final Isset __isset = new Isset();
    public static final class Isset implements java.io.Serializable {
      public boolean tableName = false;
    }

    public disableTable_args() {
    }

    public disableTable_args(
      byte[] tableName)
    {
      this();
      this.tableName = tableName;
      this.__isset.tableName = true;
    }

    public boolean equals(Object that) {
      if (that == null)
        return false;
      if (that instanceof disableTable_args)
        return this.equals((disableTable_args)that);
      return false;
    }

    public boolean equals(disableTable_args that) {
      if (that == null)
        return false;

      boolean this_present_tableName = true && (this.tableName != null);
      boolean that_present_tableName = true && (that.tableName != null);
      if (this_present_tableName || that_present_tableName) {
        if (!(this_present_tableName && that_present_tableName))
          return false;
        if (!java.util.Arrays.equals(this.tableName, that.tableName))
          return false;
      }

      return true;
    }

    public int hashCode() {
      return 0;
    }

    public void read(TProtocol iprot) throws TException {
      TField field;
      iprot.readStructBegin();
      while (true)
      {
        field = iprot.readFieldBegin();
        if (field.type == TType.STOP) { 
          break;
        }
        switch (field.id)
        {
          case 1:
            if (field.type == TType.STRING) {
              this.tableName = iprot.readBinary();
              this.__isset.tableName = true;
            } else { 
              TProtocolUtil.skip(iprot, field.type);
            }
            break;
          default:
            TProtocolUtil.skip(iprot, field.type);
            break;
        }
        iprot.readFieldEnd();
      }
      iprot.readStructEnd();
    }

    public void write(TProtocol oprot) throws TException {
      TStruct struct = new TStruct("disableTable_args");
      oprot.writeStructBegin(struct);
      TField field = new TField();
      if (this.tableName != null) {
        field.name = "tableName";
        field.type = TType.STRING;
        field.id = 1;
        oprot.writeFieldBegin(field);
        oprot.writeBinary(this.tableName);
        oprot.writeFieldEnd();
      }
      oprot.writeFieldStop();
      oprot.writeStructEnd();
    }

    public String toString() {
      StringBuilder sb = new StringBuilder("disableTable_args(");
      sb.append("tableName:");
      sb.append(this.tableName);
      sb.append(")");
      return sb.toString();
    }

  }

  public static class disableTable_result implements TBase, java.io.Serializable   {
    public IOError io;

    public final Isset __isset = new Isset();
    public static final class Isset implements java.io.Serializable {
      public boolean io = false;
    }

    public disableTable_result() {
    }

    public disableTable_result(
      IOError io)
    {
      this();
      this.io = io;
      this.__isset.io = true;
    }

    public boolean equals(Object that) {
      if (that == null)
        return false;
      if (that instanceof disableTable_result)
        return this.equals((disableTable_result)that);
      return false;
    }

    public boolean equals(disableTable_result that) {
      if (that == null)
        return false;

      boolean this_present_io = true && (this.io != null);
      boolean that_present_io = true && (that.io != null);
      if (this_present_io || that_present_io) {
        if (!(this_present_io && that_present_io))
          return false;
        if (!this.io.equals(that.io))
          return false;
      }

      return true;
    }

    public int hashCode() {
      return 0;
    }

    public void read(TProtocol iprot) throws TException {
      TField field;
      iprot.readStructBegin();
      while (true)
      {
        field = iprot.readFieldBegin();
        if (field.type == TType.STOP) { 
          break;
        }
        switch (field.id)
        {
          case 1:
            if (field.type == TType.STRUCT) {
              this.io = new IOError();
              this.io.read(iprot);
              this.__isset.io = true;
            } else { 
              TProtocolUtil.skip(iprot, field.type);
            }
            break;
          default:
            TProtocolUtil.skip(iprot, field.type);
            break;
        }
        iprot.readFieldEnd();
      }
      iprot.readStructEnd();
    }

    public void write(TProtocol oprot) throws TException {
      TStruct struct = new TStruct("disableTable_result");
      oprot.writeStructBegin(struct);
      TField field = new TField();

      if (this.__isset.io) {
        if (this.io != null) {
          field.name = "io";
          field.type = TType.STRUCT;
          field.id = 1;
          oprot.writeFieldBegin(field);
          this.io.write(oprot);
          oprot.writeFieldEnd();
        }
      }
      oprot.writeFieldStop();
      oprot.writeStructEnd();
    }

    public String toString() {
      StringBuilder sb = new StringBuilder("disableTable_result(");
      sb.append("io:");
      sb.append(this.io.toString());
      sb.append(")");
      return sb.toString();
    }

  }

  public static class isTableEnabled_args implements TBase, java.io.Serializable   {
    public byte[] tableName;

    public final Isset __isset = new Isset();
    public static final class Isset implements java.io.Serializable {
      public boolean tableName = false;
    }

    public isTableEnabled_args() {
    }

    public isTableEnabled_args(
      byte[] tableName)
    {
      this();
      this.tableName = tableName;
      this.__isset.tableName = true;
    }

    public boolean equals(Object that) {
      if (that == null)
        return false;
      if (that instanceof isTableEnabled_args)
        return this.equals((isTableEnabled_args)that);
      return false;
    }

    public boolean equals(isTableEnabled_args that) {
      if (that == null)
        return false;

      boolean this_present_tableName = true && (this.tableName != null);
      boolean that_present_tableName = true && (that.tableName != null);
      if (this_present_tableName || that_present_tableName) {
        if (!(this_present_tableName && that_present_tableName))
          return false;
        if (!java.util.Arrays.equals(this.tableName, that.tableName))
          return false;
      }

      return true;
    }

    public int hashCode() {
      return 0;
    }

    public void read(TProtocol iprot) throws TException {
      TField field;
      iprot.readStructBegin();
      while (true)
      {
        field = iprot.readFieldBegin();
        if (field.type == TType.STOP) { 
          break;
        }
        switch (field.id)
        {
          case 1:
            if (field.type == TType.STRING) {
              this.tableName = iprot.readBinary();
              this.__isset.tableName = true;
            } else { 
              TProtocolUtil.skip(iprot, field.type);
            }
            break;
          default:
            TProtocolUtil.skip(iprot, field.type);
            break;
        }
        iprot.readFieldEnd();
      }
      iprot.readStructEnd();
    }

    public void write(TProtocol oprot) throws TException {
      TStruct struct = new TStruct("isTableEnabled_args");
      oprot.writeStructBegin(struct);
      TField field = new TField();
      if (this.tableName != null) {
        field.name = "tableName";
        field.type = TType.STRING;
        field.id = 1;
        oprot.writeFieldBegin(field);
        oprot.writeBinary(this.tableName);
        oprot.writeFieldEnd();
      }
      oprot.writeFieldStop();
      oprot.writeStructEnd();
    }

    public String toString() {
      StringBuilder sb = new StringBuilder("isTableEnabled_args(");
      sb.append("tableName:");
      sb.append(this.tableName);
      sb.append(")");
      return sb.toString();
    }

  }

  public static class isTableEnabled_result implements TBase, java.io.Serializable   {
    public boolean success;
    public IOError io;

    public final Isset __isset = new Isset();
    public static final class Isset implements java.io.Serializable {
      public boolean success = false;
      public boolean io = false;
    }

    public isTableEnabled_result() {
    }

    public isTableEnabled_result(
      boolean success,
      IOError io)
    {
      this();
      this.success = success;
      this.__isset.success = true;
      this.io = io;
      this.__isset.io = true;
    }

    public boolean equals(Object that) {
      if (that == null)
        return false;
      if (that instanceof isTableEnabled_result)
        return this.equals((isTableEnabled_result)that);
      return false;
    }

    public boolean equals(isTableEnabled_result that) {
      if (that == null)
        return false;

      boolean this_present_success = true;
      boolean that_present_success = true;
      if (this_present_success || that_present_success) {
        if (!(this_present_success && that_present_success))
          return false;
        if (this.success != that.success)
          return false;
      }

      boolean this_present_io = true && (this.io != null);
      boolean that_present_io = true && (that.io != null);
      if (this_present_io || that_present_io) {
        if (!(this_present_io && that_present_io))
          return false;
        if (!this.io.equals(that.io))
          return false;
      }

      return true;
    }

    public int hashCode() {
      return 0;
    }

    public void read(TProtocol iprot) throws TException {
      TField field;
      iprot.readStructBegin();
      while (true)
      {
        field = iprot.readFieldBegin();
        if (field.type == TType.STOP) { 
          break;
        }
        switch (field.id)
        {
          case 0:
            if (field.type == TType.BOOL) {
              this.success = iprot.readBool();
              this.__isset.success = true;
            } else { 
              TProtocolUtil.skip(iprot, field.type);
            }
            break;
          case 1:
            if (field.type == TType.STRUCT) {
              this.io = new IOError();
              this.io.read(iprot);
              this.__isset.io = true;
            } else { 
              TProtocolUtil.skip(iprot, field.type);
            }
            break;
          default:
            TProtocolUtil.skip(iprot, field.type);
            break;
        }
        iprot.readFieldEnd();
      }
      iprot.readStructEnd();
    }

    public void write(TProtocol oprot) throws TException {
      TStruct struct = new TStruct("isTableEnabled_result");
      oprot.writeStructBegin(struct);
      TField field = new TField();

      if (this.__isset.success) {
        field.name = "success";
        field.type = TType.BOOL;
        field.id = 0;
        oprot.writeFieldBegin(field);
        oprot.writeBool(this.success);
        oprot.writeFieldEnd();
      } else if (this.__isset.io) {
        if (this.io != null) {
          field.name = "io";
          field.type = TType.STRUCT;
          field.id = 1;
          oprot.writeFieldBegin(field);
          this.io.write(oprot);
          oprot.writeFieldEnd();
        }
      }
      oprot.writeFieldStop();
      oprot.writeStructEnd();
    }

    public String toString() {
      StringBuilder sb = new StringBuilder("isTableEnabled_result(");
      sb.append("success:");
      sb.append(this.success);
      sb.append(",io:");
      sb.append(this.io.toString());
      sb.append(")");
      return sb.toString();
    }

  }

  public static class getTableNames_args implements TBase, java.io.Serializable   {
    public getTableNames_args() {
    }

    public boolean equals(Object that) {
      if (that == null)
        return false;
      if (that instanceof getTableNames_args)
        return this.equals((getTableNames_args)that);
      return false;
    }

    public boolean equals(getTableNames_args that) {
      if (that == null)
        return false;

      return true;
    }

    public int hashCode() {
      return 0;
    }

    public void read(TProtocol iprot) throws TException {
      TField field;
      iprot.readStructBegin();
      while (true)
      {
        field = iprot.readFieldBegin();
        if (field.type == TType.STOP) { 
          break;
        }
        switch (field.id)
        {
          default:
            TProtocolUtil.skip(iprot, field.type);
            break;
        }
        iprot.readFieldEnd();
      }
      iprot.readStructEnd();
    }

    public void write(TProtocol oprot) throws TException {
      TStruct struct = new TStruct("getTableNames_args");
      oprot.writeStructBegin(struct);
      oprot.writeFieldStop();
      oprot.writeStructEnd();
    }

    public String toString() {
      StringBuilder sb = new StringBuilder("getTableNames_args(");
      sb.append(")");
      return sb.toString();
    }

  }

  public static class getTableNames_result implements TBase, java.io.Serializable   {
    public List<byte[]> success;
    public IOError io;

    public final Isset __isset = new Isset();
    public static final class Isset implements java.io.Serializable {
      public boolean success = false;
      public boolean io = false;
    }

    public getTableNames_result() {
    }

    public getTableNames_result(
      List<byte[]> success,
      IOError io)
    {
      this();
      this.success = success;
      this.__isset.success = true;
      this.io = io;
      this.__isset.io = true;
    }

    public boolean equals(Object that) {
      if (that == null)
        return false;
      if (that instanceof getTableNames_result)
        return this.equals((getTableNames_result)that);
      return false;
    }

    public boolean equals(getTableNames_result that) {
      if (that == null)
        return false;

      boolean this_present_success = true && (this.success != null);
      boolean that_present_success = true && (that.success != null);
      if (this_present_success || that_present_success) {
        if (!(this_present_success && that_present_success))
          return false;
        if (!this.success.equals(that.success))
          return false;
      }

      boolean this_present_io = true && (this.io != null);
      boolean that_present_io = true && (that.io != null);
      if (this_present_io || that_present_io) {
        if (!(this_present_io && that_present_io))
          return false;
        if (!this.io.equals(that.io))
          return false;
      }

      return true;
    }

    public int hashCode() {
      return 0;
    }

    public void read(TProtocol iprot) throws TException {
      TField field;
      iprot.readStructBegin();
      while (true)
      {
        field = iprot.readFieldBegin();
        if (field.type == TType.STOP) { 
          break;
        }
        switch (field.id)
        {
          case 0:
            if (field.type == TType.LIST) {
              {
                TList _list9 = iprot.readListBegin();
                this.success = new ArrayList<byte[]>(_list9.size);
                for (int _i10 = 0; _i10 < _list9.size; ++_i10)
                {
                  byte[] _elem11 = null;
                  _elem11 = iprot.readBinary();
                  this.success.add(_elem11);
                }
                iprot.readListEnd();
              }
              this.__isset.success = true;
            } else { 
              TProtocolUtil.skip(iprot, field.type);
            }
            break;
          case 1:
            if (field.type == TType.STRUCT) {
              this.io = new IOError();
              this.io.read(iprot);
              this.__isset.io = true;
            } else { 
              TProtocolUtil.skip(iprot, field.type);
            }
            break;
          default:
            TProtocolUtil.skip(iprot, field.type);
            break;
        }
        iprot.readFieldEnd();
      }
      iprot.readStructEnd();
    }

    public void write(TProtocol oprot) throws TException {
      TStruct struct = new TStruct("getTableNames_result");
      oprot.writeStructBegin(struct);
      TField field = new TField();

      if (this.__isset.success) {
        if (this.success != null) {
          field.name = "success";
          field.type = TType.LIST;
          field.id = 0;
          oprot.writeFieldBegin(field);
          {
            oprot.writeListBegin(new TList(TType.STRING, this.success.size()));
            for (byte[] _iter12 : this.success)            {
              oprot.writeBinary(_iter12);
            }
            oprot.writeListEnd();
          }
          oprot.writeFieldEnd();
        }
      } else if (this.__isset.io) {
        if (this.io != null) {
          field.name = "io";
          field.type = TType.STRUCT;
          field.id = 1;
          oprot.writeFieldBegin(field);
          this.io.write(oprot);
          oprot.writeFieldEnd();
        }
      }
      oprot.writeFieldStop();
      oprot.writeStructEnd();
    }

    public String toString() {
      StringBuilder sb = new StringBuilder("getTableNames_result(");
      sb.append("success:");
      sb.append(this.success);
      sb.append(",io:");
      sb.append(this.io.toString());
      sb.append(")");
      return sb.toString();
    }

  }

  public static class getColumnDescriptors_args implements TBase, java.io.Serializable   {
    public byte[] tableName;

    public final Isset __isset = new Isset();
    public static final class Isset implements java.io.Serializable {
      public boolean tableName = false;
    }

    public getColumnDescriptors_args() {
    }

    public getColumnDescriptors_args(
      byte[] tableName)
    {
      this();
      this.tableName = tableName;
      this.__isset.tableName = true;
    }

    public boolean equals(Object that) {
      if (that == null)
        return false;
      if (that instanceof getColumnDescriptors_args)
        return this.equals((getColumnDescriptors_args)that);
      return false;
    }

    public boolean equals(getColumnDescriptors_args that) {
      if (that == null)
        return false;

      boolean this_present_tableName = true && (this.tableName != null);
      boolean that_present_tableName = true && (that.tableName != null);
      if (this_present_tableName || that_present_tableName) {
        if (!(this_present_tableName && that_present_tableName))
          return false;
        if (!java.util.Arrays.equals(this.tableName, that.tableName))
          return false;
      }

      return true;
    }

    public int hashCode() {
      return 0;
    }

    public void read(TProtocol iprot) throws TException {
      TField field;
      iprot.readStructBegin();
      while (true)
      {
        field = iprot.readFieldBegin();
        if (field.type == TType.STOP) { 
          break;
        }
        switch (field.id)
        {
          case 1:
            if (field.type == TType.STRING) {
              this.tableName = iprot.readBinary();
              this.__isset.tableName = true;
            } else { 
              TProtocolUtil.skip(iprot, field.type);
            }
            break;
          default:
            TProtocolUtil.skip(iprot, field.type);
            break;
        }
        iprot.readFieldEnd();
      }
      iprot.readStructEnd();
    }

    public void write(TProtocol oprot) throws TException {
      TStruct struct = new TStruct("getColumnDescriptors_args");
      oprot.writeStructBegin(struct);
      TField field = new TField();
      if (this.tableName != null) {
        field.name = "tableName";
        field.type = TType.STRING;
        field.id = 1;
        oprot.writeFieldBegin(field);
        oprot.writeBinary(this.tableName);
        oprot.writeFieldEnd();
      }
      oprot.writeFieldStop();
      oprot.writeStructEnd();
    }

    public String toString() {
      StringBuilder sb = new StringBuilder("getColumnDescriptors_args(");
      sb.append("tableName:");
      sb.append(this.tableName);
      sb.append(")");
      return sb.toString();
    }

  }

  public static class getColumnDescriptors_result implements TBase, java.io.Serializable   {
    public Map<byte[],ColumnDescriptor> success;
    public IOError io;

    public final Isset __isset = new Isset();
    public static final class Isset implements java.io.Serializable {
      public boolean success = false;
      public boolean io = false;
    }

    public getColumnDescriptors_result() {
    }

    public getColumnDescriptors_result(
      Map<byte[],ColumnDescriptor> success,
      IOError io)
    {
      this();
      this.success = success;
      this.__isset.success = true;
      this.io = io;
      this.__isset.io = true;
    }

    public boolean equals(Object that) {
      if (that == null)
        return false;
      if (that instanceof getColumnDescriptors_result)
        return this.equals((getColumnDescriptors_result)that);
      return false;
    }

    public boolean equals(getColumnDescriptors_result that) {
      if (that == null)
        return false;

      boolean this_present_success = true && (this.success != null);
      boolean that_present_success = true && (that.success != null);
      if (this_present_success || that_present_success) {
        if (!(this_present_success && that_present_success))
          return false;
        if (!this.success.equals(that.success))
          return false;
      }

      boolean this_present_io = true && (this.io != null);
      boolean that_present_io = true && (that.io != null);
      if (this_present_io || that_present_io) {
        if (!(this_present_io && that_present_io))
          return false;
        if (!this.io.equals(that.io))
          return false;
      }

      return true;
    }

    public int hashCode() {
      return 0;
    }

    public void read(TProtocol iprot) throws TException {
      TField field;
      iprot.readStructBegin();
      while (true)
      {
        field = iprot.readFieldBegin();
        if (field.type == TType.STOP) { 
          break;
        }
        switch (field.id)
        {
          case 0:
            if (field.type == TType.MAP) {
              {
                TMap _map13 = iprot.readMapBegin();
                this.success = new HashMap<byte[],ColumnDescriptor>(2*_map13.size);
                for (int _i14 = 0; _i14 < _map13.size; ++_i14)
                {
                  byte[] _key15;
                  ColumnDescriptor _val16;
                  _key15 = iprot.readBinary();
                  _val16 = new ColumnDescriptor();
                  _val16.read(iprot);
                  this.success.put(_key15, _val16);
                }
                iprot.readMapEnd();
              }
              this.__isset.success = true;
            } else { 
              TProtocolUtil.skip(iprot, field.type);
            }
            break;
          case 1:
            if (field.type == TType.STRUCT) {
              this.io = new IOError();
              this.io.read(iprot);
              this.__isset.io = true;
            } else { 
              TProtocolUtil.skip(iprot, field.type);
            }
            break;
          default:
            TProtocolUtil.skip(iprot, field.type);
            break;
        }
        iprot.readFieldEnd();
      }
      iprot.readStructEnd();
    }

    public void write(TProtocol oprot) throws TException {
      TStruct struct = new TStruct("getColumnDescriptors_result");
      oprot.writeStructBegin(struct);
      TField field = new TField();

      if (this.__isset.success) {
        if (this.success != null) {
          field.name = "success";
          field.type = TType.MAP;
          field.id = 0;
          oprot.writeFieldBegin(field);
          {
            oprot.writeMapBegin(new TMap(TType.STRING, TType.STRUCT, this.success.size()));
            for (byte[] _iter17 : this.success.keySet())            {
              oprot.writeBinary(_iter17);
              this.success.get(_iter17).write(oprot);
            }
            oprot.writeMapEnd();
          }
          oprot.writeFieldEnd();
        }
      } else if (this.__isset.io) {
        if (this.io != null) {
          field.name = "io";
          field.type = TType.STRUCT;
          field.id = 1;
          oprot.writeFieldBegin(field);
          this.io.write(oprot);
          oprot.writeFieldEnd();
        }
      }
      oprot.writeFieldStop();
      oprot.writeStructEnd();
    }

    public String toString() {
      StringBuilder sb = new StringBuilder("getColumnDescriptors_result(");
      sb.append("success:");
      sb.append(this.success);
      sb.append(",io:");
      sb.append(this.io.toString());
      sb.append(")");
      return sb.toString();
    }

  }

  public static class getTableRegions_args implements TBase, java.io.Serializable   {
    public byte[] tableName;

    public final Isset __isset = new Isset();
    public static final class Isset implements java.io.Serializable {
      public boolean tableName = false;
    }

    public getTableRegions_args() {
    }

    public getTableRegions_args(
      byte[] tableName)
    {
      this();
      this.tableName = tableName;
      this.__isset.tableName = true;
    }

    public boolean equals(Object that) {
      if (that == null)
        return false;
      if (that instanceof getTableRegions_args)
        return this.equals((getTableRegions_args)that);
      return false;
    }

    public boolean equals(getTableRegions_args that) {
      if (that == null)
        return false;

      boolean this_present_tableName = true && (this.tableName != null);
      boolean that_present_tableName = true && (that.tableName != null);
      if (this_present_tableName || that_present_tableName) {
        if (!(this_present_tableName && that_present_tableName))
          return false;
        if (!java.util.Arrays.equals(this.tableName, that.tableName))
          return false;
      }

      return true;
    }

    public int hashCode() {
      return 0;
    }

    public void read(TProtocol iprot) throws TException {
      TField field;
      iprot.readStructBegin();
      while (true)
      {
        field = iprot.readFieldBegin();
        if (field.type == TType.STOP) { 
          break;
        }
        switch (field.id)
        {
          case 1:
            if (field.type == TType.STRING) {
              this.tableName = iprot.readBinary();
              this.__isset.tableName = true;
            } else { 
              TProtocolUtil.skip(iprot, field.type);
            }
            break;
          default:
            TProtocolUtil.skip(iprot, field.type);
            break;
        }
        iprot.readFieldEnd();
      }
      iprot.readStructEnd();
    }

    public void write(TProtocol oprot) throws TException {
      TStruct struct = new TStruct("getTableRegions_args");
      oprot.writeStructBegin(struct);
      TField field = new TField();
      if (this.tableName != null) {
        field.name = "tableName";
        field.type = TType.STRING;
        field.id = 1;
        oprot.writeFieldBegin(field);
        oprot.writeBinary(this.tableName);
        oprot.writeFieldEnd();
      }
      oprot.writeFieldStop();
      oprot.writeStructEnd();
    }

    public String toString() {
      StringBuilder sb = new StringBuilder("getTableRegions_args(");
      sb.append("tableName:");
      sb.append(this.tableName);
      sb.append(")");
      return sb.toString();
    }

  }

  public static class getTableRegions_result implements TBase, java.io.Serializable   {
    public List<TRegionInfo> success;
    public IOError io;

    public final Isset __isset = new Isset();
    public static final class Isset implements java.io.Serializable {
      public boolean success = false;
      public boolean io = false;
    }

    public getTableRegions_result() {
    }

    public getTableRegions_result(
      List<TRegionInfo> success,
      IOError io)
    {
      this();
      this.success = success;
      this.__isset.success = true;
      this.io = io;
      this.__isset.io = true;
    }

    public boolean equals(Object that) {
      if (that == null)
        return false;
      if (that instanceof getTableRegions_result)
        return this.equals((getTableRegions_result)that);
      return false;
    }

    public boolean equals(getTableRegions_result that) {
      if (that == null)
        return false;

      boolean this_present_success = true && (this.success != null);
      boolean that_present_success = true && (that.success != null);
      if (this_present_success || that_present_success) {
        if (!(this_present_success && that_present_success))
          return false;
        if (!this.success.equals(that.success))
          return false;
      }

      boolean this_present_io = true && (this.io != null);
      boolean that_present_io = true && (that.io != null);
      if (this_present_io || that_present_io) {
        if (!(this_present_io && that_present_io))
          return false;
        if (!this.io.equals(that.io))
          return false;
      }

      return true;
    }

    public int hashCode() {
      return 0;
    }

    public void read(TProtocol iprot) throws TException {
      TField field;
      iprot.readStructBegin();
      while (true)
      {
        field = iprot.readFieldBegin();
        if (field.type == TType.STOP) { 
          break;
        }
        switch (field.id)
        {
          case 0:
            if (field.type == TType.LIST) {
              {
                TList _list18 = iprot.readListBegin();
                this.success = new ArrayList<TRegionInfo>(_list18.size);
                for (int _i19 = 0; _i19 < _list18.size; ++_i19)
                {
                  TRegionInfo _elem20 = new TRegionInfo();
                  _elem20 = new TRegionInfo();
                  _elem20.read(iprot);
                  this.success.add(_elem20);
                }
                iprot.readListEnd();
              }
              this.__isset.success = true;
            } else { 
              TProtocolUtil.skip(iprot, field.type);
            }
            break;
          case 1:
            if (field.type == TType.STRUCT) {
              this.io = new IOError();
              this.io.read(iprot);
              this.__isset.io = true;
            } else { 
              TProtocolUtil.skip(iprot, field.type);
            }
            break;
          default:
            TProtocolUtil.skip(iprot, field.type);
            break;
        }
        iprot.readFieldEnd();
      }
      iprot.readStructEnd();
    }

    public void write(TProtocol oprot) throws TException {
      TStruct struct = new TStruct("getTableRegions_result");
      oprot.writeStructBegin(struct);
      TField field = new TField();

      if (this.__isset.success) {
        if (this.success != null) {
          field.name = "success";
          field.type = TType.LIST;
          field.id = 0;
          oprot.writeFieldBegin(field);
          {
            oprot.writeListBegin(new TList(TType.STRUCT, this.success.size()));
            for (TRegionInfo _iter21 : this.success)            {
              _iter21.write(oprot);
            }
            oprot.writeListEnd();
          }
          oprot.writeFieldEnd();
        }
      } else if (this.__isset.io) {
        if (this.io != null) {
          field.name = "io";
          field.type = TType.STRUCT;
          field.id = 1;
          oprot.writeFieldBegin(field);
          this.io.write(oprot);
          oprot.writeFieldEnd();
        }
      }
      oprot.writeFieldStop();
      oprot.writeStructEnd();
    }

    public String toString() {
      StringBuilder sb = new StringBuilder("getTableRegions_result(");
      sb.append("success:");
      sb.append(this.success);
      sb.append(",io:");
      sb.append(this.io.toString());
      sb.append(")");
      return sb.toString();
    }

  }

  public static class createTable_args implements TBase, java.io.Serializable   {
    public byte[] tableName;
    public List<ColumnDescriptor> columnFamilies;

    public final Isset __isset = new Isset();
    public static final class Isset implements java.io.Serializable {
      public boolean tableName = false;
      public boolean columnFamilies = false;
    }

    public createTable_args() {
    }

    public createTable_args(
      byte[] tableName,
      List<ColumnDescriptor> columnFamilies)
    {
      this();
      this.tableName = tableName;
      this.__isset.tableName = true;
      this.columnFamilies = columnFamilies;
      this.__isset.columnFamilies = true;
    }

    public boolean equals(Object that) {
      if (that == null)
        return false;
      if (that instanceof createTable_args)
        return this.equals((createTable_args)that);
      return false;
    }

    public boolean equals(createTable_args that) {
      if (that == null)
        return false;

      boolean this_present_tableName = true && (this.tableName != null);
      boolean that_present_tableName = true && (that.tableName != null);
      if (this_present_tableName || that_present_tableName) {
        if (!(this_present_tableName && that_present_tableName))
          return false;
        if (!java.util.Arrays.equals(this.tableName, that.tableName))
          return false;
      }

      boolean this_present_columnFamilies = true && (this.columnFamilies != null);
      boolean that_present_columnFamilies = true && (that.columnFamilies != null);
      if (this_present_columnFamilies || that_present_columnFamilies) {
        if (!(this_present_columnFamilies && that_present_columnFamilies))
          return false;
        if (!this.columnFamilies.equals(that.columnFamilies))
          return false;
      }

      return true;
    }

    public int hashCode() {
      return 0;
    }

    public void read(TProtocol iprot) throws TException {
      TField field;
      iprot.readStructBegin();
      while (true)
      {
        field = iprot.readFieldBegin();
        if (field.type == TType.STOP) { 
          break;
        }
        switch (field.id)
        {
          case 1:
            if (field.type == TType.STRING) {
              this.tableName = iprot.readBinary();
              this.__isset.tableName = true;
            } else { 
              TProtocolUtil.skip(iprot, field.type);
            }
            break;
          case 2:
            if (field.type == TType.LIST) {
              {
                TList _list22 = iprot.readListBegin();
                this.columnFamilies = new ArrayList<ColumnDescriptor>(_list22.size);
                for (int _i23 = 0; _i23 < _list22.size; ++_i23)
                {
                  ColumnDescriptor _elem24 = new ColumnDescriptor();
                  _elem24 = new ColumnDescriptor();
                  _elem24.read(iprot);
                  this.columnFamilies.add(_elem24);
                }
                iprot.readListEnd();
              }
              this.__isset.columnFamilies = true;
            } else { 
              TProtocolUtil.skip(iprot, field.type);
            }
            break;
          default:
            TProtocolUtil.skip(iprot, field.type);
            break;
        }
        iprot.readFieldEnd();
      }
      iprot.readStructEnd();
    }

    public void write(TProtocol oprot) throws TException {
      TStruct struct = new TStruct("createTable_args");
      oprot.writeStructBegin(struct);
      TField field = new TField();
      if (this.tableName != null) {
        field.name = "tableName";
        field.type = TType.STRING;
        field.id = 1;
        oprot.writeFieldBegin(field);
        oprot.writeBinary(this.tableName);
        oprot.writeFieldEnd();
      }
      if (this.columnFamilies != null) {
        field.name = "columnFamilies";
        field.type = TType.LIST;
        field.id = 2;
        oprot.writeFieldBegin(field);
        {
          oprot.writeListBegin(new TList(TType.STRUCT, this.columnFamilies.size()));
          for (ColumnDescriptor _iter25 : this.columnFamilies)          {
            _iter25.write(oprot);
          }
          oprot.writeListEnd();
        }
        oprot.writeFieldEnd();
      }
      oprot.writeFieldStop();
      oprot.writeStructEnd();
    }

    public String toString() {
      StringBuilder sb = new StringBuilder("createTable_args(");
      sb.append("tableName:");
      sb.append(this.tableName);
      sb.append(",columnFamilies:");
      sb.append(this.columnFamilies);
      sb.append(")");
      return sb.toString();
    }

  }

  public static class createTable_result implements TBase, java.io.Serializable   {
    public IOError io;
    public IllegalArgument ia;
    public AlreadyExists exist;

    public final Isset __isset = new Isset();
    public static final class Isset implements java.io.Serializable {
      public boolean io = false;
      public boolean ia = false;
      public boolean exist = false;
    }

    public createTable_result() {
    }

    public createTable_result(
      IOError io,
      IllegalArgument ia,
      AlreadyExists exist)
    {
      this();
      this.io = io;
      this.__isset.io = true;
      this.ia = ia;
      this.__isset.ia = true;
      this.exist = exist;
      this.__isset.exist = true;
    }

    public boolean equals(Object that) {
      if (that == null)
        return false;
      if (that instanceof createTable_result)
        return this.equals((createTable_result)that);
      return false;
    }

    public boolean equals(createTable_result that) {
      if (that == null)
        return false;

      boolean this_present_io = true && (this.io != null);
      boolean that_present_io = true && (that.io != null);
      if (this_present_io || that_present_io) {
        if (!(this_present_io && that_present_io))
          return false;
        if (!this.io.equals(that.io))
          return false;
      }

      boolean this_present_ia = true && (this.ia != null);
      boolean that_present_ia = true && (that.ia != null);
      if (this_present_ia || that_present_ia) {
        if (!(this_present_ia && that_present_ia))
          return false;
        if (!this.ia.equals(that.ia))
          return false;
      }

      boolean this_present_exist = true && (this.exist != null);
      boolean that_present_exist = true && (that.exist != null);
      if (this_present_exist || that_present_exist) {
        if (!(this_present_exist && that_present_exist))
          return false;
        if (!this.exist.equals(that.exist))
          return false;
      }

      return true;
    }

    public int hashCode() {
      return 0;
    }

    public void read(TProtocol iprot) throws TException {
      TField field;
      iprot.readStructBegin();
      while (true)
      {
        field = iprot.readFieldBegin();
        if (field.type == TType.STOP) { 
          break;
        }
        switch (field.id)
        {
          case 1:
            if (field.type == TType.STRUCT) {
              this.io = new IOError();
              this.io.read(iprot);
              this.__isset.io = true;
            } else { 
              TProtocolUtil.skip(iprot, field.type);
            }
            break;
          case 2:
            if (field.type == TType.STRUCT) {
              this.ia = new IllegalArgument();
              this.ia.read(iprot);
              this.__isset.ia = true;
            } else { 
              TProtocolUtil.skip(iprot, field.type);
            }
            break;
          case 3:
            if (field.type == TType.STRUCT) {
              this.exist = new AlreadyExists();
              this.exist.read(iprot);
              this.__isset.exist = true;
            } else { 
              TProtocolUtil.skip(iprot, field.type);
            }
            break;
          default:
            TProtocolUtil.skip(iprot, field.type);
            break;
        }
        iprot.readFieldEnd();
      }
      iprot.readStructEnd();
    }

    public void write(TProtocol oprot) throws TException {
      TStruct struct = new TStruct("createTable_result");
      oprot.writeStructBegin(struct);
      TField field = new TField();

      if (this.__isset.io) {
        if (this.io != null) {
          field.name = "io";
          field.type = TType.STRUCT;
          field.id = 1;
          oprot.writeFieldBegin(field);
          this.io.write(oprot);
          oprot.writeFieldEnd();
        }
      } else if (this.__isset.ia) {
        if (this.ia != null) {
          field.name = "ia";
          field.type = TType.STRUCT;
          field.id = 2;
          oprot.writeFieldBegin(field);
          this.ia.write(oprot);
          oprot.writeFieldEnd();
        }
      } else if (this.__isset.exist) {
        if (this.exist != null) {
          field.name = "exist";
          field.type = TType.STRUCT;
          field.id = 3;
          oprot.writeFieldBegin(field);
          this.exist.write(oprot);
          oprot.writeFieldEnd();
        }
      }
      oprot.writeFieldStop();
      oprot.writeStructEnd();
    }

    public String toString() {
      StringBuilder sb = new StringBuilder("createTable_result(");
      sb.append("io:");
      sb.append(this.io.toString());
      sb.append(",ia:");
      sb.append(this.ia.toString());
      sb.append(",exist:");
      sb.append(this.exist.toString());
      sb.append(")");
      return sb.toString();
    }

  }

  public static class deleteTable_args implements TBase, java.io.Serializable   {
    public byte[] tableName;

    public final Isset __isset = new Isset();
    public static final class Isset implements java.io.Serializable {
      public boolean tableName = false;
    }

    public deleteTable_args() {
    }

    public deleteTable_args(
      byte[] tableName)
    {
      this();
      this.tableName = tableName;
      this.__isset.tableName = true;
    }

    public boolean equals(Object that) {
      if (that == null)
        return false;
      if (that instanceof deleteTable_args)
        return this.equals((deleteTable_args)that);
      return false;
    }

    public boolean equals(deleteTable_args that) {
      if (that == null)
        return false;

      boolean this_present_tableName = true && (this.tableName != null);
      boolean that_present_tableName = true && (that.tableName != null);
      if (this_present_tableName || that_present_tableName) {
        if (!(this_present_tableName && that_present_tableName))
          return false;
        if (!java.util.Arrays.equals(this.tableName, that.tableName))
          return false;
      }

      return true;
    }

    public int hashCode() {
      return 0;
    }

    public void read(TProtocol iprot) throws TException {
      TField field;
      iprot.readStructBegin();
      while (true)
      {
        field = iprot.readFieldBegin();
        if (field.type == TType.STOP) { 
          break;
        }
        switch (field.id)
        {
          case 1:
            if (field.type == TType.STRING) {
              this.tableName = iprot.readBinary();
              this.__isset.tableName = true;
            } else { 
              TProtocolUtil.skip(iprot, field.type);
            }
            break;
          default:
            TProtocolUtil.skip(iprot, field.type);
            break;
        }
        iprot.readFieldEnd();
      }
      iprot.readStructEnd();
    }

    public void write(TProtocol oprot) throws TException {
      TStruct struct = new TStruct("deleteTable_args");
      oprot.writeStructBegin(struct);
      TField field = new TField();
      if (this.tableName != null) {
        field.name = "tableName";
        field.type = TType.STRING;
        field.id = 1;
        oprot.writeFieldBegin(field);
        oprot.writeBinary(this.tableName);
        oprot.writeFieldEnd();
      }
      oprot.writeFieldStop();
      oprot.writeStructEnd();
    }

    public String toString() {
      StringBuilder sb = new StringBuilder("deleteTable_args(");
      sb.append("tableName:");
      sb.append(this.tableName);
      sb.append(")");
      return sb.toString();
    }

  }

  public static class deleteTable_result implements TBase, java.io.Serializable   {
    public IOError io;
    public NotFound nf;

    public final Isset __isset = new Isset();
    public static final class Isset implements java.io.Serializable {
      public boolean io = false;
      public boolean nf = false;
    }

    public deleteTable_result() {
    }

    public deleteTable_result(
      IOError io,
      NotFound nf)
    {
      this();
      this.io = io;
      this.__isset.io = true;
      this.nf = nf;
      this.__isset.nf = true;
    }

    public boolean equals(Object that) {
      if (that == null)
        return false;
      if (that instanceof deleteTable_result)
        return this.equals((deleteTable_result)that);
      return false;
    }

    public boolean equals(deleteTable_result that) {
      if (that == null)
        return false;

      boolean this_present_io = true && (this.io != null);
      boolean that_present_io = true && (that.io != null);
      if (this_present_io || that_present_io) {
        if (!(this_present_io && that_present_io))
          return false;
        if (!this.io.equals(that.io))
          return false;
      }

      boolean this_present_nf = true && (this.nf != null);
      boolean that_present_nf = true && (that.nf != null);
      if (this_present_nf || that_present_nf) {
        if (!(this_present_nf && that_present_nf))
          return false;
        if (!this.nf.equals(that.nf))
          return false;
      }

      return true;
    }

    public int hashCode() {
      return 0;
    }

    public void read(TProtocol iprot) throws TException {
      TField field;
      iprot.readStructBegin();
      while (true)
      {
        field = iprot.readFieldBegin();
        if (field.type == TType.STOP) { 
          break;
        }
        switch (field.id)
        {
          case 1:
            if (field.type == TType.STRUCT) {
              this.io = new IOError();
              this.io.read(iprot);
              this.__isset.io = true;
            } else { 
              TProtocolUtil.skip(iprot, field.type);
            }
            break;
          case 2:
            if (field.type == TType.STRUCT) {
              this.nf = new NotFound();
              this.nf.read(iprot);
              this.__isset.nf = true;
            } else { 
              TProtocolUtil.skip(iprot, field.type);
            }
            break;
          default:
            TProtocolUtil.skip(iprot, field.type);
            break;
        }
        iprot.readFieldEnd();
      }
      iprot.readStructEnd();
    }

    public void write(TProtocol oprot) throws TException {
      TStruct struct = new TStruct("deleteTable_result");
      oprot.writeStructBegin(struct);
      TField field = new TField();

      if (this.__isset.io) {
        if (this.io != null) {
          field.name = "io";
          field.type = TType.STRUCT;
          field.id = 1;
          oprot.writeFieldBegin(field);
          this.io.write(oprot);
          oprot.writeFieldEnd();
        }
      } else if (this.__isset.nf) {
        if (this.nf != null) {
          field.name = "nf";
          field.type = TType.STRUCT;
          field.id = 2;
          oprot.writeFieldBegin(field);
          this.nf.write(oprot);
          oprot.writeFieldEnd();
        }
      }
      oprot.writeFieldStop();
      oprot.writeStructEnd();
    }

    public String toString() {
      StringBuilder sb = new StringBuilder("deleteTable_result(");
      sb.append("io:");
      sb.append(this.io.toString());
      sb.append(",nf:");
      sb.append(this.nf.toString());
      sb.append(")");
      return sb.toString();
    }

  }

  public static class get_args implements TBase, java.io.Serializable   {
    public byte[] tableName;
    public byte[] row;
    public byte[] column;

    public final Isset __isset = new Isset();
    public static final class Isset implements java.io.Serializable {
      public boolean tableName = false;
      public boolean row = false;
      public boolean column = false;
    }

    public get_args() {
    }

    public get_args(
      byte[] tableName,
      byte[] row,
      byte[] column)
    {
      this();
      this.tableName = tableName;
      this.__isset.tableName = true;
      this.row = row;
      this.__isset.row = true;
      this.column = column;
      this.__isset.column = true;
    }

    public boolean equals(Object that) {
      if (that == null)
        return false;
      if (that instanceof get_args)
        return this.equals((get_args)that);
      return false;
    }

    public boolean equals(get_args that) {
      if (that == null)
        return false;

      boolean this_present_tableName = true && (this.tableName != null);
      boolean that_present_tableName = true && (that.tableName != null);
      if (this_present_tableName || that_present_tableName) {
        if (!(this_present_tableName && that_present_tableName))
          return false;
        if (!java.util.Arrays.equals(this.tableName, that.tableName))
          return false;
      }

      boolean this_present_row = true && (this.row != null);
      boolean that_present_row = true && (that.row != null);
      if (this_present_row || that_present_row) {
        if (!(this_present_row && that_present_row))
          return false;
        if (!java.util.Arrays.equals(this.row, that.row))
          return false;
      }

      boolean this_present_column = true && (this.column != null);
      boolean that_present_column = true && (that.column != null);
      if (this_present_column || that_present_column) {
        if (!(this_present_column && that_present_column))
          return false;
        if (!java.util.Arrays.equals(this.column, that.column))
          return false;
      }

      return true;
    }

    public int hashCode() {
      return 0;
    }

    public void read(TProtocol iprot) throws TException {
      TField field;
      iprot.readStructBegin();
      while (true)
      {
        field = iprot.readFieldBegin();
        if (field.type == TType.STOP) { 
          break;
        }
        switch (field.id)
        {
          case 1:
            if (field.type == TType.STRING) {
              this.tableName = iprot.readBinary();
              this.__isset.tableName = true;
            } else { 
              TProtocolUtil.skip(iprot, field.type);
            }
            break;
          case 2:
            if (field.type == TType.STRING) {
              this.row = iprot.readBinary();
              this.__isset.row = true;
            } else { 
              TProtocolUtil.skip(iprot, field.type);
            }
            break;
          case 3:
            if (field.type == TType.STRING) {
              this.column = iprot.readBinary();
              this.__isset.column = true;
            } else { 
              TProtocolUtil.skip(iprot, field.type);
            }
            break;
          default:
            TProtocolUtil.skip(iprot, field.type);
            break;
        }
        iprot.readFieldEnd();
      }
      iprot.readStructEnd();
    }

    public void write(TProtocol oprot) throws TException {
      TStruct struct = new TStruct("get_args");
      oprot.writeStructBegin(struct);
      TField field = new TField();
      if (this.tableName != null) {
        field.name = "tableName";
        field.type = TType.STRING;
        field.id = 1;
        oprot.writeFieldBegin(field);
        oprot.writeBinary(this.tableName);
        oprot.writeFieldEnd();
      }
      if (this.row != null) {
        field.name = "row";
        field.type = TType.STRING;
        field.id = 2;
        oprot.writeFieldBegin(field);
        oprot.writeBinary(this.row);
        oprot.writeFieldEnd();
      }
      if (this.column != null) {
        field.name = "column";
        field.type = TType.STRING;
        field.id = 3;
        oprot.writeFieldBegin(field);
        oprot.writeBinary(this.column);
        oprot.writeFieldEnd();
      }
      oprot.writeFieldStop();
      oprot.writeStructEnd();
    }

    public String toString() {
      StringBuilder sb = new StringBuilder("get_args(");
      sb.append("tableName:");
      sb.append(this.tableName);
      sb.append(",row:");
      sb.append(this.row);
      sb.append(",column:");
      sb.append(this.column);
      sb.append(")");
      return sb.toString();
    }

  }

  public static class get_result implements TBase, java.io.Serializable   {
    public TCell success;
    public IOError io;
    public NotFound nf;

    public final Isset __isset = new Isset();
    public static final class Isset implements java.io.Serializable {
      public boolean success = false;
      public boolean io = false;
      public boolean nf = false;
    }

    public get_result() {
    }

    public get_result(
      TCell success,
      IOError io,
      NotFound nf)
    {
      this();
      this.success = success;
      this.__isset.success = true;
      this.io = io;
      this.__isset.io = true;
      this.nf = nf;
      this.__isset.nf = true;
    }

    public boolean equals(Object that) {
      if (that == null)
        return false;
      if (that instanceof get_result)
        return this.equals((get_result)that);
      return false;
    }

    public boolean equals(get_result that) {
      if (that == null)
        return false;

      boolean this_present_success = true && (this.success != null);
      boolean that_present_success = true && (that.success != null);
      if (this_present_success || that_present_success) {
        if (!(this_present_success && that_present_success))
          return false;
        if (!this.success.equals(that.success))
          return false;
      }

      boolean this_present_io = true && (this.io != null);
      boolean that_present_io = true && (that.io != null);
      if (this_present_io || that_present_io) {
        if (!(this_present_io && that_present_io))
          return false;
        if (!this.io.equals(that.io))
          return false;
      }

      boolean this_present_nf = true && (this.nf != null);
      boolean that_present_nf = true && (that.nf != null);
      if (this_present_nf || that_present_nf) {
        if (!(this_present_nf && that_present_nf))
          return false;
        if (!this.nf.equals(that.nf))
          return false;
      }

      return true;
    }

    public int hashCode() {
      return 0;
    }

    public void read(TProtocol iprot) throws TException {
      TField field;
      iprot.readStructBegin();
      while (true)
      {
        field = iprot.readFieldBegin();
        if (field.type == TType.STOP) { 
          break;
        }
        switch (field.id)
        {
          case 0:
            if (field.type == TType.STRUCT) {
              this.success = new TCell();
              this.success.read(iprot);
              this.__isset.success = true;
            } else { 
              TProtocolUtil.skip(iprot, field.type);
            }
            break;
          case 1:
            if (field.type == TType.STRUCT) {
              this.io = new IOError();
              this.io.read(iprot);
              this.__isset.io = true;
            } else { 
              TProtocolUtil.skip(iprot, field.type);
            }
            break;
          case 2:
            if (field.type == TType.STRUCT) {
              this.nf = new NotFound();
              this.nf.read(iprot);
              this.__isset.nf = true;
            } else { 
              TProtocolUtil.skip(iprot, field.type);
            }
            break;
          default:
            TProtocolUtil.skip(iprot, field.type);
            break;
        }
        iprot.readFieldEnd();
      }
      iprot.readStructEnd();
    }

    public void write(TProtocol oprot) throws TException {
      TStruct struct = new TStruct("get_result");
      oprot.writeStructBegin(struct);
      TField field = new TField();

      if (this.__isset.success) {
        if (this.success != null) {
          field.name = "success";
          field.type = TType.STRUCT;
          field.id = 0;
          oprot.writeFieldBegin(field);
          this.success.write(oprot);
          oprot.writeFieldEnd();
        }
      } else if (this.__isset.io) {
        if (this.io != null) {
          field.name = "io";
          field.type = TType.STRUCT;
          field.id = 1;
          oprot.writeFieldBegin(field);
          this.io.write(oprot);
          oprot.writeFieldEnd();
        }
      } else if (this.__isset.nf) {
        if (this.nf != null) {
          field.name = "nf";
          field.type = TType.STRUCT;
          field.id = 2;
          oprot.writeFieldBegin(field);
          this.nf.write(oprot);
          oprot.writeFieldEnd();
        }
      }
      oprot.writeFieldStop();
      oprot.writeStructEnd();
    }

    public String toString() {
      StringBuilder sb = new StringBuilder("get_result(");
      sb.append("success:");
      sb.append(this.success.toString());
      sb.append(",io:");
      sb.append(this.io.toString());
      sb.append(",nf:");
      sb.append(this.nf.toString());
      sb.append(")");
      return sb.toString();
    }

  }

  public static class getVer_args implements TBase, java.io.Serializable   {
    public byte[] tableName;
    public byte[] row;
    public byte[] column;
    public int numVersions;

    public final Isset __isset = new Isset();
    public static final class Isset implements java.io.Serializable {
      public boolean tableName = false;
      public boolean row = false;
      public boolean column = false;
      public boolean numVersions = false;
    }

    public getVer_args() {
    }

    public getVer_args(
      byte[] tableName,
      byte[] row,
      byte[] column,
      int numVersions)
    {
      this();
      this.tableName = tableName;
      this.__isset.tableName = true;
      this.row = row;
      this.__isset.row = true;
      this.column = column;
      this.__isset.column = true;
      this.numVersions = numVersions;
      this.__isset.numVersions = true;
    }

    public boolean equals(Object that) {
      if (that == null)
        return false;
      if (that instanceof getVer_args)
        return this.equals((getVer_args)that);
      return false;
    }

    public boolean equals(getVer_args that) {
      if (that == null)
        return false;

      boolean this_present_tableName = true && (this.tableName != null);
      boolean that_present_tableName = true && (that.tableName != null);
      if (this_present_tableName || that_present_tableName) {
        if (!(this_present_tableName && that_present_tableName))
          return false;
        if (!java.util.Arrays.equals(this.tableName, that.tableName))
          return false;
      }

      boolean this_present_row = true && (this.row != null);
      boolean that_present_row = true && (that.row != null);
      if (this_present_row || that_present_row) {
        if (!(this_present_row && that_present_row))
          return false;
        if (!java.util.Arrays.equals(this.row, that.row))
          return false;
      }

      boolean this_present_column = true && (this.column != null);
      boolean that_present_column = true && (that.column != null);
      if (this_present_column || that_present_column) {
        if (!(this_present_column && that_present_column))
          return false;
        if (!java.util.Arrays.equals(this.column, that.column))
          return false;
      }

      boolean this_present_numVersions = true;
      boolean that_present_numVersions = true;
      if (this_present_numVersions || that_present_numVersions) {
        if (!(this_present_numVersions && that_present_numVersions))
          return false;
        if (this.numVersions != that.numVersions)
          return false;
      }

      return true;
    }

    public int hashCode() {
      return 0;
    }

    public void read(TProtocol iprot) throws TException {
      TField field;
      iprot.readStructBegin();
      while (true)
      {
        field = iprot.readFieldBegin();
        if (field.type == TType.STOP) { 
          break;
        }
        switch (field.id)
        {
          case 1:
            if (field.type == TType.STRING) {
              this.tableName = iprot.readBinary();
              this.__isset.tableName = true;
            } else { 
              TProtocolUtil.skip(iprot, field.type);
            }
            break;
          case 2:
            if (field.type == TType.STRING) {
              this.row = iprot.readBinary();
              this.__isset.row = true;
            } else { 
              TProtocolUtil.skip(iprot, field.type);
            }
            break;
          case 3:
            if (field.type == TType.STRING) {
              this.column = iprot.readBinary();
              this.__isset.column = true;
            } else { 
              TProtocolUtil.skip(iprot, field.type);
            }
            break;
          case 4:
            if (field.type == TType.I32) {
              this.numVersions = iprot.readI32();
              this.__isset.numVersions = true;
            } else { 
              TProtocolUtil.skip(iprot, field.type);
            }
            break;
          default:
            TProtocolUtil.skip(iprot, field.type);
            break;
        }
        iprot.readFieldEnd();
      }
      iprot.readStructEnd();
    }

    public void write(TProtocol oprot) throws TException {
      TStruct struct = new TStruct("getVer_args");
      oprot.writeStructBegin(struct);
      TField field = new TField();
      if (this.tableName != null) {
        field.name = "tableName";
        field.type = TType.STRING;
        field.id = 1;
        oprot.writeFieldBegin(field);
        oprot.writeBinary(this.tableName);
        oprot.writeFieldEnd();
      }
      if (this.row != null) {
        field.name = "row";
        field.type = TType.STRING;
        field.id = 2;
        oprot.writeFieldBegin(field);
        oprot.writeBinary(this.row);
        oprot.writeFieldEnd();
      }
      if (this.column != null) {
        field.name = "column";
        field.type = TType.STRING;
        field.id = 3;
        oprot.writeFieldBegin(field);
        oprot.writeBinary(this.column);
        oprot.writeFieldEnd();
      }
      field.name = "numVersions";
      field.type = TType.I32;
      field.id = 4;
      oprot.writeFieldBegin(field);
      oprot.writeI32(this.numVersions);
      oprot.writeFieldEnd();
      oprot.writeFieldStop();
      oprot.writeStructEnd();
    }

    public String toString() {
      StringBuilder sb = new StringBuilder("getVer_args(");
      sb.append("tableName:");
      sb.append(this.tableName);
      sb.append(",row:");
      sb.append(this.row);
      sb.append(",column:");
      sb.append(this.column);
      sb.append(",numVersions:");
      sb.append(this.numVersions);
      sb.append(")");
      return sb.toString();
    }

  }

  public static class getVer_result implements TBase, java.io.Serializable   {
    public List<TCell> success;
    public IOError io;
    public NotFound nf;

    public final Isset __isset = new Isset();
    public static final class Isset implements java.io.Serializable {
      public boolean success = false;
      public boolean io = false;
      public boolean nf = false;
    }

    public getVer_result() {
    }

    public getVer_result(
      List<TCell> success,
      IOError io,
      NotFound nf)
    {
      this();
      this.success = success;
      this.__isset.success = true;
      this.io = io;
      this.__isset.io = true;
      this.nf = nf;
      this.__isset.nf = true;
    }

    public boolean equals(Object that) {
      if (that == null)
        return false;
      if (that instanceof getVer_result)
        return this.equals((getVer_result)that);
      return false;
    }

    public boolean equals(getVer_result that) {
      if (that == null)
        return false;

      boolean this_present_success = true && (this.success != null);
      boolean that_present_success = true && (that.success != null);
      if (this_present_success || that_present_success) {
        if (!(this_present_success && that_present_success))
          return false;
        if (!this.success.equals(that.success))
          return false;
      }

      boolean this_present_io = true && (this.io != null);
      boolean that_present_io = true && (that.io != null);
      if (this_present_io || that_present_io) {
        if (!(this_present_io && that_present_io))
          return false;
        if (!this.io.equals(that.io))
          return false;
      }

      boolean this_present_nf = true && (this.nf != null);
      boolean that_present_nf = true && (that.nf != null);
      if (this_present_nf || that_present_nf) {
        if (!(this_present_nf && that_present_nf))
          return false;
        if (!this.nf.equals(that.nf))
          return false;
      }

      return true;
    }

    public int hashCode() {
      return 0;
    }

    public void read(TProtocol iprot) throws TException {
      TField field;
      iprot.readStructBegin();
      while (true)
      {
        field = iprot.readFieldBegin();
        if (field.type == TType.STOP) { 
          break;
        }
        switch (field.id)
        {
          case 0:
            if (field.type == TType.LIST) {
              {
                TList _list26 = iprot.readListBegin();
                this.success = new ArrayList<TCell>(_list26.size);
                for (int _i27 = 0; _i27 < _list26.size; ++_i27)
                {
                  TCell _elem28 = new TCell();
                  _elem28 = new TCell();
                  _elem28.read(iprot);
                  this.success.add(_elem28);
                }
                iprot.readListEnd();
              }
              this.__isset.success = true;
            } else { 
              TProtocolUtil.skip(iprot, field.type);
            }
            break;
          case 1:
            if (field.type == TType.STRUCT) {
              this.io = new IOError();
              this.io.read(iprot);
              this.__isset.io = true;
            } else { 
              TProtocolUtil.skip(iprot, field.type);
            }
            break;
          case 2:
            if (field.type == TType.STRUCT) {
              this.nf = new NotFound();
              this.nf.read(iprot);
              this.__isset.nf = true;
            } else { 
              TProtocolUtil.skip(iprot, field.type);
            }
            break;
          default:
            TProtocolUtil.skip(iprot, field.type);
            break;
        }
        iprot.readFieldEnd();
      }
      iprot.readStructEnd();
    }

    public void write(TProtocol oprot) throws TException {
      TStruct struct = new TStruct("getVer_result");
      oprot.writeStructBegin(struct);
      TField field = new TField();

      if (this.__isset.success) {
        if (this.success != null) {
          field.name = "success";
          field.type = TType.LIST;
          field.id = 0;
          oprot.writeFieldBegin(field);
          {
            oprot.writeListBegin(new TList(TType.STRUCT, this.success.size()));
            for (TCell _iter29 : this.success)            {
              _iter29.write(oprot);
            }
            oprot.writeListEnd();
          }
          oprot.writeFieldEnd();
        }
      } else if (this.__isset.io) {
        if (this.io != null) {
          field.name = "io";
          field.type = TType.STRUCT;
          field.id = 1;
          oprot.writeFieldBegin(field);
          this.io.write(oprot);
          oprot.writeFieldEnd();
        }
      } else if (this.__isset.nf) {
        if (this.nf != null) {
          field.name = "nf";
          field.type = TType.STRUCT;
          field.id = 2;
          oprot.writeFieldBegin(field);
          this.nf.write(oprot);
          oprot.writeFieldEnd();
        }
      }
      oprot.writeFieldStop();
      oprot.writeStructEnd();
    }

    public String toString() {
      StringBuilder sb = new StringBuilder("getVer_result(");
      sb.append("success:");
      sb.append(this.success);
      sb.append(",io:");
      sb.append(this.io.toString());
      sb.append(",nf:");
      sb.append(this.nf.toString());
      sb.append(")");
      return sb.toString();
    }

  }

  public static class getVerTs_args implements TBase, java.io.Serializable   {
    public byte[] tableName;
    public byte[] row;
    public byte[] column;
    public long timestamp;
    public int numVersions;

    public final Isset __isset = new Isset();
    public static final class Isset implements java.io.Serializable {
      public boolean tableName = false;
      public boolean row = false;
      public boolean column = false;
      public boolean timestamp = false;
      public boolean numVersions = false;
    }

    public getVerTs_args() {
    }

    public getVerTs_args(
      byte[] tableName,
      byte[] row,
      byte[] column,
      long timestamp,
      int numVersions)
    {
      this();
      this.tableName = tableName;
      this.__isset.tableName = true;
      this.row = row;
      this.__isset.row = true;
      this.column = column;
      this.__isset.column = true;
      this.timestamp = timestamp;
      this.__isset.timestamp = true;
      this.numVersions = numVersions;
      this.__isset.numVersions = true;
    }

    public boolean equals(Object that) {
      if (that == null)
        return false;
      if (that instanceof getVerTs_args)
        return this.equals((getVerTs_args)that);
      return false;
    }

    public boolean equals(getVerTs_args that) {
      if (that == null)
        return false;

      boolean this_present_tableName = true && (this.tableName != null);
      boolean that_present_tableName = true && (that.tableName != null);
      if (this_present_tableName || that_present_tableName) {
        if (!(this_present_tableName && that_present_tableName))
          return false;
        if (!java.util.Arrays.equals(this.tableName, that.tableName))
          return false;
      }

      boolean this_present_row = true && (this.row != null);
      boolean that_present_row = true && (that.row != null);
      if (this_present_row || that_present_row) {
        if (!(this_present_row && that_present_row))
          return false;
        if (!java.util.Arrays.equals(this.row, that.row))
          return false;
      }

      boolean this_present_column = true && (this.column != null);
      boolean that_present_column = true && (that.column != null);
      if (this_present_column || that_present_column) {
        if (!(this_present_column && that_present_column))
          return false;
        if (!java.util.Arrays.equals(this.column, that.column))
          return false;
      }

      boolean this_present_timestamp = true;
      boolean that_present_timestamp = true;
      if (this_present_timestamp || that_present_timestamp) {
        if (!(this_present_timestamp && that_present_timestamp))
          return false;
        if (this.timestamp != that.timestamp)
          return false;
      }

      boolean this_present_numVersions = true;
      boolean that_present_numVersions = true;
      if (this_present_numVersions || that_present_numVersions) {
        if (!(this_present_numVersions && that_present_numVersions))
          return false;
        if (this.numVersions != that.numVersions)
          return false;
      }

      return true;
    }

    public int hashCode() {
      return 0;
    }

    public void read(TProtocol iprot) throws TException {
      TField field;
      iprot.readStructBegin();
      while (true)
      {
        field = iprot.readFieldBegin();
        if (field.type == TType.STOP) { 
          break;
        }
        switch (field.id)
        {
          case 1:
            if (field.type == TType.STRING) {
              this.tableName = iprot.readBinary();
              this.__isset.tableName = true;
            } else { 
              TProtocolUtil.skip(iprot, field.type);
            }
            break;
          case 2:
            if (field.type == TType.STRING) {
              this.row = iprot.readBinary();
              this.__isset.row = true;
            } else { 
              TProtocolUtil.skip(iprot, field.type);
            }
            break;
          case 3:
            if (field.type == TType.STRING) {
              this.column = iprot.readBinary();
              this.__isset.column = true;
            } else { 
              TProtocolUtil.skip(iprot, field.type);
            }
            break;
          case 4:
            if (field.type == TType.I64) {
              this.timestamp = iprot.readI64();
              this.__isset.timestamp = true;
            } else { 
              TProtocolUtil.skip(iprot, field.type);
            }
            break;
          case 5:
            if (field.type == TType.I32) {
              this.numVersions = iprot.readI32();
              this.__isset.numVersions = true;
            } else { 
              TProtocolUtil.skip(iprot, field.type);
            }
            break;
          default:
            TProtocolUtil.skip(iprot, field.type);
            break;
        }
        iprot.readFieldEnd();
      }
      iprot.readStructEnd();
    }

    public void write(TProtocol oprot) throws TException {
      TStruct struct = new TStruct("getVerTs_args");
      oprot.writeStructBegin(struct);
      TField field = new TField();
      if (this.tableName != null) {
        field.name = "tableName";
        field.type = TType.STRING;
        field.id = 1;
        oprot.writeFieldBegin(field);
        oprot.writeBinary(this.tableName);
        oprot.writeFieldEnd();
      }
      if (this.row != null) {
        field.name = "row";
        field.type = TType.STRING;
        field.id = 2;
        oprot.writeFieldBegin(field);
        oprot.writeBinary(this.row);
        oprot.writeFieldEnd();
      }
      if (this.column != null) {
        field.name = "column";
        field.type = TType.STRING;
        field.id = 3;
        oprot.writeFieldBegin(field);
        oprot.writeBinary(this.column);
        oprot.writeFieldEnd();
      }
      field.name = "timestamp";
      field.type = TType.I64;
      field.id = 4;
      oprot.writeFieldBegin(field);
      oprot.writeI64(this.timestamp);
      oprot.writeFieldEnd();
      field.name = "numVersions";
      field.type = TType.I32;
      field.id = 5;
      oprot.writeFieldBegin(field);
      oprot.writeI32(this.numVersions);
      oprot.writeFieldEnd();
      oprot.writeFieldStop();
      oprot.writeStructEnd();
    }

    public String toString() {
      StringBuilder sb = new StringBuilder("getVerTs_args(");
      sb.append("tableName:");
      sb.append(this.tableName);
      sb.append(",row:");
      sb.append(this.row);
      sb.append(",column:");
      sb.append(this.column);
      sb.append(",timestamp:");
      sb.append(this.timestamp);
      sb.append(",numVersions:");
      sb.append(this.numVersions);
      sb.append(")");
      return sb.toString();
    }

  }

  public static class getVerTs_result implements TBase, java.io.Serializable   {
    public List<TCell> success;
    public IOError io;
    public NotFound nf;

    public final Isset __isset = new Isset();
    public static final class Isset implements java.io.Serializable {
      public boolean success = false;
      public boolean io = false;
      public boolean nf = false;
    }

    public getVerTs_result() {
    }

    public getVerTs_result(
      List<TCell> success,
      IOError io,
      NotFound nf)
    {
      this();
      this.success = success;
      this.__isset.success = true;
      this.io = io;
      this.__isset.io = true;
      this.nf = nf;
      this.__isset.nf = true;
    }

    public boolean equals(Object that) {
      if (that == null)
        return false;
      if (that instanceof getVerTs_result)
        return this.equals((getVerTs_result)that);
      return false;
    }

    public boolean equals(getVerTs_result that) {
      if (that == null)
        return false;

      boolean this_present_success = true && (this.success != null);
      boolean that_present_success = true && (that.success != null);
      if (this_present_success || that_present_success) {
        if (!(this_present_success && that_present_success))
          return false;
        if (!this.success.equals(that.success))
          return false;
      }

      boolean this_present_io = true && (this.io != null);
      boolean that_present_io = true && (that.io != null);
      if (this_present_io || that_present_io) {
        if (!(this_present_io && that_present_io))
          return false;
        if (!this.io.equals(that.io))
          return false;
      }

      boolean this_present_nf = true && (this.nf != null);
      boolean that_present_nf = true && (that.nf != null);
      if (this_present_nf || that_present_nf) {
        if (!(this_present_nf && that_present_nf))
          return false;
        if (!this.nf.equals(that.nf))
          return false;
      }

      return true;
    }

    public int hashCode() {
      return 0;
    }

    public void read(TProtocol iprot) throws TException {
      TField field;
      iprot.readStructBegin();
      while (true)
      {
        field = iprot.readFieldBegin();
        if (field.type == TType.STOP) { 
          break;
        }
        switch (field.id)
        {
          case 0:
            if (field.type == TType.LIST) {
              {
                TList _list30 = iprot.readListBegin();
                this.success = new ArrayList<TCell>(_list30.size);
                for (int _i31 = 0; _i31 < _list30.size; ++_i31)
                {
                  TCell _elem32 = new TCell();
                  _elem32 = new TCell();
                  _elem32.read(iprot);
                  this.success.add(_elem32);
                }
                iprot.readListEnd();
              }
              this.__isset.success = true;
            } else { 
              TProtocolUtil.skip(iprot, field.type);
            }
            break;
          case 1:
            if (field.type == TType.STRUCT) {
              this.io = new IOError();
              this.io.read(iprot);
              this.__isset.io = true;
            } else { 
              TProtocolUtil.skip(iprot, field.type);
            }
            break;
          case 2:
            if (field.type == TType.STRUCT) {
              this.nf = new NotFound();
              this.nf.read(iprot);
              this.__isset.nf = true;
            } else { 
              TProtocolUtil.skip(iprot, field.type);
            }
            break;
          default:
            TProtocolUtil.skip(iprot, field.type);
            break;
        }
        iprot.readFieldEnd();
      }
      iprot.readStructEnd();
    }

    public void write(TProtocol oprot) throws TException {
      TStruct struct = new TStruct("getVerTs_result");
      oprot.writeStructBegin(struct);
      TField field = new TField();

      if (this.__isset.success) {
        if (this.success != null) {
          field.name = "success";
          field.type = TType.LIST;
          field.id = 0;
          oprot.writeFieldBegin(field);
          {
            oprot.writeListBegin(new TList(TType.STRUCT, this.success.size()));
            for (TCell _iter33 : this.success)            {
              _iter33.write(oprot);
            }
            oprot.writeListEnd();
          }
          oprot.writeFieldEnd();
        }
      } else if (this.__isset.io) {
        if (this.io != null) {
          field.name = "io";
          field.type = TType.STRUCT;
          field.id = 1;
          oprot.writeFieldBegin(field);
          this.io.write(oprot);
          oprot.writeFieldEnd();
        }
      } else if (this.__isset.nf) {
        if (this.nf != null) {
          field.name = "nf";
          field.type = TType.STRUCT;
          field.id = 2;
          oprot.writeFieldBegin(field);
          this.nf.write(oprot);
          oprot.writeFieldEnd();
        }
      }
      oprot.writeFieldStop();
      oprot.writeStructEnd();
    }

    public String toString() {
      StringBuilder sb = new StringBuilder("getVerTs_result(");
      sb.append("success:");
      sb.append(this.success);
      sb.append(",io:");
      sb.append(this.io.toString());
      sb.append(",nf:");
      sb.append(this.nf.toString());
      sb.append(")");
      return sb.toString();
    }

  }

  public static class getRow_args implements TBase, java.io.Serializable   {
    public byte[] tableName;
    public byte[] row;

    public final Isset __isset = new Isset();
    public static final class Isset implements java.io.Serializable {
      public boolean tableName = false;
      public boolean row = false;
    }

    public getRow_args() {
    }

    public getRow_args(
      byte[] tableName,
      byte[] row)
    {
      this();
      this.tableName = tableName;
      this.__isset.tableName = true;
      this.row = row;
      this.__isset.row = true;
    }

    public boolean equals(Object that) {
      if (that == null)
        return false;
      if (that instanceof getRow_args)
        return this.equals((getRow_args)that);
      return false;
    }

    public boolean equals(getRow_args that) {
      if (that == null)
        return false;

      boolean this_present_tableName = true && (this.tableName != null);
      boolean that_present_tableName = true && (that.tableName != null);
      if (this_present_tableName || that_present_tableName) {
        if (!(this_present_tableName && that_present_tableName))
          return false;
        if (!java.util.Arrays.equals(this.tableName, that.tableName))
          return false;
      }

      boolean this_present_row = true && (this.row != null);
      boolean that_present_row = true && (that.row != null);
      if (this_present_row || that_present_row) {
        if (!(this_present_row && that_present_row))
          return false;
        if (!java.util.Arrays.equals(this.row, that.row))
          return false;
      }

      return true;
    }

    public int hashCode() {
      return 0;
    }

    public void read(TProtocol iprot) throws TException {
      TField field;
      iprot.readStructBegin();
      while (true)
      {
        field = iprot.readFieldBegin();
        if (field.type == TType.STOP) { 
          break;
        }
        switch (field.id)
        {
          case 1:
            if (field.type == TType.STRING) {
              this.tableName = iprot.readBinary();
              this.__isset.tableName = true;
            } else { 
              TProtocolUtil.skip(iprot, field.type);
            }
            break;
          case 2:
            if (field.type == TType.STRING) {
              this.row = iprot.readBinary();
              this.__isset.row = true;
            } else { 
              TProtocolUtil.skip(iprot, field.type);
            }
            break;
          default:
            TProtocolUtil.skip(iprot, field.type);
            break;
        }
        iprot.readFieldEnd();
      }
      iprot.readStructEnd();
    }

    public void write(TProtocol oprot) throws TException {
      TStruct struct = new TStruct("getRow_args");
      oprot.writeStructBegin(struct);
      TField field = new TField();
      if (this.tableName != null) {
        field.name = "tableName";
        field.type = TType.STRING;
        field.id = 1;
        oprot.writeFieldBegin(field);
        oprot.writeBinary(this.tableName);
        oprot.writeFieldEnd();
      }
      if (this.row != null) {
        field.name = "row";
        field.type = TType.STRING;
        field.id = 2;
        oprot.writeFieldBegin(field);
        oprot.writeBinary(this.row);
        oprot.writeFieldEnd();
      }
      oprot.writeFieldStop();
      oprot.writeStructEnd();
    }

    public String toString() {
      StringBuilder sb = new StringBuilder("getRow_args(");
      sb.append("tableName:");
      sb.append(this.tableName);
      sb.append(",row:");
      sb.append(this.row);
      sb.append(")");
      return sb.toString();
    }

  }

  public static class getRow_result implements TBase, java.io.Serializable   {
    public TRowResult success;
    public IOError io;

    public final Isset __isset = new Isset();
    public static final class Isset implements java.io.Serializable {
      public boolean success = false;
      public boolean io = false;
    }

    public getRow_result() {
    }

    public getRow_result(
      TRowResult success,
      IOError io)
    {
      this();
      this.success = success;
      this.__isset.success = true;
      this.io = io;
      this.__isset.io = true;
    }

    public boolean equals(Object that) {
      if (that == null)
        return false;
      if (that instanceof getRow_result)
        return this.equals((getRow_result)that);
      return false;
    }

    public boolean equals(getRow_result that) {
      if (that == null)
        return false;

      boolean this_present_success = true && (this.success != null);
      boolean that_present_success = true && (that.success != null);
      if (this_present_success || that_present_success) {
        if (!(this_present_success && that_present_success))
          return false;
        if (!this.success.equals(that.success))
          return false;
      }

      boolean this_present_io = true && (this.io != null);
      boolean that_present_io = true && (that.io != null);
      if (this_present_io || that_present_io) {
        if (!(this_present_io && that_present_io))
          return false;
        if (!this.io.equals(that.io))
          return false;
      }

      return true;
    }

    public int hashCode() {
      return 0;
    }

    public void read(TProtocol iprot) throws TException {
      TField field;
      iprot.readStructBegin();
      while (true)
      {
        field = iprot.readFieldBegin();
        if (field.type == TType.STOP) { 
          break;
        }
        switch (field.id)
        {
          case 0:
            if (field.type == TType.STRUCT) {
              this.success = new TRowResult();
              this.success.read(iprot);
              this.__isset.success = true;
            } else { 
              TProtocolUtil.skip(iprot, field.type);
            }
            break;
          case 1:
            if (field.type == TType.STRUCT) {
              this.io = new IOError();
              this.io.read(iprot);
              this.__isset.io = true;
            } else { 
              TProtocolUtil.skip(iprot, field.type);
            }
            break;
          default:
            TProtocolUtil.skip(iprot, field.type);
            break;
        }
        iprot.readFieldEnd();
      }
      iprot.readStructEnd();
    }

    public void write(TProtocol oprot) throws TException {
      TStruct struct = new TStruct("getRow_result");
      oprot.writeStructBegin(struct);
      TField field = new TField();

      if (this.__isset.success) {
        if (this.success != null) {
          field.name = "success";
          field.type = TType.STRUCT;
          field.id = 0;
          oprot.writeFieldBegin(field);
          this.success.write(oprot);
          oprot.writeFieldEnd();
        }
      } else if (this.__isset.io) {
        if (this.io != null) {
          field.name = "io";
          field.type = TType.STRUCT;
          field.id = 1;
          oprot.writeFieldBegin(field);
          this.io.write(oprot);
          oprot.writeFieldEnd();
        }
      }
      oprot.writeFieldStop();
      oprot.writeStructEnd();
    }

    public String toString() {
      StringBuilder sb = new StringBuilder("getRow_result(");
      sb.append("success:");
      sb.append(this.success.toString());
      sb.append(",io:");
      sb.append(this.io.toString());
      sb.append(")");
      return sb.toString();
    }

  }

  public static class getRowTs_args implements TBase, java.io.Serializable   {
    public byte[] tableName;
    public byte[] row;
    public long timestamp;

    public final Isset __isset = new Isset();
    public static final class Isset implements java.io.Serializable {
      public boolean tableName = false;
      public boolean row = false;
      public boolean timestamp = false;
    }

    public getRowTs_args() {
    }

    public getRowTs_args(
      byte[] tableName,
      byte[] row,
      long timestamp)
    {
      this();
      this.tableName = tableName;
      this.__isset.tableName = true;
      this.row = row;
      this.__isset.row = true;
      this.timestamp = timestamp;
      this.__isset.timestamp = true;
    }

    public boolean equals(Object that) {
      if (that == null)
        return false;
      if (that instanceof getRowTs_args)
        return this.equals((getRowTs_args)that);
      return false;
    }

    public boolean equals(getRowTs_args that) {
      if (that == null)
        return false;

      boolean this_present_tableName = true && (this.tableName != null);
      boolean that_present_tableName = true && (that.tableName != null);
      if (this_present_tableName || that_present_tableName) {
        if (!(this_present_tableName && that_present_tableName))
          return false;
        if (!java.util.Arrays.equals(this.tableName, that.tableName))
          return false;
      }

      boolean this_present_row = true && (this.row != null);
      boolean that_present_row = true && (that.row != null);
      if (this_present_row || that_present_row) {
        if (!(this_present_row && that_present_row))
          return false;
        if (!java.util.Arrays.equals(this.row, that.row))
          return false;
      }

      boolean this_present_timestamp = true;
      boolean that_present_timestamp = true;
      if (this_present_timestamp || that_present_timestamp) {
        if (!(this_present_timestamp && that_present_timestamp))
          return false;
        if (this.timestamp != that.timestamp)
          return false;
      }

      return true;
    }

    public int hashCode() {
      return 0;
    }

    public void read(TProtocol iprot) throws TException {
      TField field;
      iprot.readStructBegin();
      while (true)
      {
        field = iprot.readFieldBegin();
        if (field.type == TType.STOP) { 
          break;
        }
        switch (field.id)
        {
          case 1:
            if (field.type == TType.STRING) {
              this.tableName = iprot.readBinary();
              this.__isset.tableName = true;
            } else { 
              TProtocolUtil.skip(iprot, field.type);
            }
            break;
          case 2:
            if (field.type == TType.STRING) {
              this.row = iprot.readBinary();
              this.__isset.row = true;
            } else { 
              TProtocolUtil.skip(iprot, field.type);
            }
            break;
          case 3:
            if (field.type == TType.I64) {
              this.timestamp = iprot.readI64();
              this.__isset.timestamp = true;
            } else { 
              TProtocolUtil.skip(iprot, field.type);
            }
            break;
          default:
            TProtocolUtil.skip(iprot, field.type);
            break;
        }
        iprot.readFieldEnd();
      }
      iprot.readStructEnd();
    }

    public void write(TProtocol oprot) throws TException {
      TStruct struct = new TStruct("getRowTs_args");
      oprot.writeStructBegin(struct);
      TField field = new TField();
      if (this.tableName != null) {
        field.name = "tableName";
        field.type = TType.STRING;
        field.id = 1;
        oprot.writeFieldBegin(field);
        oprot.writeBinary(this.tableName);
        oprot.writeFieldEnd();
      }
      if (this.row != null) {
        field.name = "row";
        field.type = TType.STRING;
        field.id = 2;
        oprot.writeFieldBegin(field);
        oprot.writeBinary(this.row);
        oprot.writeFieldEnd();
      }
      field.name = "timestamp";
      field.type = TType.I64;
      field.id = 3;
      oprot.writeFieldBegin(field);
      oprot.writeI64(this.timestamp);
      oprot.writeFieldEnd();
      oprot.writeFieldStop();
      oprot.writeStructEnd();
    }

    public String toString() {
      StringBuilder sb = new StringBuilder("getRowTs_args(");
      sb.append("tableName:");
      sb.append(this.tableName);
      sb.append(",row:");
      sb.append(this.row);
      sb.append(",timestamp:");
      sb.append(this.timestamp);
      sb.append(")");
      return sb.toString();
    }

  }

  public static class getRowTs_result implements TBase, java.io.Serializable   {
    public TRowResult success;
    public IOError io;

    public final Isset __isset = new Isset();
    public static final class Isset implements java.io.Serializable {
      public boolean success = false;
      public boolean io = false;
    }

    public getRowTs_result() {
    }

    public getRowTs_result(
      TRowResult success,
      IOError io)
    {
      this();
      this.success = success;
      this.__isset.success = true;
      this.io = io;
      this.__isset.io = true;
    }

    public boolean equals(Object that) {
      if (that == null)
        return false;
      if (that instanceof getRowTs_result)
        return this.equals((getRowTs_result)that);
      return false;
    }

    public boolean equals(getRowTs_result that) {
      if (that == null)
        return false;

      boolean this_present_success = true && (this.success != null);
      boolean that_present_success = true && (that.success != null);
      if (this_present_success || that_present_success) {
        if (!(this_present_success && that_present_success))
          return false;
        if (!this.success.equals(that.success))
          return false;
      }

      boolean this_present_io = true && (this.io != null);
      boolean that_present_io = true && (that.io != null);
      if (this_present_io || that_present_io) {
        if (!(this_present_io && that_present_io))
          return false;
        if (!this.io.equals(that.io))
          return false;
      }

      return true;
    }

    public int hashCode() {
      return 0;
    }

    public void read(TProtocol iprot) throws TException {
      TField field;
      iprot.readStructBegin();
      while (true)
      {
        field = iprot.readFieldBegin();
        if (field.type == TType.STOP) { 
          break;
        }
        switch (field.id)
        {
          case 0:
            if (field.type == TType.STRUCT) {
              this.success = new TRowResult();
              this.success.read(iprot);
              this.__isset.success = true;
            } else { 
              TProtocolUtil.skip(iprot, field.type);
            }
            break;
          case 1:
            if (field.type == TType.STRUCT) {
              this.io = new IOError();
              this.io.read(iprot);
              this.__isset.io = true;
            } else { 
              TProtocolUtil.skip(iprot, field.type);
            }
            break;
          default:
            TProtocolUtil.skip(iprot, field.type);
            break;
        }
        iprot.readFieldEnd();
      }
      iprot.readStructEnd();
    }

    public void write(TProtocol oprot) throws TException {
      TStruct struct = new TStruct("getRowTs_result");
      oprot.writeStructBegin(struct);
      TField field = new TField();

      if (this.__isset.success) {
        if (this.success != null) {
          field.name = "success";
          field.type = TType.STRUCT;
          field.id = 0;
          oprot.writeFieldBegin(field);
          this.success.write(oprot);
          oprot.writeFieldEnd();
        }
      } else if (this.__isset.io) {
        if (this.io != null) {
          field.name = "io";
          field.type = TType.STRUCT;
          field.id = 1;
          oprot.writeFieldBegin(field);
          this.io.write(oprot);
          oprot.writeFieldEnd();
        }
      }
      oprot.writeFieldStop();
      oprot.writeStructEnd();
    }

    public String toString() {
      StringBuilder sb = new StringBuilder("getRowTs_result(");
      sb.append("success:");
      sb.append(this.success.toString());
      sb.append(",io:");
      sb.append(this.io.toString());
      sb.append(")");
      return sb.toString();
    }

  }

  public static class mutateRow_args implements TBase, java.io.Serializable   {
    public byte[] tableName;
    public byte[] row;
    public List<Mutation> mutations;

    public final Isset __isset = new Isset();
    public static final class Isset implements java.io.Serializable {
      public boolean tableName = false;
      public boolean row = false;
      public boolean mutations = false;
    }

    public mutateRow_args() {
    }

    public mutateRow_args(
      byte[] tableName,
      byte[] row,
      List<Mutation> mutations)
    {
      this();
      this.tableName = tableName;
      this.__isset.tableName = true;
      this.row = row;
      this.__isset.row = true;
      this.mutations = mutations;
      this.__isset.mutations = true;
    }

    public boolean equals(Object that) {
      if (that == null)
        return false;
      if (that instanceof mutateRow_args)
        return this.equals((mutateRow_args)that);
      return false;
    }

    public boolean equals(mutateRow_args that) {
      if (that == null)
        return false;

      boolean this_present_tableName = true && (this.tableName != null);
      boolean that_present_tableName = true && (that.tableName != null);
      if (this_present_tableName || that_present_tableName) {
        if (!(this_present_tableName && that_present_tableName))
          return false;
        if (!java.util.Arrays.equals(this.tableName, that.tableName))
          return false;
      }

      boolean this_present_row = true && (this.row != null);
      boolean that_present_row = true && (that.row != null);
      if (this_present_row || that_present_row) {
        if (!(this_present_row && that_present_row))
          return false;
        if (!java.util.Arrays.equals(this.row, that.row))
          return false;
      }

      boolean this_present_mutations = true && (this.mutations != null);
      boolean that_present_mutations = true && (that.mutations != null);
      if (this_present_mutations || that_present_mutations) {
        if (!(this_present_mutations && that_present_mutations))
          return false;
        if (!this.mutations.equals(that.mutations))
          return false;
      }

      return true;
    }

    public int hashCode() {
      return 0;
    }

    public void read(TProtocol iprot) throws TException {
      TField field;
      iprot.readStructBegin();
      while (true)
      {
        field = iprot.readFieldBegin();
        if (field.type == TType.STOP) { 
          break;
        }
        switch (field.id)
        {
          case 1:
            if (field.type == TType.STRING) {
              this.tableName = iprot.readBinary();
              this.__isset.tableName = true;
            } else { 
              TProtocolUtil.skip(iprot, field.type);
            }
            break;
          case 2:
            if (field.type == TType.STRING) {
              this.row = iprot.readBinary();
              this.__isset.row = true;
            } else { 
              TProtocolUtil.skip(iprot, field.type);
            }
            break;
          case 3:
            if (field.type == TType.LIST) {
              {
                TList _list34 = iprot.readListBegin();
                this.mutations = new ArrayList<Mutation>(_list34.size);
                for (int _i35 = 0; _i35 < _list34.size; ++_i35)
                {
                  Mutation _elem36 = new Mutation();
                  _elem36 = new Mutation();
                  _elem36.read(iprot);
                  this.mutations.add(_elem36);
                }
                iprot.readListEnd();
              }
              this.__isset.mutations = true;
            } else { 
              TProtocolUtil.skip(iprot, field.type);
            }
            break;
          default:
            TProtocolUtil.skip(iprot, field.type);
            break;
        }
        iprot.readFieldEnd();
      }
      iprot.readStructEnd();
    }

    public void write(TProtocol oprot) throws TException {
      TStruct struct = new TStruct("mutateRow_args");
      oprot.writeStructBegin(struct);
      TField field = new TField();
      if (this.tableName != null) {
        field.name = "tableName";
        field.type = TType.STRING;
        field.id = 1;
        oprot.writeFieldBegin(field);
        oprot.writeBinary(this.tableName);
        oprot.writeFieldEnd();
      }
      if (this.row != null) {
        field.name = "row";
        field.type = TType.STRING;
        field.id = 2;
        oprot.writeFieldBegin(field);
        oprot.writeBinary(this.row);
        oprot.writeFieldEnd();
      }
      if (this.mutations != null) {
        field.name = "mutations";
        field.type = TType.LIST;
        field.id = 3;
        oprot.writeFieldBegin(field);
        {
          oprot.writeListBegin(new TList(TType.STRUCT, this.mutations.size()));
          for (Mutation _iter37 : this.mutations)          {
            _iter37.write(oprot);
          }
          oprot.writeListEnd();
        }
        oprot.writeFieldEnd();
      }
      oprot.writeFieldStop();
      oprot.writeStructEnd();
    }

    public String toString() {
      StringBuilder sb = new StringBuilder("mutateRow_args(");
      sb.append("tableName:");
      sb.append(this.tableName);
      sb.append(",row:");
      sb.append(this.row);
      sb.append(",mutations:");
      sb.append(this.mutations);
      sb.append(")");
      return sb.toString();
    }

  }

  public static class mutateRow_result implements TBase, java.io.Serializable   {
    public IOError io;
    public IllegalArgument ia;

    public final Isset __isset = new Isset();
    public static final class Isset implements java.io.Serializable {
      public boolean io = false;
      public boolean ia = false;
    }

    public mutateRow_result() {
    }

    public mutateRow_result(
      IOError io,
      IllegalArgument ia)
    {
      this();
      this.io = io;
      this.__isset.io = true;
      this.ia = ia;
      this.__isset.ia = true;
    }

    public boolean equals(Object that) {
      if (that == null)
        return false;
      if (that instanceof mutateRow_result)
        return this.equals((mutateRow_result)that);
      return false;
    }

    public boolean equals(mutateRow_result that) {
      if (that == null)
        return false;

      boolean this_present_io = true && (this.io != null);
      boolean that_present_io = true && (that.io != null);
      if (this_present_io || that_present_io) {
        if (!(this_present_io && that_present_io))
          return false;
        if (!this.io.equals(that.io))
          return false;
      }

      boolean this_present_ia = true && (this.ia != null);
      boolean that_present_ia = true && (that.ia != null);
      if (this_present_ia || that_present_ia) {
        if (!(this_present_ia && that_present_ia))
          return false;
        if (!this.ia.equals(that.ia))
          return false;
      }

      return true;
    }

    public int hashCode() {
      return 0;
    }

    public void read(TProtocol iprot) throws TException {
      TField field;
      iprot.readStructBegin();
      while (true)
      {
        field = iprot.readFieldBegin();
        if (field.type == TType.STOP) { 
          break;
        }
        switch (field.id)
        {
          case 1:
            if (field.type == TType.STRUCT) {
              this.io = new IOError();
              this.io.read(iprot);
              this.__isset.io = true;
            } else { 
              TProtocolUtil.skip(iprot, field.type);
            }
            break;
          case 2:
            if (field.type == TType.STRUCT) {
              this.ia = new IllegalArgument();
              this.ia.read(iprot);
              this.__isset.ia = true;
            } else { 
              TProtocolUtil.skip(iprot, field.type);
            }
            break;
          default:
            TProtocolUtil.skip(iprot, field.type);
            break;
        }
        iprot.readFieldEnd();
      }
      iprot.readStructEnd();
    }

    public void write(TProtocol oprot) throws TException {
      TStruct struct = new TStruct("mutateRow_result");
      oprot.writeStructBegin(struct);
      TField field = new TField();

      if (this.__isset.io) {
        if (this.io != null) {
          field.name = "io";
          field.type = TType.STRUCT;
          field.id = 1;
          oprot.writeFieldBegin(field);
          this.io.write(oprot);
          oprot.writeFieldEnd();
        }
      } else if (this.__isset.ia) {
        if (this.ia != null) {
          field.name = "ia";
          field.type = TType.STRUCT;
          field.id = 2;
          oprot.writeFieldBegin(field);
          this.ia.write(oprot);
          oprot.writeFieldEnd();
        }
      }
      oprot.writeFieldStop();
      oprot.writeStructEnd();
    }

    public String toString() {
      StringBuilder sb = new StringBuilder("mutateRow_result(");
      sb.append("io:");
      sb.append(this.io.toString());
      sb.append(",ia:");
      sb.append(this.ia.toString());
      sb.append(")");
      return sb.toString();
    }

  }

  public static class mutateRowTs_args implements TBase, java.io.Serializable   {
    public byte[] tableName;
    public byte[] row;
    public List<Mutation> mutations;
    public long timestamp;

    public final Isset __isset = new Isset();
    public static final class Isset implements java.io.Serializable {
      public boolean tableName = false;
      public boolean row = false;
      public boolean mutations = false;
      public boolean timestamp = false;
    }

    public mutateRowTs_args() {
    }

    public mutateRowTs_args(
      byte[] tableName,
      byte[] row,
      List<Mutation> mutations,
      long timestamp)
    {
      this();
      this.tableName = tableName;
      this.__isset.tableName = true;
      this.row = row;
      this.__isset.row = true;
      this.mutations = mutations;
      this.__isset.mutations = true;
      this.timestamp = timestamp;
      this.__isset.timestamp = true;
    }

    public boolean equals(Object that) {
      if (that == null)
        return false;
      if (that instanceof mutateRowTs_args)
        return this.equals((mutateRowTs_args)that);
      return false;
    }

    public boolean equals(mutateRowTs_args that) {
      if (that == null)
        return false;

      boolean this_present_tableName = true && (this.tableName != null);
      boolean that_present_tableName = true && (that.tableName != null);
      if (this_present_tableName || that_present_tableName) {
        if (!(this_present_tableName && that_present_tableName))
          return false;
        if (!java.util.Arrays.equals(this.tableName, that.tableName))
          return false;
      }

      boolean this_present_row = true && (this.row != null);
      boolean that_present_row = true && (that.row != null);
      if (this_present_row || that_present_row) {
        if (!(this_present_row && that_present_row))
          return false;
        if (!java.util.Arrays.equals(this.row, that.row))
          return false;
      }

      boolean this_present_mutations = true && (this.mutations != null);
      boolean that_present_mutations = true && (that.mutations != null);
      if (this_present_mutations || that_present_mutations) {
        if (!(this_present_mutations && that_present_mutations))
          return false;
        if (!this.mutations.equals(that.mutations))
          return false;
      }

      boolean this_present_timestamp = true;
      boolean that_present_timestamp = true;
      if (this_present_timestamp || that_present_timestamp) {
        if (!(this_present_timestamp && that_present_timestamp))
          return false;
        if (this.timestamp != that.timestamp)
          return false;
      }

      return true;
    }

    public int hashCode() {
      return 0;
    }

    public void read(TProtocol iprot) throws TException {
      TField field;
      iprot.readStructBegin();
      while (true)
      {
        field = iprot.readFieldBegin();
        if (field.type == TType.STOP) { 
          break;
        }
        switch (field.id)
        {
          case 1:
            if (field.type == TType.STRING) {
              this.tableName = iprot.readBinary();
              this.__isset.tableName = true;
            } else { 
              TProtocolUtil.skip(iprot, field.type);
            }
            break;
          case 2:
            if (field.type == TType.STRING) {
              this.row = iprot.readBinary();
              this.__isset.row = true;
            } else { 
              TProtocolUtil.skip(iprot, field.type);
            }
            break;
          case 3:
            if (field.type == TType.LIST) {
              {
                TList _list38 = iprot.readListBegin();
                this.mutations = new ArrayList<Mutation>(_list38.size);
                for (int _i39 = 0; _i39 < _list38.size; ++_i39)
                {
                  Mutation _elem40 = new Mutation();
                  _elem40 = new Mutation();
                  _elem40.read(iprot);
                  this.mutations.add(_elem40);
                }
                iprot.readListEnd();
              }
              this.__isset.mutations = true;
            } else { 
              TProtocolUtil.skip(iprot, field.type);
            }
            break;
          case 4:
            if (field.type == TType.I64) {
              this.timestamp = iprot.readI64();
              this.__isset.timestamp = true;
            } else { 
              TProtocolUtil.skip(iprot, field.type);
            }
            break;
          default:
            TProtocolUtil.skip(iprot, field.type);
            break;
        }
        iprot.readFieldEnd();
      }
      iprot.readStructEnd();
    }

    public void write(TProtocol oprot) throws TException {
      TStruct struct = new TStruct("mutateRowTs_args");
      oprot.writeStructBegin(struct);
      TField field = new TField();
      if (this.tableName != null) {
        field.name = "tableName";
        field.type = TType.STRING;
        field.id = 1;
        oprot.writeFieldBegin(field);
        oprot.writeBinary(this.tableName);
        oprot.writeFieldEnd();
      }
      if (this.row != null) {
        field.name = "row";
        field.type = TType.STRING;
        field.id = 2;
        oprot.writeFieldBegin(field);
        oprot.writeBinary(this.row);
        oprot.writeFieldEnd();
      }
      if (this.mutations != null) {
        field.name = "mutations";
        field.type = TType.LIST;
        field.id = 3;
        oprot.writeFieldBegin(field);
        {
          oprot.writeListBegin(new TList(TType.STRUCT, this.mutations.size()));
          for (Mutation _iter41 : this.mutations)          {
            _iter41.write(oprot);
          }
          oprot.writeListEnd();
        }
        oprot.writeFieldEnd();
      }
      field.name = "timestamp";
      field.type = TType.I64;
      field.id = 4;
      oprot.writeFieldBegin(field);
      oprot.writeI64(this.timestamp);
      oprot.writeFieldEnd();
      oprot.writeFieldStop();
      oprot.writeStructEnd();
    }

    public String toString() {
      StringBuilder sb = new StringBuilder("mutateRowTs_args(");
      sb.append("tableName:");
      sb.append(this.tableName);
      sb.append(",row:");
      sb.append(this.row);
      sb.append(",mutations:");
      sb.append(this.mutations);
      sb.append(",timestamp:");
      sb.append(this.timestamp);
      sb.append(")");
      return sb.toString();
    }

  }

  public static class mutateRowTs_result implements TBase, java.io.Serializable   {
    public IOError io;
    public IllegalArgument ia;

    public final Isset __isset = new Isset();
    public static final class Isset implements java.io.Serializable {
      public boolean io = false;
      public boolean ia = false;
    }

    public mutateRowTs_result() {
    }

    public mutateRowTs_result(
      IOError io,
      IllegalArgument ia)
    {
      this();
      this.io = io;
      this.__isset.io = true;
      this.ia = ia;
      this.__isset.ia = true;
    }

    public boolean equals(Object that) {
      if (that == null)
        return false;
      if (that instanceof mutateRowTs_result)
        return this.equals((mutateRowTs_result)that);
      return false;
    }

    public boolean equals(mutateRowTs_result that) {
      if (that == null)
        return false;

      boolean this_present_io = true && (this.io != null);
      boolean that_present_io = true && (that.io != null);
      if (this_present_io || that_present_io) {
        if (!(this_present_io && that_present_io))
          return false;
        if (!this.io.equals(that.io))
          return false;
      }

      boolean this_present_ia = true && (this.ia != null);
      boolean that_present_ia = true && (that.ia != null);
      if (this_present_ia || that_present_ia) {
        if (!(this_present_ia && that_present_ia))
          return false;
        if (!this.ia.equals(that.ia))
          return false;
      }

      return true;
    }

    public int hashCode() {
      return 0;
    }

    public void read(TProtocol iprot) throws TException {
      TField field;
      iprot.readStructBegin();
      while (true)
      {
        field = iprot.readFieldBegin();
        if (field.type == TType.STOP) { 
          break;
        }
        switch (field.id)
        {
          case 1:
            if (field.type == TType.STRUCT) {
              this.io = new IOError();
              this.io.read(iprot);
              this.__isset.io = true;
            } else { 
              TProtocolUtil.skip(iprot, field.type);
            }
            break;
          case 2:
            if (field.type == TType.STRUCT) {
              this.ia = new IllegalArgument();
              this.ia.read(iprot);
              this.__isset.ia = true;
            } else { 
              TProtocolUtil.skip(iprot, field.type);
            }
            break;
          default:
            TProtocolUtil.skip(iprot, field.type);
            break;
        }
        iprot.readFieldEnd();
      }
      iprot.readStructEnd();
    }

    public void write(TProtocol oprot) throws TException {
      TStruct struct = new TStruct("mutateRowTs_result");
      oprot.writeStructBegin(struct);
      TField field = new TField();

      if (this.__isset.io) {
        if (this.io != null) {
          field.name = "io";
          field.type = TType.STRUCT;
          field.id = 1;
          oprot.writeFieldBegin(field);
          this.io.write(oprot);
          oprot.writeFieldEnd();
        }
      } else if (this.__isset.ia) {
        if (this.ia != null) {
          field.name = "ia";
          field.type = TType.STRUCT;
          field.id = 2;
          oprot.writeFieldBegin(field);
          this.ia.write(oprot);
          oprot.writeFieldEnd();
        }
      }
      oprot.writeFieldStop();
      oprot.writeStructEnd();
    }

    public String toString() {
      StringBuilder sb = new StringBuilder("mutateRowTs_result(");
      sb.append("io:");
      sb.append(this.io.toString());
      sb.append(",ia:");
      sb.append(this.ia.toString());
      sb.append(")");
      return sb.toString();
    }

  }

  public static class mutateRows_args implements TBase, java.io.Serializable   {
    public byte[] tableName;
    public List<BatchMutation> rowBatches;

    public final Isset __isset = new Isset();
    public static final class Isset implements java.io.Serializable {
      public boolean tableName = false;
      public boolean rowBatches = false;
    }

    public mutateRows_args() {
    }

    public mutateRows_args(
      byte[] tableName,
      List<BatchMutation> rowBatches)
    {
      this();
      this.tableName = tableName;
      this.__isset.tableName = true;
      this.rowBatches = rowBatches;
      this.__isset.rowBatches = true;
    }

    public boolean equals(Object that) {
      if (that == null)
        return false;
      if (that instanceof mutateRows_args)
        return this.equals((mutateRows_args)that);
      return false;
    }

    public boolean equals(mutateRows_args that) {
      if (that == null)
        return false;

      boolean this_present_tableName = true && (this.tableName != null);
      boolean that_present_tableName = true && (that.tableName != null);
      if (this_present_tableName || that_present_tableName) {
        if (!(this_present_tableName && that_present_tableName))
          return false;
        if (!java.util.Arrays.equals(this.tableName, that.tableName))
          return false;
      }

      boolean this_present_rowBatches = true && (this.rowBatches != null);
      boolean that_present_rowBatches = true && (that.rowBatches != null);
      if (this_present_rowBatches || that_present_rowBatches) {
        if (!(this_present_rowBatches && that_present_rowBatches))
          return false;
        if (!this.rowBatches.equals(that.rowBatches))
          return false;
      }

      return true;
    }

    public int hashCode() {
      return 0;
    }

    public void read(TProtocol iprot) throws TException {
      TField field;
      iprot.readStructBegin();
      while (true)
      {
        field = iprot.readFieldBegin();
        if (field.type == TType.STOP) { 
          break;
        }
        switch (field.id)
        {
          case 1:
            if (field.type == TType.STRING) {
              this.tableName = iprot.readBinary();
              this.__isset.tableName = true;
            } else { 
              TProtocolUtil.skip(iprot, field.type);
            }
            break;
          case 2:
            if (field.type == TType.LIST) {
              {
                TList _list42 = iprot.readListBegin();
                this.rowBatches = new ArrayList<BatchMutation>(_list42.size);
                for (int _i43 = 0; _i43 < _list42.size; ++_i43)
                {
                  BatchMutation _elem44 = new BatchMutation();
                  _elem44 = new BatchMutation();
                  _elem44.read(iprot);
                  this.rowBatches.add(_elem44);
                }
                iprot.readListEnd();
              }
              this.__isset.rowBatches = true;
            } else { 
              TProtocolUtil.skip(iprot, field.type);
            }
            break;
          default:
            TProtocolUtil.skip(iprot, field.type);
            break;
        }
        iprot.readFieldEnd();
      }
      iprot.readStructEnd();
    }

    public void write(TProtocol oprot) throws TException {
      TStruct struct = new TStruct("mutateRows_args");
      oprot.writeStructBegin(struct);
      TField field = new TField();
      if (this.tableName != null) {
        field.name = "tableName";
        field.type = TType.STRING;
        field.id = 1;
        oprot.writeFieldBegin(field);
        oprot.writeBinary(this.tableName);
        oprot.writeFieldEnd();
      }
      if (this.rowBatches != null) {
        field.name = "rowBatches";
        field.type = TType.LIST;
        field.id = 2;
        oprot.writeFieldBegin(field);
        {
          oprot.writeListBegin(new TList(TType.STRUCT, this.rowBatches.size()));
          for (BatchMutation _iter45 : this.rowBatches)          {
            _iter45.write(oprot);
          }
          oprot.writeListEnd();
        }
        oprot.writeFieldEnd();
      }
      oprot.writeFieldStop();
      oprot.writeStructEnd();
    }

    public String toString() {
      StringBuilder sb = new StringBuilder("mutateRows_args(");
      sb.append("tableName:");
      sb.append(this.tableName);
      sb.append(",rowBatches:");
      sb.append(this.rowBatches);
      sb.append(")");
      return sb.toString();
    }

  }

  public static class mutateRows_result implements TBase, java.io.Serializable   {
    public IOError io;
    public IllegalArgument ia;

    public final Isset __isset = new Isset();
    public static final class Isset implements java.io.Serializable {
      public boolean io = false;
      public boolean ia = false;
    }

    public mutateRows_result() {
    }

    public mutateRows_result(
      IOError io,
      IllegalArgument ia)
    {
      this();
      this.io = io;
      this.__isset.io = true;
      this.ia = ia;
      this.__isset.ia = true;
    }

    public boolean equals(Object that) {
      if (that == null)
        return false;
      if (that instanceof mutateRows_result)
        return this.equals((mutateRows_result)that);
      return false;
    }

    public boolean equals(mutateRows_result that) {
      if (that == null)
        return false;

      boolean this_present_io = true && (this.io != null);
      boolean that_present_io = true && (that.io != null);
      if (this_present_io || that_present_io) {
        if (!(this_present_io && that_present_io))
          return false;
        if (!this.io.equals(that.io))
          return false;
      }

      boolean this_present_ia = true && (this.ia != null);
      boolean that_present_ia = true && (that.ia != null);
      if (this_present_ia || that_present_ia) {
        if (!(this_present_ia && that_present_ia))
          return false;
        if (!this.ia.equals(that.ia))
          return false;
      }

      return true;
    }

    public int hashCode() {
      return 0;
    }

    public void read(TProtocol iprot) throws TException {
      TField field;
      iprot.readStructBegin();
      while (true)
      {
        field = iprot.readFieldBegin();
        if (field.type == TType.STOP) { 
          break;
        }
        switch (field.id)
        {
          case 1:
            if (field.type == TType.STRUCT) {
              this.io = new IOError();
              this.io.read(iprot);
              this.__isset.io = true;
            } else { 
              TProtocolUtil.skip(iprot, field.type);
            }
            break;
          case 2:
            if (field.type == TType.STRUCT) {
              this.ia = new IllegalArgument();
              this.ia.read(iprot);
              this.__isset.ia = true;
            } else { 
              TProtocolUtil.skip(iprot, field.type);
            }
            break;
          default:
            TProtocolUtil.skip(iprot, field.type);
            break;
        }
        iprot.readFieldEnd();
      }
      iprot.readStructEnd();
    }

    public void write(TProtocol oprot) throws TException {
      TStruct struct = new TStruct("mutateRows_result");
      oprot.writeStructBegin(struct);
      TField field = new TField();

      if (this.__isset.io) {
        if (this.io != null) {
          field.name = "io";
          field.type = TType.STRUCT;
          field.id = 1;
          oprot.writeFieldBegin(field);
          this.io.write(oprot);
          oprot.writeFieldEnd();
        }
      } else if (this.__isset.ia) {
        if (this.ia != null) {
          field.name = "ia";
          field.type = TType.STRUCT;
          field.id = 2;
          oprot.writeFieldBegin(field);
          this.ia.write(oprot);
          oprot.writeFieldEnd();
        }
      }
      oprot.writeFieldStop();
      oprot.writeStructEnd();
    }

    public String toString() {
      StringBuilder sb = new StringBuilder("mutateRows_result(");
      sb.append("io:");
      sb.append(this.io.toString());
      sb.append(",ia:");
      sb.append(this.ia.toString());
      sb.append(")");
      return sb.toString();
    }

  }

  public static class mutateRowsTs_args implements TBase, java.io.Serializable   {
    public byte[] tableName;
    public List<BatchMutation> rowBatches;
    public long timestamp;

    public final Isset __isset = new Isset();
    public static final class Isset implements java.io.Serializable {
      public boolean tableName = false;
      public boolean rowBatches = false;
      public boolean timestamp = false;
    }

    public mutateRowsTs_args() {
    }

    public mutateRowsTs_args(
      byte[] tableName,
      List<BatchMutation> rowBatches,
      long timestamp)
    {
      this();
      this.tableName = tableName;
      this.__isset.tableName = true;
      this.rowBatches = rowBatches;
      this.__isset.rowBatches = true;
      this.timestamp = timestamp;
      this.__isset.timestamp = true;
    }

    public boolean equals(Object that) {
      if (that == null)
        return false;
      if (that instanceof mutateRowsTs_args)
        return this.equals((mutateRowsTs_args)that);
      return false;
    }

    public boolean equals(mutateRowsTs_args that) {
      if (that == null)
        return false;

      boolean this_present_tableName = true && (this.tableName != null);
      boolean that_present_tableName = true && (that.tableName != null);
      if (this_present_tableName || that_present_tableName) {
        if (!(this_present_tableName && that_present_tableName))
          return false;
        if (!java.util.Arrays.equals(this.tableName, that.tableName))
          return false;
      }

      boolean this_present_rowBatches = true && (this.rowBatches != null);
      boolean that_present_rowBatches = true && (that.rowBatches != null);
      if (this_present_rowBatches || that_present_rowBatches) {
        if (!(this_present_rowBatches && that_present_rowBatches))
          return false;
        if (!this.rowBatches.equals(that.rowBatches))
          return false;
      }

      boolean this_present_timestamp = true;
      boolean that_present_timestamp = true;
      if (this_present_timestamp || that_present_timestamp) {
        if (!(this_present_timestamp && that_present_timestamp))
          return false;
        if (this.timestamp != that.timestamp)
          return false;
      }

      return true;
    }

    public int hashCode() {
      return 0;
    }

    public void read(TProtocol iprot) throws TException {
      TField field;
      iprot.readStructBegin();
      while (true)
      {
        field = iprot.readFieldBegin();
        if (field.type == TType.STOP) { 
          break;
        }
        switch (field.id)
        {
          case 1:
            if (field.type == TType.STRING) {
              this.tableName = iprot.readBinary();
              this.__isset.tableName = true;
            } else { 
              TProtocolUtil.skip(iprot, field.type);
            }
            break;
          case 2:
            if (field.type == TType.LIST) {
              {
                TList _list46 = iprot.readListBegin();
                this.rowBatches = new ArrayList<BatchMutation>(_list46.size);
                for (int _i47 = 0; _i47 < _list46.size; ++_i47)
                {
                  BatchMutation _elem48 = new BatchMutation();
                  _elem48 = new BatchMutation();
                  _elem48.read(iprot);
                  this.rowBatches.add(_elem48);
                }
                iprot.readListEnd();
              }
              this.__isset.rowBatches = true;
            } else { 
              TProtocolUtil.skip(iprot, field.type);
            }
            break;
          case 3:
            if (field.type == TType.I64) {
              this.timestamp = iprot.readI64();
              this.__isset.timestamp = true;
            } else { 
              TProtocolUtil.skip(iprot, field.type);
            }
            break;
          default:
            TProtocolUtil.skip(iprot, field.type);
            break;
        }
        iprot.readFieldEnd();
      }
      iprot.readStructEnd();
    }

    public void write(TProtocol oprot) throws TException {
      TStruct struct = new TStruct("mutateRowsTs_args");
      oprot.writeStructBegin(struct);
      TField field = new TField();
      if (this.tableName != null) {
        field.name = "tableName";
        field.type = TType.STRING;
        field.id = 1;
        oprot.writeFieldBegin(field);
        oprot.writeBinary(this.tableName);
        oprot.writeFieldEnd();
      }
      if (this.rowBatches != null) {
        field.name = "rowBatches";
        field.type = TType.LIST;
        field.id = 2;
        oprot.writeFieldBegin(field);
        {
          oprot.writeListBegin(new TList(TType.STRUCT, this.rowBatches.size()));
          for (BatchMutation _iter49 : this.rowBatches)          {
            _iter49.write(oprot);
          }
          oprot.writeListEnd();
        }
        oprot.writeFieldEnd();
      }
      field.name = "timestamp";
      field.type = TType.I64;
      field.id = 3;
      oprot.writeFieldBegin(field);
      oprot.writeI64(this.timestamp);
      oprot.writeFieldEnd();
      oprot.writeFieldStop();
      oprot.writeStructEnd();
    }

    public String toString() {
      StringBuilder sb = new StringBuilder("mutateRowsTs_args(");
      sb.append("tableName:");
      sb.append(this.tableName);
      sb.append(",rowBatches:");
      sb.append(this.rowBatches);
      sb.append(",timestamp:");
      sb.append(this.timestamp);
      sb.append(")");
      return sb.toString();
    }

  }

  public static class mutateRowsTs_result implements TBase, java.io.Serializable   {
    public IOError io;
    public IllegalArgument ia;

    public final Isset __isset = new Isset();
    public static final class Isset implements java.io.Serializable {
      public boolean io = false;
      public boolean ia = false;
    }

    public mutateRowsTs_result() {
    }

    public mutateRowsTs_result(
      IOError io,
      IllegalArgument ia)
    {
      this();
      this.io = io;
      this.__isset.io = true;
      this.ia = ia;
      this.__isset.ia = true;
    }

    public boolean equals(Object that) {
      if (that == null)
        return false;
      if (that instanceof mutateRowsTs_result)
        return this.equals((mutateRowsTs_result)that);
      return false;
    }

    public boolean equals(mutateRowsTs_result that) {
      if (that == null)
        return false;

      boolean this_present_io = true && (this.io != null);
      boolean that_present_io = true && (that.io != null);
      if (this_present_io || that_present_io) {
        if (!(this_present_io && that_present_io))
          return false;
        if (!this.io.equals(that.io))
          return false;
      }

      boolean this_present_ia = true && (this.ia != null);
      boolean that_present_ia = true && (that.ia != null);
      if (this_present_ia || that_present_ia) {
        if (!(this_present_ia && that_present_ia))
          return false;
        if (!this.ia.equals(that.ia))
          return false;
      }

      return true;
    }

    public int hashCode() {
      return 0;
    }

    public void read(TProtocol iprot) throws TException {
      TField field;
      iprot.readStructBegin();
      while (true)
      {
        field = iprot.readFieldBegin();
        if (field.type == TType.STOP) { 
          break;
        }
        switch (field.id)
        {
          case 1:
            if (field.type == TType.STRUCT) {
              this.io = new IOError();
              this.io.read(iprot);
              this.__isset.io = true;
            } else { 
              TProtocolUtil.skip(iprot, field.type);
            }
            break;
          case 2:
            if (field.type == TType.STRUCT) {
              this.ia = new IllegalArgument();
              this.ia.read(iprot);
              this.__isset.ia = true;
            } else { 
              TProtocolUtil.skip(iprot, field.type);
            }
            break;
          default:
            TProtocolUtil.skip(iprot, field.type);
            break;
        }
        iprot.readFieldEnd();
      }
      iprot.readStructEnd();
    }

    public void write(TProtocol oprot) throws TException {
      TStruct struct = new TStruct("mutateRowsTs_result");
      oprot.writeStructBegin(struct);
      TField field = new TField();

      if (this.__isset.io) {
        if (this.io != null) {
          field.name = "io";
          field.type = TType.STRUCT;
          field.id = 1;
          oprot.writeFieldBegin(field);
          this.io.write(oprot);
          oprot.writeFieldEnd();
        }
      } else if (this.__isset.ia) {
        if (this.ia != null) {
          field.name = "ia";
          field.type = TType.STRUCT;
          field.id = 2;
          oprot.writeFieldBegin(field);
          this.ia.write(oprot);
          oprot.writeFieldEnd();
        }
      }
      oprot.writeFieldStop();
      oprot.writeStructEnd();
    }

    public String toString() {
      StringBuilder sb = new StringBuilder("mutateRowsTs_result(");
      sb.append("io:");
      sb.append(this.io.toString());
      sb.append(",ia:");
      sb.append(this.ia.toString());
      sb.append(")");
      return sb.toString();
    }

  }

  public static class deleteAll_args implements TBase, java.io.Serializable   {
    public byte[] tableName;
    public byte[] row;
    public byte[] column;

    public final Isset __isset = new Isset();
    public static final class Isset implements java.io.Serializable {
      public boolean tableName = false;
      public boolean row = false;
      public boolean column = false;
    }

    public deleteAll_args() {
    }

    public deleteAll_args(
      byte[] tableName,
      byte[] row,
      byte[] column)
    {
      this();
      this.tableName = tableName;
      this.__isset.tableName = true;
      this.row = row;
      this.__isset.row = true;
      this.column = column;
      this.__isset.column = true;
    }

    public boolean equals(Object that) {
      if (that == null)
        return false;
      if (that instanceof deleteAll_args)
        return this.equals((deleteAll_args)that);
      return false;
    }

    public boolean equals(deleteAll_args that) {
      if (that == null)
        return false;

      boolean this_present_tableName = true && (this.tableName != null);
      boolean that_present_tableName = true && (that.tableName != null);
      if (this_present_tableName || that_present_tableName) {
        if (!(this_present_tableName && that_present_tableName))
          return false;
        if (!java.util.Arrays.equals(this.tableName, that.tableName))
          return false;
      }

      boolean this_present_row = true && (this.row != null);
      boolean that_present_row = true && (that.row != null);
      if (this_present_row || that_present_row) {
        if (!(this_present_row && that_present_row))
          return false;
        if (!java.util.Arrays.equals(this.row, that.row))
          return false;
      }

      boolean this_present_column = true && (this.column != null);
      boolean that_present_column = true && (that.column != null);
      if (this_present_column || that_present_column) {
        if (!(this_present_column && that_present_column))
          return false;
        if (!java.util.Arrays.equals(this.column, that.column))
          return false;
      }

      return true;
    }

    public int hashCode() {
      return 0;
    }

    public void read(TProtocol iprot) throws TException {
      TField field;
      iprot.readStructBegin();
      while (true)
      {
        field = iprot.readFieldBegin();
        if (field.type == TType.STOP) { 
          break;
        }
        switch (field.id)
        {
          case 1:
            if (field.type == TType.STRING) {
              this.tableName = iprot.readBinary();
              this.__isset.tableName = true;
            } else { 
              TProtocolUtil.skip(iprot, field.type);
            }
            break;
          case 2:
            if (field.type == TType.STRING) {
              this.row = iprot.readBinary();
              this.__isset.row = true;
            } else { 
              TProtocolUtil.skip(iprot, field.type);
            }
            break;
          case 3:
            if (field.type == TType.STRING) {
              this.column = iprot.readBinary();
              this.__isset.column = true;
            } else { 
              TProtocolUtil.skip(iprot, field.type);
            }
            break;
          default:
            TProtocolUtil.skip(iprot, field.type);
            break;
        }
        iprot.readFieldEnd();
      }
      iprot.readStructEnd();
    }

    public void write(TProtocol oprot) throws TException {
      TStruct struct = new TStruct("deleteAll_args");
      oprot.writeStructBegin(struct);
      TField field = new TField();
      if (this.tableName != null) {
        field.name = "tableName";
        field.type = TType.STRING;
        field.id = 1;
        oprot.writeFieldBegin(field);
        oprot.writeBinary(this.tableName);
        oprot.writeFieldEnd();
      }
      if (this.row != null) {
        field.name = "row";
        field.type = TType.STRING;
        field.id = 2;
        oprot.writeFieldBegin(field);
        oprot.writeBinary(this.row);
        oprot.writeFieldEnd();
      }
      if (this.column != null) {
        field.name = "column";
        field.type = TType.STRING;
        field.id = 3;
        oprot.writeFieldBegin(field);
        oprot.writeBinary(this.column);
        oprot.writeFieldEnd();
      }
      oprot.writeFieldStop();
      oprot.writeStructEnd();
    }

    public String toString() {
      StringBuilder sb = new StringBuilder("deleteAll_args(");
      sb.append("tableName:");
      sb.append(this.tableName);
      sb.append(",row:");
      sb.append(this.row);
      sb.append(",column:");
      sb.append(this.column);
      sb.append(")");
      return sb.toString();
    }

  }

  public static class deleteAll_result implements TBase, java.io.Serializable   {
    public IOError io;

    public final Isset __isset = new Isset();
    public static final class Isset implements java.io.Serializable {
      public boolean io = false;
    }

    public deleteAll_result() {
    }

    public deleteAll_result(
      IOError io)
    {
      this();
      this.io = io;
      this.__isset.io = true;
    }

    public boolean equals(Object that) {
      if (that == null)
        return false;
      if (that instanceof deleteAll_result)
        return this.equals((deleteAll_result)that);
      return false;
    }

    public boolean equals(deleteAll_result that) {
      if (that == null)
        return false;

      boolean this_present_io = true && (this.io != null);
      boolean that_present_io = true && (that.io != null);
      if (this_present_io || that_present_io) {
        if (!(this_present_io && that_present_io))
          return false;
        if (!this.io.equals(that.io))
          return false;
      }

      return true;
    }

    public int hashCode() {
      return 0;
    }

    public void read(TProtocol iprot) throws TException {
      TField field;
      iprot.readStructBegin();
      while (true)
      {
        field = iprot.readFieldBegin();
        if (field.type == TType.STOP) { 
          break;
        }
        switch (field.id)
        {
          case 1:
            if (field.type == TType.STRUCT) {
              this.io = new IOError();
              this.io.read(iprot);
              this.__isset.io = true;
            } else { 
              TProtocolUtil.skip(iprot, field.type);
            }
            break;
          default:
            TProtocolUtil.skip(iprot, field.type);
            break;
        }
        iprot.readFieldEnd();
      }
      iprot.readStructEnd();
    }

    public void write(TProtocol oprot) throws TException {
      TStruct struct = new TStruct("deleteAll_result");
      oprot.writeStructBegin(struct);
      TField field = new TField();

      if (this.__isset.io) {
        if (this.io != null) {
          field.name = "io";
          field.type = TType.STRUCT;
          field.id = 1;
          oprot.writeFieldBegin(field);
          this.io.write(oprot);
          oprot.writeFieldEnd();
        }
      }
      oprot.writeFieldStop();
      oprot.writeStructEnd();
    }

    public String toString() {
      StringBuilder sb = new StringBuilder("deleteAll_result(");
      sb.append("io:");
      sb.append(this.io.toString());
      sb.append(")");
      return sb.toString();
    }

  }

  public static class deleteAllTs_args implements TBase, java.io.Serializable   {
    public byte[] tableName;
    public byte[] row;
    public byte[] column;
    public long timestamp;

    public final Isset __isset = new Isset();
    public static final class Isset implements java.io.Serializable {
      public boolean tableName = false;
      public boolean row = false;
      public boolean column = false;
      public boolean timestamp = false;
    }

    public deleteAllTs_args() {
    }

    public deleteAllTs_args(
      byte[] tableName,
      byte[] row,
      byte[] column,
      long timestamp)
    {
      this();
      this.tableName = tableName;
      this.__isset.tableName = true;
      this.row = row;
      this.__isset.row = true;
      this.column = column;
      this.__isset.column = true;
      this.timestamp = timestamp;
      this.__isset.timestamp = true;
    }

    public boolean equals(Object that) {
      if (that == null)
        return false;
      if (that instanceof deleteAllTs_args)
        return this.equals((deleteAllTs_args)that);
      return false;
    }

    public boolean equals(deleteAllTs_args that) {
      if (that == null)
        return false;

      boolean this_present_tableName = true && (this.tableName != null);
      boolean that_present_tableName = true && (that.tableName != null);
      if (this_present_tableName || that_present_tableName) {
        if (!(this_present_tableName && that_present_tableName))
          return false;
        if (!java.util.Arrays.equals(this.tableName, that.tableName))
          return false;
      }

      boolean this_present_row = true && (this.row != null);
      boolean that_present_row = true && (that.row != null);
      if (this_present_row || that_present_row) {
        if (!(this_present_row && that_present_row))
          return false;
        if (!java.util.Arrays.equals(this.row, that.row))
          return false;
      }

      boolean this_present_column = true && (this.column != null);
      boolean that_present_column = true && (that.column != null);
      if (this_present_column || that_present_column) {
        if (!(this_present_column && that_present_column))
          return false;
        if (!java.util.Arrays.equals(this.column, that.column))
          return false;
      }

      boolean this_present_timestamp = true;
      boolean that_present_timestamp = true;
      if (this_present_timestamp || that_present_timestamp) {
        if (!(this_present_timestamp && that_present_timestamp))
          return false;
        if (this.timestamp != that.timestamp)
          return false;
      }

      return true;
    }

    public int hashCode() {
      return 0;
    }

    public void read(TProtocol iprot) throws TException {
      TField field;
      iprot.readStructBegin();
      while (true)
      {
        field = iprot.readFieldBegin();
        if (field.type == TType.STOP) { 
          break;
        }
        switch (field.id)
        {
          case 1:
            if (field.type == TType.STRING) {
              this.tableName = iprot.readBinary();
              this.__isset.tableName = true;
            } else { 
              TProtocolUtil.skip(iprot, field.type);
            }
            break;
          case 2:
            if (field.type == TType.STRING) {
              this.row = iprot.readBinary();
              this.__isset.row = true;
            } else { 
              TProtocolUtil.skip(iprot, field.type);
            }
            break;
          case 3:
            if (field.type == TType.STRING) {
              this.column = iprot.readBinary();
              this.__isset.column = true;
            } else { 
              TProtocolUtil.skip(iprot, field.type);
            }
            break;
          case 4:
            if (field.type == TType.I64) {
              this.timestamp = iprot.readI64();
              this.__isset.timestamp = true;
            } else { 
              TProtocolUtil.skip(iprot, field.type);
            }
            break;
          default:
            TProtocolUtil.skip(iprot, field.type);
            break;
        }
        iprot.readFieldEnd();
      }
      iprot.readStructEnd();
    }

    public void write(TProtocol oprot) throws TException {
      TStruct struct = new TStruct("deleteAllTs_args");
      oprot.writeStructBegin(struct);
      TField field = new TField();
      if (this.tableName != null) {
        field.name = "tableName";
        field.type = TType.STRING;
        field.id = 1;
        oprot.writeFieldBegin(field);
        oprot.writeBinary(this.tableName);
        oprot.writeFieldEnd();
      }
      if (this.row != null) {
        field.name = "row";
        field.type = TType.STRING;
        field.id = 2;
        oprot.writeFieldBegin(field);
        oprot.writeBinary(this.row);
        oprot.writeFieldEnd();
      }
      if (this.column != null) {
        field.name = "column";
        field.type = TType.STRING;
        field.id = 3;
        oprot.writeFieldBegin(field);
        oprot.writeBinary(this.column);
        oprot.writeFieldEnd();
      }
      field.name = "timestamp";
      field.type = TType.I64;
      field.id = 4;
      oprot.writeFieldBegin(field);
      oprot.writeI64(this.timestamp);
      oprot.writeFieldEnd();
      oprot.writeFieldStop();
      oprot.writeStructEnd();
    }

    public String toString() {
      StringBuilder sb = new StringBuilder("deleteAllTs_args(");
      sb.append("tableName:");
      sb.append(this.tableName);
      sb.append(",row:");
      sb.append(this.row);
      sb.append(",column:");
      sb.append(this.column);
      sb.append(",timestamp:");
      sb.append(this.timestamp);
      sb.append(")");
      return sb.toString();
    }

  }

  public static class deleteAllTs_result implements TBase, java.io.Serializable   {
    public IOError io;

    public final Isset __isset = new Isset();
    public static final class Isset implements java.io.Serializable {
      public boolean io = false;
    }

    public deleteAllTs_result() {
    }

    public deleteAllTs_result(
      IOError io)
    {
      this();
      this.io = io;
      this.__isset.io = true;
    }

    public boolean equals(Object that) {
      if (that == null)
        return false;
      if (that instanceof deleteAllTs_result)
        return this.equals((deleteAllTs_result)that);
      return false;
    }

    public boolean equals(deleteAllTs_result that) {
      if (that == null)
        return false;

      boolean this_present_io = true && (this.io != null);
      boolean that_present_io = true && (that.io != null);
      if (this_present_io || that_present_io) {
        if (!(this_present_io && that_present_io))
          return false;
        if (!this.io.equals(that.io))
          return false;
      }

      return true;
    }

    public int hashCode() {
      return 0;
    }

    public void read(TProtocol iprot) throws TException {
      TField field;
      iprot.readStructBegin();
      while (true)
      {
        field = iprot.readFieldBegin();
        if (field.type == TType.STOP) { 
          break;
        }
        switch (field.id)
        {
          case 1:
            if (field.type == TType.STRUCT) {
              this.io = new IOError();
              this.io.read(iprot);
              this.__isset.io = true;
            } else { 
              TProtocolUtil.skip(iprot, field.type);
            }
            break;
          default:
            TProtocolUtil.skip(iprot, field.type);
            break;
        }
        iprot.readFieldEnd();
      }
      iprot.readStructEnd();
    }

    public void write(TProtocol oprot) throws TException {
      TStruct struct = new TStruct("deleteAllTs_result");
      oprot.writeStructBegin(struct);
      TField field = new TField();

      if (this.__isset.io) {
        if (this.io != null) {
          field.name = "io";
          field.type = TType.STRUCT;
          field.id = 1;
          oprot.writeFieldBegin(field);
          this.io.write(oprot);
          oprot.writeFieldEnd();
        }
      }
      oprot.writeFieldStop();
      oprot.writeStructEnd();
    }

    public String toString() {
      StringBuilder sb = new StringBuilder("deleteAllTs_result(");
      sb.append("io:");
      sb.append(this.io.toString());
      sb.append(")");
      return sb.toString();
    }

  }

  public static class deleteAllRow_args implements TBase, java.io.Serializable   {
    public byte[] tableName;
    public byte[] row;

    public final Isset __isset = new Isset();
    public static final class Isset implements java.io.Serializable {
      public boolean tableName = false;
      public boolean row = false;
    }

    public deleteAllRow_args() {
    }

    public deleteAllRow_args(
      byte[] tableName,
      byte[] row)
    {
      this();
      this.tableName = tableName;
      this.__isset.tableName = true;
      this.row = row;
      this.__isset.row = true;
    }

    public boolean equals(Object that) {
      if (that == null)
        return false;
      if (that instanceof deleteAllRow_args)
        return this.equals((deleteAllRow_args)that);
      return false;
    }

    public boolean equals(deleteAllRow_args that) {
      if (that == null)
        return false;

      boolean this_present_tableName = true && (this.tableName != null);
      boolean that_present_tableName = true && (that.tableName != null);
      if (this_present_tableName || that_present_tableName) {
        if (!(this_present_tableName && that_present_tableName))
          return false;
        if (!java.util.Arrays.equals(this.tableName, that.tableName))
          return false;
      }

      boolean this_present_row = true && (this.row != null);
      boolean that_present_row = true && (that.row != null);
      if (this_present_row || that_present_row) {
        if (!(this_present_row && that_present_row))
          return false;
        if (!java.util.Arrays.equals(this.row, that.row))
          return false;
      }

      return true;
    }

    public int hashCode() {
      return 0;
    }

    public void read(TProtocol iprot) throws TException {
      TField field;
      iprot.readStructBegin();
      while (true)
      {
        field = iprot.readFieldBegin();
        if (field.type == TType.STOP) { 
          break;
        }
        switch (field.id)
        {
          case 1:
            if (field.type == TType.STRING) {
              this.tableName = iprot.readBinary();
              this.__isset.tableName = true;
            } else { 
              TProtocolUtil.skip(iprot, field.type);
            }
            break;
          case 2:
            if (field.type == TType.STRING) {
              this.row = iprot.readBinary();
              this.__isset.row = true;
            } else { 
              TProtocolUtil.skip(iprot, field.type);
            }
            break;
          default:
            TProtocolUtil.skip(iprot, field.type);
            break;
        }
        iprot.readFieldEnd();
      }
      iprot.readStructEnd();
    }

    public void write(TProtocol oprot) throws TException {
      TStruct struct = new TStruct("deleteAllRow_args");
      oprot.writeStructBegin(struct);
      TField field = new TField();
      if (this.tableName != null) {
        field.name = "tableName";
        field.type = TType.STRING;
        field.id = 1;
        oprot.writeFieldBegin(field);
        oprot.writeBinary(this.tableName);
        oprot.writeFieldEnd();
      }
      if (this.row != null) {
        field.name = "row";
        field.type = TType.STRING;
        field.id = 2;
        oprot.writeFieldBegin(field);
        oprot.writeBinary(this.row);
        oprot.writeFieldEnd();
      }
      oprot.writeFieldStop();
      oprot.writeStructEnd();
    }

    public String toString() {
      StringBuilder sb = new StringBuilder("deleteAllRow_args(");
      sb.append("tableName:");
      sb.append(this.tableName);
      sb.append(",row:");
      sb.append(this.row);
      sb.append(")");
      return sb.toString();
    }

  }

  public static class deleteAllRow_result implements TBase, java.io.Serializable   {
    public IOError io;

    public final Isset __isset = new Isset();
    public static final class Isset implements java.io.Serializable {
      public boolean io = false;
    }

    public deleteAllRow_result() {
    }

    public deleteAllRow_result(
      IOError io)
    {
      this();
      this.io = io;
      this.__isset.io = true;
    }

    public boolean equals(Object that) {
      if (that == null)
        return false;
      if (that instanceof deleteAllRow_result)
        return this.equals((deleteAllRow_result)that);
      return false;
    }

    public boolean equals(deleteAllRow_result that) {
      if (that == null)
        return false;

      boolean this_present_io = true && (this.io != null);
      boolean that_present_io = true && (that.io != null);
      if (this_present_io || that_present_io) {
        if (!(this_present_io && that_present_io))
          return false;
        if (!this.io.equals(that.io))
          return false;
      }

      return true;
    }

    public int hashCode() {
      return 0;
    }

    public void read(TProtocol iprot) throws TException {
      TField field;
      iprot.readStructBegin();
      while (true)
      {
        field = iprot.readFieldBegin();
        if (field.type == TType.STOP) { 
          break;
        }
        switch (field.id)
        {
          case 1:
            if (field.type == TType.STRUCT) {
              this.io = new IOError();
              this.io.read(iprot);
              this.__isset.io = true;
            } else { 
              TProtocolUtil.skip(iprot, field.type);
            }
            break;
          default:
            TProtocolUtil.skip(iprot, field.type);
            break;
        }
        iprot.readFieldEnd();
      }
      iprot.readStructEnd();
    }

    public void write(TProtocol oprot) throws TException {
      TStruct struct = new TStruct("deleteAllRow_result");
      oprot.writeStructBegin(struct);
      TField field = new TField();

      if (this.__isset.io) {
        if (this.io != null) {
          field.name = "io";
          field.type = TType.STRUCT;
          field.id = 1;
          oprot.writeFieldBegin(field);
          this.io.write(oprot);
          oprot.writeFieldEnd();
        }
      }
      oprot.writeFieldStop();
      oprot.writeStructEnd();
    }

    public String toString() {
      StringBuilder sb = new StringBuilder("deleteAllRow_result(");
      sb.append("io:");
      sb.append(this.io.toString());
      sb.append(")");
      return sb.toString();
    }

  }

  public static class deleteAllRowTs_args implements TBase, java.io.Serializable   {
    public byte[] tableName;
    public byte[] row;
    public long timestamp;

    public final Isset __isset = new Isset();
    public static final class Isset implements java.io.Serializable {
      public boolean tableName = false;
      public boolean row = false;
      public boolean timestamp = false;
    }

    public deleteAllRowTs_args() {
    }

    public deleteAllRowTs_args(
      byte[] tableName,
      byte[] row,
      long timestamp)
    {
      this();
      this.tableName = tableName;
      this.__isset.tableName = true;
      this.row = row;
      this.__isset.row = true;
      this.timestamp = timestamp;
      this.__isset.timestamp = true;
    }

    public boolean equals(Object that) {
      if (that == null)
        return false;
      if (that instanceof deleteAllRowTs_args)
        return this.equals((deleteAllRowTs_args)that);
      return false;
    }

    public boolean equals(deleteAllRowTs_args that) {
      if (that == null)
        return false;

      boolean this_present_tableName = true && (this.tableName != null);
      boolean that_present_tableName = true && (that.tableName != null);
      if (this_present_tableName || that_present_tableName) {
        if (!(this_present_tableName && that_present_tableName))
          return false;
        if (!java.util.Arrays.equals(this.tableName, that.tableName))
          return false;
      }

      boolean this_present_row = true && (this.row != null);
      boolean that_present_row = true && (that.row != null);
      if (this_present_row || that_present_row) {
        if (!(this_present_row && that_present_row))
          return false;
        if (!java.util.Arrays.equals(this.row, that.row))
          return false;
      }

      boolean this_present_timestamp = true;
      boolean that_present_timestamp = true;
      if (this_present_timestamp || that_present_timestamp) {
        if (!(this_present_timestamp && that_present_timestamp))
          return false;
        if (this.timestamp != that.timestamp)
          return false;
      }

      return true;
    }

    public int hashCode() {
      return 0;
    }

    public void read(TProtocol iprot) throws TException {
      TField field;
      iprot.readStructBegin();
      while (true)
      {
        field = iprot.readFieldBegin();
        if (field.type == TType.STOP) { 
          break;
        }
        switch (field.id)
        {
          case 1:
            if (field.type == TType.STRING) {
              this.tableName = iprot.readBinary();
              this.__isset.tableName = true;
            } else { 
              TProtocolUtil.skip(iprot, field.type);
            }
            break;
          case 2:
            if (field.type == TType.STRING) {
              this.row = iprot.readBinary();
              this.__isset.row = true;
            } else { 
              TProtocolUtil.skip(iprot, field.type);
            }
            break;
          case 3:
            if (field.type == TType.I64) {
              this.timestamp = iprot.readI64();
              this.__isset.timestamp = true;
            } else { 
              TProtocolUtil.skip(iprot, field.type);
            }
            break;
          default:
            TProtocolUtil.skip(iprot, field.type);
            break;
        }
        iprot.readFieldEnd();
      }
      iprot.readStructEnd();
    }

    public void write(TProtocol oprot) throws TException {
      TStruct struct = new TStruct("deleteAllRowTs_args");
      oprot.writeStructBegin(struct);
      TField field = new TField();
      if (this.tableName != null) {
        field.name = "tableName";
        field.type = TType.STRING;
        field.id = 1;
        oprot.writeFieldBegin(field);
        oprot.writeBinary(this.tableName);
        oprot.writeFieldEnd();
      }
      if (this.row != null) {
        field.name = "row";
        field.type = TType.STRING;
        field.id = 2;
        oprot.writeFieldBegin(field);
        oprot.writeBinary(this.row);
        oprot.writeFieldEnd();
      }
      field.name = "timestamp";
      field.type = TType.I64;
      field.id = 3;
      oprot.writeFieldBegin(field);
      oprot.writeI64(this.timestamp);
      oprot.writeFieldEnd();
      oprot.writeFieldStop();
      oprot.writeStructEnd();
    }

    public String toString() {
      StringBuilder sb = new StringBuilder("deleteAllRowTs_args(");
      sb.append("tableName:");
      sb.append(this.tableName);
      sb.append(",row:");
      sb.append(this.row);
      sb.append(",timestamp:");
      sb.append(this.timestamp);
      sb.append(")");
      return sb.toString();
    }

  }

  public static class deleteAllRowTs_result implements TBase, java.io.Serializable   {
    public IOError io;

    public final Isset __isset = new Isset();
    public static final class Isset implements java.io.Serializable {
      public boolean io = false;
    }

    public deleteAllRowTs_result() {
    }

    public deleteAllRowTs_result(
      IOError io)
    {
      this();
      this.io = io;
      this.__isset.io = true;
    }

    public boolean equals(Object that) {
      if (that == null)
        return false;
      if (that instanceof deleteAllRowTs_result)
        return this.equals((deleteAllRowTs_result)that);
      return false;
    }

    public boolean equals(deleteAllRowTs_result that) {
      if (that == null)
        return false;

      boolean this_present_io = true && (this.io != null);
      boolean that_present_io = true && (that.io != null);
      if (this_present_io || that_present_io) {
        if (!(this_present_io && that_present_io))
          return false;
        if (!this.io.equals(that.io))
          return false;
      }

      return true;
    }

    public int hashCode() {
      return 0;
    }

    public void read(TProtocol iprot) throws TException {
      TField field;
      iprot.readStructBegin();
      while (true)
      {
        field = iprot.readFieldBegin();
        if (field.type == TType.STOP) { 
          break;
        }
        switch (field.id)
        {
          case 1:
            if (field.type == TType.STRUCT) {
              this.io = new IOError();
              this.io.read(iprot);
              this.__isset.io = true;
            } else { 
              TProtocolUtil.skip(iprot, field.type);
            }
            break;
          default:
            TProtocolUtil.skip(iprot, field.type);
            break;
        }
        iprot.readFieldEnd();
      }
      iprot.readStructEnd();
    }

    public void write(TProtocol oprot) throws TException {
      TStruct struct = new TStruct("deleteAllRowTs_result");
      oprot.writeStructBegin(struct);
      TField field = new TField();

      if (this.__isset.io) {
        if (this.io != null) {
          field.name = "io";
          field.type = TType.STRUCT;
          field.id = 1;
          oprot.writeFieldBegin(field);
          this.io.write(oprot);
          oprot.writeFieldEnd();
        }
      }
      oprot.writeFieldStop();
      oprot.writeStructEnd();
    }

    public String toString() {
      StringBuilder sb = new StringBuilder("deleteAllRowTs_result(");
      sb.append("io:");
      sb.append(this.io.toString());
      sb.append(")");
      return sb.toString();
    }

  }

  public static class scannerOpen_args implements TBase, java.io.Serializable   {
    public byte[] tableName;
    public byte[] startRow;
    public List<byte[]> columns;

    public final Isset __isset = new Isset();
    public static final class Isset implements java.io.Serializable {
      public boolean tableName = false;
      public boolean startRow = false;
      public boolean columns = false;
    }

    public scannerOpen_args() {
    }

    public scannerOpen_args(
      byte[] tableName,
      byte[] startRow,
      List<byte[]> columns)
    {
      this();
      this.tableName = tableName;
      this.__isset.tableName = true;
      this.startRow = startRow;
      this.__isset.startRow = true;
      this.columns = columns;
      this.__isset.columns = true;
    }

    public boolean equals(Object that) {
      if (that == null)
        return false;
      if (that instanceof scannerOpen_args)
        return this.equals((scannerOpen_args)that);
      return false;
    }

    public boolean equals(scannerOpen_args that) {
      if (that == null)
        return false;

      boolean this_present_tableName = true && (this.tableName != null);
      boolean that_present_tableName = true && (that.tableName != null);
      if (this_present_tableName || that_present_tableName) {
        if (!(this_present_tableName && that_present_tableName))
          return false;
        if (!java.util.Arrays.equals(this.tableName, that.tableName))
          return false;
      }

      boolean this_present_startRow = true && (this.startRow != null);
      boolean that_present_startRow = true && (that.startRow != null);
      if (this_present_startRow || that_present_startRow) {
        if (!(this_present_startRow && that_present_startRow))
          return false;
        if (!java.util.Arrays.equals(this.startRow, that.startRow))
          return false;
      }

      boolean this_present_columns = true && (this.columns != null);
      boolean that_present_columns = true && (that.columns != null);
      if (this_present_columns || that_present_columns) {
        if (!(this_present_columns && that_present_columns))
          return false;
        if (!this.columns.equals(that.columns))
          return false;
      }

      return true;
    }

    public int hashCode() {
      return 0;
    }

    public void read(TProtocol iprot) throws TException {
      TField field;
      iprot.readStructBegin();
      while (true)
      {
        field = iprot.readFieldBegin();
        if (field.type == TType.STOP) { 
          break;
        }
        switch (field.id)
        {
          case 1:
            if (field.type == TType.STRING) {
              this.tableName = iprot.readBinary();
              this.__isset.tableName = true;
            } else { 
              TProtocolUtil.skip(iprot, field.type);
            }
            break;
          case 2:
            if (field.type == TType.STRING) {
              this.startRow = iprot.readBinary();
              this.__isset.startRow = true;
            } else { 
              TProtocolUtil.skip(iprot, field.type);
            }
            break;
          case 3:
            if (field.type == TType.LIST) {
              {
                TList _list50 = iprot.readListBegin();
                this.columns = new ArrayList<byte[]>(_list50.size);
                for (int _i51 = 0; _i51 < _list50.size; ++_i51)
                {
                  byte[] _elem52 = null;
                  _elem52 = iprot.readBinary();
                  this.columns.add(_elem52);
                }
                iprot.readListEnd();
              }
              this.__isset.columns = true;
            } else { 
              TProtocolUtil.skip(iprot, field.type);
            }
            break;
          default:
            TProtocolUtil.skip(iprot, field.type);
            break;
        }
        iprot.readFieldEnd();
      }
      iprot.readStructEnd();
    }

    public void write(TProtocol oprot) throws TException {
      TStruct struct = new TStruct("scannerOpen_args");
      oprot.writeStructBegin(struct);
      TField field = new TField();
      if (this.tableName != null) {
        field.name = "tableName";
        field.type = TType.STRING;
        field.id = 1;
        oprot.writeFieldBegin(field);
        oprot.writeBinary(this.tableName);
        oprot.writeFieldEnd();
      }
      if (this.startRow != null) {
        field.name = "startRow";
        field.type = TType.STRING;
        field.id = 2;
        oprot.writeFieldBegin(field);
        oprot.writeBinary(this.startRow);
        oprot.writeFieldEnd();
      }
      if (this.columns != null) {
        field.name = "columns";
        field.type = TType.LIST;
        field.id = 3;
        oprot.writeFieldBegin(field);
        {
          oprot.writeListBegin(new TList(TType.STRING, this.columns.size()));
          for (byte[] _iter53 : this.columns)          {
            oprot.writeBinary(_iter53);
          }
          oprot.writeListEnd();
        }
        oprot.writeFieldEnd();
      }
      oprot.writeFieldStop();
      oprot.writeStructEnd();
    }

    public String toString() {
      StringBuilder sb = new StringBuilder("scannerOpen_args(");
      sb.append("tableName:");
      sb.append(this.tableName);
      sb.append(",startRow:");
      sb.append(this.startRow);
      sb.append(",columns:");
      sb.append(this.columns);
      sb.append(")");
      return sb.toString();
    }

  }

  public static class scannerOpen_result implements TBase, java.io.Serializable   {
    public int success;
    public IOError io;

    public final Isset __isset = new Isset();
    public static final class Isset implements java.io.Serializable {
      public boolean success = false;
      public boolean io = false;
    }

    public scannerOpen_result() {
    }

    public scannerOpen_result(
      int success,
      IOError io)
    {
      this();
      this.success = success;
      this.__isset.success = true;
      this.io = io;
      this.__isset.io = true;
    }

    public boolean equals(Object that) {
      if (that == null)
        return false;
      if (that instanceof scannerOpen_result)
        return this.equals((scannerOpen_result)that);
      return false;
    }

    public boolean equals(scannerOpen_result that) {
      if (that == null)
        return false;

      boolean this_present_success = true;
      boolean that_present_success = true;
      if (this_present_success || that_present_success) {
        if (!(this_present_success && that_present_success))
          return false;
        if (this.success != that.success)
          return false;
      }

      boolean this_present_io = true && (this.io != null);
      boolean that_present_io = true && (that.io != null);
      if (this_present_io || that_present_io) {
        if (!(this_present_io && that_present_io))
          return false;
        if (!this.io.equals(that.io))
          return false;
      }

      return true;
    }

    public int hashCode() {
      return 0;
    }

    public void read(TProtocol iprot) throws TException {
      TField field;
      iprot.readStructBegin();
      while (true)
      {
        field = iprot.readFieldBegin();
        if (field.type == TType.STOP) { 
          break;
        }
        switch (field.id)
        {
          case 0:
            if (field.type == TType.I32) {
              this.success = iprot.readI32();
              this.__isset.success = true;
            } else { 
              TProtocolUtil.skip(iprot, field.type);
            }
            break;
          case 1:
            if (field.type == TType.STRUCT) {
              this.io = new IOError();
              this.io.read(iprot);
              this.__isset.io = true;
            } else { 
              TProtocolUtil.skip(iprot, field.type);
            }
            break;
          default:
            TProtocolUtil.skip(iprot, field.type);
            break;
        }
        iprot.readFieldEnd();
      }
      iprot.readStructEnd();
    }

    public void write(TProtocol oprot) throws TException {
      TStruct struct = new TStruct("scannerOpen_result");
      oprot.writeStructBegin(struct);
      TField field = new TField();

      if (this.__isset.success) {
        field.name = "success";
        field.type = TType.I32;
        field.id = 0;
        oprot.writeFieldBegin(field);
        oprot.writeI32(this.success);
        oprot.writeFieldEnd();
      } else if (this.__isset.io) {
        if (this.io != null) {
          field.name = "io";
          field.type = TType.STRUCT;
          field.id = 1;
          oprot.writeFieldBegin(field);
          this.io.write(oprot);
          oprot.writeFieldEnd();
        }
      }
      oprot.writeFieldStop();
      oprot.writeStructEnd();
    }

    public String toString() {
      StringBuilder sb = new StringBuilder("scannerOpen_result(");
      sb.append("success:");
      sb.append(this.success);
      sb.append(",io:");
      sb.append(this.io.toString());
      sb.append(")");
      return sb.toString();
    }

  }

  public static class scannerOpenWithStop_args implements TBase, java.io.Serializable   {
    public byte[] tableName;
    public byte[] startRow;
    public byte[] stopRow;
    public List<byte[]> columns;

    public final Isset __isset = new Isset();
    public static final class Isset implements java.io.Serializable {
      public boolean tableName = false;
      public boolean startRow = false;
      public boolean stopRow = false;
      public boolean columns = false;
    }

    public scannerOpenWithStop_args() {
    }

    public scannerOpenWithStop_args(
      byte[] tableName,
      byte[] startRow,
      byte[] stopRow,
      List<byte[]> columns)
    {
      this();
      this.tableName = tableName;
      this.__isset.tableName = true;
      this.startRow = startRow;
      this.__isset.startRow = true;
      this.stopRow = stopRow;
      this.__isset.stopRow = true;
      this.columns = columns;
      this.__isset.columns = true;
    }

    public boolean equals(Object that) {
      if (that == null)
        return false;
      if (that instanceof scannerOpenWithStop_args)
        return this.equals((scannerOpenWithStop_args)that);
      return false;
    }

    public boolean equals(scannerOpenWithStop_args that) {
      if (that == null)
        return false;

      boolean this_present_tableName = true && (this.tableName != null);
      boolean that_present_tableName = true && (that.tableName != null);
      if (this_present_tableName || that_present_tableName) {
        if (!(this_present_tableName && that_present_tableName))
          return false;
        if (!java.util.Arrays.equals(this.tableName, that.tableName))
          return false;
      }

      boolean this_present_startRow = true && (this.startRow != null);
      boolean that_present_startRow = true && (that.startRow != null);
      if (this_present_startRow || that_present_startRow) {
        if (!(this_present_startRow && that_present_startRow))
          return false;
        if (!java.util.Arrays.equals(this.startRow, that.startRow))
          return false;
      }

      boolean this_present_stopRow = true && (this.stopRow != null);
      boolean that_present_stopRow = true && (that.stopRow != null);
      if (this_present_stopRow || that_present_stopRow) {
        if (!(this_present_stopRow && that_present_stopRow))
          return false;
        if (!java.util.Arrays.equals(this.stopRow, that.stopRow))
          return false;
      }

      boolean this_present_columns = true && (this.columns != null);
      boolean that_present_columns = true && (that.columns != null);
      if (this_present_columns || that_present_columns) {
        if (!(this_present_columns && that_present_columns))
          return false;
        if (!this.columns.equals(that.columns))
          return false;
      }

      return true;
    }

    public int hashCode() {
      return 0;
    }

    public void read(TProtocol iprot) throws TException {
      TField field;
      iprot.readStructBegin();
      while (true)
      {
        field = iprot.readFieldBegin();
        if (field.type == TType.STOP) { 
          break;
        }
        switch (field.id)
        {
          case 1:
            if (field.type == TType.STRING) {
              this.tableName = iprot.readBinary();
              this.__isset.tableName = true;
            } else { 
              TProtocolUtil.skip(iprot, field.type);
            }
            break;
          case 2:
            if (field.type == TType.STRING) {
              this.startRow = iprot.readBinary();
              this.__isset.startRow = true;
            } else { 
              TProtocolUtil.skip(iprot, field.type);
            }
            break;
          case 3:
            if (field.type == TType.STRING) {
              this.stopRow = iprot.readBinary();
              this.__isset.stopRow = true;
            } else { 
              TProtocolUtil.skip(iprot, field.type);
            }
            break;
          case 4:
            if (field.type == TType.LIST) {
              {
                TList _list54 = iprot.readListBegin();
                this.columns = new ArrayList<byte[]>(_list54.size);
                for (int _i55 = 0; _i55 < _list54.size; ++_i55)
                {
                  byte[] _elem56 = null;
                  _elem56 = iprot.readBinary();
                  this.columns.add(_elem56);
                }
                iprot.readListEnd();
              }
              this.__isset.columns = true;
            } else { 
              TProtocolUtil.skip(iprot, field.type);
            }
            break;
          default:
            TProtocolUtil.skip(iprot, field.type);
            break;
        }
        iprot.readFieldEnd();
      }
      iprot.readStructEnd();
    }

    public void write(TProtocol oprot) throws TException {
      TStruct struct = new TStruct("scannerOpenWithStop_args");
      oprot.writeStructBegin(struct);
      TField field = new TField();
      if (this.tableName != null) {
        field.name = "tableName";
        field.type = TType.STRING;
        field.id = 1;
        oprot.writeFieldBegin(field);
        oprot.writeBinary(this.tableName);
        oprot.writeFieldEnd();
      }
      if (this.startRow != null) {
        field.name = "startRow";
        field.type = TType.STRING;
        field.id = 2;
        oprot.writeFieldBegin(field);
        oprot.writeBinary(this.startRow);
        oprot.writeFieldEnd();
      }
      if (this.stopRow != null) {
        field.name = "stopRow";
        field.type = TType.STRING;
        field.id = 3;
        oprot.writeFieldBegin(field);
        oprot.writeBinary(this.stopRow);
        oprot.writeFieldEnd();
      }
      if (this.columns != null) {
        field.name = "columns";
        field.type = TType.LIST;
        field.id = 4;
        oprot.writeFieldBegin(field);
        {
          oprot.writeListBegin(new TList(TType.STRING, this.columns.size()));
          for (byte[] _iter57 : this.columns)          {
            oprot.writeBinary(_iter57);
          }
          oprot.writeListEnd();
        }
        oprot.writeFieldEnd();
      }
      oprot.writeFieldStop();
      oprot.writeStructEnd();
    }

    public String toString() {
      StringBuilder sb = new StringBuilder("scannerOpenWithStop_args(");
      sb.append("tableName:");
      sb.append(this.tableName);
      sb.append(",startRow:");
      sb.append(this.startRow);
      sb.append(",stopRow:");
      sb.append(this.stopRow);
      sb.append(",columns:");
      sb.append(this.columns);
      sb.append(")");
      return sb.toString();
    }

  }

  public static class scannerOpenWithStop_result implements TBase, java.io.Serializable   {
    public int success;
    public IOError io;

    public final Isset __isset = new Isset();
    public static final class Isset implements java.io.Serializable {
      public boolean success = false;
      public boolean io = false;
    }

    public scannerOpenWithStop_result() {
    }

    public scannerOpenWithStop_result(
      int success,
      IOError io)
    {
      this();
      this.success = success;
      this.__isset.success = true;
      this.io = io;
      this.__isset.io = true;
    }

    public boolean equals(Object that) {
      if (that == null)
        return false;
      if (that instanceof scannerOpenWithStop_result)
        return this.equals((scannerOpenWithStop_result)that);
      return false;
    }

    public boolean equals(scannerOpenWithStop_result that) {
      if (that == null)
        return false;

      boolean this_present_success = true;
      boolean that_present_success = true;
      if (this_present_success || that_present_success) {
        if (!(this_present_success && that_present_success))
          return false;
        if (this.success != that.success)
          return false;
      }

      boolean this_present_io = true && (this.io != null);
      boolean that_present_io = true && (that.io != null);
      if (this_present_io || that_present_io) {
        if (!(this_present_io && that_present_io))
          return false;
        if (!this.io.equals(that.io))
          return false;
      }

      return true;
    }

    public int hashCode() {
      return 0;
    }

    public void read(TProtocol iprot) throws TException {
      TField field;
      iprot.readStructBegin();
      while (true)
      {
        field = iprot.readFieldBegin();
        if (field.type == TType.STOP) { 
          break;
        }
        switch (field.id)
        {
          case 0:
            if (field.type == TType.I32) {
              this.success = iprot.readI32();
              this.__isset.success = true;
            } else { 
              TProtocolUtil.skip(iprot, field.type);
            }
            break;
          case 1:
            if (field.type == TType.STRUCT) {
              this.io = new IOError();
              this.io.read(iprot);
              this.__isset.io = true;
            } else { 
              TProtocolUtil.skip(iprot, field.type);
            }
            break;
          default:
            TProtocolUtil.skip(iprot, field.type);
            break;
        }
        iprot.readFieldEnd();
      }
      iprot.readStructEnd();
    }

    public void write(TProtocol oprot) throws TException {
      TStruct struct = new TStruct("scannerOpenWithStop_result");
      oprot.writeStructBegin(struct);
      TField field = new TField();

      if (this.__isset.success) {
        field.name = "success";
        field.type = TType.I32;
        field.id = 0;
        oprot.writeFieldBegin(field);
        oprot.writeI32(this.success);
        oprot.writeFieldEnd();
      } else if (this.__isset.io) {
        if (this.io != null) {
          field.name = "io";
          field.type = TType.STRUCT;
          field.id = 1;
          oprot.writeFieldBegin(field);
          this.io.write(oprot);
          oprot.writeFieldEnd();
        }
      }
      oprot.writeFieldStop();
      oprot.writeStructEnd();
    }

    public String toString() {
      StringBuilder sb = new StringBuilder("scannerOpenWithStop_result(");
      sb.append("success:");
      sb.append(this.success);
      sb.append(",io:");
      sb.append(this.io.toString());
      sb.append(")");
      return sb.toString();
    }

  }

  public static class scannerOpenTs_args implements TBase, java.io.Serializable   {
    public byte[] tableName;
    public byte[] startRow;
    public List<byte[]> columns;
    public long timestamp;

    public final Isset __isset = new Isset();
    public static final class Isset implements java.io.Serializable {
      public boolean tableName = false;
      public boolean startRow = false;
      public boolean columns = false;
      public boolean timestamp = false;
    }

    public scannerOpenTs_args() {
    }

    public scannerOpenTs_args(
      byte[] tableName,
      byte[] startRow,
      List<byte[]> columns,
      long timestamp)
    {
      this();
      this.tableName = tableName;
      this.__isset.tableName = true;
      this.startRow = startRow;
      this.__isset.startRow = true;
      this.columns = columns;
      this.__isset.columns = true;
      this.timestamp = timestamp;
      this.__isset.timestamp = true;
    }

    public boolean equals(Object that) {
      if (that == null)
        return false;
      if (that instanceof scannerOpenTs_args)
        return this.equals((scannerOpenTs_args)that);
      return false;
    }

    public boolean equals(scannerOpenTs_args that) {
      if (that == null)
        return false;

      boolean this_present_tableName = true && (this.tableName != null);
      boolean that_present_tableName = true && (that.tableName != null);
      if (this_present_tableName || that_present_tableName) {
        if (!(this_present_tableName && that_present_tableName))
          return false;
        if (!java.util.Arrays.equals(this.tableName, that.tableName))
          return false;
      }

      boolean this_present_startRow = true && (this.startRow != null);
      boolean that_present_startRow = true && (that.startRow != null);
      if (this_present_startRow || that_present_startRow) {
        if (!(this_present_startRow && that_present_startRow))
          return false;
        if (!java.util.Arrays.equals(this.startRow, that.startRow))
          return false;
      }

      boolean this_present_columns = true && (this.columns != null);
      boolean that_present_columns = true && (that.columns != null);
      if (this_present_columns || that_present_columns) {
        if (!(this_present_columns && that_present_columns))
          return false;
        if (!this.columns.equals(that.columns))
          return false;
      }

      boolean this_present_timestamp = true;
      boolean that_present_timestamp = true;
      if (this_present_timestamp || that_present_timestamp) {
        if (!(this_present_timestamp && that_present_timestamp))
          return false;
        if (this.timestamp != that.timestamp)
          return false;
      }

      return true;
    }

    public int hashCode() {
      return 0;
    }

    public void read(TProtocol iprot) throws TException {
      TField field;
      iprot.readStructBegin();
      while (true)
      {
        field = iprot.readFieldBegin();
        if (field.type == TType.STOP) { 
          break;
        }
        switch (field.id)
        {
          case 1:
            if (field.type == TType.STRING) {
              this.tableName = iprot.readBinary();
              this.__isset.tableName = true;
            } else { 
              TProtocolUtil.skip(iprot, field.type);
            }
            break;
          case 2:
            if (field.type == TType.STRING) {
              this.startRow = iprot.readBinary();
              this.__isset.startRow = true;
            } else { 
              TProtocolUtil.skip(iprot, field.type);
            }
            break;
          case 3:
            if (field.type == TType.LIST) {
              {
                TList _list58 = iprot.readListBegin();
                this.columns = new ArrayList<byte[]>(_list58.size);
                for (int _i59 = 0; _i59 < _list58.size; ++_i59)
                {
                  byte[] _elem60 = null;
                  _elem60 = iprot.readBinary();
                  this.columns.add(_elem60);
                }
                iprot.readListEnd();
              }
              this.__isset.columns = true;
            } else { 
              TProtocolUtil.skip(iprot, field.type);
            }
            break;
          case 4:
            if (field.type == TType.I64) {
              this.timestamp = iprot.readI64();
              this.__isset.timestamp = true;
            } else { 
              TProtocolUtil.skip(iprot, field.type);
            }
            break;
          default:
            TProtocolUtil.skip(iprot, field.type);
            break;
        }
        iprot.readFieldEnd();
      }
      iprot.readStructEnd();
    }

    public void write(TProtocol oprot) throws TException {
      TStruct struct = new TStruct("scannerOpenTs_args");
      oprot.writeStructBegin(struct);
      TField field = new TField();
      if (this.tableName != null) {
        field.name = "tableName";
        field.type = TType.STRING;
        field.id = 1;
        oprot.writeFieldBegin(field);
        oprot.writeBinary(this.tableName);
        oprot.writeFieldEnd();
      }
      if (this.startRow != null) {
        field.name = "startRow";
        field.type = TType.STRING;
        field.id = 2;
        oprot.writeFieldBegin(field);
        oprot.writeBinary(this.startRow);
        oprot.writeFieldEnd();
      }
      if (this.columns != null) {
        field.name = "columns";
        field.type = TType.LIST;
        field.id = 3;
        oprot.writeFieldBegin(field);
        {
          oprot.writeListBegin(new TList(TType.STRING, this.columns.size()));
          for (byte[] _iter61 : this.columns)          {
            oprot.writeBinary(_iter61);
          }
          oprot.writeListEnd();
        }
        oprot.writeFieldEnd();
      }
      field.name = "timestamp";
      field.type = TType.I64;
      field.id = 4;
      oprot.writeFieldBegin(field);
      oprot.writeI64(this.timestamp);
      oprot.writeFieldEnd();
      oprot.writeFieldStop();
      oprot.writeStructEnd();
    }

    public String toString() {
      StringBuilder sb = new StringBuilder("scannerOpenTs_args(");
      sb.append("tableName:");
      sb.append(this.tableName);
      sb.append(",startRow:");
      sb.append(this.startRow);
      sb.append(",columns:");
      sb.append(this.columns);
      sb.append(",timestamp:");
      sb.append(this.timestamp);
      sb.append(")");
      return sb.toString();
    }

  }

  public static class scannerOpenTs_result implements TBase, java.io.Serializable   {
    public int success;
    public IOError io;

    public final Isset __isset = new Isset();
    public static final class Isset implements java.io.Serializable {
      public boolean success = false;
      public boolean io = false;
    }

    public scannerOpenTs_result() {
    }

    public scannerOpenTs_result(
      int success,
      IOError io)
    {
      this();
      this.success = success;
      this.__isset.success = true;
      this.io = io;
      this.__isset.io = true;
    }

    public boolean equals(Object that) {
      if (that == null)
        return false;
      if (that instanceof scannerOpenTs_result)
        return this.equals((scannerOpenTs_result)that);
      return false;
    }

    public boolean equals(scannerOpenTs_result that) {
      if (that == null)
        return false;

      boolean this_present_success = true;
      boolean that_present_success = true;
      if (this_present_success || that_present_success) {
        if (!(this_present_success && that_present_success))
          return false;
        if (this.success != that.success)
          return false;
      }

      boolean this_present_io = true && (this.io != null);
      boolean that_present_io = true && (that.io != null);
      if (this_present_io || that_present_io) {
        if (!(this_present_io && that_present_io))
          return false;
        if (!this.io.equals(that.io))
          return false;
      }

      return true;
    }

    public int hashCode() {
      return 0;
    }

    public void read(TProtocol iprot) throws TException {
      TField field;
      iprot.readStructBegin();
      while (true)
      {
        field = iprot.readFieldBegin();
        if (field.type == TType.STOP) { 
          break;
        }
        switch (field.id)
        {
          case 0:
            if (field.type == TType.I32) {
              this.success = iprot.readI32();
              this.__isset.success = true;
            } else { 
              TProtocolUtil.skip(iprot, field.type);
            }
            break;
          case 1:
            if (field.type == TType.STRUCT) {
              this.io = new IOError();
              this.io.read(iprot);
              this.__isset.io = true;
            } else { 
              TProtocolUtil.skip(iprot, field.type);
            }
            break;
          default:
            TProtocolUtil.skip(iprot, field.type);
            break;
        }
        iprot.readFieldEnd();
      }
      iprot.readStructEnd();
    }

    public void write(TProtocol oprot) throws TException {
      TStruct struct = new TStruct("scannerOpenTs_result");
      oprot.writeStructBegin(struct);
      TField field = new TField();

      if (this.__isset.success) {
        field.name = "success";
        field.type = TType.I32;
        field.id = 0;
        oprot.writeFieldBegin(field);
        oprot.writeI32(this.success);
        oprot.writeFieldEnd();
      } else if (this.__isset.io) {
        if (this.io != null) {
          field.name = "io";
          field.type = TType.STRUCT;
          field.id = 1;
          oprot.writeFieldBegin(field);
          this.io.write(oprot);
          oprot.writeFieldEnd();
        }
      }
      oprot.writeFieldStop();
      oprot.writeStructEnd();
    }

    public String toString() {
      StringBuilder sb = new StringBuilder("scannerOpenTs_result(");
      sb.append("success:");
      sb.append(this.success);
      sb.append(",io:");
      sb.append(this.io.toString());
      sb.append(")");
      return sb.toString();
    }

  }

  public static class scannerOpenWithStopTs_args implements TBase, java.io.Serializable   {
    public byte[] tableName;
    public byte[] startRow;
    public byte[] stopRow;
    public List<byte[]> columns;
    public long timestamp;

    public final Isset __isset = new Isset();
    public static final class Isset implements java.io.Serializable {
      public boolean tableName = false;
      public boolean startRow = false;
      public boolean stopRow = false;
      public boolean columns = false;
      public boolean timestamp = false;
    }

    public scannerOpenWithStopTs_args() {
    }

    public scannerOpenWithStopTs_args(
      byte[] tableName,
      byte[] startRow,
      byte[] stopRow,
      List<byte[]> columns,
      long timestamp)
    {
      this();
      this.tableName = tableName;
      this.__isset.tableName = true;
      this.startRow = startRow;
      this.__isset.startRow = true;
      this.stopRow = stopRow;
      this.__isset.stopRow = true;
      this.columns = columns;
      this.__isset.columns = true;
      this.timestamp = timestamp;
      this.__isset.timestamp = true;
    }

    public boolean equals(Object that) {
      if (that == null)
        return false;
      if (that instanceof scannerOpenWithStopTs_args)
        return this.equals((scannerOpenWithStopTs_args)that);
      return false;
    }

    public boolean equals(scannerOpenWithStopTs_args that) {
      if (that == null)
        return false;

      boolean this_present_tableName = true && (this.tableName != null);
      boolean that_present_tableName = true && (that.tableName != null);
      if (this_present_tableName || that_present_tableName) {
        if (!(this_present_tableName && that_present_tableName))
          return false;
        if (!java.util.Arrays.equals(this.tableName, that.tableName))
          return false;
      }

      boolean this_present_startRow = true && (this.startRow != null);
      boolean that_present_startRow = true && (that.startRow != null);
      if (this_present_startRow || that_present_startRow) {
        if (!(this_present_startRow && that_present_startRow))
          return false;
        if (!java.util.Arrays.equals(this.startRow, that.startRow))
          return false;
      }

      boolean this_present_stopRow = true && (this.stopRow != null);
      boolean that_present_stopRow = true && (that.stopRow != null);
      if (this_present_stopRow || that_present_stopRow) {
        if (!(this_present_stopRow && that_present_stopRow))
          return false;
        if (!java.util.Arrays.equals(this.stopRow, that.stopRow))
          return false;
      }

      boolean this_present_columns = true && (this.columns != null);
      boolean that_present_columns = true && (that.columns != null);
      if (this_present_columns || that_present_columns) {
        if (!(this_present_columns && that_present_columns))
          return false;
        if (!this.columns.equals(that.columns))
          return false;
      }

      boolean this_present_timestamp = true;
      boolean that_present_timestamp = true;
      if (this_present_timestamp || that_present_timestamp) {
        if (!(this_present_timestamp && that_present_timestamp))
          return false;
        if (this.timestamp != that.timestamp)
          return false;
      }

      return true;
    }

    public int hashCode() {
      return 0;
    }

    public void read(TProtocol iprot) throws TException {
      TField field;
      iprot.readStructBegin();
      while (true)
      {
        field = iprot.readFieldBegin();
        if (field.type == TType.STOP) { 
          break;
        }
        switch (field.id)
        {
          case 1:
            if (field.type == TType.STRING) {
              this.tableName = iprot.readBinary();
              this.__isset.tableName = true;
            } else { 
              TProtocolUtil.skip(iprot, field.type);
            }
            break;
          case 2:
            if (field.type == TType.STRING) {
              this.startRow = iprot.readBinary();
              this.__isset.startRow = true;
            } else { 
              TProtocolUtil.skip(iprot, field.type);
            }
            break;
          case 3:
            if (field.type == TType.STRING) {
              this.stopRow = iprot.readBinary();
              this.__isset.stopRow = true;
            } else { 
              TProtocolUtil.skip(iprot, field.type);
            }
            break;
          case 4:
            if (field.type == TType.LIST) {
              {
                TList _list62 = iprot.readListBegin();
                this.columns = new ArrayList<byte[]>(_list62.size);
                for (int _i63 = 0; _i63 < _list62.size; ++_i63)
                {
                  byte[] _elem64 = null;
                  _elem64 = iprot.readBinary();
                  this.columns.add(_elem64);
                }
                iprot.readListEnd();
              }
              this.__isset.columns = true;
            } else { 
              TProtocolUtil.skip(iprot, field.type);
            }
            break;
          case 5:
            if (field.type == TType.I64) {
              this.timestamp = iprot.readI64();
              this.__isset.timestamp = true;
            } else { 
              TProtocolUtil.skip(iprot, field.type);
            }
            break;
          default:
            TProtocolUtil.skip(iprot, field.type);
            break;
        }
        iprot.readFieldEnd();
      }
      iprot.readStructEnd();
    }

    public void write(TProtocol oprot) throws TException {
      TStruct struct = new TStruct("scannerOpenWithStopTs_args");
      oprot.writeStructBegin(struct);
      TField field = new TField();
      if (this.tableName != null) {
        field.name = "tableName";
        field.type = TType.STRING;
        field.id = 1;
        oprot.writeFieldBegin(field);
        oprot.writeBinary(this.tableName);
        oprot.writeFieldEnd();
      }
      if (this.startRow != null) {
        field.name = "startRow";
        field.type = TType.STRING;
        field.id = 2;
        oprot.writeFieldBegin(field);
        oprot.writeBinary(this.startRow);
        oprot.writeFieldEnd();
      }
      if (this.stopRow != null) {
        field.name = "stopRow";
        field.type = TType.STRING;
        field.id = 3;
        oprot.writeFieldBegin(field);
        oprot.writeBinary(this.stopRow);
        oprot.writeFieldEnd();
      }
      if (this.columns != null) {
        field.name = "columns";
        field.type = TType.LIST;
        field.id = 4;
        oprot.writeFieldBegin(field);
        {
          oprot.writeListBegin(new TList(TType.STRING, this.columns.size()));
          for (byte[] _iter65 : this.columns)          {
            oprot.writeBinary(_iter65);
          }
          oprot.writeListEnd();
        }
        oprot.writeFieldEnd();
      }
      field.name = "timestamp";
      field.type = TType.I64;
      field.id = 5;
      oprot.writeFieldBegin(field);
      oprot.writeI64(this.timestamp);
      oprot.writeFieldEnd();
      oprot.writeFieldStop();
      oprot.writeStructEnd();
    }

    public String toString() {
      StringBuilder sb = new StringBuilder("scannerOpenWithStopTs_args(");
      sb.append("tableName:");
      sb.append(this.tableName);
      sb.append(",startRow:");
      sb.append(this.startRow);
      sb.append(",stopRow:");
      sb.append(this.stopRow);
      sb.append(",columns:");
      sb.append(this.columns);
      sb.append(",timestamp:");
      sb.append(this.timestamp);
      sb.append(")");
      return sb.toString();
    }

  }

  public static class scannerOpenWithStopTs_result implements TBase, java.io.Serializable   {
    public int success;
    public IOError io;

    public final Isset __isset = new Isset();
    public static final class Isset implements java.io.Serializable {
      public boolean success = false;
      public boolean io = false;
    }

    public scannerOpenWithStopTs_result() {
    }

    public scannerOpenWithStopTs_result(
      int success,
      IOError io)
    {
      this();
      this.success = success;
      this.__isset.success = true;
      this.io = io;
      this.__isset.io = true;
    }

    public boolean equals(Object that) {
      if (that == null)
        return false;
      if (that instanceof scannerOpenWithStopTs_result)
        return this.equals((scannerOpenWithStopTs_result)that);
      return false;
    }

    public boolean equals(scannerOpenWithStopTs_result that) {
      if (that == null)
        return false;

      boolean this_present_success = true;
      boolean that_present_success = true;
      if (this_present_success || that_present_success) {
        if (!(this_present_success && that_present_success))
          return false;
        if (this.success != that.success)
          return false;
      }

      boolean this_present_io = true && (this.io != null);
      boolean that_present_io = true && (that.io != null);
      if (this_present_io || that_present_io) {
        if (!(this_present_io && that_present_io))
          return false;
        if (!this.io.equals(that.io))
          return false;
      }

      return true;
    }

    public int hashCode() {
      return 0;
    }

    public void read(TProtocol iprot) throws TException {
      TField field;
      iprot.readStructBegin();
      while (true)
      {
        field = iprot.readFieldBegin();
        if (field.type == TType.STOP) { 
          break;
        }
        switch (field.id)
        {
          case 0:
            if (field.type == TType.I32) {
              this.success = iprot.readI32();
              this.__isset.success = true;
            } else { 
              TProtocolUtil.skip(iprot, field.type);
            }
            break;
          case 1:
            if (field.type == TType.STRUCT) {
              this.io = new IOError();
              this.io.read(iprot);
              this.__isset.io = true;
            } else { 
              TProtocolUtil.skip(iprot, field.type);
            }
            break;
          default:
            TProtocolUtil.skip(iprot, field.type);
            break;
        }
        iprot.readFieldEnd();
      }
      iprot.readStructEnd();
    }

    public void write(TProtocol oprot) throws TException {
      TStruct struct = new TStruct("scannerOpenWithStopTs_result");
      oprot.writeStructBegin(struct);
      TField field = new TField();

      if (this.__isset.success) {
        field.name = "success";
        field.type = TType.I32;
        field.id = 0;
        oprot.writeFieldBegin(field);
        oprot.writeI32(this.success);
        oprot.writeFieldEnd();
      } else if (this.__isset.io) {
        if (this.io != null) {
          field.name = "io";
          field.type = TType.STRUCT;
          field.id = 1;
          oprot.writeFieldBegin(field);
          this.io.write(oprot);
          oprot.writeFieldEnd();
        }
      }
      oprot.writeFieldStop();
      oprot.writeStructEnd();
    }

    public String toString() {
      StringBuilder sb = new StringBuilder("scannerOpenWithStopTs_result(");
      sb.append("success:");
      sb.append(this.success);
      sb.append(",io:");
      sb.append(this.io.toString());
      sb.append(")");
      return sb.toString();
    }

  }

  public static class scannerGet_args implements TBase, java.io.Serializable   {
    public int id;

    public final Isset __isset = new Isset();
    public static final class Isset implements java.io.Serializable {
      public boolean id = false;
    }

    public scannerGet_args() {
    }

    public scannerGet_args(
      int id)
    {
      this();
      this.id = id;
      this.__isset.id = true;
    }

    public boolean equals(Object that) {
      if (that == null)
        return false;
      if (that instanceof scannerGet_args)
        return this.equals((scannerGet_args)that);
      return false;
    }

    public boolean equals(scannerGet_args that) {
      if (that == null)
        return false;

      boolean this_present_id = true;
      boolean that_present_id = true;
      if (this_present_id || that_present_id) {
        if (!(this_present_id && that_present_id))
          return false;
        if (this.id != that.id)
          return false;
      }

      return true;
    }

    public int hashCode() {
      return 0;
    }

    public void read(TProtocol iprot) throws TException {
      TField field;
      iprot.readStructBegin();
      while (true)
      {
        field = iprot.readFieldBegin();
        if (field.type == TType.STOP) { 
          break;
        }
        switch (field.id)
        {
          case 1:
            if (field.type == TType.I32) {
              this.id = iprot.readI32();
              this.__isset.id = true;
            } else { 
              TProtocolUtil.skip(iprot, field.type);
            }
            break;
          default:
            TProtocolUtil.skip(iprot, field.type);
            break;
        }
        iprot.readFieldEnd();
      }
      iprot.readStructEnd();
    }

    public void write(TProtocol oprot) throws TException {
      TStruct struct = new TStruct("scannerGet_args");
      oprot.writeStructBegin(struct);
      TField field = new TField();
      field.name = "id";
      field.type = TType.I32;
      field.id = 1;
      oprot.writeFieldBegin(field);
      oprot.writeI32(this.id);
      oprot.writeFieldEnd();
      oprot.writeFieldStop();
      oprot.writeStructEnd();
    }

    public String toString() {
      StringBuilder sb = new StringBuilder("scannerGet_args(");
      sb.append("id:");
      sb.append(this.id);
      sb.append(")");
      return sb.toString();
    }

  }

  public static class scannerGet_result implements TBase, java.io.Serializable   {
    public TRowResult success;
    public IOError io;
    public IllegalArgument ia;
    public NotFound nf;

    public final Isset __isset = new Isset();
    public static final class Isset implements java.io.Serializable {
      public boolean success = false;
      public boolean io = false;
      public boolean ia = false;
      public boolean nf = false;
    }

    public scannerGet_result() {
    }

    public scannerGet_result(
      TRowResult success,
      IOError io,
      IllegalArgument ia,
      NotFound nf)
    {
      this();
      this.success = success;
      this.__isset.success = true;
      this.io = io;
      this.__isset.io = true;
      this.ia = ia;
      this.__isset.ia = true;
      this.nf = nf;
      this.__isset.nf = true;
    }

    public boolean equals(Object that) {
      if (that == null)
        return false;
      if (that instanceof scannerGet_result)
        return this.equals((scannerGet_result)that);
      return false;
    }

    public boolean equals(scannerGet_result that) {
      if (that == null)
        return false;

      boolean this_present_success = true && (this.success != null);
      boolean that_present_success = true && (that.success != null);
      if (this_present_success || that_present_success) {
        if (!(this_present_success && that_present_success))
          return false;
        if (!this.success.equals(that.success))
          return false;
      }

      boolean this_present_io = true && (this.io != null);
      boolean that_present_io = true && (that.io != null);
      if (this_present_io || that_present_io) {
        if (!(this_present_io && that_present_io))
          return false;
        if (!this.io.equals(that.io))
          return false;
      }

      boolean this_present_ia = true && (this.ia != null);
      boolean that_present_ia = true && (that.ia != null);
      if (this_present_ia || that_present_ia) {
        if (!(this_present_ia && that_present_ia))
          return false;
        if (!this.ia.equals(that.ia))
          return false;
      }

      boolean this_present_nf = true && (this.nf != null);
      boolean that_present_nf = true && (that.nf != null);
      if (this_present_nf || that_present_nf) {
        if (!(this_present_nf && that_present_nf))
          return false;
        if (!this.nf.equals(that.nf))
          return false;
      }

      return true;
    }

    public int hashCode() {
      return 0;
    }

    public void read(TProtocol iprot) throws TException {
      TField field;
      iprot.readStructBegin();
      while (true)
      {
        field = iprot.readFieldBegin();
        if (field.type == TType.STOP) { 
          break;
        }
        switch (field.id)
        {
          case 0:
            if (field.type == TType.STRUCT) {
              this.success = new TRowResult();
              this.success.read(iprot);
              this.__isset.success = true;
            } else { 
              TProtocolUtil.skip(iprot, field.type);
            }
            break;
          case 1:
            if (field.type == TType.STRUCT) {
              this.io = new IOError();
              this.io.read(iprot);
              this.__isset.io = true;
            } else { 
              TProtocolUtil.skip(iprot, field.type);
            }
            break;
          case 2:
            if (field.type == TType.STRUCT) {
              this.ia = new IllegalArgument();
              this.ia.read(iprot);
              this.__isset.ia = true;
            } else { 
              TProtocolUtil.skip(iprot, field.type);
            }
            break;
          case 3:
            if (field.type == TType.STRUCT) {
              this.nf = new NotFound();
              this.nf.read(iprot);
              this.__isset.nf = true;
            } else { 
              TProtocolUtil.skip(iprot, field.type);
            }
            break;
          default:
            TProtocolUtil.skip(iprot, field.type);
            break;
        }
        iprot.readFieldEnd();
      }
      iprot.readStructEnd();
    }

    public void write(TProtocol oprot) throws TException {
      TStruct struct = new TStruct("scannerGet_result");
      oprot.writeStructBegin(struct);
      TField field = new TField();

      if (this.__isset.success) {
        if (this.success != null) {
          field.name = "success";
          field.type = TType.STRUCT;
          field.id = 0;
          oprot.writeFieldBegin(field);
          this.success.write(oprot);
          oprot.writeFieldEnd();
        }
      } else if (this.__isset.io) {
        if (this.io != null) {
          field.name = "io";
          field.type = TType.STRUCT;
          field.id = 1;
          oprot.writeFieldBegin(field);
          this.io.write(oprot);
          oprot.writeFieldEnd();
        }
      } else if (this.__isset.ia) {
        if (this.ia != null) {
          field.name = "ia";
          field.type = TType.STRUCT;
          field.id = 2;
          oprot.writeFieldBegin(field);
          this.ia.write(oprot);
          oprot.writeFieldEnd();
        }
      } else if (this.__isset.nf) {
        if (this.nf != null) {
          field.name = "nf";
          field.type = TType.STRUCT;
          field.id = 3;
          oprot.writeFieldBegin(field);
          this.nf.write(oprot);
          oprot.writeFieldEnd();
        }
      }
      oprot.writeFieldStop();
      oprot.writeStructEnd();
    }

    public String toString() {
      StringBuilder sb = new StringBuilder("scannerGet_result(");
      sb.append("success:");
      sb.append(this.success.toString());
      sb.append(",io:");
      sb.append(this.io.toString());
      sb.append(",ia:");
      sb.append(this.ia.toString());
      sb.append(",nf:");
      sb.append(this.nf.toString());
      sb.append(")");
      return sb.toString();
    }

  }

  public static class scannerClose_args implements TBase, java.io.Serializable   {
    public int id;

    public final Isset __isset = new Isset();
    public static final class Isset implements java.io.Serializable {
      public boolean id = false;
    }

    public scannerClose_args() {
    }

    public scannerClose_args(
      int id)
    {
      this();
      this.id = id;
      this.__isset.id = true;
    }

    public boolean equals(Object that) {
      if (that == null)
        return false;
      if (that instanceof scannerClose_args)
        return this.equals((scannerClose_args)that);
      return false;
    }

    public boolean equals(scannerClose_args that) {
      if (that == null)
        return false;

      boolean this_present_id = true;
      boolean that_present_id = true;
      if (this_present_id || that_present_id) {
        if (!(this_present_id && that_present_id))
          return false;
        if (this.id != that.id)
          return false;
      }

      return true;
    }

    public int hashCode() {
      return 0;
    }

    public void read(TProtocol iprot) throws TException {
      TField field;
      iprot.readStructBegin();
      while (true)
      {
        field = iprot.readFieldBegin();
        if (field.type == TType.STOP) { 
          break;
        }
        switch (field.id)
        {
          case 1:
            if (field.type == TType.I32) {
              this.id = iprot.readI32();
              this.__isset.id = true;
            } else { 
              TProtocolUtil.skip(iprot, field.type);
            }
            break;
          default:
            TProtocolUtil.skip(iprot, field.type);
            break;
        }
        iprot.readFieldEnd();
      }
      iprot.readStructEnd();
    }

    public void write(TProtocol oprot) throws TException {
      TStruct struct = new TStruct("scannerClose_args");
      oprot.writeStructBegin(struct);
      TField field = new TField();
      field.name = "id";
      field.type = TType.I32;
      field.id = 1;
      oprot.writeFieldBegin(field);
      oprot.writeI32(this.id);
      oprot.writeFieldEnd();
      oprot.writeFieldStop();
      oprot.writeStructEnd();
    }

    public String toString() {
      StringBuilder sb = new StringBuilder("scannerClose_args(");
      sb.append("id:");
      sb.append(this.id);
      sb.append(")");
      return sb.toString();
    }

  }

  public static class scannerClose_result implements TBase, java.io.Serializable   {
    public IOError io;
    public IllegalArgument ia;

    public final Isset __isset = new Isset();
    public static final class Isset implements java.io.Serializable {
      public boolean io = false;
      public boolean ia = false;
    }

    public scannerClose_result() {
    }

    public scannerClose_result(
      IOError io,
      IllegalArgument ia)
    {
      this();
      this.io = io;
      this.__isset.io = true;
      this.ia = ia;
      this.__isset.ia = true;
    }

    public boolean equals(Object that) {
      if (that == null)
        return false;
      if (that instanceof scannerClose_result)
        return this.equals((scannerClose_result)that);
      return false;
    }

    public boolean equals(scannerClose_result that) {
      if (that == null)
        return false;

      boolean this_present_io = true && (this.io != null);
      boolean that_present_io = true && (that.io != null);
      if (this_present_io || that_present_io) {
        if (!(this_present_io && that_present_io))
          return false;
        if (!this.io.equals(that.io))
          return false;
      }

      boolean this_present_ia = true && (this.ia != null);
      boolean that_present_ia = true && (that.ia != null);
      if (this_present_ia || that_present_ia) {
        if (!(this_present_ia && that_present_ia))
          return false;
        if (!this.ia.equals(that.ia))
          return false;
      }

      return true;
    }

    public int hashCode() {
      return 0;
    }

    public void read(TProtocol iprot) throws TException {
      TField field;
      iprot.readStructBegin();
      while (true)
      {
        field = iprot.readFieldBegin();
        if (field.type == TType.STOP) { 
          break;
        }
        switch (field.id)
        {
          case 1:
            if (field.type == TType.STRUCT) {
              this.io = new IOError();
              this.io.read(iprot);
              this.__isset.io = true;
            } else { 
              TProtocolUtil.skip(iprot, field.type);
            }
            break;
          case 2:
            if (field.type == TType.STRUCT) {
              this.ia = new IllegalArgument();
              this.ia.read(iprot);
              this.__isset.ia = true;
            } else { 
              TProtocolUtil.skip(iprot, field.type);
            }
            break;
          default:
            TProtocolUtil.skip(iprot, field.type);
            break;
        }
        iprot.readFieldEnd();
      }
      iprot.readStructEnd();
    }

    public void write(TProtocol oprot) throws TException {
      TStruct struct = new TStruct("scannerClose_result");
      oprot.writeStructBegin(struct);
      TField field = new TField();

      if (this.__isset.io) {
        if (this.io != null) {
          field.name = "io";
          field.type = TType.STRUCT;
          field.id = 1;
          oprot.writeFieldBegin(field);
          this.io.write(oprot);
          oprot.writeFieldEnd();
        }
      } else if (this.__isset.ia) {
        if (this.ia != null) {
          field.name = "ia";
          field.type = TType.STRUCT;
          field.id = 2;
          oprot.writeFieldBegin(field);
          this.ia.write(oprot);
          oprot.writeFieldEnd();
        }
      }
      oprot.writeFieldStop();
      oprot.writeStructEnd();
    }

    public String toString() {
      StringBuilder sb = new StringBuilder("scannerClose_result(");
      sb.append("io:");
      sb.append(this.io.toString());
      sb.append(",ia:");
      sb.append(this.ia.toString());
      sb.append(")");
      return sb.toString();
    }

  }

}
