/**
 * Copyright 2007 The Apache Software Foundation
 *
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.apache.hadoop.hbase.mapred;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;                             //TODO: remove

import org.apache.hadoop.io.Writable;
import org.apache.lucene.document.Document;

/**
 * A utility class used to pass a lucene document from reduce to OutputFormat.
 * It doesn't really serialize/deserialize a lucene document.
 */
class LuceneDocumentWrapper implements Writable {
  private Document doc;

  /**
   * @param doc
   */
  public LuceneDocumentWrapper(Document doc) {
    this.doc = doc;
  }

  /**
   * @return the document
   */
  public Document get() {
    return doc;
  }

  public void readFields(@SuppressWarnings("unused") DataInput in) {
    // intentionally left blank
  }

  public void write(@SuppressWarnings("unused") DataOutput out) {
    // intentionally left blank
  }
}
