/*
 * Decompiled with CFR 0.152.
 */
package org.zhouer.zterm;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Font;
import java.awt.KeyboardFocusManager;
import java.awt.image.BufferedImage;
import java.util.Locale;
import java.util.Vector;
import javax.swing.DefaultComboBoxModel;
import javax.swing.ImageIcon;
import javax.swing.JApplet;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JTabbedPane;
import javax.swing.JToolBar;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.text.JTextComponent;
import org.zhouer.zterm.ActionHandler;
import org.zhouer.zterm.ChangeHandler;
import org.zhouer.zterm.ComponentHandler;
import org.zhouer.zterm.KeyEventHandler;
import org.zhouer.zterm.KeyHandler;
import org.zhouer.zterm.Messages;
import org.zhouer.zterm.Model;
import org.zhouer.zterm.Resource;
import org.zhouer.zterm.Session;
import org.zhouer.zterm.Sessions;
import org.zhouer.zterm.Site;

public class ZTerm
extends JApplet {
    private static final long serialVersionUID = 6304594468121008572L;
    protected BufferedImage bi;
    protected JMenuItem big5Item;
    protected JMenuItem utf8Item;
    protected JToolBar connectionToolbar;
    protected JButton copyButton;
    protected JButton colorCopyButton;
    protected JButton pasteButton;
    protected JButton colorPasteButton;
    protected JMenuItem copyItem;
    protected JMenuItem pasteItem;
    protected JMenuItem colorCopyItem;
    protected JMenuItem colorPasteItem;
    protected JMenuItem[] favoriteItems;
    protected JButton openButton;
    protected JButton closeButton;
    protected JButton reopenButton;
    protected JMenuItem openItem;
    protected JMenuItem closeItem;
    protected JMenuItem reopenItem;
    protected JMenuItem popupCopyItem;
    protected JMenuItem popupPasteItem;
    protected JMenuItem popupColorCopyItem;
    protected JMenuItem popupColorPasteItem;
    protected JMenuItem popupCopyLinkItem;
    protected JPopupMenu popupMenu;
    protected JMenuItem preferenceItem;
    protected JMenuItem siteManagerItem;
    protected JMenuItem showToolbarItem;
    protected JComboBox siteField;
    protected DefaultComboBoxModel siteModel;
    protected JTextComponent siteText;
    protected JTabbedPane tabbedPane;
    protected JButton telnetButton;
    protected JButton sshButton;
    protected final ImageIcon tryingIcon;
    protected final ImageIcon connectedIcon;
    protected final ImageIcon closedIcon;
    protected final ImageIcon bellIcon;
    protected JMenuItem usageItem;
    protected JMenuItem faqItem;
    protected JMenuItem aboutItem;
    private final ActionHandler actionController;
    private final ChangeHandler changeController;
    private final ComponentHandler componentController;
    private JMenu connectMenu;
    private JMenu editMenu;
    private JMenu toolsMenu;
    private JMenu helpMenu;
    private JMenu encodingMenu;
    private JMenu languageMenu;
    private JMenu viewMenu;
    private JMenu historyMenu;
    protected JMenuItem[] languageItems;
    private final KeyHandler keyController;
    private final KeyEventHandler keyEventController;
    private JMenuBar menuBar;
    private final Model model;
    private final Resource resource;
    private final Sessions sessions = Sessions.getInstance();

    public ZTerm() {
        this.resource = Resource.getInstance();
        Locale.setDefault(this.resource.getLocale());
        this.updateLookAndFeel();
        this.tryingIcon = new ImageIcon(ZTerm.class.getResource(Messages.getString("ZTerm.Trying_Icon_File")));
        this.connectedIcon = new ImageIcon(ZTerm.class.getResource(Messages.getString("ZTerm.Connected_Icon_File")));
        this.closedIcon = new ImageIcon(ZTerm.class.getResource(Messages.getString("ZTerm.Closed_Icon_File")));
        this.bellIcon = new ImageIcon(ZTerm.class.getResource(Messages.getString("ZTerm.Bell_Icon_File")));
        this.actionController = new ActionHandler();
        this.changeController = new ChangeHandler();
        this.componentController = new ComponentHandler();
        this.keyEventController = new KeyEventHandler();
        this.keyController = new KeyHandler();
        this.model = Model.getInstance();
        this.model.setView(this);
        this.configMemberField();
        this.model.openNewTab();
        this.updateToolbar(false);
    }

    @Override
    public void init() {
        String value;
        this.model.w_user = value = this.getParameter("p1");
        this.model.w_password = value = this.getParameter("p2");
    }

    private void makeLanguageMenu() {
        int n = 2;
        this.languageItems = new JMenuItem[2];
        this.languageItems[0] = new JMenuItem(Messages.getString("ZTerm.Language_English_Item"));
        this.languageItems[0].setToolTipText(Messages.getString("ZTerm.Language_English_ToolTip"));
        this.languageItems[0].addActionListener(this.actionController);
        this.languageItems[1] = new JMenuItem(Messages.getString("ZTerm.Language_TraditionalChinese_Item"));
        this.languageItems[1].setToolTipText(Messages.getString("ZTerm.Language_TraditionalChinese_ToolTip"));
        this.languageItems[1].addActionListener(this.actionController);
        int i = 0;
        while (i < this.languageItems.length) {
            this.languageMenu.add(this.languageItems[i]);
            ++i;
        }
    }

    public void updateFavoriteMenu() {
        Vector<Site> favorites = this.resource.getFavorites();
        this.favoriteItems = new JMenuItem[favorites.size()];
        this.historyMenu.removeAll();
        int i = 0;
        while (i < favorites.size()) {
            Site fa = favorites.elementAt(i);
            this.favoriteItems[i] = new JMenuItem(fa.name);
            this.favoriteItems[i].setToolTipText(String.valueOf(fa.host) + ":" + fa.port);
            this.favoriteItems[i].addActionListener(this.actionController);
            this.historyMenu.add(this.favoriteItems[i]);
            ++i;
        }
    }

    public void updateLookAndFeel() {
        block6: {
            try {
                try {
                    if (this.resource.getBooleanValue("use-system-look-and-feel")) {
                        UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
                        break block6;
                    }
                    UIManager.setLookAndFeel(UIManager.getCrossPlatformLookAndFeelClassName());
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            finally {
                SwingUtilities.updateComponentTreeUI(this);
            }
        }
    }

    public void updateSize() {
        this.bi = new BufferedImage(this.getWidth(), this.getHeight(), 1);
        int i = 0;
        while (i < this.sessions.size()) {
            Session session = (Session)this.sessions.elementAt(i);
            session.validate();
            session.updateImage(this.bi);
            session.updateSize();
            ++i;
        }
    }

    public void updateTabState(int state, Session session) {
        ImageIcon imageIcon;
        switch (state) {
            case 1: {
                imageIcon = this.tryingIcon;
                break;
            }
            case 2: {
                imageIcon = this.connectedIcon;
                break;
            }
            case 3: {
                imageIcon = this.closedIcon;
                break;
            }
            case 4: {
                imageIcon = this.bellIcon;
                break;
            }
            default: {
                imageIcon = null;
            }
        }
        int index = this.tabbedPane.indexOfComponent(session);
        if (index != -1) {
            this.tabbedPane.setIconAt(index, imageIcon);
        }
    }

    public void updateToolbar(boolean isShowToolbar) {
        this.showToolbarItem.setText(isShowToolbar ? Messages.getString("ZTerm.ToggleToolbar_MenuItem_Hide_Text") : Messages.getString("ZTerm.ToggleToolbar_MenuItem_Show_Text"));
        this.connectionToolbar.setVisible(isShowToolbar);
        this.validate();
    }

    private void cacheFont() {
        String family = this.resource.getStringValue("font.family");
        Font font = new Font(family, 0, 0);
        this.getFontMetrics(font);
    }

    private void configMemberField() {
        this.resource.getBooleanValue("show-toolbar");
        this.getContentPane().setLayout(new BorderLayout());
        this.makeMenu();
        this.makePopupMenu();
        this.makeTabbedPane();
        this.makeToolbar();
        this.makeLanguageMenu();
        this.model.updateBounds();
        this.bi = new BufferedImage(this.getWidth(), this.getHeight(), 1);
        this.updateText();
        this.setVisible(true);
        this.actionController.setView(this);
        this.actionController.setModel(this.model);
        this.changeController.setView(this);
        this.changeController.setModel(this.model);
        this.keyController.setView(this);
        this.keyController.setModel(this.model);
        this.keyEventController.setView(this);
        this.keyEventController.setModel(this.model);
        this.componentController.setView(this);
        this.componentController.setModel(this.model);
        this.model.setView(this);
        this.addComponentListener(this.componentController);
        KeyboardFocusManager.getCurrentKeyboardFocusManager().addKeyEventDispatcher(this.keyEventController);
        this.cacheFont();
        this.model.autoconnect();
    }

    private void makeMenu() {
        this.menuBar = new JMenuBar();
        this.connectMenu = new JMenu();
        this.languageMenu = new JMenu();
        this.editMenu = new JMenu();
        this.viewMenu = new JMenu();
        this.historyMenu = new JMenu();
        this.toolsMenu = new JMenu();
        this.helpMenu = new JMenu();
        this.encodingMenu = new JMenu();
        this.openItem = new JMenuItem();
        this.closeItem = new JMenuItem();
        this.reopenItem = new JMenuItem();
        this.copyItem = new JMenuItem();
        this.pasteItem = new JMenuItem();
        this.colorCopyItem = new JMenuItem();
        this.colorPasteItem = new JMenuItem();
        this.preferenceItem = new JMenuItem();
        this.siteManagerItem = new JMenuItem();
        this.showToolbarItem = new JMenuItem();
        this.usageItem = new JMenuItem();
        this.faqItem = new JMenuItem();
        this.aboutItem = new JMenuItem();
        this.big5Item = new JMenuItem();
        this.utf8Item = new JMenuItem();
        this.connectMenu.setMnemonic(70);
        this.editMenu.setMnemonic(69);
        this.viewMenu.setMnemonic(86);
        this.historyMenu.setMnemonic(89);
        this.toolsMenu.setMnemonic(84);
        this.helpMenu.setMnemonic(72);
        this.openItem.addActionListener(this.actionController);
        this.closeItem.addActionListener(this.actionController);
        this.reopenItem.addActionListener(this.actionController);
        this.copyItem.addActionListener(this.actionController);
        this.pasteItem.addActionListener(this.actionController);
        this.colorCopyItem.addActionListener(this.actionController);
        this.colorPasteItem.addActionListener(this.actionController);
        this.preferenceItem.addActionListener(this.actionController);
        this.siteManagerItem.addActionListener(this.actionController);
        this.showToolbarItem.addActionListener(this.actionController);
        this.usageItem.addActionListener(this.actionController);
        this.faqItem.addActionListener(this.actionController);
        this.aboutItem.addActionListener(this.actionController);
        this.big5Item.addActionListener(this.actionController);
        this.utf8Item.addActionListener(this.actionController);
        this.menuBar.add(this.connectMenu);
        this.menuBar.add(this.editMenu);
        this.menuBar.add(this.viewMenu);
        this.menuBar.add(this.historyMenu);
        this.menuBar.add(this.toolsMenu);
        this.menuBar.add(this.helpMenu);
        this.connectMenu.add(this.openItem);
        this.connectMenu.add(this.reopenItem);
        this.connectMenu.add(this.closeItem);
        this.updateFavoriteMenu();
        this.encodingMenu.add(this.big5Item);
        this.encodingMenu.add(this.utf8Item);
        this.editMenu.add(this.copyItem);
        this.editMenu.add(this.pasteItem);
        this.editMenu.add(this.colorCopyItem);
        this.editMenu.add(this.colorPasteItem);
        this.viewMenu.add(this.showToolbarItem);
        this.viewMenu.add(this.encodingMenu);
        this.viewMenu.add(this.languageMenu);
        this.toolsMenu.add(this.preferenceItem);
        this.toolsMenu.add(this.siteManagerItem);
        this.helpMenu.add(this.usageItem);
        this.helpMenu.add(this.faqItem);
        this.helpMenu.add(this.aboutItem);
        this.setJMenuBar(this.menuBar);
    }

    private void makePopupMenu() {
        this.popupMenu = new JPopupMenu();
        this.popupCopyItem = new JMenuItem();
        this.popupPasteItem = new JMenuItem();
        this.popupColorCopyItem = new JMenuItem();
        this.popupColorPasteItem = new JMenuItem();
        this.popupCopyLinkItem = new JMenuItem();
        this.popupCopyItem.addActionListener(this.actionController);
        this.popupPasteItem.addActionListener(this.actionController);
        this.popupColorCopyItem.addActionListener(this.actionController);
        this.popupColorPasteItem.addActionListener(this.actionController);
        this.popupCopyLinkItem.addActionListener(this.actionController);
        this.popupCopyLinkItem.setEnabled(false);
        this.popupMenu.add(this.popupCopyItem);
        this.popupMenu.add(this.popupPasteItem);
        this.popupMenu.add(this.popupColorCopyItem);
        this.popupMenu.add(this.popupColorPasteItem);
        this.popupMenu.add(this.popupCopyLinkItem);
    }

    private void makeTabbedPane() {
        this.tabbedPane = new JTabbedPane(1, 1);
        this.tabbedPane.addChangeListener(this.changeController);
        this.getContentPane().add(this.tabbedPane);
    }

    private void makeToolbar() {
        boolean isShowToolbar = this.resource.getBooleanValue("show-toolbar");
        this.connectionToolbar = new JToolBar();
        this.connectionToolbar.setVisible(isShowToolbar);
        this.connectionToolbar.setRollover(true);
        this.closeButton = new JButton();
        this.closeButton.setFocusable(false);
        this.closeButton.addActionListener(this.actionController);
        this.reopenButton = new JButton();
        this.reopenButton.setFocusable(false);
        this.reopenButton.addActionListener(this.actionController);
        this.copyButton = new JButton();
        this.copyButton.setFocusable(false);
        this.copyButton.addActionListener(this.actionController);
        this.pasteButton = new JButton();
        this.pasteButton.setFocusable(false);
        this.pasteButton.addActionListener(this.actionController);
        this.colorCopyButton = new JButton();
        this.colorCopyButton.setFocusable(false);
        this.colorCopyButton.addActionListener(this.actionController);
        this.colorPasteButton = new JButton();
        this.colorPasteButton.setFocusable(false);
        this.colorPasteButton.addActionListener(this.actionController);
        this.telnetButton = new JButton();
        this.telnetButton.setFocusable(false);
        this.telnetButton.addActionListener(this.actionController);
        this.sshButton = new JButton();
        this.sshButton.setFocusable(false);
        this.sshButton.addActionListener(this.actionController);
        this.siteModel = new DefaultComboBoxModel();
        this.siteField = new JComboBox(this.siteModel);
        this.siteField.setEditable(true);
        this.siteText = (JTextComponent)this.siteField.getEditor().getEditorComponent();
        this.siteText.setText("ssh://hadoop.nchc.org.tw");
        this.siteText.addKeyListener(this.keyController);
        this.openButton = new JButton();
        this.openButton.setFocusable(false);
        this.openButton.addActionListener(this.actionController);
        this.connectionToolbar.add(this.closeButton);
        this.connectionToolbar.add(this.reopenButton);
        this.connectionToolbar.add(new JToolBar.Separator());
        this.connectionToolbar.add(this.copyButton);
        this.connectionToolbar.add(this.pasteButton);
        this.connectionToolbar.add(this.colorCopyButton);
        this.connectionToolbar.add(this.colorPasteButton);
        this.connectionToolbar.add(new JToolBar.Separator());
        this.connectionToolbar.add(this.telnetButton);
        this.connectionToolbar.add(this.sshButton);
        this.connectionToolbar.add(new JToolBar.Separator());
        this.connectionToolbar.add(this.siteField);
        this.connectionToolbar.add(new JToolBar.Separator());
        this.connectionToolbar.add(this.openButton);
        this.getContentPane().add((Component)this.connectionToolbar, "North");
    }

    public void updateText() {
        boolean isShowToolbar = this.resource.getBooleanValue("show-toolbar");
        this.connectMenu.setText(Messages.getString("ZTerm.Connect_Menu_Text"));
        this.connectMenu.setToolTipText(Messages.getString("ZTerm.Connect_Menu_ToolTip"));
        this.languageMenu.setText("Language");
        this.languageMenu.setToolTipText("Change your language");
        this.historyMenu.setText(Messages.getString("ZTerm.Site_Menu_Text"));
        this.viewMenu.setText(Messages.getString("ZTerm.View_Menu_Text"));
        this.viewMenu.setToolTipText(Messages.getString("ZTerm.View_Menu_ToolTip"));
        this.historyMenu.setText(Messages.getString("ZTerm.History_Menu_Text"));
        this.historyMenu.setToolTipText(Messages.getString("ZTerm.History_Menu_ToolTip"));
        this.editMenu.setText(Messages.getString("ZTerm.Edit_Menu_Text"));
        this.editMenu.setToolTipText(Messages.getString("ZTerm.Edit_Menu_ToolTip"));
        this.toolsMenu.setText(Messages.getString("ZTerm.Option_Menu_Text"));
        this.toolsMenu.setToolTipText(Messages.getString("ZTerm.Option_Menu_ToolTip"));
        this.helpMenu.setText(Messages.getString("ZTerm.Help_Menu_Text"));
        this.helpMenu.setToolTipText(Messages.getString("ZTerm.Help_Menu_ToolTip"));
        this.encodingMenu.setText(Messages.getString("ZTerm.Encoding_Menu_Text"));
        this.openItem.setText(Messages.getString("ZTerm.Open_MenuItem_Text"));
        this.openItem.setToolTipText(Messages.getString("ZTerm.Open_MenuItem_ToolTip"));
        this.closeItem.setText(Messages.getString("ZTerm.Close_MenuItem_Text"));
        this.closeItem.setToolTipText(Messages.getString("ZTerm.Close_MenuItem_ToolTip"));
        this.reopenItem.setText(Messages.getString("ZTerm.Reopen_Item_Text"));
        this.reopenItem.setToolTipText(Messages.getString("ZTerm.Reopen_Item_ToolTip"));
        this.copyItem.setText(Messages.getString("ZTerm.Copy_MenuItem_Text"));
        this.copyItem.setToolTipText(Messages.getString("ZTerm.Copy_MenuItem_ToolTip"));
        this.pasteItem.setText(Messages.getString("ZTerm.Paste_MenuItem_Text"));
        this.pasteItem.setToolTipText(Messages.getString("ZTerm.Paste_MenuItem_ToolTip"));
        this.colorCopyItem.setText(Messages.getString("ZTerm.ColorCopy_MenuItem_Text"));
        this.colorCopyItem.setToolTipText(Messages.getString("ZTerm.ColorCopy_MenuItem__ToolTip"));
        this.colorPasteItem.setText(Messages.getString("ZTerm.ColorPaste_MenuItem_Text"));
        this.colorPasteItem.setToolTipText(Messages.getString("ZTerm.ColorPaste_MenuItem__ToolTip"));
        this.preferenceItem.setText(Messages.getString("ZTerm.Preference_MenuItem_Text"));
        this.preferenceItem.setToolTipText(Messages.getString("ZTerm.Preference_MenuItem_ToolTip"));
        this.siteManagerItem.setText(Messages.getString("ZTerm.SiteManager_MenuItem_Text"));
        this.siteManagerItem.setToolTipText(Messages.getString("ZTerm.SiteManager_MenuItem_ToolTip"));
        this.showToolbarItem.setText(isShowToolbar ? Messages.getString("ZTerm.ToggleToolbar_MenuItem_Hide_Text") : Messages.getString("ZTerm.ToggleToolbar_MenuItem_Show_Text"));
        this.usageItem.setText(Messages.getString("ZTerm.Usage_MenuItem_Text"));
        this.faqItem.setText(Messages.getString("ZTerm.FAQ_MenuItem_Text"));
        this.aboutItem.setText(Messages.getString("ZTerm.About_MenuItem_Text"));
        this.big5Item.setText(Messages.getString("ZTerm.Big5_MenuItem_Text"));
        this.utf8Item.setText(Messages.getString("ZTerm.UTF8_MenuItem_Text"));
        this.popupCopyLinkItem.setText(Messages.getString("ZTerm.Popup_CopyLink_MenuItem_Text"));
        this.popupCopyItem.setText(Messages.getString("ZTerm.Copy_MenuItem_Text"));
        this.popupCopyItem.setToolTipText(Messages.getString("ZTerm.Copy_MenuItem_ToolTip"));
        this.popupPasteItem.setText(Messages.getString("ZTerm.Paste_MenuItem_Text"));
        this.popupPasteItem.setToolTipText(Messages.getString("ZTerm.Paste_MenuItem_ToolTip"));
        this.popupColorCopyItem.setText(Messages.getString("ZTerm.ColorCopy_MenuItem_Text"));
        this.popupColorCopyItem.setToolTipText(Messages.getString("ZTerm.ColorCopy_MenuItem__ToolTip"));
        this.popupColorPasteItem.setText(Messages.getString("ZTerm.ColorPaste_MenuItem_Text"));
        this.popupColorPasteItem.setToolTipText(Messages.getString("ZTerm.ColorPaste_MenuItem__ToolTip"));
        this.closeButton.setText(Messages.getString("ZTerm.Close_Button_Text"));
        this.closeButton.setToolTipText(Messages.getString("ZTerm.Close_Button_ToolTip"));
        this.reopenButton.setText(Messages.getString("ZTerm.Reopen_Button_Text"));
        this.reopenButton.setToolTipText(Messages.getString("ZTerm.Reopen_Button_ToolTip"));
        this.copyButton.setText(Messages.getString("ZTerm.Copy_Button_Text"));
        this.copyButton.setToolTipText(Messages.getString("ZTerm.Copy_Button_ToolTip"));
        this.pasteButton.setText(Messages.getString("ZTerm.Paste_Button_Text"));
        this.pasteButton.setToolTipText(Messages.getString("ZTerm.Paste_Button_ToolTip"));
        this.colorCopyButton.setText(Messages.getString("ZTerm.ColorCopy_Button_Text"));
        this.colorPasteButton.setText(Messages.getString("ZTerm.ColorPaste_Button_Text"));
        this.telnetButton.setText(Messages.getString("ZTerm.Telnet_Button_Text"));
        this.telnetButton.setToolTipText(Messages.getString("ZTerm.Telnet_Button_ToolTip"));
        this.sshButton.setText(Messages.getString("ZTerm.SSH_Button_Text"));
        this.sshButton.setToolTipText(Messages.getString("ZTerm.SSH_Button_ToolTip"));
        this.siteField.setToolTipText(Messages.getString("ZTerm.Site_ComboBox_ToolTip"));
        this.openButton.setText(Messages.getString("ZTerm.Open_Button_Text"));
    }
}

