/*
 * Decompiled with CFR 0.152.
 */
package org.zhouer.zterm;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.Iterator;
import java.util.Vector;
import javax.swing.ButtonGroup;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextField;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.zhouer.zterm.Messages;
import org.zhouer.zterm.Model;
import org.zhouer.zterm.Resource;
import org.zhouer.zterm.Site;

public class SiteManager
extends JOptionPane {
    private static final long serialVersionUID = 3644901803388220764L;
    private final Vector<Site> favorites;
    private final JSplitPane jsp;
    private final ParameterPanel parameterPanel;
    private final Resource resource = Resource.getInstance();
    private final SitePanel sitePanel;

    public SiteManager() {
        this.favorites = this.resource.getFavorites();
        this.parameterPanel = new ParameterPanel(this);
        this.sitePanel = new SitePanel(this, this.favorites);
        this.jsp = new JSplitPane(1, this.sitePanel, this.parameterPanel);
        JPanel panel = new JPanel(new GridLayout(1, 1));
        panel.add(this.jsp);
        this.setMessage(panel);
        this.jsp.setDividerLocation(160);
        this.setOptionType(2);
        this.init();
    }

    private void init() {
        if (this.sitePanel.siteListModel.getSize() == 0) {
            this.sitePanel.siteListModel.addElement("NCHC_Hadoop");
            this.sitePanel.favorites.add(new Site("NCHC_Hadoop", "hadoop.nchc.org.tw", 22, "ssh"));
            this.sitePanel.siteList.setSelectedIndex(this.sitePanel.siteListModel.getSize() - 1);
        }
    }

    public void updateFavorite(Site site) {
        this.sitePanel.updateFavorite(site);
    }

    public void updateParameter(Site site) {
        this.parameterPanel.updateParameter(site);
    }

    protected void submit() {
        Site s = new Site();
        s.name = this.parameterPanel.nameField.getText();
        s.host = this.parameterPanel.hostField.getText();
        s.port = Integer.parseInt(this.parameterPanel.portField.getText());
        s.alias = this.parameterPanel.aliasField.getText();
        if (this.parameterPanel.telnetButton.isSelected()) {
            s.protocol = "telnet";
        } else if (this.parameterPanel.sshButton.isSelected()) {
            s.protocol = "ssh";
        }
        s.encoding = this.parameterPanel.encodingCombo.getSelectedItem().toString();
        s.emulation = this.parameterPanel.emulationCombo.getSelectedItem().toString();
        s.autoconnect = this.parameterPanel.autoConnectCheckBox.isSelected();
        this.updateFavorite(s);
        this.resource.setFavorites(this.favorites);
        this.resource.writeFile();
        Model.getInstance().updateFavoriteMenu();
    }

    private class ParameterPanel
    extends JPanel
    implements ActionListener,
    KeyListener {
        private static final long serialVersionUID = -3479511727147739169L;
        private final JLabel autoConnectLabel;
        private final String[] emulationList = new String[]{"vt100", "xterm", "xterm-color", "ansi"};
        private final JLabel encodingLabel;
        private final JLabel emulationLabel;
        private final String[] encodingList = new String[]{"Big5", "UTF-8"};
        private final JLabel nameLabel;
        private final JLabel hostLabel;
        private final JLabel portLabel;
        private final JLabel protocolLabel;
        private final JLabel aliasLabel;
        private final SiteManager parent;
        private final ButtonGroup protocolGroup;
        final JCheckBox autoConnectCheckBox;
        final JComboBox emulationCombo;
        final JComboBox encodingCombo;
        final JTextField hostField;
        final JTextField portField;
        final JTextField aliasField;
        final JTextField nameField;
        final JRadioButton sshButton;
        JRadioButton telnetButton;

        public ParameterPanel(SiteManager p) {
            this.parent = p;
            this.setLayout(new GridBagLayout());
            GridBagConstraints c = new GridBagConstraints();
            this.nameLabel = new JLabel(Messages.getString("SiteManager.Name"));
            this.hostLabel = new JLabel(Messages.getString("SiteManager.Host"));
            this.portLabel = new JLabel(Messages.getString("SiteManager.Port"));
            this.aliasLabel = new JLabel(Messages.getString("SiteManager.Alias"));
            this.protocolLabel = new JLabel(Messages.getString("SiteManager.Protocal"));
            this.encodingLabel = new JLabel(Messages.getString("SiteManager.Encoding"));
            this.emulationLabel = new JLabel(Messages.getString("SiteManager.Emulation"));
            this.autoConnectLabel = new JLabel(Messages.getString("SiteManager.AutoConnect"));
            this.nameField = new JTextField(15);
            this.nameField.addKeyListener(this);
            this.hostField = new JTextField(15);
            this.hostField.addKeyListener(this);
            this.portField = new JTextField(15);
            this.portField.addKeyListener(this);
            this.aliasField = new JTextField(15);
            this.aliasField.addKeyListener(this);
            this.telnetButton = new JRadioButton(Messages.getString("SiteManager.TelnetButtonText"));
            this.telnetButton.addActionListener(this);
            this.sshButton = new JRadioButton(Messages.getString("SiteManager.SSHButtonText"));
            this.sshButton.addActionListener(this);
            this.protocolGroup = new ButtonGroup();
            this.protocolGroup.add(this.telnetButton);
            this.protocolGroup.add(this.sshButton);
            this.encodingCombo = new JComboBox<String>(this.encodingList);
            this.encodingCombo.addActionListener(this);
            this.emulationCombo = new JComboBox<String>(this.emulationList);
            this.emulationCombo.addActionListener(this);
            this.autoConnectCheckBox = new JCheckBox();
            this.autoConnectCheckBox.addActionListener(this);
            c.ipady = 3;
            c.ipadx = 3;
            c.gridx = 0;
            c.gridy = 0;
            c.gridwidth = 1;
            this.add((Component)this.nameLabel, c);
            c.gridx = 1;
            c.gridwidth = 2;
            this.add((Component)this.nameField, c);
            c.gridx = 0;
            c.gridy = 1;
            c.gridwidth = 1;
            this.add((Component)this.hostLabel, c);
            c.gridx = 1;
            c.gridwidth = 2;
            this.add((Component)this.hostField, c);
            c.gridx = 0;
            c.gridy = 2;
            c.gridwidth = 1;
            this.add((Component)this.portLabel, c);
            c.gridx = 1;
            c.gridwidth = 2;
            this.add((Component)this.portField, c);
            c.gridx = 0;
            c.gridy = 3;
            c.gridwidth = 1;
            this.add((Component)this.aliasLabel, c);
            c.gridx = 1;
            c.gridwidth = 2;
            this.add((Component)this.aliasField, c);
            c.gridx = 0;
            c.gridy = 4;
            c.gridwidth = 1;
            this.add((Component)this.protocolLabel, c);
            c.gridx = 1;
            this.add((Component)this.telnetButton, c);
            c.gridx = 2;
            this.add((Component)this.sshButton, c);
            c.gridx = 0;
            c.gridy = 5;
            c.gridwidth = 1;
            this.add((Component)this.encodingLabel, c);
            c.gridx = 1;
            this.add((Component)this.encodingCombo, c);
            c.gridx = 0;
            c.gridy = 6;
            c.gridwidth = 1;
            this.add((Component)this.emulationLabel, c);
            c.gridx = 1;
            this.add((Component)this.emulationCombo, c);
            c.gridx = 0;
            c.gridy = 7;
            c.gridwidth = 1;
            this.add((Component)this.autoConnectLabel, c);
            c.gridx = 1;
            this.add((Component)this.autoConnectCheckBox, c);
            c.gridx = 0;
            c.gridy = 9;
            c.gridx = 1;
        }

        @Override
        public void keyReleased(KeyEvent e) {
            this.update();
        }

        @Override
        public void actionPerformed(ActionEvent ae) {
            if (ae.getSource() == this.telnetButton) {
                this.portField.setText(Integer.toString(23));
            } else if (ae.getSource() == this.sshButton) {
                this.portField.setText(Integer.toString(22));
            }
        }

        private void update() {
            Site s = new Site();
            s.name = this.nameField.getText();
            s.host = this.hostField.getText();
            s.port = Integer.parseInt(this.portField.getText());
            s.alias = this.aliasField.getText();
            if (this.telnetButton.isSelected()) {
                s.protocol = "telnet";
            } else if (this.sshButton.isSelected()) {
                s.protocol = "ssh";
            }
            s.encoding = this.encodingCombo.getSelectedItem().toString();
            s.emulation = this.emulationCombo.getSelectedItem().toString();
            s.autoconnect = this.autoConnectCheckBox.isSelected();
            this.parent.updateFavorite(s);
        }

        public void updateParameter(Site s) {
            this.nameField.setText(s.name);
            this.hostField.setText(s.host);
            this.portField.setText(Integer.toString(s.port));
            this.aliasField.setText(s.alias);
            if (s.protocol.equalsIgnoreCase("telnet")) {
                this.telnetButton.setSelected(true);
            } else if (s.protocol.equalsIgnoreCase("ssh")) {
                this.sshButton.setSelected(true);
            }
            this.encodingCombo.setSelectedItem(s.encoding);
            this.emulationCombo.setSelectedItem(s.emulation);
            this.autoConnectCheckBox.setSelected(s.autoconnect);
        }

        @Override
        public void keyPressed(KeyEvent e) {
        }

        @Override
        public void keyTyped(KeyEvent e) {
        }
    }

    private class SitePanel
    extends JPanel
    implements ActionListener,
    ListSelectionListener {
        private static final long serialVersionUID = 6399807179665067907L;
        private JButton addButton;
        private JButton removeButton;
        private JButton upButton;
        private JButton downButton;
        private final Vector<Site> favorites;
        private JPanel modifyPanel;
        private final SiteManager parent;
        private JList siteList;
        private DefaultListModel siteListModel;

        public SitePanel(SiteManager siteManager2, Vector<Site> favorite) {
            this.parent = siteManager2;
            this.favorites = favorite;
            this.makeList();
            this.makeModify();
            this.setLayout(new BorderLayout());
            this.add((Component)new JScrollPane(this.siteList), "Center");
            this.add((Component)this.modifyPanel, "South");
        }

        @Override
        public void actionPerformed(ActionEvent ae) {
            int i;
            if (ae.getSource() == this.addButton) {
                this.siteListModel.addElement("NCHC_Hadoop");
                this.favorites.add(new Site("NCHC_Hadoop", "hadoop.nchc.org.tw", 22, "ssh"));
                this.siteList.setSelectedIndex(this.siteListModel.getSize() - 1);
            } else if (ae.getSource() == this.removeButton) {
                int i2 = this.siteList.getSelectedIndex();
                if (i2 != -1) {
                    this.siteListModel.removeElementAt(i2);
                    this.favorites.removeElementAt(i2);
                    this.siteList.setSelectedIndex(i2 - 1);
                }
            } else if (ae.getSource() == this.upButton) {
                int i3 = this.siteList.getSelectedIndex();
                if (i3 > 0) {
                    Site tmp = this.favorites.elementAt(i3);
                    this.favorites.removeElementAt(i3);
                    this.favorites.insertElementAt(tmp, i3 - 1);
                    Object tmp2 = this.siteListModel.elementAt(i3);
                    this.siteListModel.removeElementAt(i3);
                    this.siteListModel.insertElementAt(tmp2, i3 - 1);
                    this.siteList.setSelectedIndex(i3 - 1);
                }
            } else if (ae.getSource() == this.downButton && (i = this.siteList.getSelectedIndex()) < this.siteListModel.size() - 1) {
                Site tmp = this.favorites.elementAt(i);
                this.favorites.removeElementAt(i);
                this.favorites.insertElementAt(tmp, i + 1);
                Object tmp2 = this.siteListModel.elementAt(i);
                this.siteListModel.removeElementAt(i);
                this.siteListModel.insertElementAt(tmp2, i + 1);
                this.siteList.setSelectedIndex(i + 1);
            }
        }

        public void updateFavorite(Site f) {
            int index = this.siteList.getSelectedIndex();
            if (index != -1) {
                this.siteListModel.setElementAt(f.name, index);
                this.favorites.setElementAt(f, index);
            }
        }

        @Override
        public void valueChanged(ListSelectionEvent lse) {
            int index = this.siteList.getSelectedIndex();
            if (index != -1) {
                this.parent.updateParameter(this.favorites.elementAt(index));
            }
        }

        private void makeList() {
            Iterator<Site> iter = this.favorites.iterator();
            this.siteListModel = new DefaultListModel();
            while (iter.hasNext()) {
                this.siteListModel.addElement(iter.next().name);
            }
            this.siteList = new JList(this.siteListModel);
            this.siteList.setSelectionMode(0);
            this.siteList.addListSelectionListener(this);
            this.siteList.setSelectedIndex(0);
        }

        private void makeModify() {
            this.modifyPanel = new JPanel();
            this.modifyPanel.setLayout(new GridLayout(0, 2, 3, 3));
            this.addButton = new JButton(Messages.getString("SiteManager.AddButtonText"));
            this.addButton.addActionListener(this);
            this.removeButton = new JButton(Messages.getString("SiteManager.RemoveButtonText"));
            this.removeButton.addActionListener(this);
            this.upButton = new JButton(Messages.getString("SiteManager.UpButtonText"));
            this.upButton.addActionListener(this);
            this.downButton = new JButton(Messages.getString("SiteManager.DownButtonText"));
            this.downButton.addActionListener(this);
            this.modifyPanel.add(this.addButton);
            this.modifyPanel.add(this.removeButton);
            this.modifyPanel.add(this.upButton);
            this.modifyPanel.add(this.downButton);
        }
    }
}

