/*
 * Decompiled with CFR 0.152.
 */
package org.zhouer.utils;

import java.io.IOException;
import java.io.InputStream;

public class Convertor {
    private final byte[] big5bytes;
    private final byte[] ucs2bytes = new byte[65536];
    private final char[] ucs2chars;

    public static boolean isValidBig5(byte[] b, int offset, int limit) {
        if (b[offset] >= 0) {
            return limit == 1;
        }
        return limit == 2;
    }

    public static boolean isValidUTF8(byte[] b, int offset, int limit) {
        if (b[offset] >= 0) {
            return limit == 1;
        }
        if (b[offset] >= -64 && b[offset] <= -33) {
            return limit == 2;
        }
        if (b[offset] >= -32 && b[offset] <= -17) {
            return limit == 3;
        }
        if (b[offset] >= -16 && b[offset] <= -9) {
            return limit == 4;
        }
        return true;
    }

    public static boolean isWideChar(char c) {
        return c > '\u007f';
    }

    public static boolean containsWideChar(String message) {
        int i = 0;
        while (i < message.length()) {
            char c = message.charAt(i);
            if (Convertor.isWideChar(c)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static int readFile(String name, byte[] b) {
        int size = 0;
        InputStream is = Convertor.class.getResourceAsStream(name);
        try {
            int len;
            while ((len = is.read(b, size, b.length - size)) != -1) {
                size += len;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return size;
    }

    public Convertor() {
        this.big5bytes = new byte[131072];
        Convertor.readFile("conv/ucs2.txt", this.ucs2bytes);
        Convertor.readFile("conv/big5.txt", this.big5bytes);
        this.ucs2chars = new char[this.ucs2bytes.length / 2];
        int i = 0;
        while (i < this.ucs2bytes.length) {
            int i1 = (this.ucs2bytes[i] < 0 ? 256 : 0) + this.ucs2bytes[i];
            int i2 = (this.ucs2bytes[i + 1] < 0 ? 256 : 0) + this.ucs2bytes[i + 1];
            this.ucs2chars[i / 2] = (char)(i1 << 8 | i2);
            i += 2;
        }
    }

    public char big5BytesToChar(byte[] buf, int offset, int limit) {
        int i2;
        if (limit == 1) {
            return (char)buf[offset];
        }
        int i1 = (buf[offset] < 0 ? 256 : 0) + buf[offset];
        int shift = (i1 << 8 | (i2 = (buf[offset + 1] < 0 ? 256 : 0) + buf[offset + 1])) - 33088;
        if (shift < 0 || shift * 2 + 1 >= this.ucs2bytes.length) {
            return '?';
        }
        i1 = (this.ucs2bytes[shift * 2] < 0 ? 256 : 0) + this.ucs2bytes[shift * 2];
        i2 = (this.ucs2bytes[shift * 2 + 1] < 0 ? 256 : 0) + this.ucs2bytes[shift * 2 + 1];
        return (char)(i1 << 8 | i2);
    }

    public String big5BytesToString(byte[] buf, int offset, int limit) {
        StringBuffer sb = new StringBuffer();
        int i = 0;
        while (i < limit) {
            if (i + 1 < limit && buf[offset + i] < 0) {
                sb.append(this.big5BytesToChar(buf, offset + i, 2));
                ++i;
            } else {
                sb.append((char)buf[offset + i]);
            }
            ++i;
        }
        return new String(sb);
    }

    public char bytesToChar(byte[] b, int from, int limit, String encoding) {
        if (encoding.equalsIgnoreCase("Big5")) {
            return this.big5BytesToChar(b, from, limit);
        }
        if (encoding.equalsIgnoreCase("UTF-8")) {
            return this.utf8BytesToChar(b, from, limit);
        }
        System.out.println("Unknown Encoding: " + encoding);
        return '\u0000';
    }

    public byte[] charToBig5Bytes(char c) {
        if (c < '\u0080') {
            byte[] b = new byte[]{(byte)c};
            return b;
        }
        byte[] b = new byte[]{this.big5bytes[(c - 128) * 2], this.big5bytes[(c - 128) * 2 + 1]};
        return b;
    }

    public byte[] charToBytes(char c, String encoding) {
        if (encoding.equalsIgnoreCase("Big5")) {
            return this.charToBig5Bytes(c);
        }
        if (encoding.equalsIgnoreCase("UTF-8")) {
            return this.charToUTF8Bytes(c);
        }
        System.out.println("Unknown Encoding: " + encoding);
        return null;
    }

    public byte[] charToUTF8Bytes(char c) {
        byte[] b;
        if (c >= '\u0000' && c <= '\u007f') {
            b = new byte[]{(byte)c};
        } else if (c >= '\u0080' && c <= '\u07ff') {
            b = new byte[]{(byte)(0xC0 | c >> 6), (byte)(0x80 | c & 0x3F)};
        } else if (c >= '\u0800' && c <= '\uffff') {
            b = new byte[]{(byte)(0xE0 | c >> 12), (byte)(0x80 | c >> 6 & 0x3F), (byte)(0x80 | c & 0x3F)};
        } else if (c >= '\u10000' && c <= '\u10ffff') {
            b = new byte[]{(byte)(0xF0 | c >> 18), (byte)(0x80 | c >> 12 & 0x3F), (byte)(0x80 | c >> 6 & 0x3F), (byte)(0x80 | c & 0x3F)};
        } else {
            System.out.println("Error converting char to UTF-8 bytes.");
            b = null;
        }
        return b;
    }

    public boolean isValidMultiBytes(byte[] b, int from, int limit, String encoding) {
        if (encoding.equalsIgnoreCase("Big5")) {
            return Convertor.isValidBig5(b, from, limit);
        }
        if (encoding.equalsIgnoreCase("UTF-8")) {
            return Convertor.isValidUTF8(b, from, limit);
        }
        System.out.println("Unknown Encoding: " + encoding);
        return true;
    }

    public byte[] StringToBig5Bytes(String str) {
        int count = 0;
        byte[] tmp = new byte[str.length() * 2];
        int i = 0;
        while (i < str.length()) {
            byte[] buf = this.charToBig5Bytes(str.charAt(i));
            int j = 0;
            while (j < buf.length) {
                tmp[count++] = buf[j];
                ++j;
            }
            ++i;
        }
        byte[] result = new byte[count];
        i = 0;
        while (i < count) {
            result[i] = tmp[i];
            ++i;
        }
        return result;
    }

    public char utf8BytesToChar(byte[] buf, int offset, int limit) {
        char c;
        if (limit == 1) {
            c = (char)buf[0];
        } else if (limit == 2) {
            c = (char)(buf[0] & 0x1F);
            c = (char)(c << 6);
            c = (char)(c | (char)(buf[1] & 0x3F));
        } else if (limit == 3) {
            c = (char)(buf[0] & 0xF);
            c = (char)(c << 6);
            c = (char)(c | (char)(buf[1] & 0x3F));
            c = (char)(c << 6);
            c = (char)(c | (char)(buf[2] & 0x3F));
        } else {
            c = (char)(buf[0] & 7);
            c = (char)(c << 6);
            c = (char)(c | (char)(buf[1] & 0x3F));
            c = (char)(c << 6);
            c = (char)(c | (char)(buf[2] & 0x3F));
            c = (char)(c << 6);
            c = (char)(c | (char)(buf[3] & 0x3F));
        }
        return c;
    }
}

