/*
 * Decompiled with CFR 0.152.
 */
package org.zhouer.protocol;

import ch.ethz.ssh2.Connection;
import ch.ethz.ssh2.Session;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.zhouer.protocol.Auth;
import org.zhouer.protocol.Protocol;
import org.zhouer.protocol.SSH2InputStream;
import org.zhouer.protocol.SSH2OutputStream;

public class SSH2
implements Protocol {
    private boolean authenticated;
    private Connection conn;
    private boolean connected;
    private boolean closed;
    private final String host;
    private InputStream is;
    private OutputStream os;
    private final int port;
    private Session sess;
    private String terminalType;

    public SSH2(String h, int p) {
        this.host = h;
        this.port = p;
        this.connected = false;
        this.authenticated = false;
        this.closed = false;
    }

    @Override
    public boolean connect() {
        block13: {
            String username;
            block12: {
                try {
                    this.conn = new Connection(this.host, this.port);
                    this.conn.connect(null, 5000, 60000);
                    this.conn.setTCPNoDelay(true);
                    this.connected = true;
                    username = Auth.getUsername();
                    if (username != null) break block12;
                    this.disconnect();
                    return false;
                }
                catch (IOException e) {
                    System.out.println("Caught IOException in SSH2::connect()");
                    this.connected = false;
                    this.disconnect();
                    return false;
                }
            }
            String[] methods = this.conn.getRemainingAuthMethods(username);
            if (methods.length != 0) {
                if (this.conn.isAuthMethodAvailable(username, "password")) {
                    String password = Auth.getPassword();
                    if (password != null) {
                        this.authenticated = this.conn.authenticateWithPassword(username, password);
                    }
                } else if (this.conn.isAuthMethodAvailable(username, "keyboard-interactive")) {
                    this.authenticated = this.conn.authenticateWithKeyboardInteractive(username, new Auth());
                } else if (this.conn.isAuthMethodAvailable(username, "publickey")) {
                    System.out.println("SSH2 publickey(not yet support)");
                } else {
                    System.out.println("unknown SSH2 authentication method.");
                }
            }
            if (this.authenticated) break block13;
            this.disconnect();
            return false;
        }
        this.sess = this.conn.openSession();
        this.sess.requestPTY(this.terminalType, 80, 24, 0, 0, null);
        this.sess.startShell();
        this.is = this.sess.getStdout();
        this.os = this.sess.getStdin();
        return true;
    }

    @Override
    public void disconnect() {
        if (this.authenticated) {
            try {
                this.is.close();
                this.os.close();
                this.sess.close();
            }
            catch (IOException e) {
                System.out.println("Caught IOException in SSH2::disconnect()");
            }
        }
        this.conn.close();
        this.closed = true;
    }

    @Override
    public InputStream getInputStream() {
        return new SSH2InputStream(this);
    }

    @Override
    public OutputStream getOutputStream() {
        return new SSH2OutputStream(this);
    }

    @Override
    public String getTerminalType() {
        return this.terminalType;
    }

    @Override
    public boolean isClosed() {
        return this.closed;
    }

    @Override
    public boolean isConnected() {
        return this.connected;
    }

    public int readByte() throws IOException {
        int r = this.is.read();
        if (r == -1) {
            throw new IOException();
        }
        return r;
    }

    public int readBytes(byte[] b) throws IOException {
        int r = this.is.read(b);
        if (r == -1) {
            throw new IOException();
        }
        return r;
    }

    public int readBytes(byte[] b, int offset, int length) throws IOException {
        int r = this.is.read(b, offset, length);
        if (r == -1) {
            throw new IOException();
        }
        return r;
    }

    @Override
    public void setTerminalType(String tt) {
        this.terminalType = tt;
    }

    public void writeByte(byte b) throws IOException {
        this.os.write(b);
        this.os.flush();
    }

    public void writeBytes(byte[] buf) throws IOException {
        this.os.write(buf);
        this.os.flush();
    }

    public void writeBytes(byte[] buf, int offset, int size) throws IOException {
        this.os.write(buf, offset, size);
        this.os.flush();
    }
}

