/*
 * Decompiled with CFR 0.152.
 */
package org.zhouer.zterm;

import java.util.Date;
import java.util.HashMap;
import java.util.Vector;
import org.zhouer.utils.CSV;
import org.zhouer.utils.TextUtils;

public class Site
implements Comparable<Site> {
    protected String alias;
    protected boolean autoconnect;
    protected boolean autologin;
    protected final String defEmulation = "vt100";
    protected final String defEncoding = "UTF-8";
    protected final String defProtocol = "telnet";
    protected String emulation;
    protected String encoding;
    protected String host;
    protected long lastvisit;
    protected String name;
    protected int port;
    protected String prelogin;
    protected String postlogin;
    protected String protocol;
    protected int total;
    protected String usernameprompt;
    protected String username;
    protected String userpassprompt;
    protected String userpass;

    public Site() {
    }

    public Site(String h) {
        HashMap<String, String> m = TextUtils.getCsvParameters(h);
        this.name = (String)m.get("name");
        this.host = (String)m.get("host");
        this.port = Integer.parseInt((String)m.get("port"));
        this.protocol = m.containsKey("protocol") ? (String)m.get("protocol") : "telnet";
        this.alias = m.containsKey("alias") ? (String)m.get("alias") : "";
        this.encoding = m.containsKey("encoding") ? (String)m.get("encoding") : "UTF-8";
        this.emulation = m.containsKey("emulation") ? (String)m.get("emulation") : "vt100";
        this.lastvisit = m.containsKey("lastvisit") ? Long.parseLong((String)m.get("lastvisit")) : 0L;
        this.total = m.containsKey("total") ? Integer.parseInt((String)m.get("total")) : 0;
        this.autoconnect = m.containsKey("autoconnect") ? ((String)m.get("autoconnect")).equalsIgnoreCase("true") : false;
        this.autologin = m.containsKey("autologin") ? ((String)m.get("autologin")).equalsIgnoreCase("true") : false;
    }

    public Site(String n, String h, int po, String pr) {
        this.name = n;
        this.host = h;
        this.port = po;
        this.protocol = pr;
        this.alias = "";
        this.encoding = "UTF-8";
        this.emulation = "vt100";
        this.lastvisit = 0L;
        this.total = 0;
        this.autoconnect = false;
        this.autologin = false;
    }

    @Override
    public int compareTo(Site site) {
        if (this.total == site.total) {
            return (int)(site.lastvisit - this.lastvisit);
        }
        return site.total - this.total;
    }

    public boolean equals(Object o) {
        if (o instanceof Site) {
            Site site = (Site)o;
            if (this.host.equalsIgnoreCase(site.host) && this.protocol.equalsIgnoreCase(site.protocol) && this.port == site.port) {
                return true;
            }
        }
        return false;
    }

    public String getURL() {
        String url = String.valueOf(this.protocol) + "://" + this.host;
        if (this.protocol.equalsIgnoreCase("telnet") && this.port != 23 || this.protocol.equalsIgnoreCase("ssh") && this.port != 22) {
            url = String.valueOf(url) + ":" + this.port;
        }
        return url;
    }

    public String toString() {
        Vector<String> v = new Vector<String>();
        v.addElement("name=" + this.name);
        v.addElement("host=" + this.host);
        v.addElement("port=" + this.port);
        v.addElement("protocol=" + this.protocol);
        v.addElement("alias=" + this.alias);
        v.addElement("encoding=" + this.encoding);
        v.addElement("emulation=" + this.emulation);
        v.addElement("lastvisit=" + this.lastvisit);
        v.addElement("total=" + this.total);
        if (this.autoconnect) {
            v.addElement("autoconnect=true");
        } else {
            v.addElement("autoconnect=false");
        }
        if (this.autologin) {
            v.addElement("autologin=true");
        } else {
            v.addElement("autologin=false");
        }
        return CSV.generate(v);
    }

    public void update() {
        ++this.total;
        this.lastvisit = new Date().getTime();
    }
}

