/*
 * Decompiled with CFR 0.152.
 */
package org.zhouer.zterm;

import java.applet.Applet;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.util.Date;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import javax.swing.Timer;
import org.zhouer.protocol.Protocol;
import org.zhouer.protocol.SSH2;
import org.zhouer.protocol.Telnet;
import org.zhouer.utils.Convertor;
import org.zhouer.utils.TextUtils;
import org.zhouer.vt.Application;
import org.zhouer.vt.VT100;
import org.zhouer.zterm.Messages;
import org.zhouer.zterm.Model;
import org.zhouer.zterm.Resource;
import org.zhouer.zterm.Site;

public class Session
extends JPanel
implements Runnable,
Application,
AdjustmentListener,
MouseWheelListener {
    public static final int STATE_ALERT = 4;
    public static final int STATE_CLOSED = 3;
    public static final int STATE_CONNECTED = 2;
    public static final int STATE_TRYING = 1;
    private static final long serialVersionUID = 2180544188833033537L;
    public int state;
    private boolean antiidle;
    private final Convertor conv;
    private boolean hasTab;
    private String iconname;
    private InputStream is;
    private long lastInputTime;
    private long antiIdleInterval;
    private final Model model;
    private Protocol network;
    private OutputStream os;
    private final Resource resource;
    private JScrollBar scrollbar;
    private int scrolllines;
    private final Site site;
    private long startTime;
    private Timer ti;
    private final VT100 vt;
    private String windowtitle;

    public Session(Site s, Resource r, Convertor c, BufferedImage bi, Model model) {
        this.site = s;
        this.resource = r;
        this.conv = c;
        this.model = model;
        this.hasTab = true;
        this.windowtitle = this.site.host;
        this.iconname = this.site.host;
        this.setBackground(Color.BLACK);
        this.vt = new VT100(this, this.resource, this.conv, bi);
        this.vt.setEncoding(this.site.encoding);
        this.vt.setEmulation(this.site.emulation);
        this.setLayout(new BorderLayout());
        this.add((Component)this.vt, "Center");
        if (this.resource.getBooleanValue("show-scroll-bar")) {
            this.scrolllines = this.resource.getIntValue("terminal.scrolls");
            this.scrollbar = new JScrollBar(1, this.scrolllines - 1, 24, 0, this.scrolllines + 23);
            this.scrollbar.addAdjustmentListener(this);
            this.add((Component)this.scrollbar, "East");
            this.addMouseWheelListener(this);
        }
    }

    @Override
    public void adjustmentValueChanged(AdjustmentEvent ae) {
        this.vt.setScrollUp(this.scrollbar.getMaximum() - this.scrollbar.getValue() - this.scrollbar.getVisibleAmount());
    }

    @Override
    public void bell() {
        this.model.bell(this);
    }

    public void bell(Session s) {
        if (this.resource.getBooleanValue("use-custom-bell")) {
            try {
                Applet.newAudioClip(new File(this.resource.getStringValue("custom-bell-path")).toURI().toURL()).play();
            }
            catch (MalformedURLException e) {
                e.printStackTrace();
            }
        } else {
            Toolkit.getDefaultToolkit().beep();
        }
        if (!this.model.isTabForeground(s)) {
            s.setState(4);
        }
    }

    public void close(boolean fromRemote) {
        if (this.isClosed()) {
            return;
        }
        this.removeMouseWheelListener(this);
        this.network.disconnect();
        if (this.ti != null) {
            this.ti.stop();
        }
        if (this.vt != null) {
            this.vt.close();
        }
        this.setState(3);
        boolean autoreconnect = this.resource.getBooleanValue("connect.auto-reconnect");
        if (autoreconnect && fromRemote) {
            long reopenTime = this.resource.getIntValue("connect.autoreconnect-time");
            long reopenInterval = this.resource.getIntValue("connect.auto-reconnect-interval");
            long now = new Date().getTime();
            if (now - this.startTime <= reopenTime * 1000L || reopenTime == 0L) {
                try {
                    Thread.sleep(reopenInterval);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
                this.model.reopenSession(this);
            }
        }
    }

    @Override
    public void colorCopy() {
        this.model.colorCopy();
    }

    @Override
    public void colorPaste() {
        this.model.colorPaste();
    }

    @Override
    public void copy() {
        this.model.copy();
    }

    public String getEmulation() {
        return this.site.emulation;
    }

    public String getIconName() {
        return this.iconname;
    }

    public String getSelectedColorText() {
        return this.vt.getSelectedColorText();
    }

    public String getSelectedText() {
        return this.vt.getSelectedText();
    }

    public Site getSite() {
        return this.site;
    }

    public String getURL() {
        return this.site.getURL();
    }

    public String getWindowTitle() {
        return this.windowtitle;
    }

    @Override
    public boolean isClosed() {
        if (this.network == null) {
            return true;
        }
        return this.network.isClosed();
    }

    @Override
    public boolean isConnected() {
        if (this.network == null) {
            return false;
        }
        return this.network.isConnected();
    }

    @Override
    public boolean isTabForeground() {
        return this.model.isTabForeground(this);
    }

    @Override
    public void mouseWheelMoved(MouseWheelEvent arg0) {
        this.scroll(arg0.getWheelRotation());
    }

    @Override
    public void openExternalBrowser(String url) {
        this.model.openExternalBrowser(url);
    }

    @Override
    public void paste() {
        this.model.paste();
    }

    public void pasteColorText(String str) {
        this.vt.pasteColorText(str);
    }

    public void pasteText(String str) {
        this.vt.pasteText(str);
    }

    @Override
    public int readBytes(byte[] buf) {
        try {
            return this.is.read(buf);
        }
        catch (IOException e) {
            this.close(true);
            return -1;
        }
    }

    public void remove() {
        this.hasTab = false;
    }

    @Override
    public boolean requestFocusInWindow() {
        return this.vt.requestFocusInWindow();
    }

    public void resetSelected() {
        this.vt.resetSelected();
    }

    @Override
    public void run() {
        this.setState(1);
        if (this.site.protocol.equalsIgnoreCase("telnet")) {
            this.network = new Telnet(this.site.host, this.site.port);
            this.network.setTerminalType(this.site.emulation);
        } else if (this.site.protocol.equalsIgnoreCase("ssh")) {
            this.network = new SSH2(this.site.host, this.site.port);
            this.network.setTerminalType(this.site.emulation);
        } else {
            System.err.println("Unknown protocol: " + this.site.protocol);
        }
        if (!this.network.connect()) {
            this.setState(3);
            this.showMessage(Messages.getString("Session.ConnectionFailed"));
            return;
        }
        this.is = this.network.getInputStream();
        this.os = this.network.getOutputStream();
        this.setState(2);
        this.resource.addFavorite(this.site);
        this.model.updateFavoriteMenu();
        this.updateAntiIdleTime();
        this.lastInputTime = new Date().getTime();
        this.ti = new Timer(1000, new AntiIdleTask());
        this.ti.start();
        this.startTime = new Date().getTime();
        this.vt.run();
    }

    @Override
    public void scroll(int amount) {
        this.scrollbar.setValue(this.scrollbar.getValue() + amount);
    }

    public void setEmulation(String emu) {
        this.site.emulation = emu;
        this.network.setTerminalType(emu);
        this.vt.setEmulation(emu);
    }

    public void setEncoding(String enc) {
        this.site.encoding = enc;
        this.vt.setEncoding(this.site.encoding);
        this.requestScreenData();
    }

    public void requestScreenData() {
        int n = 12;
        this.writeChar('\f');
    }

    @Override
    public void setIconName(String in) {
        this.iconname = in;
        this.model.updateTab();
    }

    public void setState(int s) {
        this.state = s;
        this.model.updateTabState(s, this);
    }

    @Override
    public void setWindowTitle(String wt) {
        this.windowtitle = wt;
        this.model.updateTab();
    }

    @Override
    public void showMessage(String msg) {
        if (this.hasTab) {
            this.model.showMessage(msg);
        }
    }

    @Override
    public void showPopup(int x, int y) {
        Point p = this.vt.getLocationOnScreen();
        String link = this.vt.coverURL(x, y) ? this.vt.getURL(x, y) : null;
        this.model.showPopup(p.x + x, p.y + y, link);
    }

    public void updateAntiIdleTime() {
        this.antiidle = this.resource.getBooleanValue("connect.anti-idle");
        this.antiIdleInterval = this.resource.getIntValue("connect.anti-idle-interval") * 1000;
    }

    public void updateImage(BufferedImage bi) {
        this.vt.updateImage(bi);
    }

    public void updateScreen() {
        this.vt.updateScreen();
    }

    public void updateSize() {
        this.vt.updateSize();
    }

    @Override
    public void writeByte(byte b) {
        this.lastInputTime = new Date().getTime();
        try {
            this.os.write(b);
        }
        catch (IOException e) {
            System.out.println("Caught IOException in Session::writeByte(...)");
            this.close(true);
        }
    }

    @Override
    public void writeBytes(byte[] buf, int offset, int len) {
        this.lastInputTime = new Date().getTime();
        try {
            this.os.write(buf, offset, len);
        }
        catch (IOException e) {
            System.out.println("Caught IOException in Session::writeBytes(...)");
            this.close(true);
        }
    }

    @Override
    public void writeChar(char c) {
        byte[] buf = this.conv.charToBytes(c, this.site.encoding);
        this.writeBytes(buf, 0, buf.length);
    }

    @Override
    public void writeChars(char[] buf, int offset, int len) {
        int count = 0;
        byte[] tmp = new byte[len * 4];
        int i = 0;
        while (i < len) {
            byte[] tmp2 = this.conv.charToBytes(buf[offset + i], this.site.encoding);
            int j = 0;
            while (j < tmp2.length) {
                tmp[count++] = tmp2[j];
                ++j;
            }
            ++i;
        }
        this.writeBytes(tmp, 0, count);
    }

    private class AntiIdleTask
    implements ActionListener {
        private AntiIdleTask() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            long now = new Date().getTime();
            if (Session.this.antiidle && Session.this.isConnected() && now - Session.this.lastInputTime > Session.this.antiIdleInterval && ((Session)Session.this).site.protocol.equalsIgnoreCase("telnet")) {
                String buf = TextUtils.BSStringToString(Session.this.resource.getStringValue("connect.anti-idle-string"));
                char[] ca = buf.toCharArray();
                Session.this.writeChars(ca, 0, ca.length);
            }
        }
    }
}

