/*
 * Decompiled with CFR 0.152.
 */
package org.zhouer.zterm;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;
import java.util.TreeSet;
import java.util.Vector;
import java.util.regex.Pattern;
import org.zhouer.vt.Config;
import org.zhouer.zterm.Site;

public class Resource
implements Config {
    public static final String LOCALE_COUNTRY = "locale.country";
    public static final String LOCALE_LANGUAGE = "locale.language";
    public static final String LOCALE_VARIANT = "locale.variant";
    public static final String ANTI_IDLE = "connect.anti-idle";
    public static final String ANTI_IDLE_INTERVAL = "connect.anti-idle-interval";
    public static final String ANTI_IDLE_STRING = "connect.anti-idle-string";
    public static final String AUTO_RECONNECT = "connect.auto-reconnect";
    public static final String AUTO_RECONNECT_INTERVAL = "connect.auto-reconnect-interval";
    public static final String AUTO_RECONNECT_TIME = "connect.autoreconnect-time";
    public static final String CUSTOM_BELL_PATH = "custom-bell-path";
    public static final String EXTERNAL_BROWSER = "external-browser-command";
    public static final String GEOMETRY_HEIGHT = "geometry.height";
    public static final String GEOMETRY_WIDTH = "geometry.width";
    public static final String GEOMETRY_X = "geometry.x";
    public static final String GEOMETRY_Y = "geometry.y";
    public static final String REMOVE_MANUAL_DISCONNECT = "remove-manual-disconnect";
    public static final String SHOW_SCROLL_BAR = "show-scroll-bar";
    public static final String SHOW_TOOLBAR = "show-toolbar";
    public static final String SYSTEM_LOOK_FEEL = "use-system-look-and-feel";
    public static final String TAB_NUMBER = "tab-number";
    public static final String USE_CUSTOM_BELL = "use-custom-bell";
    private static volatile Resource resource = null;
    private final HashMap defmap;
    private final HashMap map;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Resource getInstance() {
        if (resource != null) return resource;
        Class<Resource> clazz = Resource.class;
        synchronized (Resource.class) {
            if (resource != null) return resource;
            resource = new Resource();
            // ** MonitorExit[var0] (shouldn't be in output)
            return resource;
        }
    }

    public Locale getLocale() {
        String country = this.getValue(LOCALE_COUNTRY);
        String language = this.getValue(LOCALE_LANGUAGE);
        String variant = this.getValue(LOCALE_VARIANT);
        Locale locale = new Locale(language, country, variant);
        return locale;
    }

    private Resource() {
        File rc = this.getRcFile();
        this.map = new HashMap();
        this.defmap = new HashMap();
        this.loadDefault();
        if (rc.exists()) {
            this.readFile();
        } else {
            try {
                rc.createNewFile();
            }
            catch (IOException e) {
                System.err.println("catch IOException when create new rcfile.");
            }
        }
        this.setValue(SYSTEM_LOOK_FEEL, false);
    }

    public void addFavorite(Site site) {
        Vector<Site> favorites = this.getFavorites();
        int index = favorites.indexOf(site);
        if (index == -1) {
            favorites.addElement(site);
        } else {
            favorites.elementAt(index).update();
        }
        this.setFavorites(favorites);
    }

    public synchronized Vector<Site> getArray(String name) {
        String s;
        Vector<Site> v = new Vector<Site>();
        int count = 0;
        while ((s = this.getStringValue(String.valueOf(name) + "." + count)) != null) {
            v.addElement(new Site(s));
            ++count;
        }
        return v;
    }

    @Override
    public boolean getBooleanValue(String key) {
        return this.getValue(key).equalsIgnoreCase("true");
    }

    public Site getFavorite(String id) {
        Vector<Site> f = this.getFavorites();
        for (Site fa : f) {
            if (!id.equalsIgnoreCase(fa.name) && !id.equalsIgnoreCase(fa.alias)) continue;
            return fa;
        }
        return null;
    }

    public Vector<Site> getFavorites() {
        Vector<Site> favorites = this.getArray("favorite");
        int i = 0;
        while (i < favorites.size()) {
            favorites.setElementAt(new Site(favorites.elementAt(i).toString()), i);
            ++i;
        }
        return favorites;
    }

    @Override
    public int getIntValue(String key) {
        return Integer.parseInt(this.getValue(key));
    }

    @Override
    public String getStringValue(String key) {
        return this.getValue(key);
    }

    public void readFile() {
        File rc = this.getRcFile();
        try {
            String buf;
            BufferedReader br = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(rc), "UTF8"));
            while ((buf = br.readLine()) != null) {
                this.parseLine(buf);
            }
            br.close();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public synchronized void setArray(String name, Vector strs) {
        Iterator mapiter = this.map.keySet().iterator();
        Iterator iter = strs.iterator();
        while (mapiter.hasNext()) {
            String tmp = mapiter.next().toString();
            if (!tmp.startsWith(String.valueOf(name) + ".")) continue;
            mapiter.remove();
        }
        int count = 0;
        while (iter.hasNext()) {
            this.setValue(String.valueOf(name) + "." + count, iter.next().toString());
            ++count;
        }
    }

    public void setFavorites(Vector favorites) {
        this.setArray("favorite", favorites);
    }

    public void setValue(String key, boolean value) {
        if (value) {
            this.setValue(key, "true");
        } else {
            this.setValue(key, "false");
        }
    }

    public void setValue(String key, int value) {
        this.setValue(key, Integer.toString(value));
    }

    public synchronized void setValue(String key, String value) {
        this.map.put(key, value);
    }

    public void writeFile() {
        File rc = this.getRcFile();
        TreeSet ts = new TreeSet(this.map.keySet());
        Iterator iter = ts.iterator();
        try {
            PrintWriter pw = new PrintWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(rc), "UTF8"));
            while (iter.hasNext()) {
                String str = iter.next().toString();
                pw.println(String.valueOf(str) + "::" + this.map.get(str));
            }
            pw.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private File getRcFile() {
        String home = System.getProperty("user.home");
        String string = ".ztermrc";
        File f = new File(String.valueOf(home) + File.separator + ".ztermrc");
        return f;
    }

    private synchronized String getValue(String key) {
        if (this.map.get(key) != null) {
            return (String)this.map.get(key);
        }
        return (String)this.defmap.get(key);
    }

    private void loadDefault() {
        String os = System.getProperty("os.name");
        this.defmap.put(LOCALE_COUNTRY, Locale.getDefault().getCountry());
        this.defmap.put(LOCALE_LANGUAGE, Locale.getDefault().getLanguage());
        this.defmap.put(LOCALE_VARIANT, Locale.getDefault().getVariant());
        this.defmap.put(GEOMETRY_X, "0");
        this.defmap.put(GEOMETRY_Y, "0");
        this.defmap.put(GEOMETRY_WIDTH, "980");
        this.defmap.put(GEOMETRY_HEIGHT, "720");
        this.defmap.put(SHOW_TOOLBAR, "true");
        this.defmap.put(TAB_NUMBER, "true");
        this.defmap.put(SHOW_SCROLL_BAR, "true");
        this.defmap.put("terminal.columns", "80");
        this.defmap.put("terminal.rows", "24");
        this.defmap.put("terminal.scrolls", "200");
        this.defmap.put(ANTI_IDLE, "true");
        this.defmap.put(ANTI_IDLE_INTERVAL, "120");
        this.defmap.put(ANTI_IDLE_STRING, "\\x1bOA\\x1bOB");
        this.defmap.put(AUTO_RECONNECT, "true");
        this.defmap.put(AUTO_RECONNECT_TIME, "10");
        this.defmap.put(AUTO_RECONNECT_INTERVAL, "500");
        this.defmap.put("font.family", "Monospaced");
        this.defmap.put("font.size", "0");
        this.defmap.put("font.bold", "false");
        this.defmap.put("font.italy", "false");
        if (Pattern.matches(".*Windows.*", os)) {
            this.defmap.put("font.antialias", "false");
        } else {
            this.defmap.put("font.antialias", "true");
        }
        this.defmap.put("font.vertical-gap", "0");
        this.defmap.put("font.hoizontal-gap", "0");
        this.defmap.put("font.descent-adjust", "0");
        this.defmap.put("cursor.blink", "true");
        this.defmap.put("cursor.shape", "block");
        if (Pattern.matches(".*Windows.*", os)) {
            this.defmap.put(EXTERNAL_BROWSER, "explorer \"%u\"");
        } else {
            this.defmap.put(EXTERNAL_BROWSER, "mozilla %u");
        }
        this.defmap.put(SYSTEM_LOOK_FEEL, "false");
        this.defmap.put("copy-on-select", "false");
        this.defmap.put("clear-after-copy", "true");
        this.defmap.put(REMOVE_MANUAL_DISCONNECT, "true");
        this.defmap.put("auto-line-break", "false");
        this.defmap.put("auto-line-break-length", "72");
        this.defmap.put(USE_CUSTOM_BELL, "false");
        this.defmap.put(CUSTOM_BELL_PATH, "");
    }

    private void parseLine(String line) {
        String[] argv = line.split("::");
        if (argv.length != 2) {
            return;
        }
        if (argv[0].length() > 0) {
            this.map.put(argv[0], argv[1]);
        }
    }
}

