/*
 * Decompiled with CFR 0.152.
 */
package org.zhouer.vt;

import java.awt.Cursor;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import org.zhouer.vt.Application;
import org.zhouer.vt.Config;
import org.zhouer.vt.VT100;

public class User
implements KeyListener,
MouseListener,
MouseMotionListener {
    private final Config config;
    private boolean isDefaultCursor;
    private final Application parent;
    private int pressX;
    private int pressY;
    private int dragX;
    private int dragY;
    private final VT100 vt;

    public User(Application p, VT100 v, Config c) {
        this.parent = p;
        this.vt = v;
        this.config = c;
        this.isDefaultCursor = true;
    }

    @Override
    public void keyPressed(KeyEvent e) {
        int len;
        byte[] buf = new byte[4];
        switch (e.getKeyCode()) {
            case 38: {
                if (this.vt.getKeypadMode() == 1) {
                    buf[0] = 27;
                    buf[1] = 91;
                    buf[2] = 65;
                    len = 3;
                    break;
                }
                buf[0] = 27;
                buf[1] = 79;
                buf[2] = 65;
                len = 3;
                break;
            }
            case 40: {
                if (this.vt.getKeypadMode() == 1) {
                    buf[0] = 27;
                    buf[1] = 91;
                    buf[2] = 66;
                    len = 3;
                    break;
                }
                buf[0] = 27;
                buf[1] = 79;
                buf[2] = 66;
                len = 3;
                break;
            }
            case 39: {
                if (this.vt.getKeypadMode() == 1) {
                    buf[0] = 27;
                    buf[1] = 91;
                    buf[2] = 67;
                    len = 3;
                    break;
                }
                buf[0] = 27;
                buf[1] = 79;
                buf[2] = 67;
                len = 3;
                break;
            }
            case 37: {
                if (this.vt.getKeypadMode() == 1) {
                    buf[0] = 27;
                    buf[1] = 91;
                    buf[2] = 68;
                    len = 3;
                    break;
                }
                buf[0] = 27;
                buf[1] = 79;
                buf[2] = 68;
                len = 3;
                break;
            }
            case 155: {
                buf[0] = 27;
                buf[1] = 91;
                buf[2] = 50;
                buf[3] = 126;
                len = 4;
                break;
            }
            case 36: {
                if (this.vt.getKeypadMode() == 1) {
                    buf[0] = 27;
                    buf[1] = 91;
                    buf[2] = 49;
                    buf[3] = 126;
                    len = 4;
                    break;
                }
                buf[0] = 27;
                buf[1] = 79;
                buf[2] = 72;
                len = 3;
                break;
            }
            case 33: {
                buf[0] = 27;
                buf[1] = 91;
                buf[2] = 53;
                buf[3] = 126;
                len = 4;
                break;
            }
            case 127: {
                buf[0] = 27;
                buf[1] = 91;
                buf[2] = 51;
                buf[3] = 126;
                len = 4;
                break;
            }
            case 35: {
                if (this.vt.getKeypadMode() == 1) {
                    buf[0] = 27;
                    buf[1] = 91;
                    buf[2] = 52;
                    buf[3] = 126;
                    len = 4;
                    break;
                }
                buf[0] = 27;
                buf[1] = 79;
                buf[2] = 70;
                len = 3;
                break;
            }
            case 34: {
                buf[0] = 27;
                buf[1] = 91;
                buf[2] = 54;
                buf[3] = 126;
                len = 4;
                break;
            }
            default: {
                len = 0;
            }
        }
        if (len != 0) {
            this.parent.writeBytes(buf, 0, len);
            return;
        }
        if (e.getKeyCode() == 27) {
            this.parent.writeByte((byte)27);
            return;
        }
        if (e.getKeyCode() == 10) {
            this.parent.writeByte((byte)13);
            return;
        }
    }

    @Override
    public void keyReleased(KeyEvent e) {
    }

    @Override
    public void keyTyped(KeyEvent e) {
        if (e.isAltDown() || e.isMetaDown()) {
            return;
        }
        if (e.getKeyChar() == '\u007f' || e.getKeyChar() == '\n' || e.getKeyChar() == '\u001b') {
            return;
        }
        this.parent.writeChar(e.getKeyChar());
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void mouseClicked(MouseEvent e) {
        if (e.getButton() == 1) {
            if (this.vt.coverURL(e.getX(), e.getY())) {
                String url = this.vt.getURL(e.getX(), e.getY());
                if (url.length() == 0) return;
                this.parent.openExternalBrowser(url);
                return;
            }
            if (e.getClickCount() == 2) {
                this.vt.selectConsequtive(e.getX(), e.getY());
                this.vt.repaint();
                return;
            }
            if (e.getClickCount() == 3) {
                this.vt.selectEntireLine(e.getX(), e.getY());
                this.vt.repaint();
                return;
            }
        } else {
            if (e.getButton() == 2) {
                if (e.isControlDown()) {
                    this.parent.colorPaste();
                    return;
                }
                this.parent.paste();
                return;
            }
            if (e.getButton() == 3) {
                this.parent.showPopup(e.getX(), e.getY());
                return;
            }
        }
        this.vt.requestFocusInWindow();
        this.vt.resetSelected();
        this.vt.repaint();
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        this.dragX = e.getX();
        this.dragY = e.getY();
        this.vt.setSelected(this.pressX, this.pressY, this.dragX, this.dragY);
        this.vt.repaint();
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mouseMoved(MouseEvent e) {
        boolean cover = this.vt.coverURL(e.getX(), e.getY());
        if (this.isDefaultCursor && cover) {
            this.vt.setCursor(new Cursor(12));
            this.isDefaultCursor = false;
        } else if (!this.isDefaultCursor && !cover) {
            this.vt.setCursor(new Cursor(0));
            this.isDefaultCursor = true;
        }
    }

    @Override
    public void mousePressed(MouseEvent e) {
        this.pressX = e.getX();
        this.pressY = e.getY();
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        if (e.getButton() != 1) {
            return;
        }
        boolean meta = e.isAltDown() || e.isMetaDown();
        boolean ctrl = e.isControlDown();
        if (this.config.getBooleanValue("copy-on-select") == meta) {
            return;
        }
        if (ctrl) {
            this.parent.colorCopy();
        } else {
            this.parent.copy();
        }
    }
}

