/**
 * Program: LogParser.java
 * Editor: Waue Chen 
 * From :  NCHC. Taiwn
 * Last Update Date: 07/23/2008
 */

package tw.org.nchc.code;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.text.ParseException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class SnortParser {
	private String logData = new String();

	private String in;

	private String ou;

	public SnortParser(String in, String ou) {
		this.in = in;
		this.ou = ou;
	}

	public SnortParser() {
		this.in = "/var/log/snort/alert";
		this.ou = "~/parseSnort.log";
	}

	public void snortParser(String line, int i) throws ParseException,
			Exception {
		String[] data;
		Pattern patten_line;
		Matcher matcher;
		switch (i) {
		case 1:
			patten_line = Pattern
					.compile("^\\[\\**\\] \\[([0-9]*):([0-9]*):([0-9]*)\\] ([^\\[]*)\\[\\**\\]$");
			break;
		case 2:
			patten_line = Pattern
					.compile("^\\[Classification: ([^\\]]*)\\] \\[Priority: ([1-9]*)\\].*$");
			break;
		case 3:
			patten_line = Pattern
					.compile("(^[0-9]*)\\/([0-9]*)\\-([0-9]*)\\:([0-9]*)\\:([0-9]*)\\.[0-9]* ([^ ]*) -> ([^$]*)$");
			break;
		case 4:
			patten_line = Pattern
					.compile("^([^ ]*) [^$]*$");
			// .compile("^([^ ]*) TTL:([^ ]*) TOS:([^ ]*) ID:([^ ]*) IpLen:([^ ]*) DgmLen:([^ ]*)$");

			break;
		default:
			patten_line = null;
			break;
		}
		matcher = patten_line.matcher(line);
		if (matcher.matches()) {
			int number = matcher.groupCount();
			data = new String[number];
			for (int j = 0; j < number; j++) {
				data[j] = matcher.group(j + 1);
				this.logData += (data[j] + ";");
			}
		}else if(i ==1 ){
			this.logData += "0;0;0;parse error;";
		}else if(i == 2){
			this.logData += "Port Scan;3;";
		}else if(i == 3){
			this.logData += "01;01;00;00;00;error;error;";
		}else if(i == 4){
			this.logData += "0;";
		}else{
			this.logData = "*FatalError*";
		}

	}

	void parseToLine() throws IOException, ParseException, Exception {
		BufferedReader fi = new BufferedReader(new FileReader(new File(in)));
		BufferedWriter fw = new BufferedWriter(new FileWriter(new File(ou)));
		String line = null;
		int count = 0;
		do {
			line = fi.readLine();
			if (line == null) {
				break;
			} else if (line.isEmpty()) {
				fw.write(this.logData.toString() + "\n");
				this.logData = "";
				count = 0;
			} else if (count < 4) {
				// System.out.println(line);
				snortParser(line, count + 1);
				count++;
			} else {
				count++;
			}
		} while (true);
		fw.flush();
		fw.close();

	}

	// 需搞定icmp ping 的格式問題
	public static void main(String[] args) throws ParseException, Exception {
		String in = new String("/home/waue/Desktop/alert_flex.txt");
		String ou = new String("/home/waue/Desktop/alert_flex_parsed.txt");
		SnortParser a = new SnortParser(in, ou);
		a.parseToLine();
	}
}