#!/bin/bash
# Program:
#   Functions for client_install.sh
# Author: 
#   Waue, Shunfa, Rock {waue, shunfa, rock}@nchc.org.tw
# History:
#   2010/05/20  Rock    First release(0.1)

# 正式版之後，記的將不必要的 echo 拿掉


# 檢查執行這個程式的是否為root權限
function check_root(){
# 正式版後可拿掉此 echo
echo -e "\n= check_root (debug) ="
if [ $USER != "root" ]; then
    echo -e "\nPlz Change root to execute it!!!"
    exit
fi
# 正式版後可拿掉此 echo
echo -e "Identify is root."
}


# 查出此主機的作業系統,以及版本
function check_systemInfo(){
echo -e "\n= check_systemInfo (debug) ="
echo -e "\nYour system information are:"
Linux_Distribution=$(lsb_release -a 2> /dev/null | grep "Distributor ID:" | awk '{print $3}')
Linux_Version=$(lsb_release -a 2> /dev/null | grep "Release" | awk '{print $2}')
echo $Linux_Distribution , $Linux_Version
}


# 安裝需要的相依套件 (目前只支援 deb 套件的系統自動安裝，yum或其他套件系統的則需手動安裝)
function install_packages(){
# deb 系列系統
echo -e "\n= install_packages (debug) ="
echo -e "\nCheck dependent packages"
if [ "$Linux_Distribution" == "Ubuntu" ] || [ "$Linux_Distribution" == "Debian" ] ;then
    echo -e "\nIt will install sime packages (expect, ssh, and dialog).\n"
    aptitude install -y expect ssh dialog
# rpm 系列系統
elif [ "$Linux_Distribution" == "Fedora" ] || [ "$Linux_Distribution" == "CentOS" ] ;then
    echo -e "Plz install expect, ssh, and dialog."
    exit
else
    echo -e "Plz install expect, ssh, and dialog."
    exit
fi 
}


# 檢查之前是否有安裝NutchEz
# 目前先檢查是否有/opt/nutchez 這個資料夾即可
function check_nez_installed(){
echo -e "\n= chcheck_nez_installed (debug) ="
if [ -d /opt/nutchez ]; then
    echo -e "\nSystem already had NutchEz."
    exit
else
    echo -e "\nSystem does not has NutchEz."
fi
}


# 檢查是否有安裝sun java ,並檢查是否為jdk 1.6 以上版本
# 4種判斷可能性 (1)系統沒安裝 JAVA (2)系統有安裝JAVA，但非sun版本 
# (3)系統有安裝但Sun Java 在非預設路徑下 (4)以正確安裝 Sun JAVA 預設路徑下
function check_sunJava(){
echo -e "\n= check_sunJava (debug) ="
echo -e "\nNutchEz need Sun Java JDK 1.6.x or above version"

javaPath="/usr"
yesno="no"
choice="3"

    if [ -e $javaPath/bin/java ]; then
      JAVA_org=$($javaPath/bin/java -version 2>&1 | grep "Java(TM)")
      JAVA_version=$($javaPath/bin/java -version 2>&1 | grep "java version" | \
      awk '{print $3}' | cut -d "." -f1-2 | cut -d "\"" -f2)
   
        if [ "$JAVA_org" == "" ]; then 
            echo "Java is not Sun version, plz install sun Java 1.6.X"
            echo -e "\nPlz input your choice: "
            echo "(1)System don't have Sun Java (2)Sun Java is in other path (3)Exit"
            read -p "plz input (1/2/3): " choice
            case $choice  in
                "1")
                echo -e "Plz install Sun Java manually!"
                exit 
                ;;
                "2")
                    read -p "Input Sun Java home path(ex. '/usr/lib/jvm/java-6-sun-1.6.0.12' or using default '/usr' ): " javaPath
                ;;
                "*")
                exit
                ;;
            esac

            if [ $choice == "2" ]; then
                JAVA_org=$($javaPath/bin/java -version 2>&1 | grep "Java(TM)")
                JAVA_version=$($javaPath/bin/java -version 2>&1 | grep "java version" | \
                awk '{print $3}' | cut -d "." -f1-2 | cut -d "\"" -f2)
                
                if [ "$JAVA_org" == "" ]; then
                echo -e "It is not Sun Java! Plz install Sun Java manually!"
                exit
                fi
            fi
        fi  

      large16=$(echo "$JAVA_version >= 1.6" | bc)
      if [ "${large16}" == 0 ]; then
          echo "Java version is too old (it need 1.6.X above)"
          exit
      fi  
      
      echo "System has Sun Java 1.6 above version."
  else
      echo "Plz install Sun JAVA 1.6.X or above version"
      exit
  fi

unset JAVA_org
unset JAVA_version
}


# 檢查是否有安裝openssh, openssh-server
function check_ssh(){
echo -e "\n= check_ssh (debug) ="
if [ -e /usr/bin/ssh ]; then
    echo -e "\nSystem has ssh."
else
    echo "Plz install ssh."
    exit
fi

if [ -e /usr/sbin/sshd ]; then
    echo "System has ssh Server (sshd)."
else
    echo "Plz install ssh Server (sshd)."
    exit
fi
}


# 檢查是否有安裝dialog
function check_dialog(){
echo -e "\n= check_dialog (debug) ="
if [ -e /usr/bin/dialog ]; then
    echo -e "\nSystem has dialog."
else
    echo "Plz install dialog."
    exit
fi
}


# scp nutchuser@master_ip:~ 把.ssh/目錄複製下來
# 當使用者輸入nutchuser 密碼時，將此密碼紀錄到Nutchuser_Passwd
# 此步驟若無法連到 master 則跳出
function scp_master_nutchuser_sshkey(){
echo -e "\n= scp_master_nutchuser_sshkey (debug) ="
echo -e "mkdir -p /home/nutchuser/"
mkdir -p /home/nutchuser/.ssh/
rm -fr /home/nutchuser/.ssh/*

unset Nutchuser_Passwd2

echo -e "scp nutchuser@$1:~/.ssh /home/nutchuser/"
expect -c "spawn scp -r -o StrictHostKeyChecking=no nutchuser@$1:~/.ssh /home/nutchuser/
expect \"*: \" { send \"$Nutchuser_Passwd\r\" }
expect \"*: \" { send_user \"Password is error\" }
expect eof"

if [ -e "/home/nutchuser/.ssh/authorized_keys" ]; then
        echo -e "\nscp correct."    
    else
        echo -e "\nscp is error,\n(1)plz check nutchuser password in server\n(2)nutchuser's authorized_keys in server\n(3)server's network status"
        exit
    fi

    echo "chown -R nutchuser:nutchuser /home/nutchuser/.ssh"
    chown -R nutchuser:nutchuser /home/nutchuser/.ssh

}


# 新增nutchuser 帳號時用 Nutchuser_Passwd 當密碼
function creat_nutchuser_account(){
echo -e "\n= creat_nutchuser_account (debug) ="

while [ "$Nutchuser_Passwd" != "$Nutchuser_Passwd2" ]
do
    echo -e "\n"
    read -p "Plz input nutchuser password of master node: " Nutchuser_Passwd
    read -p "plz input nutchuser password, again: " Nutchuser_Passwd2
        if [ "$Nutchuser_Passwd" == "$Nutchuser_Passwd2" ]; then
            echo "Two Passwords match."
        else
            echo "two passwords do not match, plz re-input nutchuser's password."
        fi
done                                                                                                                                    
   
unset Nutchuser_Passwd2

if [ $(cat /etc/passwd | grep nutchuser) ]; then
    echo "System already has nutchuser, change nutchuser password."
    expect -c "spawn passwd nutchuser
    set timeout 1
    expect \"*: \"
    send \"$Nutchuser_Passwd\r\"
    expect \"*: \"
    send \"$Nutchuser_Passwd\r\"
    expect eof"
else
    echo "Create nutchuser and change password."
    useradd -m nutchuser -s /bin/bash
    expect -c "spawn passwd nutchuser
    set timeout 1
    expect \"*: \"
    send \"$Nutchuser_Passwd\r\"
    expect \"*: \"
    send \"$Nutchuser_Passwd\r\"
    expect eof"
fi
}

# 用scp 複製 master 的設定與安裝資料
# 目前僅需做到能無礙的複製遠端的/opt/nutchez/到local的/opt/
function scp_packages(){
echo -e "\n= scp_packages (debug) ="
chmod 777 /opt
mkdir /opt/nutchez
mkdir /var/nutchez
#su nutchuser -c "scp -r -o StrictHostKeyChecking=no nutchuser@$1:/opt/nutchez /opt/"
echo "scp -r nutchuser@$1:/home/nutchuser/nutchez/NutchezForClientOf_$Master_IP_Address.tar.gz /opt/nutchez/"
chown -R nutchuser:nutchuser /opt/nutchez
chown -R nutchuser:nutchuser /var/nutchez
su nutchuser -c "scp -r nutchuser@$1:/home/nutchuser/nutchez/NutchezForClientOf_$Master_IP_Address.tar.gz /opt/nutchez/"

echo -e "\nchown -R nutchuser:nutchuser /opt/nutchez"
chmod 755 /opt
}


function install_nutch_package () {
  tar -zxvf /opt/nutchez/NutchezForClientOf_$Master_IP_Address.tar.gz -C /
  /opt/nutchez/nutch/bin/hadoop-daemon.sh start datanode
  /opt/nutchez/nutch/bin/hadoop-daemon.sh start tasktracker
}
