#!/bin/bash
# Program:
#   Functions for client_install.sh
# Author: 
#   Waue, Shunfa, Rock {waue, shunfa, rock}@nchc.org.tw
# History:
#   2010/05/20  Rock    First release(0.1)

# 正式版之後，記的將不必要的 echo 拿掉


# 檢查執行這個程式的是否為root權限
function check_root(){
# 正式版後可拿掉此 echo
echo -e "\n= check_root (debug) ="
if [ $USER != "root" ]; then
    echo -e "\nPlz Change root to execute it!!!"
    exit
fi
# 正式版後可拿掉此 echo
echo -e "Identify is root."
}


# 查出此主機的作業系統,以及版本
function check_systemInfo(){
echo -e "\n= check_systemInfo (debug) ="
echo -e "\nYour system information are:"
lsb_release -a 2>/dev/null 
}


# 檢查之前是否有安裝NutchEz
# 目前先檢查是否有/opt/nutchez 這個資料夾即可
function check_nez_installed(){
echo -e "\n= chcheck_nez_installed (debug) ="
test -d /opt/nutchez && echo -e "\nYour system already had NutchEz." || \
echo -e "\nYour system does not has NutchEz."
}


# 檢查是否有安裝sun java ,並檢查是否為jdk 1.6 以上版本
# 4種判斷可能性 (1)系統沒安裝 JAVA (2)系統有安裝JAVA，但非sun版本 
# (3)系統有安裝但Sun Java 在非預設路徑下 (4)以正確安裝 Sun JAVA 預設路徑下
function check_sunJava(){
echo -e "\n= check_sunJava (debug) ="
echo -e "\nNutchEz need Sun Java JDK 1.6.x or above version"
javaPath="/usr/"

test -e $javaPath/bin/java || read -p "Plz input specific Java path\
(ex./opt/jvm/java-6-sun-1.6.0.20/): " javaPath

if [ -e $javaPath/bin/java ]; then
    JAVA_org=$($javaPath/bin/java -version 2>&1 | grep "Java(TM)")
    JAVA_version=$($javaPath/bin/java -version 2>&1 | grep "java version" | \
    awk '{print $3}' | cut -d "." -f1-2 | cut -d "\"" -f2)

    if [ "$JAVA_org" == "" ]; then 
        echo "Java is not Sun version, plz install sun Java 1.6.X"
        exit    
    fi
   
    large16=$(echo "$JAVA_version >= 1.6" | bc)
    if [ "${large16}" == 0 ]; then
        echo "Java version is too old (it need 1.6.X above)"
        exit
    fi
    
    echo "System has Sun Java 1.6 above version."
else
    echo "Plz install Sun JAVA 1.6.X or above version"
    exit
fi

unset JAVA_org
unset JAVA_version
}


# 檢查是否有安裝openssh, openssh-server
function check_ssh(){
echo -e "\n= check_ssh (debug) ="
if [ -e /usr/bin/ssh ]; then
    echo -e "\nSystem has ssh."
else
    echo "Plz install ssh."
    exit
fi

if [ -e /usr/sbin/sshd ]; then
    echo "System has ssh Server (sshd)."
else
    echo "Plz install ssh Server (sshd)."
    exit
fi
}


# 檢查是否有安裝dialog
function check_dialog(){
echo -e "\n= check_dialog (debug) ="
if [ -e /usr/bin/dialog ]; then
    echo -e "\nSystem has dialog."
else
    echo "Plz install dialog."
    exit
fi
}


# 檢查是否安裝 php 5.5
function check_php(){
echo -e "\n= check_php (debug) ="
if [ "$(php -v 2>/dev/null | grep "PHP 5" | awk '{print $2}' | cut -d "." -f1)" == 5 ]; then
    echo -e "\nPHP'version is 5"
else
    echo -e "\nplz install PHP 5 version!"
#    exit
fi
}


# scp nutchuser@master_ip:~ 把.ssh/目錄複製下來
# 當使用者輸入nutchuser 密碼時，將此密碼紀錄到Nutchuser_Passwd
# 此步驟若無法連到 master 則跳出
function scp_master_nutchuser_sshkey(){
echo -e "\n= scp_master_nutchuser_sshkey (debug) ="
echo -e "mkdir -p /home/nutchuser/"
mkdir -p /home/nutchuser/

while [ ! -d "/home/nutchuser/.ssh" ]
    do
    echo -e "\n"
    read -p "Plz input nutchuser passwd of master node: " Nutchuser_Passwd
    echo -e "scp nutchuser@$1:~/.ssh /home/nutchuser/"
    expect -c "spawn scp -r -o StrictHostKeyChecking=no nutchuser@$1:~/.ssh /home/nutchuser/
    expect \"*: \" { send \"$Nutchuser_Passwd\r\" }
    expect \"*: \" { send_user \"Passwd is error\" }
    expect eof"
        if [ ! -d "/home/nutchuser/.ssh" ]; then
            echo -e "\nPasswd is error, plz re-input nutchuser passwd of master node."
        else
            echo -e "\nscp correct."
        fi
        echo "chown -R nutchuser:nutchuser /home/nutchuser/.ssh"
        chown -R nutchuser:nutchuser /home/nutchuser/.ssh
done
}


# 新增nutchuser 帳號時用 Nutchuser_Passwd 當密碼
function creat_nutchuser_account(){
echo -e "\n= creat_nutchuser_account (debug) ="                             

# 若沒 nutchuser_Passwd 的參數傳遞才將註解打開讓使用者字型輸入
#while [ "1" != "$Nutchuser_Passwd2" ]
#do
#    read -p "Create nutchuser, plz input nutchuser's password: " Nutchuser_Passwd
#    read -p "plz input nutchuser's password, again: " Nutchuser_Passwd2

#    if [ "$1" == "$Nutchuser_Passwd2" ]; then
#        echo "Two Passwords match."
#    else
#        echo "two passwords do not match, plz re-input nutchuser's password."
#    fi
#done

#unset Nutchuser_Passwd2

if [ $(cat /etc/passwd | grep nutchuser) ]; then
    echo "System already has nutchuser, change nutchuser password."
    expect -c "spawn passwd nutchuser                 
    expect \"*: \"                         
    send \"$1\r\"                          
    expect \"*: \"                         
    send \"$1\r\"                          
    expect eof"
else
    echo "System already has nutchuser, create nutchuser and change password."
    useradd -m nutchuser -s /bin/bash
    expect -c "spawn passwd nutchuser                 
    expect \"*: \" 
    send \"$1\r\"
    expect \"*: \" 
    send \"$1\r\" 
    expect eof"
fi
}


# 用scp 複製 master 的設定與安裝資料
# 目前僅需做到能無礙的複製遠端的/opt/nutchez/到local的/opt/
function scp_packages(){
echo -e "\n= scp_packages (debug) ="
echo "scp -r -o StrictHostKeyChecking=no nutchuser@$1:/opt/nutchez/ /opt/"
scp -r -o StrictHostKeyChecking=no nutchuser@$1:/opt/nutchez/ /opt/

echo "chown -R nutchuser:nutchuser /opt/nutchez/"
chown -R nutchuser:nutchuser /opt/nutchez/
}
