#!/bin/bash
# Program:
#   Functions for client_install.sh
# Author: 
#   Waue, Shunfa, Rock {waue, shunfa, rock}@nchc.org.tw
# History:
#   2010/05/20  Rock    First release(0.1)

function check_root(){
echo -e "\n= check_root ="
if [ $USER != "root" ]; then
    echo -e "\nPlz Change root to execute it!!!"
    exit
fi
}



# 查出此主機的作業系統,以及版本
function check_systemInfo(){
echo -e "\n= check_systemInfo ="
echo -e "\nYour system information are:"
lsb_release -a 2>/dev/null 
}


# 檢查之前是否有安裝NutchEz
# 目前先檢查是否有/opt/nutchez 這個資料夾即可
function check_nez_installed(){
    echo -e "\n= chcheck_nez_installed ="
    test -d /opt/nutchez && echo -e "\nYour system already had NutchEz." || \
    echo -e "\nYour system does not has NutchEz."
}


# 檢查是否有安裝sun java ,並檢查是否為jdk 1.6 以上版本
# 4種判斷可能性 (1)系統沒安裝 JAVA (2)系統有安裝JAVA，但非sun版本 
# (3)系統有安裝但Sun Java 在非預設路徑下 (4)以正確安裝 Sun JAVA 預設路徑下
function check_sunJava(){
echo -e "\n= check_sunJava ="
echo -e "\nNutchEz need Sun Java JDK 1.6.x or above version"
javaPath="/usr/"

test -e $javaPath/bin/java || read -p "Plz input your specific Java path\
(ex./opt/jvm/java-6-sun-1.6.0.20/): " javaPath

if [ -e $javaPath/bin/java ]; then
    JAVA_org=$($javaPath/bin/java -version 2>&1 | grep "Java(TM)")
    JAVA_version=$($javaPath/bin/java -version 2>&1 | grep "java version" | \
    awk '{print $3}' | cut -d "." -f1-2 | cut -d "\"" -f2)

    if [ "$JAVA_org" == "" ]; then 
        echo "Your Java is not Sun version, plz install sun Java 1.6.X"
        exit    
    fi
    
    if [ $JAVA_version -lt "1.6" ]; then
        echo "Your Java version is too old (it need 1.6.X above)"
        exit
    fi

else
    echo "Plz install Sun JAVA 1.6.X or above version"
    exit
fi

unset JAVA_org
unset JAVA_version

}
